<?php
/**
 * XenForo User Birthdays
 *
 * @category XenForo Application
 * @package    XfRu_Birthdays
 * @copyright  Copyright (c) 2010 XF-Russia. (http://www.xf-russia.ru)
 * @license
 * @version   $Id: UserGroups.php 80 2011-01-09 21:17:21Z pepelac $ $Date: 2011-01-09 22:17:21 +0100 (Sun, 09 Jan 2011) $ $Revision: 80 $
 * @author Pepelac
 *
 */


class XfRu_Birthdays_Option_UserGroups
{
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$preparedOption['formatParams'] = array();

		$groupModel = XenForo_Model::create('XenForo_Model_UserGroup');

		foreach ($groupModel->getAllUserGroups() as $group)
		{
			$preparedOption['formatParams'][$group['user_group_id']] = $group['title'];
		}

		$preparedOption['formatParams'] = XenForo_ViewAdmin_Helper_Option::prepareMultiChoiceOptions($fieldPrefix, $preparedOption);

		return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
			'xfr_birtdays_option_template_usergroups',
			$view, $fieldPrefix, $preparedOption, $canEdit
		);
	}
}