<?php
/**
 * XenForo User Birthdays
 *
 * @category XenForo Application
 * @package    XfRu_Birthdays
 * @copyright  Copyright (c) 2010 XF-Russia. (http://www.xf-russia.ru)
 * @license
 * @version   $Id: Birthdays.php 94 2011-01-10 14:26:52Z pepelac $ $Date: 2011-01-10 15:26:52 +0100 (Mon, 10 Jan 2011) $ $Revision: 94 $
 * @author Pepelac
 *
 */


class XfRu_Birthdays_ControllerPublic_Birthdays extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		$bDayModel = $this->getModelFromCache('XfRu_Birthdays_Model_Birthday');

		if (!$bDayModel->canSeeBlock())
		{
			return $this->responseNoPermission();
		}

		$users = $bDayModel->getUsers();

		$breadCrumbs[] = array(
			'href' => XenForo_Link::buildPublicLink('full:members'),
			'value' => new XenForo_Phrase('members')
		);

	    $viewParams = array(
			'breadCrumbs' => $breadCrumbs,
			'users' => $users,
	    );

		return $this->responseView(
			'XfRu_Birthdays_ViewPublic_MemeberList',
			'xfr_birthdays_member_list',
			$viewParams
		);
	}
}