<?php
/**
 * XenForo User Birthdays
 *
 * @category XenForo Application
 * @package    XfRu_Birthdays
 * @copyright  Copyright (c) 2010 XF-Russia. (http://www.xf-russia.ru)
 * @license
 * @version   $Id: Birthday.php 86 2011-01-10 13:42:48Z pepelac $ $Date: 2011-01-10 14:42:48 +0100 (Mon, 10 Jan 2011) $ $Revision: 86 $
 * @author Pepelac
 *
 */

class XfRu_Birthdays_Model_Birthday extends Xenforo_Model
{
	public function getTemplateContent()
	{
		// check if user can see block
		if (!$this->canSeeBlock())
		{
			return '';
		}

		$options = XenForo_Application::get('options');

		$users = $this->getUsers();

		$total = count($users);

		$showMoreLink = false;
		if ($total > $options->XfRu_BDay_maxUsersInBlock)
		{
			$showMoreLink = true;
			array_splice($users, $options->XfRu_BDay_maxUsersInBlock);
		}

		if (empty($users) && !$options->XfRu_BDay_alwaysShowBlock)
		{
			return '';
		}

	    $viewParams = array(
			'users' => $users,
			'limit' => min(array($options->XfRu_BDay_maxUsersInBlock, $total)),
			'moreUsers' => ($total-$options->XfRu_BDay_maxUsersInBlock),
			'showMoreLink' => $showMoreLink,
			'useAvatars' => $options->XfRu_BDay_useAvatars
	    );

		// todo: use cache to store template
	    $tpl = new XenForo_Template_Public('xfr_birthdays_sidebar_user_list', $viewParams);

		return $tpl->render();

	}

	public function getUsers()
	{
		$users = $this->fetchAllKeyed($this->prepareSql(), 'user_id');
		$currYear = date('Y', $this->getTimeWithTZOffset());
		foreach ($users as &$user)
		{
			$user['showAge'] = $user['show_dob_year'] || $this->canIgnorePrivacyControl(XenForo_Application::get('options')->XfRu_BDay_privacyIgnore) ;
			$user['ageOverriden'] = ($user['dob_year']) ? $currYear - $user['dob_year'] : 0;
		    $user['title'] = ($user['showAge'] && $user['ageOverriden']) ? $user['username'] . ' ('.new XenForo_Phrase('age').': '.$user['ageOverriden'].')' : $user['username'];
		}
	    return $users;
	}

	private function prepareSql()
	{
		$options = XenForo_Application::get('options');

	    $where = '';
	    $currDay = date('j', $this->getTimeWithTZOffset());
	    $currMonth = date('n', $this->getTimeWithTZOffset());

		$where .= ' AND (up.dob_day = '.$currDay.' AND up.dob_month = '.$currMonth.')';

		// privacy control
		if ($options->XfRu_BDay_privacyControl && !$this->canIgnorePrivacyControl($options->XfRu_BDay_privacyIgnore))
		{
			$where .= ' AND uo.show_dob_date = 1';
		}

		// usergroups control
		if ($options->XfRu_BDay_searchGroups['_type'] != '_all')
		{
			$searchGroups = $this->getKeysFromOptionArray($options->XfRu_BDay_searchGroups);
			if (!empty($searchGroups))
			{
				$where .= ' AND u.user_group_id IN ('.implode(',', $searchGroups).')';
			}
		}

		// user state control
		if (!empty($options->XfRu_BDay_searchState))
		{
			$searchState = $this->getKeysFromOptionArray($options->XfRu_BDay_searchState, false);
		    if (!empty($searchState))
			{
				$where .= ' AND u.user_state IN ("'.implode('","', $searchState).'")';
			}
		}

		// user ban conrtol
		if ($options->XfRu_BDay_searchBanned)
		{
			$where .= ' AND is_banned IN (0,1)';
		} else {
			$where .= ' AND is_banned = 0';
		}

		$sql = '
			SELECT
			  up.dob_year,
			  u.*,
			  uo.show_dob_year, uo.show_dob_date
			FROM
			  `xf_user_profile` AS up
			LEFT JOIN `xf_user` AS u ON u.user_id=up.user_id
			LEFT JOIN `xf_user_option` AS uo ON uo.user_id=u.user_id
			WHERE
			  up.dob_day > 0
		';


	    return $sql . $where . ' ORDER BY user_id';
	}

	private function getKeysFromOptionArray(array $option, $onlyIntKeys = true)
	{
		$keys = array();
	    foreach ($option as $key => $v)
		{
			if ($onlyIntKeys)
			{
				if (is_int($key))
				{
					$keys[] = $key;
				}
			} else {
				$keys[] = $key;
			}

		}
	    return $keys;
	}

	private function isMemberOfOneOfTheGroups(array $groups)
	{
		$visitor = XenForo_Visitor::getInstance();
		$isMember = false;
		
		foreach ($groups as $groupId => $v)
		{
			if (is_int($groupId))
			{
				if ($visitor->isMemberOf($groupId, true))
				{
					$isMember = true;
					break;
				}
			}
		}

	    return $isMember;
	}

	public function canSeeBlock()
	{
		$optShowToGroups = XenForo_Application::get('options')->XfRu_BDay_showToGroups;
		
		if ($optShowToGroups['_type'] == '_some')
		{
		    return $this->isMemberOfOneOfTheGroups($optShowToGroups);
		} else {
			return true;
		}
	}

	public function canIgnorePrivacyControl($optPrivacyIgnore)
	{
		if ($optPrivacyIgnore['_type'] == '_some')
		{
			return $this->isMemberOfOneOfTheGroups($optPrivacyIgnore);
		} else {
			return true;
		}
	}

	private function getTimeWithTZOffset()
	{
	    return XenForo_Application::$time + XenForo_Locale::getTimeZoneOffset();
	}
}