//---  MDM QuickQuote 1.4.4 / vB4 ---
function qq_Post_Handler()
{
	this.posts = new Array();
	this.quote = '';
	this.activePost = null;
	this.hover = false;
	this.allowQuote = false;

	this.win = new qq_Popup_Window();
	this.win.button.onclick = qq_PostEntry.prototype.onclick;
}

qq_Post_Handler.prototype.register = function(tpost, nick)
{
	if (tpost && tpost.id)
	{
		var ident = 'post_', searchId = 'post_message_';
		if (qq_mode == 'article')
		{
			ident = 'post';
			if (nick) searchId = ident;
		}
		if (qq_mode == 'blog')
		{
			ident = 'comment_';
			if (nick) searchId = ident;
			else searchId = 'comment_text_';
		}
		var postid = (tpost.id != ident ? parseInt(tpost.id.substr(ident.length), 10) : '');
		var post = fetch_object(searchId + postid);
		if (post && (qq_mode == 'thread' || qq_mode == 'pm')) post = post.parentNode.parentNode;
		if (post)
		{
			post.postid = (postid != '' ? postid : 0);
			var links = new Array(), username = null;
			if ((nick && (links.push(nick))) || (links = fetch_tags(tpost, 'a')))
			{
				for (var i = 0; i < links.length; i++)
				{
					if (YAHOO.util.Dom.hasClass(links[i], "username"))
					{
						this.posts[post.postid] = new qq_PostEntry(post.postid, post, links[i]);
						break;
					}
				}
			}
			if ((typeof this.posts[post.postid] == 'undefined') && (username = YAHOO.util.Dom.getElementsByClassName("username", "span", fetch_object('post_' + postid))[0]))
			{
				this.posts[post.postid] = new qq_PostEntry(post.postid, post, username);
			}

			if (qq_hide_qrbtn)
			{
				var btn = fetch_object('qr_' + postid);
				if (btn)
				{
					btn.style.display = 'none';
					btn = btn.nextSibling.nextSibling;
					if (btn && btn.className == 'seperator') btn.style.display = 'none';
				}
			}
		}
	}
}

qq_Post_Handler.prototype.check = function(v)
{
	this.quote = PHP.trim(this.selection());

	if (this.quote != '' && qq_winpos > 0)
	{
		for (var postid in this.posts)
		{
			if (this.posts[postid].post == this.activePost)
			{
				this.posts[postid].nick.title = vbphrase['qq_nicktitle'];
				if (qq_winpos == 2 || v)
				{
					if (!this.win.visible || this.win.force)
						this.posts[postid].nick.title = '';
					this.win.force = v;
					var pos = YAHOO.util.Dom.getXY(this.posts[postid].nick);
					this.win.winX = pos[0];
					this.win.winY = pos[1] + this.posts[postid].nick.offsetHeight;
				}
				this.win.button.postid = postid;
				this.win.set();
				break;
			}
		}
	}
}

qq_Post_Handler.prototype.paste = function(obj, e)
{
	for (var postid in this.posts)
	{
		if (postid == obj.postid)
		{
			var entry = this.posts[postid];
			break;
		}
	}

	this.win.hide();
	YAHOO.vBulletin.vBPopupMenu.close_all();
	if (typeof entry != 'undefined')
	{
		if (typeof entry.nick.username == 'undefined')
		{
			entry.nick.username = PHP.trim(typeof entry.nick.textContent != 'undefined' ? entry.nick.textContent : entry.nick.innerText);
		}

		if (qq_mode == 'thread' || qq_mode == 'pm' || qq_mode == 'blog')
			var edt = vB_Editor[QR_EditorID];
		else if (qq_mode == 'article')
			var edt = vB_Editor[qq_editor_name];
		if (typeof edt == 'undefined') return false;

		var _require_click = (typeof require_click != 'undefined' && require_click);
		if (_require_click && edt.disabled) edt.write_editor_contents('');
		var wmode = edt.wysiwyg_mode;
		var content = edt.get_editor_contents();
		var delim = (wmode ? '<br />' : '\n');
		var quote = '';

		var username = entry.nick.username;
		if (this.quote == '' || this.activePost.postid != entry.postid)
		{
			if (username != '')
			{
				if (entry.nick.href && e.shiftKey)
				{
					if (wmode) username = '<a href="' + entry.nick.href + '">' + username + '</a>';
					else username = '[url="' + entry.nick.href + '"]' + username + '[/url]';
				}
				quote = (wmode ? '<b>' : '[b]') + username + (wmode ? '</b>' : '[/b]') + ', ';
			}
		}
		else
		{
			quote = '[quote' + (username != '' ? '="' + username + ((entry.postid > 0) && (qq_mode != 'blog') ? ';' + entry.postid : '') + '"' : '') + ']' + this.quote + '[/quote]' + delim;
		}
		this.quote = '';
		if (wmode) quote = quote.replace(/\n/g, '<br />');
		if (wmode && PHP.in_array(content, ['', '<br />', '<br>', '<P>&nbsp;</P>', '&nbsp;', '<b></b>', '<b></b><br>', '<P></P>']) != -1) content = '';
		if (content == '') delim = '';
		
		if (entry.postid > 0 && (qq_mode == 'thread' || qq_mode == 'pm'))
		{
			var cancelbtn = fetch_object('qr_cancelbutton');
			cancelbtn.style.display = '';

			var qrobj = document.createElement("li");
			qrobj.id = "qr_" + entry.postid;
			var post = YAHOO.util.Dom.get("post_" + postid);
			var qr_container = post.parentNode.insertBefore(qrobj, post.nextSibling);
			var qr_form = fetch_object('quick_reply');
			qr_container.appendChild(qr_form);
			qr_activate(entry.postid, (wmode ? ' ' : content + delim + quote));
			if (wmode) edt.insert_text(content + delim + quote, false);
		}
		else
		{
			edt.write_editor_contents((wmode ? ' ' : content + delim + quote), false);
			if (wmode) edt.insert_text(content + delim + quote, false);

		}
		edt.check_focus();
		if (!wmode)
		{
			var ewin = edt.editwin, len = ewin.value.length;
			if (ewin.setSelectionRange)
				ewin.setSelectionRange(len, len);
			else if (ewin.createTextRange)
				with (ewin.createTextRange())
				{
					collapse(false);
					select();
				}
			ewin.scrollTop = ewin.scrollHeight;
		}
		this.allowQuote = false;
		return true;
	}
	return false;
}

qq_Post_Handler.prototype.selection = function()
{
	if (window.getSelection) return window.getSelection().toString();
	else if (document.getSelection) return document.getSelection();
	else if (document.selection) return document.selection.createRange().text;
}

qq_Post_Handler.prototype.dohover = function(v, obj)
{
	this.hover = v;
	clearTimeout(this.win.timer);
	if (v)
	{
		if (this.allowQuote && this.activePost && this.activePost.postid == obj.postid)
		{
			this.check(true);
		}
	}
	else
	{
		this.posts[obj.postid].nick.title = vbphrase['qq_nicktitle'];
		if (qq_wintime > 0)
		{
			this.win.timer = setTimeout("qqPostData.win.hide()", qq_wintime * 1000);
		}
	}
}

//---  ---
function qq_PostEntry(postid, post, nick)
{
	this.postid = postid;

	this.post = post;
	this.post.onmouseup = this.postmouseup;

	this.nick = nick;
	this.nick.postid = postid;
	YAHOO.util.Event.purgeElement(this.nick, false, "click");
	YAHOO.util.Event.on(this.nick, "click", this.onclick, this, true);
	YAHOO.util.Dom.removeClass(this.nick, "popupctrl");

	this.nick.style.cursor = pointer_cursor;
	this.nick.setAttribute('title', vbphrase['qq_nicktitle']);
	this.nick.onmouseover = function(){qqPostData.dohover(true, this);};
	this.nick.onmouseout = function(){qqPostData.dohover(false, this);};

	if (this.nick.tagName == 'A' && typeof this.nick.done == 'undefined')
	{
		this.nick.done = true;
		span = document.createElement('span');
		span.className = 'popupctrl';
		with (span.style)
		{
			backgroundImage = 'url(' + IMGDIR_MISC + '/black_downward_arrow.png)';
			backgroundPosition = 'center center';
			backgroundRepeat = 'no-repeat';
			width = '12px';
			height = '12px';
			marginLeft = '4px';
			display = 'inline-block';
			cursor = pointer_cursor;
		}
		if ((qq_mode == 'article' || qq_mode == 'blog') && this.postid > 0)
		{
			span.style.backgroundImage = 'url(' + IMGDIR_MISC + '/navbit-arrow-right.png)';
			YAHOO.util.Event.on(span, "click", function(){location.href = this.nick.href;}, this, true);
		}
		else
			span.setAttribute('title', vbphrase['qq_usermenu']);
		this.nick.parentNode.insertBefore(span, this.nick.nextSibling);
	}
}

qq_PostEntry.prototype.postmouseup = function(e)
{
	e = e || window.event;

	t = (e.target || e.srcElement);
	if (t.tagName == 'TEXTAREA' || t.tagName == 'INPUT' || (t.tagName == 'IMG' && t.src.match(/\/editor\//)))
	{
		return;
	}

	if (e.pageX == null && typeof e.clientX == "number")
	{
		e.pageX = e.clientX + document.documentElement.scrollLeft;
		e.pageY = e.clientY + document.documentElement.scrollTop;
	}
	if (!e.which && e.button)
	{
		if (e.button & 1) e.which = 1;
	}
	if (e.which == 1)
	{
		qqPostData.win.force = false;
		qqPostData.win.winX = e.pageX;
		qqPostData.win.winY = e.pageY;
		qqPostData.activePost = this;
		qqPostData.allowQuote = true;
		setTimeout("qqPostData.check(false);", 0);
	}
}

qq_PostEntry.prototype.onclick = function(e)
{
	e = e || window.event;
	if (qqPostData.paste(this, e) && typeof do_an_e == 'function')
	{
		do_an_e(e);
	}
}

//---  ---
function qq_Popup_Window()
{
	this.visible = false;
	this.force = false;
	this.winX = -1;
	this.winY = -1;

	this.win = document.createElement('ul');
	this.win.className = 'popupbody';
	this.win.id = 'qqwin';
	this.win.style.minWidth = '0';

	this.button_c = document.createElement('li');
	this.button = document.createElement('label');
	this.button.postid = 0;
	this.button.innerHTML = '<img src="' + IMGDIR_EDITOR + '/quote.png" alt="" align="absmiddle" /> ' + vbphrase['qq_title'];
	this.button.style.padding = '3px 6px 2px 2px';
	this.button.style.fontWeight = 'bold';
	this.button.style.cursor = pointer_cursor;
	this.button.onmouseover = function(){qqPostData.dohover(true, this);};
	this.button.onmouseout = function(){qqPostData.dohover(false, this);};

	if (qq_mode == 'article')
	{
		this.win.style.paddingLeft = '0';
		this.button.style.marginLeft = '2px';
	}
	this.button_c.appendChild(this.button);
	this.win.appendChild(this.button_c);
	document.body.insertBefore(this.win, document.body.firstChild);
}

qq_Popup_Window.prototype.set = function()
{
	if (!this.visible)
		setTimeout("qqPostData.win.show()", 0);
}

qq_Popup_Window.prototype.show = function()
{
	this.visible = true;
	clearTimeout(this.timer);
	YAHOO.vBulletin.vBPopupMenu.close_all();
	if (qq_jQuery)
	{
		jQuery('#qqwin').css("opacity", "0").animate({height: "show", opacity: "1"}, 200);
	}
	else
	{
		this.win.style.display = 'block';
	}

	var l = this.winX;
	var t = this.winY;
	if (qq_winpos == 1 && !this.force)
	{
		var l = l - (this.win.offsetWidth / (is_ie ? 1 : 2));
		var t = t + 12;
	}
	this.win.style.left = l + 'px';
	this.win.style.top = t + 'px';
	if (qq_wintime > 0) this.timer = setTimeout("qqPostData.win.hide()", qq_wintime * 1000);
}

qq_Popup_Window.prototype.hide = function()
{
	this.visible = false;
	this.force = false;
	clearTimeout(this.timer);
	if (qq_jQuery) jQuery('#qqwin').stop(true, true);
	this.win.style.display = 'none';
}

//---  ---
function qq_init()
{
	var posts = new Array();
	if (qq_mode == 'thread')
		posts = fetch_tags(fetch_object('posts'), 'li');
	if (qq_mode == 'pm')
		posts.push(fetch_object('post_')); // Private Message

	if (qq_mode == 'article') // CMS Article
	{
		var post = YAHOO.util.Dom.getElementsByClassName("article", "")[0];
		var nick = YAHOO.util.Dom.getElementsByClassName("username", "a")[0];
		post.id = 'post';
		qqPostData.register(post, nick);
		posts = YAHOO.util.Dom.getElementsByClassName("postbit", "li");
	}

	if (qq_mode == 'blog') // Blog
	{
		var post = YAHOO.util.Dom.getElementsByClassName("blogcontent", "")[0];
		var nick = YAHOO.util.Dom.getElementsByClassName("username", "a")[0];
		post.id = 'comment_';
		qqPostData.register(post, nick);
		posts = YAHOO.util.Dom.getElementsByClassName("postbit", "li");
	}

	for (var i = 0; i < posts.length; i++)
	{
		if (posts[i] && posts[i].id && (posts[i].id.indexOf('post') == 0 || posts[i].id.indexOf('comment') == 0))
		{
			qqPostData.register(posts[i], null);
		}
	}

	function qqwin_hide(e)
	{
		if (!qqPostData.hover && qqPostData.win.visible)
		{
			qqPostData.win.hide();
			qqPostData.quote = '';
			qqPostData.allowQuote = false;
		}
	}

	qqPostBit_Init = PostBit_Init;
	PostBit_Init = function(obj, postid)
	{
		qqPostBit_Init(obj, postid);
		qqPostData.register(obj);
	}

	if (window.attachEvent && !is_saf) document.attachEvent('onmousedown', qqwin_hide);
	else if (document.addEventListener && !is_saf) document.addEventListener('mousedown', qqwin_hide, false);
	else window.onmousedown = qqwin_hide;
}
var qq_jQuery = (typeof jQuery == 'function' && jQuery.fn.jquery.replace(/\./g, '') >= 130);
var qqPostData = new qq_Post_Handler();
qq_init();
