<?php
/*
Plugin Name: XenForo
Plugin URI: http://domain.com/i-cant-afford-it-yet
Description: WordPress loves XenForo.
Version: 2.0
Author: XFRocks
Author URI: http://domain.com/i-cant-afford-it-yet
*/

$xfPath = get_option('xf_path');
if (!empty($xfPath)) {
	$xfFullPaths = array(
		realpath(ABSPATH . '/' . $xfPath), // treat as relative path
		realpath($xfPath), // absolute path?
	);
	foreach ($xfFullPaths as $xfFullPath) {
		if (is_dir($xfFullPath)) {
			define('XENFORO_PATH',$xfFullPath);
			break; // thanks God, we found a directory
		}
	}

	if (defined('XENFORO_PATH')) {
		require_once(dirname(__FILE__) . '/class_core.php');
		require(dirname(__FILE__) . '/pluggable.php');
		
		if (strpos($_SERVER['REQUEST_URI'],'wp-login.php') !== false) {
			if (!empty($_REQUEST['action'])) {
				switch ($_REQUEST['action']) {
					case 'lostpassword': $xf = XenForo_WP::create()->redirect('lost-password');
					case 'register': $xf = XenForo_WP::create()->redirect('register');
					// break is not needed
				}
			} else if (empty($_GET)) {
				$xf = XenForo_WP::create()->redirect('login');
			} else {
				$location = site_url('');
				header("Location: $location");
				exit;
			}
		}
	}
}

if (is_admin()) {
	require(dirname(__FILE__) . '/admin.php');
}

function xenforo_wpmu_new_blog($blog_id) {
	if (class_exists('XenForo_WP')) {
		// the bridge is active
		$ours = array('xf_path','xf_globalSalt','xf_roles_map');
		$found = array();
		foreach ($ours as $option_id) {
			$option_value = get_option($option_id);
			if (!empty($option_value)) {
				$found[$option_id] = $option_value;
			}
		}

		if (!empty($found)) {
			switch_to_blog($blog_id);
			foreach ($found as $option_id => $option_value) {
				// sync to new blog
				add_option($option_id, $option_value, '', 'yes');
			}
			restore_current_blog();
		}
	}
}

add_action('wpmu_new_blog','xenforo_wpmu_new_blog');

require(dirname(__FILE__) . '/loader.php');

/* XenForo rocks. Admit it! */