<?php
class XenForo_WP {
	function __construct() {
		$this->DIR = realpath(XENFORO_PATH);
		
		if (is_dir($this->DIR)) {
			$this->DIR .= '/';
		} else {
			trigger_error('Unable to communicate with XenForo system', E_ERROR);
		}
		
		$this->load_config();
		
		$this->COOKIE_PREFIX = $this->config['cookie']['prefix'];
		
		$this->prepare_db();
		$this->load_options();
		
		$this->userinfo = null;
		$this->strikes = 0;
	}
	
	function load_config() {
		// default config from XenForo_Application
		// remove parts out of interest
		$config = array(
			'db' => array(
				'adapter' => 'mysqli',
				'host' => 'localhost',
				'port' => '3306',
				'username' => '',
				'password' => '',
				'dbname' => ''
			),
			'globalSalt' => get_option('xf_globalSalt'),
			'cookie' => array(
				'prefix' => 'xf_',
				'path' => '/',
				'domain' => ''
			),
			'internalDataPath' => 'internal_data',
			'session' => array( // this one is from XenForo_Session
				'ipCidrMatch' => 24,
			),
		);
		require($this->DIR . 'library/config.php'); // overwrite the default config array
		$this->config = $config;
		
		
		$required = array('db','globalSalt','cookie');
		foreach ($required as $key) {
			if (empty($this->config[$key])) {
				echo "XenForo configuration missing: $key. Auto disabled the bridge, please re-configure...";
				update_option('xf_path', '');
				exit;
			}
		}
	}
	
	function prepare_db() {
		//keep an instance of Wordpress's db
		$this->wpdb =& $GLOBALS['wpdb'];
		
		//setup XenForo's db
		$db_host = $this->config['db']['host'];
		$db_user = $this->config['db']['username'];
		$db_password = $this->config['db']['password'];
		$db_name = $this->config['db']['dbname'];
		if ($db_user == DB_USER AND $db_password == DB_PASSWORD AND $db_name == DB_NAME AND $db_host == DB_HOST) {
			//wow, same database for Wordpress and XenForo, use the existing wpdb object
			$this->xfdb =& $GLOBALS['wpdb'];
		} else {
			//create a new connection
			$this->xfdb = new wpdb($db_user, $db_password, $db_name, $db_host);
		}
	}
	
	function load_options() {
		$this->options = array();
		
		$roles_map = get_option('xf_roles_map');
		if (empty($roles_map)) {
			//it appears like the plugin has just been installed
			//we will automatically map the Administrative usergroup (#3) with administrator user role
			$roles_map = array(
				'3' => 'administrator',
			);
			add_option('xenforo_roles_map', $roles_map, '', 'yes'); //we want this auto loaded, improve performance
		}
		$this->options['roles_map'] = $roles_map;

		// $xfOptions = get_option('xf_options');
		$xfOptions = array();
		$xfOptions_required = array(
			'boardTitle'
			,'boardUrl'
			,'useFriendlyUrls'
		);
		if ($xfOptions === false OR count($xfOptions) != count($xfOptions_required)) {
			// it appears like the plugin has just been installed (or reset?)
			// we will get these crucial information from XenForo's database
			// actually, we are going to do this ALL THE TIME
			$xfOptions_raw = $this->xfdb->get_results("
				SELECT option_id, option_value
				FROM `xf_option`
				WHERE option_id IN ('" . implode("','", $xfOptions_required) . "')
			");
			$xfOptions = array();
			foreach ($xfOptions_raw as $xfOption) {
				$xfOptions[$xfOption->option_id] = $xfOption->option_value;
			}
			// add_option('xenforo_options', $xfOptions, '', 'yes');
		}
		$this->options = array_merge($this->options, $xfOptions);
	}
	
	static function create() {
		static $instance;
		
		if (empty($instance)) $instance = new XenForo_WP();
		
		return $instance;
	}
	
	//main function
	function validate_auth_cookie() {
		$sessionId = @$_COOKIE[$this->COOKIE_PREFIX . 'session'];
		$usercookie = @$_COOKIE[$this->COOKIE_PREFIX . 'user'];
		$gotsession = false;
		$session = null;
		$userinfo = null;
		
		if (class_exists('XenForo_Visitor')) {
			// wow, we are in XenForo now
			$visitor =& XenForo_Visitor::getInstance();
			if ($visitor->get('user_id') > 0) {
				$array = $visitor->toArray();
				$userinfo = new StdClass();
				foreach ($array as $akey => $avalue) {
					$userinfo->$akey = $avalue;
				}
			}
		} else {
			if ($sessionId) {
				$session = $this->xfdb->get_row("
					SELECT *
					FROM `xf_session`
					WHERE session_id = '" . $this->xfdb->_real_escape($sessionId) /* we don't want to be hacked */ . "'
						AND expiry_date > " . time() . "
				");
				if (!empty($session)) {
					$session->session_data = unserialize($session->session_data);
					$ipAddress = $this->getIpAddressHash();
					if (empty($ipAddress) OR empty($this->config['session']['ipCidrMatch']) OR $this->config['session']['ipCidrMatch'] < 0) {
						// let it through
					} else {
						// check the IP address
						// code copied from XenForo_Session
						$shiftAmount = 32 - min($this->config['session']['ipCidrMatch'], 32);
						$ipMatched = (($session->session_data['ip'] >> $shiftAmount) === ($ipAddress >> $shiftAmount));
						if (!$ipMatched) {
							$session = false;
						}
					}
					
				}
				if (!empty($session)) {
					$gotsession = true;
					// found a session - get the userinfo
					if (!empty($session->session_data['user_id'])) {
						$userinfo = $this->setupUser($session->session_data['user_id']);
					}
				}
			}
			
			if ($gotsession == false OR empty($userinfo) AND $usercookie) {
				// try to login using cookie
				// code copied from XenForo_Model_User
				$parts = explode(',', $usercookie);
				if (count($parts) >= 2) {
					$userId = intval($parts[0]);
					$rememberKey = $parts[1];
					if (!empty($userId) AND !empty($rememberKey)) {
						$authRecord = $this->getAuthRecord($userId);
						if (empty($authRecord)) {
							// *sigh*
						} else if ($rememberKey == $this->hashRememberKey($authRecord->remember_key)) {
							// wow!
							$userinfo = $this->setupUser($userId);
							$this->setCookie('user',$usercookie,time() + 7*86400); // simply extend the current cookie value
						}
					}
				}
			}
						
			//we don't process any more (with guests/creating new session)
			//just leave it there
		}
		
		if (!empty($userinfo)) {
			$wp_userinfo = $this->createUser($userinfo);
			$wp_userid = $wp_userinfo->ID;
		}
		
		if (!empty($wp_userid)) {
			$this->userinfo =& $userinfo; //store our XenForo's userinfo
			$this->session =& $session;
			return $wp_userid;
		} else {
			return 0;
		}
	}
	
	function logout() {
		$nonce = $_REQUEST['_wpnonce'];
		if (!wp_verify_nonce($nonce, 'log-out')) die('Security check'); // the action 'log-out' is used by WP
		
		if (!empty($this->userinfo) AND $this->userinfo->is_admin) {
			// remove admin session if any
			$adminSessionId = @$_COOKIE[$this->COOKIE_PREFIX . 'admin_session'];
			$adminSession = $this->xfdb->query("
				DELETE
				FROM `xf_session_admin`
				WHERE session_id = '" . $this->xfdb->_real_escape($adminSessionId) . "'
			");
		}

		// clear all cookies beginning with COOKIE_PREFIX
		// code copied from vBulletin
		$prefix_length = strlen($this->COOKIE_PREFIX);
		$cookie_vars = array();
		foreach ($_COOKIE AS $key => $val) {
			$index = strpos($key, $this->COOKIE_PREFIX);
			if ($index == 0 AND $index !== false) {
				$key = substr($key, $prefix_length);
				if (trim($key) == '') {
					continue;
				}
				$cookie_vars[$key] = '';
			}
		}
		foreach ($cookie_vars as $key => $value) {
			$this->setCookie($key,false);
		}

		if (!empty($this->session)) {
			$this->xfdb->query("
				DELETE
				FROM `xf_session`
				WHERE session_id = '" . $this->session->session_id . "'
			");
		}
		
		//ignore guest session (again)
	}
	
	function setupUser($user_id) {
		$user_id = intval($user_id);
		return $this->xfdb->get_row("
			SELECT *
			FROM `xf_user`
			WHERE user_id = $user_id
		");
	}
	
	function getUsergroups() {
		return $this->xfdb->get_results("
			SELECT *
			FROM `xf_user_group`
		");
	}
	
	//create Wordpress user record if needed
	function createUser($userinfo) {
		require_once(ABSPATH . WPINC . '/registration.php');
		
		$wp_userinfo = get_userdatabylogin($userinfo->username);
		$correct_role = $this->findSuitableRole($userinfo);
		
		if (empty($wp_userinfo->ID)) {
			// use a semi-random password for the generated user...
			$wp_userid = wp_create_user($userinfo->username,$this->hashRememberKey($userinfo->username),$userinfo->email);
			if ($wp_userid instanceof WP_Error) {
				// the only error can happen is existed email...
				// create a new user without email, LOL
				$wp_userid = wp_create_user($userinfo->username,$this->hashRememberKey($userinfo->username),'');
			}
			$wp_userinfo = get_userdatabylogin($userinfo->username);
		}
		
		if (!empty($wp_userinfo)) {
			//validate user's role
			if (!empty($correct_role)) {
				$cap = @$wp_userinfo->{$this->wpdb->prefix . 'capabilities'};
				if (empty($cap)) {
					// hmm, MU?
					$cap = @$wp_userinfo->wp_capabilities;
				}
				if (is_array($cap)) {
					if (!isset($cap[$correct_role]) OR empty($cap[$correct_role])) {
						$user = new WP_User($wp_userinfo->ID);					
						$user->set_role($correct_role);
					}
				}
			}
		}
		
		return $wp_userinfo;
	}
	
	//find a role for a user
	function findSuitableRole($userinfo) {
		global $wp_roles;
		if (!isset($wp_roles)) $wp_roles = new WP_Roles();
		$varnames = array_keys($wp_roles->get_names());
		$userGroupIds = array($userinfo->user_group_id);
		$secondary_group_ids = explode(',',$userinfo->secondary_group_ids);
		if (!empty($secondary_group_ids)) {
			foreach ($secondary_group_ids as $id) {
				if (!empty($id)) $userGroupIds[] = $id;
			}
		}
		
		foreach ($varnames as $varname) {
			foreach ($this->options['roles_map'] as $id => $role) {
				if (!empty($role) AND $role == $varname AND in_array($id,$userGroupIds)) return $role;
			}
		}
		return null;
	}
	
	function getIpAddressHash() {
		$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false);
		if (is_string($ipAddress) && strpos($ipAddress, '.')) {
			$ipAddress = ip2long($ipAddress); // LOL, thanks XF. I haven't known this function yet
		} else {
			$ipAddress = false;
		}
		return $ipAddress;
	}
	
	function getAuthRecord($userId) {
		$userId = intval($userId);
		return $this->xfdb->get_row("
			SELECT *
			FROM `xf_user_authenticate`
			WHERE user_id = $userId
		");
	}
	
	function hashRememberKey($rememberKey) {
		return sha1($this->config['globalSalt'] . $rememberKey);
	}
	
	function setCookie($name,$value,$exp = 0,$httpOnly = false,$secure = null) {
		$path = $this->config['cookie']['path'];
		$domain = $this->config['cookie']['domain'];
		if ($value === false) {
			$exp = time() - 86400*365;
		}
		$name = $this->config['cookie']['prefix'] . $name;
		
		return setcookie($name, $value, $exp, $path, $domain, $secure, $httpOnly);
	}
	
	function redirect($target) {
		if ($this->options['useFriendlyUrls']) {
			$location = $this->options['boardUrl'] . "/$target/";
		} else {
			$location = $this->options['boardUrl'] . "/index.php?$target/";
		}
		header("Location: $location");
		exit;
	}
}
/* XenForo rocks. Admit it! */