<?php

foreach (array('wp_the_query','wp_query','wp_rewrite','wp','wp_widget_factory','wp_locale') AS $needglobalizing) {
	$GLOBALS[$needglobalizing] =& $$needglobalizing;
}

function xenforo_user_info($user) {
	bdWordPressProxy_TemplateHelper::addRequiredExternal('css','message_user_info');
	?>
	<div class="messageUserInfo">
			<div class="messageUserBlock">
				<div class="avatarHolder">
					<?php echo bdWordPressProxy_TemplateHelper::prepare('XenForo_Template_Helper_Core::avatarHtml',array(
							$user,
							'm',
							false,
							array(
								'user' => '$user',
								'size' => 'm',
								'itemprop' => 'photo'
							)
							,''
						)) ?>
				</div>
				<h3 class="userText">
					<?php if ($user['user_id']): ?>
					<a href="<?php echo bdWordPressProxy_TemplateHelper::prepare('XenForo_Link::buildPublicLink',array(
						'members',
						$user,
					)); ?>"><?php echo $user['username'] ?></a>
					<?php else: ?>
					<?php echo $user['username'] ?>
					<?php endif; ?>
				</h3>
				<span class="arrow"><span></span></span>
			</div>
		</div><!-- .messageUserInfo -->
<?php
}

function xenforo_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	if (!empty($comment->xf_user)) {
		$xf_user = $comment->xf_user;
	} else {
		$xf_user = array('gender' => 'm','user_id' => 0,'username' => $comment->comment_author);
	}
	bdWordPressProxy_TemplateHelper::addRequiredExternal('css','message');
	
	switch ( $comment->comment_type ) :
		case '' :
?>
	<li id="li-comment-<?php comment_ID(); ?>" class="message">
		<?php xenforo_user_info ($xf_user) ?>
		<div class="messageInfo">
			<div class="messageContent">
				<blockquote class="messageText ugc baseHtml">
					<?php comment_text() ?>
				</blockquote>
			</div>
			<div class="messageMeta">
				<div class="privateControls">
					<span class="item muted">
						<?php echo XenForo_Template_Helper_Core::dateTimeHtml(get_the_date('U')) ?>
						<?php if ( $comment->comment_approved == '0' ) : ?>
							<br /><em><?php _e( 'Your comment is awaiting moderation.', 'twentyten' ); ?></em>
						<?php endif; ?>
					</span>
				</div>
				<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div>
		</div><!-- .messageInfo -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<?php
			break;
	endswitch;
}

function xenforo_get_posted_info() {
	return sprintf(__( 'Posted by %1$s'),
		sprintf( '<a href="%1$s" title="%2$s">%3$s</a>',
			get_author_posts_url( get_the_author_meta( 'ID' ) ),
			sprintf( esc_attr__( 'View all posts by %s' ), get_the_author() ),
			get_the_author()
		))
		. ', ' . XenForo_Template_Helper_Core::dateTimeHtml(get_the_date('U'));
}

function xenforo_get_breadcrumb_link() {
	global $wp_query;
	$qo = $wp_query->get_queried_object();

	if (is_category()) {
		get_category_link($qo->term_id);
	}
	
	return $_SERVER['REQUEST_URI'];
}
