<?php

if (class_exists('XenForo_Application')) {
	// only work if we are in XenForo
	function xenforo_stylesheet_directory($path) {
		define('XF_ORIGINAL_STYLESHEETPATH',$path);
		return dirname(__FILE__) . '/theme';
	}
	add_filter('stylesheet_directory','xenforo_stylesheet_directory');
	
	function xenforo_home_url($url) {
		// I must say it's a WP bug when filter args are missing ALL THE TIME
		$home_parsed = parse_url(get_option('home'));
		$url_parsed = parse_url($url);
		$xf_parsed = parse_url(XenForo_Application::get('options')->boardUrl);
		
		$parsed = $url_parsed;
		$parsed['host'] = $xf_parsed['host'];
		$parsed['path'] = $xf_parsed['path'] . '/' . bdWordPressProxy_TemplateHelper::routePrefix() . str_replace($home_parsed['path'],'',$url_parsed['path']);
		
		$result = "$parsed[scheme]://$parsed[host]$parsed[path]";
		if (!empty($parsed['query'])) $result .= "?$parsed[query]";
		return $result;
	}
	add_filter('home_url','xenforo_home_url');
	
	function xenforo_comments_array($comments) {
		$usernames = array();
		$users = array();
		$wp_user_id = wp_get_current_user()->ID;
		$xf_user = XenForo_Visitor::getInstance()->toArray();
		foreach ($comments as &$comment) {
			if ($comment->user_id) {
				if ($comment->user_id == $wp_user_id) {
					$comment->xf_user = $xf_user;
				} else {
					$usernames[$comment->user_id] = $comment->comment_author;
				}
			}
		}
		if (!empty($usernames)) {
			$db = XenForo_Application::get('db');
			$usersRaw = $db->fetchAll('
				SELECT user.*
				FROM xf_user AS user
				WHERE user.username IN (?)
			',$db->quote($usernames));
			$users = array();
			for ($i = 0; $i < count($usersRaw); $i++) {
				$users[$usersRaw[$i]['username']] =& $usersRaw[$i];
			}
			foreach ($comments as &$comment) {
				if ($comment->user_id AND empty($comment->xf_user) AND isset($users[$comment->comment_author])) {
					$comment->xf_user = $users[$comment->comment_author];
				}
			}
		}
		
		return $comments;
	}
	add_filter('comments_array','xenforo_comments_array');
	
	function xenforo_dynamic_sidebar_params($params) {
		$id = 'id="' . $params[0]['widget_id'] . '"';
		$params[0]['before_widget'] = '<div ' . $id . ' class="section"><div class="secondaryContent">';
		$params[0]['after_widget'] = '</div></div>'; 
		$params[0]['before_title'] = '<h3>';
		$params[0]['after_title'] = '</h3>'; // this one is not really needed
		return $params;
	}
	add_filter('dynamic_sidebar_params','xenforo_dynamic_sidebar_params');
}