<?php

class ModerateCountry_RegisterController extends XFCP_ModerateCountry_RegisterController
{
	public function actionRegister()
	{
		$options = XenForo_Application::get('options');
		$errors = array();
		$data   = $this->_input->filter(array(
	            'username'   => XenForo_Input::STRING,
	            'email'      => XenForo_Input::STRING,
	            'timezone'   => XenForo_Input::STRING,
	            'gender'     => XenForo_Input::STRING,
	            'dob_day'    => XenForo_Input::UINT,
	            'dob_month'  => XenForo_Input::UINT,
	            'dob_year'   => XenForo_Input::UINT,
	        )); 
	       
		$ip_list = array();	
	
		$dhandle = @opendir(XenForo_Application::getInstance()->getConfigDir() . '/ModerateCountry/zones');
		
		$files = array();
	
		if ($dhandle) {
	 
			while (false !== ($fname = readdir($dhandle))) {
	
				if (($fname != '.') && ($fname != '..') && (preg_match('/zone/',$fname))) {
	
					$tmp_cnt = preg_split('/\./',$fname);
	
					$ips = file(XenForo_Application::getInstance()->getConfigDir() . '/ModerateCountry/zones/' . $fname);
	
					foreach ((array) $ips as $ip) {
		
						$ip_list[trim($ip)] = $tmp_cnt[0];
					}
	
				}
	   		}
	
		}	
	
	   	closedir($dhandle);
	
		$country = '';
	
		foreach ($ip_list as $cidr => $val) {
	
			if ($this->_netMatch($cidr, $_SERVER['REMOTE_ADDR'])) {
	
				$country = strtoupper($val);
	
				continue;
			}
		}
	
		$invalid_countries = explode(",",preg_replace("| |",'',strtoupper(XenForo_Application::get('options')->moderate_country_countries)));
	
		if (in_array($country, $invalid_countries)) 
		{
			$errors[] = new XenForo_Phrase('country_mod_no_reggie');
			$fields = $data;
			$fields['tos'] = $this->_input->filterSingle('agree', XenForo_Input::UINT);
			return $this->_getRegisterFormResponse($fields, $errors);
		}

		return parent::actionRegister();
	}

	protected function _netMatch($CIDR,$IP) {
	
		list ($net, $mask) = explode ('/', $CIDR);
		return ( ip2long ($IP) & ~((1 << (32 - $mask)) - 1) ) == ip2long ($net);
	} 
}