<?php
class DBTech_TopXStats_Model_TopStats extends XenForo_Model
{
	/**
	 * Fetches Top X Stats from the database, default limit is 5
	 * @param int $limit
	 * @return array Rows of top stats
	 */
	public function getTopStats($limit = 5)
	{
		// Cache a few phrases we'll be using
		$phraseCache = array(
			'Members' 	=> new XenForo_Phrase('dbtech_topxstats_newest_members'),
			'Posts' 	=> new XenForo_Phrase('dbtech_topxstats_top_posters'),
			'Replies' 	=> new XenForo_Phrase('dbtech_topxstats_latest_replies')
		);
		
		// Init the retval array 		
		$retval = array();			
		
		foreach (array('Members', 'Posts', 'Replies') as $model)
		{
			// Loop through each model we're using and get its top stats
			$retval[$phraseCache[$model]->render()] = $this->_getTopStatsModel($model)->getTopStats($limit);
		}
		
		return $retval;
	}
	
	/**
	 * Fetches the specified model for usage with the Top X Stats
	 * @param string The Top Stats block we're using
	 * @return DBTech_TopXStats_Model_X
	 */
	protected function _getTopStatsModel($model)
	{
		return $this->getModelFromCache('DBTech_TopXStats_Model_' . $model);
	}	
}