<?php
class DBTech_TopXStats_Model_Replies extends XenForo_Model
{
	/**
	 * Fetches the X latest members from the database.
	 * @param int $limit
	 * @return array Rows of top stats
	 */
	public function getTopStats($limit = 5)
	{
		// Cache a few phrases we'll be using
		$phraseCache = array(
			'thread_title' 	=> new XenForo_Phrase('dbtech_topxstats_thread_title'),
			'forum_title' 	=> new XenForo_Phrase('dbtech_topxstats_forum_title'),
			'poster' 		=> new XenForo_Phrase('dbtech_topxstats_last_post_by')
		);		
		
		$retval = array(
			'subHeaders' => array(
				1 => $phraseCache['thread_title']->render(),
				2 => $phraseCache['forum_title']->render(),
				3 => $phraseCache['poster']->render(),
			),
			'data' => array()
		);
				
		// TODO :: Exclude groups, proper limiting, exclude forums
		$data = $this->_getDb()->fetchAll($this->limitQueryResults("
			SELECT 
				post.user_id,
				post.post_id,
				thread.thread_id, 
				thread.title AS thread_title,
				thread.node_id,
				node.title AS forum_title,
				user.username
			FROM xf_post AS post
			LEFT JOIN xf_thread AS thread ON(thread.thread_id = post.thread_id)
			LEFT JOIN xf_node AS node ON(node.node_id = thread.node_id)
			LEFT JOIN xf_user AS user ON(user.user_id = post.user_id)
			WHERE NOT ISNULL(thread.thread_id)	
				AND thread.discussion_state = 'visible'
			ORDER BY post.post_date DESC
		", $limit, 0));		

		foreach ($data as $key => $values)
		{
			$i = $key + 1;
			
			// TODO :: Proper trim settings
			$retval['data'][1][$i] = array(
				'href' 	=> XenForo_Link::buildPublicLink('posts', array('post_id' => $values['post_id'])),
				'title' => $values['thread_title'],
				'value' => XenForo_Helper_String::wholeWordTrim($values['thread_title'], XenForo_Application::get('options')->dbtech_topxstats_trimthreadtitle),
			);
			
			$retval['data'][2][$i] = array(
				'href' 	=> XenForo_Link::buildPublicLink('forums', array('node_id' => $values['node_id'], 'title' => $values['forum_title'])),
				'title' => $values['forum_title'],
				'value' => XenForo_Helper_String::wholeWordTrim($values['forum_title'], XenForo_Application::get('options')->dbtech_topxstats_trimforumtitle),
			);

			$retval['data'][3][$i] = array(
				'href' 	=> XenForo_Link::buildPublicLink('members', array('user_id' => $values['user_id'], 'username' => $values['username'])),
				'title' => $values['username'],
				'value' => XenForo_Helper_String::wholeWordTrim($values['username'], XenForo_Application::get('options')->dbtech_topxstats_trimusername),
			);
		}
		
		return $retval;
	}
}