<?php
class DBTech_TopXStats_Model_Posts extends XenForo_Model
{
	/**
	 * Fetches the X top posters from the database.
	 * @param int $limit
	 * @return array Rows of top stats
	 */
	public function getTopStats($limit = 5)
	{
		// Cache a few phrases we'll be using
		$phraseCache = array(
			'user_name' 	=> new XenForo_Phrase('dbtech_topxstats_username'),
			'numposts' 		=> new XenForo_Phrase('dbtech_topxstats_posts'),
			'viewposts' 	=> new XenForo_Phrase('dbtech_topxstats_view_posts'),
			'findposts'		=> new XenForo_Phrase('dbtech_topxstats_find_posts'),
		);		
		
		$retval = array(
			'subHeaders' => array(
				1 => $phraseCache['user_name']->render(),
				2 => $phraseCache['numposts']->render(),
				3 => $phraseCache['viewposts']->render(),
			),
			'data' => array()
		);
		
		// TODO :: Exclude groups, proper limiting, exclude forums
		$data = $this->_getDb()->fetchAll($this->limitQueryResults("
			SELECT 
				user.username,
				user.user_id,
				user.message_count
			FROM xf_user AS user
			WHERE is_banned = '0'
			ORDER BY user.message_count DESC
		", $limit, 0));
		
		foreach ($data as $key => $values)
		{
			// Store the findposts phrase
			$findposts = new XenForo_Phrase('find_all_content_by_x', array('name' => $values['username']));
			
			$i = $key + 1;
			
			// TODO :: Proper trim settings
			$retval['data'][1][$i] = array(
				'href' 	=> XenForo_Link::buildPublicLink('members', array('user_id' => $values['user_id'], 'username' => $values['username'])),
				'title' => $values['username'],
				'value' => XenForo_Helper_String::wholeWordTrim($values['username'], XenForo_Application::get('options')->dbtech_topxstats_trimusername),
			);
			
			$retval['data'][2][$i] = array(
				'value' => XenForo_Locale::numberFormat($values['message_count']),
			);

			$retval['data'][3][$i] = array(
				'href' 	=> XenForo_Link::buildPublicLink('search/member', '', array('user_id' => $values['user_id'])),
				'title' => $findposts->render(),
				'value' => $phraseCache['findposts']->render(),
			);
		}		
		
		return $retval;
	}
}