<?php
class DBTech_TopXStats_Model_Members extends XenForo_Model
{
	/**
	 * Fetches the X latest members from the database.
	 * @param int $limit
	 * @return array Rows of top stats
	 */
	public function getTopStats($limit = 5)
	{
		// Cache a few phrases we'll be using
		$phraseCache = array(
			'user_name' 	=> new XenForo_Phrase('dbtech_topxstats_username'),
			'posts' 		=> new XenForo_Phrase('dbtech_topxstats_posts'),
			'join_date' 	=> new XenForo_Phrase('dbtech_topxstats_joindate'),
		);		
		
		$retval = array(
			'subHeaders' => array(
				1 => $phraseCache['user_name']->render(),
				3 => $phraseCache['posts']->render(),
				2 => $phraseCache['join_date']->render(),
			),
			'data' => array()
		);

		// TODO :: Exclude groups, proper limiting, exclude forums
		$data = $this->_getDb()->fetchAll($this->limitQueryResults("
			SELECT 
				user.username,
				user.user_id,
				user.message_count,
				user.register_date
			FROM xf_user AS user
			WHERE is_banned = '0'
			ORDER BY user.register_date DESC
		", $limit, 0));
		
		foreach ($data as $key => $values)
		{
			$i = $key + 1;
			
			// TODO :: Proper trim settings
			$retval['data'][1][$i] = array(
				'href' 	=> XenForo_Link::buildPublicLink('members', array('user_id' => $values['user_id'], 'username' => $values['username'])),
				'title' => $values['username'],
				'value' => XenForo_Helper_String::wholeWordTrim($values['username'], XenForo_Application::get('options')->dbtech_topxstats_trimusername),
			);
			
			$retval['data'][2][$i] = array(
				'value' => XenForo_Locale::numberFormat($values['message_count']),
			);

			$retval['data'][3][$i] = array(
				'value' => XenForo_Locale::date($values['register_date']),
			);
		}		
		
		return $retval;
	}
}