<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTech_TopXStats_Controller_Index extends XenForo_ControllerPublic_Abstract
{
	/** 
	 * View top x stats
	 * @return XenForo_ControllerResponse_View
	 */
	public function actionIndex()
	{
		$viewParams = array(
			'topstats'	=> $this->_getTopStatsModel()->getTopStats(XenForo_Application::get('options')->dbtech_topxstats_limit),
		);
		
		return $this->responseView('DBTech_TopXStats_View_Index', 'dbtech_topxstats_box', $viewParams['topstats']);
	}

	/**
	 * @return DBTech_TopXStats_Model_TopStats
	 */
	protected function _getTopStatsModel()
	{
		return $this->getModelFromCache('DBTech_TopXStats_Model_TopStats');
	}
}