/**
 * @author Belazor
 */
(function($)
{
	XenForo.TopXStats = function()
	{
		var label = $('#dbtech_topxstats_seconds'), refreshtime = 60, timeout, getStats = function()
		{
			label.text(0);
			XenForo.ajax('index.php?topxstats/', '', function(ajaxData)
			{
				if (XenForo.hasResponseError(ajaxData)) return false;

				for (var i = 1; i <= 3; i++)
				{					
					$('#dbtech_topstats_header' + i).text(ajaxData['header'][i]);
					$('#dbtech_topstats_data' + i).html(ajaxData['data'][i]);
				}

				timeout = refreshtime;
			}, { type: 'GET' });
		};

		setInterval(function()
		{	// Decrement the timer or fetch stats again
			if (--timeout)
			{
				if (timeout < 0)
				{
					timeout = 0;
				}
				label.text(timeout);
			}
			else
			{
				getStats();
			}
		}, 1000);

		getStats();
	};

	/**
	 * Register and initialise
	 */
	XenForo.register('#TopXStats', XenForo.TopXStats);
})(jQuery);