<?php
/****
 * Users Viewing Thread
 * Copyright 2010; Deceptor (http://dragonbyte-tech.com)
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

class DBTech_UsersViewingThread_Model_Session extends XenForo_Model_Session
{
	/**
	 * Extends the normal session conditions to limit those viewing a specific thread.
	 * 
	 * @return string
	 * @see XenForo_Model_Session::prepareSessionActivityConditions()
	 */
	
	public function prepareSessionActivityConditions(array $conditions, array &$fetchOptions)
	{
		$rawConditions = parent::prepareSessionActivityConditions($conditions, $fetchOptions);
		$sqlConditions = $rawConditions == '1=1' ? array() : explode(') AND (', $rawConditions);

		if (isset($conditions['controller']))
		{
			$sqlConditions[] = "session_activity.controller_name = '$conditions[controller]'";
		}

		if (isset($conditions['threadid']))
		{
			$sqlConditions[] = "(
				session_activity.params like '%thread_id=" . intval($conditions['threadid']) . "'
			or
				session_activity.params like '%thread_id=" . intval($conditions['threadid']) . "&%'
			)";
		}

		return $this->getConditionsForClause($sqlConditions);
	}
}