<?php
/****
 * Users Viewing Thread
 * Copyright 2010; Deceptor (http://dragonbyte-tech.com)
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

class DBTech_UsersViewingThread_Model_UsersViewingThread extends XenForo_Model
{
	/**
	 * Gets the users viewing the current thread.
	 * 
	 * @param int $threadid
	 * @return array
	 */
	public function getUsersViewingThread($threadid = 0)
	{
		return $this->_fetchUsersViewingThread($threadid);
	}

	protected function _fetchUsersViewingThread($threadid = 0)
	{
		$visitor = XenForo_Visitor::getInstance();
		$bypassUserPrivacy = $this->getModelFromCache('XenForo_Model_User')->canBypassUserPrivacy();

		return array_merge($this->getModelFromCache('DBTech_UsersViewingThread_Model_Session')->getSessionActivityQuickList(
			$visitor->toArray(),
			array(
				'cutOff'			=> array('>', $this->getModelFromCache('XenForo_Model_Session')->getOnlineStatusTimeout()),
				'controller'		=> 'XenForo_ControllerPublic_Thread',
				'threadid'			=> $threadid,
				'getInvisible'		=> $bypassUserPrivacy,
				'getUnconfirmed'	=> $bypassUserPrivacy,
			),
			($visitor['user_id'] ? $visitor->toArray() : null)
		), array('bypassPrivacy' => $bypassUserPrivacy));
	}
}