<?php
/****
 * Users Viewing Thread
 * Copyright 2010; Deceptor (http://dragonbyte-tech.com)
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

class DBTech_UsersViewingThread_Controller_UsersViewingThread extends XFCP_DBTech_UsersViewingThread_Controller_UsersViewingThread
{
	/**
	 * @see XenForo_ControllerPublic_Thread::actionIndex()
	 */
	public function actionIndex()
	{
		$response = parent::actionIndex();

		if ($response instanceof XenForo_ControllerResponse_View && XenForo_Application::get('options')->dbtech_uvf_enabled)
		{
			$response->params['usersViewingThread'] = $this->_getUsersViewingThreadModel()->getUsersViewingThread($response->params['thread']['thread_id']);
			return $this->responseView('XenForo_ViewPublic_Thread_View', 'thread_online', $response->params);
		}

		return $response;
	}
	
	/**
	 * @return	DBTech_UsersViewingThread_Model_UsersViewingThread
	 */
	protected function _getUsersViewingThreadModel()
	{
		return $this->getModelFromCache('DBTech_UsersViewingThread_Model_UsersViewingThread');
	}
}