<?php
class FirstPostOnAllPages_Install
{
	private static $_instance;

	protected $_db;

	public static final function getInstance()
	{
		if (!self::$_instance)
		{
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	protected function _getDb()
	{
		if ($this->_db === null)
		{
			$this->_db = XenForo_Application::get('db');
		}

		return $this->_db;
	}

	public static function install($existingAddOn, $addOnData)
	{
		$startVersionId = 1;
		$endVersionId = $addOnData['version_id'];

		if ($existingAddOn)
		{
			$startVersionId = $existingAddOn['version_id'] + 1;
		}

		$install = self::getInstance();

		for ($i = $startVersionId; $i <= $endVersionId; $i++)
		{
			$method = '_installVersion' . $i;
			if (method_exists($install, $method) === false)
			{
				continue;
			}

			$install->$method();
		}
	}

	protected function _installVersion1()
	{
                $this->_getDb();

                $this->_db->query("ALTER TABLE `xf_thread` ADD `firstpoststicked` INT( 10 ) NOT NULL DEFAULT '0'");
	}

	protected function _installVersion2()
	{
                $this->_getDb();

                $this->_db->query("ALTER TABLE `xf_thread` CHANGE `firstpoststicked` `firstpoststicked` INT( 10 ) NOT NULL DEFAULT '0'");
	}
}
