<?php
class FirstPostOnAllPages_UnInstall
{
	private static $_instance;

	protected $_db;

	public static final function getInstance()
	{
		if (!self::$_instance)
		{
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	protected function _getDb()
	{
		if ($this->_db === null)
		{
			$this->_db = XenForo_Application::get('db');
		}

		return $this->_db;
	}

	public static function uninstall($addOnData)
	{
		$startVersionId = $addOnData['version_id'];
		$endVersionId = 1;

		$uninstall = self::getInstance();

		for ($i = $startVersionId; $i >= $endVersionId; $i--)
		{
			$method = '_uninstallVersion' . $i;
			if (method_exists($uninstall, $method) === false)
			{
				continue;
			}

			$uninstall->$method();
		}
	}

	protected function _uninstallVersion1()
	{
                $this->_getDb();

		$this->_db->query("ALTER TABLE xf_thread DROP firstpoststicked");
	}
}
