<?php
class MultipleAccountDetection_Model_MultipleAccountDetection extends XenForo_Model
{
	public function setDetectionCookie(&$report)
	{
		$report = false;
		$options = XenForo_Application::get('options');
		$cookieConfig = XenForo_Application::get('config')->cookie;
		$cookieValue = '';
		if (!empty($_COOKIE[$options->madCookieName]))
		{		
			$users = explode(",", $_COOKIE[$options->madCookieName]);
			$newUsers = $users;
			$newUsers[] = XenForo_Visitor::getUserId();
			$newUsers = array_unique($newUsers);
			if (count($newUsers) > count($users))
			{
				foreach ($newUsers as $user)
				{
					$cookieValue .= $user . ",";
				}
				// cut off ending comma
				$cookieValue = substr($cookieValue, 0, strlen($cookieValue) - 1);
				$report = true;
			}
			else
			{
				$cookieValue = $_COOKIE[$options->madCookieName];
			}
		}
		else
		{
			$cookieValue = XenForo_Visitor::getUserId();
		}
		setcookie(
			$options->madCookieName,
			$cookieValue,
			XenForo_Application::$time + 86400 * 365,
			$cookieConfig->path,
			$cookieConfig->domain
		);
	}
	
	public function checkIgnore(array $user = null)
	{
		$options = XenForo_Application::get('options');
		$ignoreUsers = explode(",", $options->madIgnoreUsers);
		$ignoreGroups = explode(",", $options->madIgnoreGroups);
		if (!$user)
		{
			$user = XenForo_Visitor::getInstance();
		}
		elseif ($user['user_id'] == XenForo_Visitor::getUserId())
		{
			// we should also ignore user if his id matches with visitor
			return true;
		}
		// check for user id and primary user group
		if (in_array($user['user_id'], $ignoreUsers) OR 
			in_array($user['user_group_id'], $ignoreGroups))
		{
				return true;
		}
		// check for secondary user groups
		if (!empty($user['secondary_group_ids']))
		{
			foreach (explode(",", $user['secondary_group_ids']) as $userGroupId)
			{
				if (in_array($userGroupId, $ignoreGroups))
				{
					return true;
				}
			}
		}
		return false;
	}
}