<?php
class MultipleAccountDetection_ControllerPublic_Login extends XFCP_MultipleAccountDetection_ControllerPublic_Login
{
	public function actionLogin()
	{
		$response = parent::actionLogin();
		$options = XenForo_Application::get('options');
		/* @var $model MultipleAccountDetection_Model_MultipleAccountDetection */
		$model = $this->getModelFromCache('MultipleAccountDetection_Model_MultipleAccountDetection');
		$userModel = $this->getModelFromCache('XenForo_Model_User');
		$report = false;
		if (!XenForo_Visitor::getUserId())
		{
			return $response;
		}
		if (!$model->checkIgnore())
		{
			$model->setDetectionCookie($report);
		}
		else
		{
			// we shouldn't proceed with ignored user
			return $response;
		}
		// we have no cookies previously set, so return
		if (!$report OR !array_key_exists($options->madCookieName, $_COOKIE))
		{
			return $response;
		}
		
		$visitor = XenForo_Visitor::getInstance();

		$ban = false;
		$users = array();
		foreach (explode(",", $_COOKIE[$options->madCookieName]) as $userId)
		{
			$user = $userModel->getUserById($userId);
			if ($user AND !$model->checkIgnore($user))
			{
				if ($user['is_banned'])
				{
					$ban = true;
				}
				$users[] = $user;
			}
		}
		// no unignored users found
		if (count($users) == 0)
		{
			return $response;
		}
		
		$report = $this->_constructMultipleAccountsReport($users, $visitor);
		
		if ($options->madRequireApproval && $visitor['user_state'] != 'moderated')
		{
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_User');
			$dw->setExistingData($visitor['user_id']);
			$dw->set('user_state', 'moderated');
			$dw->save();
			$report .= "\n" . new XenForo_Phrase('account_requires_manual_approval', array(
				'user_name' => $visitor['username'],
			));
		}
		
		if ($ban AND $options->madBanned AND !$visitor['is_banned'])
		{
			$userModel->ban(
				$visitor['user_id'],
				0,
				new XenForo_Phrase('one_of_your_accounts_is_banned'),
				false,
				$errorKey
			);
			$report .= "\n" . new XenForo_Phrase('account_was_banned_as_one_of_above_listed_users_is_banned', array(
				'user_name' => $visitor['username']
			));
		}
		if ($options->madReportByPC)
		{
			$conversationDw = XenForo_DataWriter::create('XenForo_DataWriter_ConversationMaster');
			$conversationDw->set('user_id', $visitor['user_id']);
			$conversationDw->set('username', $visitor['username']);
			$conversationDw->set('title', new XenForo_Phrase('multiple_accounts'));
			$conversationDw->addRecipientUserIds(explode(",", $options->madPCParticipants));
			
			$messageDw = $conversationDw->getFirstMessageDw();
			$messageDw->set('message', $report);
			$conversationDw->preSave();
			if (!$conversationDw->hasErrors())
			{
				$conversationDw->save();
				$newConversation = $conversationDw->getMergedData();
				// detected user should not be able to see this conversation
				$this->getModelFromCache('XenForo_Model_Conversation')->
					deleteConversationForUser(
						$newConversation['conversation_id'],
						$visitor['user_id'],
						'delete_ignore'
				);	
			}
		}
		if ($options->madReportByNewThread)
		{
			$threadDw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
			$threadDw->set('user_id', $visitor['user_id']);
			$threadDw->set('username', $visitor['username']);
			$threadDw->set('node_id', $options->madReportsForum);
			$threadDw->set('title', new XenForo_Phrase('multiple_accounts'));
			
			$postDw = $threadDw->getFirstMessageDw();
			$postDw->set('message', $report);
			
			$threadDw->preSave();
			if (!$threadDw->hasErrors())
			{
				$threadDw->save();
			}
		}
		return $response;
	}
	
	protected function _constructMultipleAccountsReport($users, $visitor)
	{
		$report = new XenForo_Phrase('user_was_detected_using_multiple_accounts');
		$report .= '
			[LIST=1][*][URL=' .
			XenForo_Link::buildPublicLink('canonical:members', $visitor) .
			']' . $visitor['username'] . '[/URL]';
		foreach ($users as $user)
		{
			$report .= 
				'[*][URL=' .
				XenForo_Link::buildPublicLink('canonical:members', $user) .
				']' . $user['username'] . '[/URL]';
		}
		$report .= '[/LIST]';
		return $report;
	}
}
