<?php

class StopForumSpam_ControllerPublic_Register extends XFCP_StopForumSpam_ControllerPublic_Register
{
    public function actionRegister()
    {
		$options = XenForo_Application::get('options');
        $errors = array();
        $data   = $this->_input->filter(array(
            'username'   => XenForo_Input::STRING,
            'email'      => XenForo_Input::STRING,
            'timezone'   => XenForo_Input::STRING,
            'gender'     => XenForo_Input::STRING,
            'dob_day'    => XenForo_Input::UINT,
            'dob_month'  => XenForo_Input::UINT,
            'dob_year'   => XenForo_Input::UINT,
        ));
		$data['ip'] = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false); // Thank you XenForo.
		
        if (!$this->_validateHumanStatus($data, $options->sfs_rejection_level))
        {
        	// YOU'RE NOT HUMAN! GET OUT OF HERE!
            $errors[] = new XenForo_Phrase('sfs_rejected');
        }

        if ($errors)
        {
        	if($options->sfs_submit == 1 AND !empty($options->sfs_api_key))
        	{
        		$this->_submitData($data, $options->sfs_api_key);
        	}
            return $this->_getRegisterFormResponse($data, $errors);
        }

        // So, you are human after all. I guess I shall let you register.
        return parent::actionRegister();
    }

    protected function _validateHumanStatus($data, $rejection_level)
    {
		$matches = 0;
		$xml = simplexml_load_file("http://www.stopforumspam.com/api?username=" . $data['username'] ."&email=" . $data['email'] . "&ip=" . $data['ip'] . "&f=xmlcdata");
		
		if(!isset($xml->username) || !isset($xml->ip) || !isset($xml->email))
		{
			// Something went wrong, basically, the simplexml_load_file(); didn't load what it should, so the required data isn't set. In this case, we're not sure, but we'll give them the benefit of the doubt... so...
			return true;
		}
		
		if($xml->username->appears == 1)
		{
			$matches++;
		}
		
		if($xml->ip->appears == 1)
		{
			$matches++;
		}
		
		if($xml->email->appears == 1)
		{
			$matches++;
		}
		
		if($matches >= $rejection_level)
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	
	protected function _submitData($data, $apiKey)
	{
		$ipAppend = '';
		if($data['ip'])
		{
			$ipAppend = '&ip_addr=' . $data['ip'];
		}
		
		$url = "http://www.stopforumspam.com/add.php?username=" . $data['username'] . $ipAppend . "&email=" . $data['email'] . "&api_key=" . $apiKey;
		http_get($url);
	}
}