<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~ E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'ajaxlivesearch');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array('lsa_main', 'lsa_script', 'lsa_bit', 'lsa_form', 'lsa_box', 'lsa_integrate');

// ######################### REQUIRE BACK-END ############################
require_once ('./global.php');

if ($vbulletin->options['lsa_global'])
{
	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('lsagroup');
	if ($_POST['do'] == 'lsawin')
	{
		eval('$lsawin = "' . fetch_template('lsa_main') . '";');
		$xml->add_tag('lsagetwin', process_replacement_vars($lsawin));
	}
	if ($_POST['do'] == 'lsa')
	{

		$vbulletin->input->clean_array_gpc('p', array(
			'searchin' => TYPE_NOHTML, 
			'sortby' => TYPE_NOHTML,
			'sorttype' => TYPE_NOHTML, 
			'withword' => TYPE_BOOL, 
			'lsatype' => TYPE_BOOL, 
			'keyword' => TYPE_STR
		));

		$minstr = $vbulletin->options['lsa_minsym'];
		$maxstr = $vbulletin->options['lsa_maxsym'];
		$lsanresults = intval($vbulletin->options['lsa_nresults']);
		$trimtitle = $vbulletin->options['lsa_trimt'];
		$trimftitle = $vbulletin->options['lsa_trimf'];

		$lsasearchin = $vbulletin->GPC['searchin'];
		if (empty($lsasearchin))
		{
			$lsasearchin = 'allforum';
		}
		$lsasorttype = $vbulletin->GPC['sorttype'];
		$lsatype = $vbulletin->GPC['lsatype'];
		$lsaut = ($lsatype) ? $vbphrase['lsa_users'] : $vbphrase['lsa_threads'];

		switch ($vbulletin->GPC['sortby'])
		{
			case 'dateline':
				$lsasortby .= 'thread.dateline';
				break;

			case 'title':
				$lsasortby .= 'thread.title';
				break;

			case 'replycount':
				$lsasortby .= 'thread.replycount';
				break;

			case 'views':
				$lsasortby .= 'thread.views';
				break;

			case 'forum':
				$lsasortby .= 'forum.title';
				break;

			case 'lastpost':
				$lsasortby .= 'thread.lastpost';
				break;
			default:
				$lsasortby .= 'thread.lastpost';
		}

		$vbulletin->GPC['keyword'] = convert_urlencoded_unicode($vbulletin->GPC['keyword']);
		$query = htmlspecialchars_uni($vbulletin->GPC['keyword']);

		$lsaword = str_replace(" ", ", ", $query);
		$wordlist = explode(" ", $query);
		$sl = sizeof($wordlist);
		$lsaresult = 0;

		$lsww = ($vbulletin->GPC['withword']) ? ' AND ' : ' OR ';

		$iword = array();

		foreach ($wordlist AS $word)
		{
			if (strlen($word) >= $minstr OR strlen($wordlist[0]) < $minstr)
			{
				if ($lsatype)
				{
					$iword[] = "username LIKE('%" . $db->escape_string_like($word) . "%')";
				} else
				{
					$iword[] = "thread.title LIKE('%" . $db->escape_string_like($word) . "%')";
				}
			}
		}

		foreach ($vbulletin->userinfo['forumpermissions'] AS $forumid => $fperms)
		{
			if (!($fperms & $vbulletin->bf_ugp_forumpermissions['canview']) OR !($fperms & $vbulletin->
				bf_ugp_forumpermissions['cansearch']) OR !verify_forum_password($forumid, $forum['password'], false) OR
				!($vbulletin->forumcache["$forumid"]['options'] & $vbulletin->bf_misc_forumoptions['indexposts']))
			{
				$excludelist .= ",$forumid";
			} else
				if ((!$vbulletin->GPC['titleonly'] or $vbulletin->GPC['showposts']) AND !($fperms & $vbulletin->
					bf_ugp_forumpermissions['canviewthreads']))
				{ // exclude forums that have canview but no canviewthreads if this is a post search
					$excludelist .= ",$forumid";
				}
		}

		if ($lsatype)
		{
			$results = $vbulletin->db->query_read("
					SELECT userid, username, usertitle, usergroupid, displaygroupid
					FROM " . TABLE_PREFIX . "user AS user
					WHERE " . implode($lsww, $iword) . "
					ORDER BY username ASC
					LIMIT $lsanresults
				");
		} else
		{
			$results = $vbulletin->db->query_read("
					SELECT thread.threadid, thread.lastpostid, thread.forumid AS tforumid, thread.title AS ttitle, forum.title AS ftitle
					FROM " . TABLE_PREFIX . "thread AS thread
					LEFT JOIN " . TABLE_PREFIX . "forum AS forum ON(thread.forumid = forum.forumid)
					WHERE " . implode($lsww, $iword) . "
					" . iif($lsasearchin != 'allforum', 'AND thread.forumid IN (' . $lsasearchin . ')') . "
					AND thread.forumid NOT IN (0$excludelist)
					AND thread.lastpostid > 0
					ORDER BY $lsasortby $lsasorttype
					LIMIT $lsanresults
				");
		}

		if (strlen($wordlist[0]) >= $minstr AND $vbulletin->db->num_rows($results) > 0)
		{
			while ($result = $vbulletin->db->fetch_array($results))
			{
				$lsfid = $result['tforumid'];
				$lsttitle = $result['ttitle'];
				$lstid = $result['threadid'];
				$lsunamealt = $result['username'];
				$lsuname = $result['username'];
				$lsuname = fetch_musername($result);
				$lsuid = $result['userid'];

				// triming thread title
				$lstalt = $lsttitle;
				if ($trimtitle > 0 AND strlen($lsttitle) > $trimtitle)
				{
					$lsttitle = fetch_trimmed_title($lsttitle, $trimtitle);
				}

				// triming forum title
				$lsforumname = $result[ftitle];
				$lsfalt = $lsforumname;
				if ($trimftitle > 0)
				{
					$lsfname = fetch_trimmed_title($lsfalt, $trimftitle);
				} else
				{
					$lsfname = $lsfalt;
				}

				// words to highlight from the search engine
				foreach ($wordlist AS $hiword)
				{
					$lsttitle = preg_replace('#(' . $hiword . ')(?![^<]*>)#si', '<span class="highlight">\\1</span>', $lsttitle);
					//$lsuname = preg_replace('#(' . $hiword . ')(?![^<]*>)#si', '<span class="highlight">\\1</span>', $lsunamealt);
				}

				eval('$lsa_bits .= "' . fetch_template('lsa_bit') . '";');
				$lsaresult++;
			}
			$lsaphr = construct_phrase($vbphrase['lsa_result'], $lsaresult, $lsaword, $lsaut);
			eval('$lsaout = "' . fetch_template('lsa_box') . '";');

		} else
		{
			$lsaout = $vbphrase[lsa_no_results];
		}
		$xml->add_tag('ajaxlivesearch', process_replacement_vars($lsaout));
	}
	$xml->close_group();
	$xml->print_xml();
}

?>