<?php

//   -------------------------------------------------------------------------------
//  |                  net2ftp: a web based FTP client                              |
//  |              Copyright (c) 2003-2007 by David Gartner                         |
//  |                                                                               |
//  | This program is free software; you can redistribute it and/or                 |
//  | modify it under the terms of the GNU General Public License                   |
//  | as published by the Free Software Foundation; either version 2                |
//  | of the License, or (at your option) any later version.                        |
//  |                                                                               |
//   -------------------------------------------------------------------------------

//   -------------------------------------------------------------------------------
//  | For credits, see the credits.txt file                                         |
//   -------------------------------------------------------------------------------
//  |                                                                               |
//  |                              INSTRUCTIONS                                     |
//  |                                                                               |
//  |  The messages to translate are listed below.                                  |
//  |  The structure of each line is like this:                                     |
//  |     $message["Hello world!"] = "Hello world!";                                |
//  |                                                                               |
//  |  Keep the text between square brackets [] as it is.                           |
//  |  Translate the 2nd part, keeping the same punctuation and HTML tags.          |
//  |                                                                               |
//  |  The English message, for example                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is written in PHP!";    |
//  |  should become after translation:                                             |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp est ecrit en PHP!";     |
//  |     $message["net2ftp is written in PHP!"] = "net2ftp is geschreven in PHP!"; |
//  |                                                                               |
//  |  Note that the variable starts with a dollar sign $, that the value is        |
//  |  enclosed in double quotes " and that the line ends with a semi-colon ;       |
//  |  Be careful when editing this file, do not erase those special characters.    |
//  |                                                                               |
//  |  Some messages also contain one or more variables which start with a percent  |
//  |  sign, for example %1\$s or %2\$s. The English message, for example           |
//  |     $messages[...] = ["The file %1\$s was copied to %2\$s "]                  |
//  |  should becomes after translation:                                            |
//  |     $messages[...] = ["Le fichier %1\$s a t copi vers %2\$s "]             |
//  |                                                                               |
//  |  When a real percent sign % is needed in the text it is entered as %%         |
//  |  otherwise it is interpreted as a variable. So no, it's not a mistake.        |
//  |                                                                               |
//  |  Between the messages to translate there is additional PHP code, for example: |
//  |      if ($net2ftp_globals["state2"] == "rename") {           // <-- PHP code  |
//  |          $net2ftp_messages["Rename file"] = "Rename file";   // <-- message   |
//  |      }                                                       // <-- PHP code  |
//  |  This code is needed to load the messages only when they are actually needed. |
//  |  There is no need to change or delete any of that PHP code; translate only    |
//  |  the message.                                                                 |
//  |                                                                               |
//  |  Thanks in advance to all the translators!                                    |
//  |  David.                                                                       |
//  |                                                                               |
//   -------------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Language settings
// -------------------------------------------------------------------------

// HTML lang attribute
$net2ftp_messages["en"] = "ja";

// HTML dir attribute: left-to-right (LTR) or right-to-left (RTL)
$net2ftp_messages["ltr"] = "ltr";

// CSS style: align left or right (use in combination with LTR or RTL)
$net2ftp_messages["left"] = "left";
$net2ftp_messages["right"] = "right";

// Encoding
$net2ftp_messages["iso-8859-1"] = "euc-jp";


// -------------------------------------------------------------------------
// Status messages
// -------------------------------------------------------------------------

// When translating these messages, keep in mind that the text should not be too long
// It should fit in the status textbox

$net2ftp_messages["Connecting to the FTP server"] = "FTPФ³Ƥޤ";
$net2ftp_messages["Logging into the FTP server"] = "FTPФ˥󤷤Ƥޤ";
$net2ftp_messages["Setting the passive mode"] = "ѥå֥⡼ɤ򤷤Ƥޤ";
$net2ftp_messages["Getting the FTP system type"] = "FTPƥ̤Ƥޤ";
$net2ftp_messages["Changing the directory"] = "ǥ쥯ȥѹƤޤ";
$net2ftp_messages["Getting the current directory"] = "ȥǥ쥯ȥƤޤ";
$net2ftp_messages["Getting the list of directories and files"] = "ǥ쥯ȥȥեΥꥹȤƤޤ";
$net2ftp_messages["Parsing the list of directories and files"] = "ǥ쥯ȥȥեΥꥹȤϤƤޤ";
$net2ftp_messages["Logging out of the FTP server"] = "FTPФȤƤޤ";
$net2ftp_messages["Getting the list of directories and files"] = "ǥ쥯ȥȥեΥꥹȤƤޤ";
$net2ftp_messages["Printing the list of directories and files"] = "ǥ쥯ȥȥեΥꥹȤɽƤޤ";
$net2ftp_messages["Processing the entries"] = "ȥν򤷤Ƥޤ";
$net2ftp_messages["Processing entry %1\$s"] = "ȥ %1\$s Ƥޤ";
$net2ftp_messages["Checking files"] = "եå򤷤Ƥޤ";
$net2ftp_messages["Transferring files to the FTP server"] = "ե FTPФžƤޤ";
$net2ftp_messages["Decompressing archives and transferring files"] = "֤षեžƤޤ";
$net2ftp_messages["Searching the files..."] = "եθ...";
$net2ftp_messages["Uploading new file"] = "ե򥢥åץɤƤޤ";
$net2ftp_messages["Reading the file"] = "եɤ߹Ǥޤ";
$net2ftp_messages["Parsing the file"] = "եϤƤޤ";
$net2ftp_messages["Reading the new file"] = "եɤ߹Ǥޤ";
$net2ftp_messages["Reading the old file"] = "Ťեɤ߹Ǥޤ";
$net2ftp_messages["Comparing the 2 files"] = "2ĤΥեӤƤޤ";
$net2ftp_messages["Printing the comparison"] = "ʬɽƤޤ";
$net2ftp_messages["Sending FTP command %1\$s of %2\$s"] = "FTPޥɤ %2\$s  %1\$s";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Getting archive %1\$s of %2\$s from the FTP server";
$net2ftp_messages["Creating a temporary directory on the FTP server"] = "Creating a temporary directory on the FTP server";
$net2ftp_messages["Setting the permissions of the temporary directory"] = "Setting the permissions of the temporary directory";
$net2ftp_messages["Copying the net2ftp installer script to the FTP server"] = "Copying the net2ftp installer script to the FTP server";
$net2ftp_messages["Script finished in %1\$s seconds"] = "ץȤ %1\$s äǽλޤ";
$net2ftp_messages["Script halted"] = "ץȤߤޤ";

// Used on various screens
$net2ftp_messages["Please wait..."] = "Ф餯Ԥ...";


// -------------------------------------------------------------------------
// index.php
// -------------------------------------------------------------------------
$net2ftp_messages["Unexpected state string: %1\$s. Exiting."] = "ͽʤơʸ: %1\$s λޤ";
$net2ftp_messages["This beta function is not activated on this server."] = "βǽϤΥФǤϲưޤ";
$net2ftp_messages["This function has been disabled by the Administrator of this website."] = "εǽϥȤδԤˤä̵ˤƤޤ";


// -------------------------------------------------------------------------
// /includes/browse.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["The directory <b>%1\$s</b> does not exist or could not be selected, so the directory <b>%2\$s</b> is shown instead."] = "ǥ쥯ȥ <b>%1\$s</b> ¸ߤʤ򤹤뤳ȤǤޤ󡣥ǥ쥯ȥ <b>%2\$s</b> ɽޤ";
$net2ftp_messages["Your root directory <b>%1\$s</b> does not exist or could not be selected."] = "ʤΥ롼ȥǥ쥯ȥ <b>%1\$s</b> ¸ߤʤ򤹤뤳ȤǤޤ";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected - you may not have sufficient rights to view this directory, or it may not exist."] = "ǥ쥯ȥ <b>%1\$s</b> 򤹤뤳ȤǤޤ - ʤˤϤΥǥ쥯ȥ뽽ʬʻʤʤޤϥǥ쥯ȥ꤬¸ߤޤ";
$net2ftp_messages["Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp."] = "Entries which contain banned keywords can't be managed using net2ftp. This is to avoid Paypal or Ebay scams from being uploaded through net2ftp.";
$net2ftp_messages["Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted."] = "Files which are too big can't be downloaded, uploaded, copied, moved, searched, zipped, unzipped, viewed or edited; they can only be renamed, chmodded or deleted.";
$net2ftp_messages["Execute %1\$s in a new window"] = "%1\$s 򿷤ɥǼ¹";


// -------------------------------------------------------------------------
// /includes/main.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Please select at least one directory or file!"] = "1İʾΥǥ쥯ȥϥե򤷤Ʋ!";


// -------------------------------------------------------------------------
// /includes/authorizations.inc.php
// -------------------------------------------------------------------------

// checkAuthorization()
$net2ftp_messages["The FTP server <b>%1\$s</b> is not in the list of allowed FTP servers."] = "FTP <b>%1\$s</b> ϡĤ줿FTPФΥꥹȤäƤޤ";
$net2ftp_messages["The FTP server <b>%1\$s</b> is in the list of banned FTP servers."] = "FTP<b>%1\$s</b>ϡ ػߤ줿FTPФΥꥹȤäƤޤ";
$net2ftp_messages["Your IP address (%1\$s) is in the list of banned IP addresses."] = "ʤIPɥ쥹(%1\$s)ϡػߤ줿IPɥ쥹ΥꥹȤäƤޤ";
$net2ftp_messages["The FTP server port %1\$s may not be used."] = "FTPХݡ %1\$s ϻѤǤޤ";

// isAuthorizedDirectory()
$net2ftp_messages["Table net2ftp_users contains duplicate rows."] = "ơ֥ net2ftp_users ˽ʣԤޤޤƤޤ";

// logAccess(), logLogin(), logError()
$net2ftp_messages["Unable to execute the SQL query."] = "SQL¹Ԥ뤳ȤǤޤ";

// checkAdminUsernamePassword()
$net2ftp_messages["You did not enter your Administrator username or password."] = "ԤΥ桼̾ѥɤϤƤޤ";
$net2ftp_messages["Wrong username or password. Please try again."] = "ä桼̾ѥɤǤľƤ";


// -------------------------------------------------------------------------
// /includes/consumption.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Unable to determine your IP address."] = "ʤ IPɥ쥹Ƚ̤뤳ȤǤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate rows."] = "ơ֥ net2ftp_log_consumption_ipaddress ˽ʣԤޤޤƤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate rows."] = "ơ֥ net2ftp_log_consumption_ftpserver ˽ʣԤޤޤƤޤ";
$net2ftp_messages["The variable <b>consumption_ipaddress_datatransfer</b> is not numeric."] = "ѿ <b>consumption_ipaddress_datatransfer</b> ϿͤǤϤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress could not be updated."] = "ơ֥ net2ftp_log_consumption_ipaddress ϹԲĤǤ";
$net2ftp_messages["Table net2ftp_log_consumption_ipaddress contains duplicate entries."] = "ơ֥ net2ftp_log_consumption_ipaddress ˽ʣȥ꤬ޤޤƤޤ";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver could not be updated."] = "ơ֥ net2ftp_log_consumption_ftpserver ϹԲĤǤ";
$net2ftp_messages["Table net2ftp_log_consumption_ftpserver contains duplicate entries."] = "ơ֥ net2ftp_log_consumption_ftpserver ˽ʣȥ꤬ޤޤƤޤ";


// -------------------------------------------------------------------------
// /includes/database.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Unable to connect to the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php.";
$net2ftp_messages["Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php."] = "Unable to select the MySQL database. Please check your MySQL database settings in net2ftp's configuration file settings.inc.php.";


// -------------------------------------------------------------------------
// /includes/errorhandling.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["An error has occured"] = "顼Ǥ";
$net2ftp_messages["Go back"] = "";
$net2ftp_messages["Go to the login page"] = "ڡ";


// -------------------------------------------------------------------------
// /includes/filesystem.inc.php
// -------------------------------------------------------------------------

// ftp_openconnection()
$net2ftp_messages["The <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">FTP module of PHP</a> is not installed.<br /><br /> The administrator of this website should install this FTP module. Installation instructions are given on <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a><br />"] = "<a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">PHP  FTP⥸塼</a> 󥹥ȡ뤵Ƥޤ<br /><br />  webȤδԤ FTP⥸塼 򥤥󥹥ȡ뤷ʤФʤޤ󡣥󥹥ȡˡ <a href=\"http://www.php.net/manual/en/ref.ftp.php\" target=\"_blank\">php.net</a> 󶡤Ƥޤ<br />";
$net2ftp_messages["Unable to connect to FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "FTP <b>%1\$s</b> Υݡ <b>%2\$s</b> ³뤳ȤǤޤ<br /><br />Υɥ쥹 FTP ΤΤǤ?  HTTP (web) ФΤΤȤϰۤʤäƤޤʤ ISPΥݡȥǥ ޤ ƥ 䤤碌Ƥ<br />";
$net2ftp_messages["Unable to login to FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "FTP <b>%1\$s</b> ˥桼̾ <b>%2\$s</b> ǥ󤹤뤳ȤǤޤ<br /><br />ʤΥ桼̾ȥѥɤǤ? ʤ ISPΥݡȥǥ ޤ ƥ 䤤碌Ƥ<br />";
$net2ftp_messages["Unable to switch to the passive mode on FTP server <b>%1\$s</b>."] = "FTP <b>%1\$s</b> Υѥå֥⡼ɤڤؤ뤳ȤǤޤ";

// ftp_openconnection2()
$net2ftp_messages["Unable to connect to the second (target) FTP server <b>%1\$s</b> on port <b>%2\$s</b>.<br /><br />Are you sure this is the address of the second (target) FTP server? This is often different from that of the HTTP (web) server. Please contact your ISP helpdesk or system administrator for help.<br />"] = "2 (о) FTP <b>%1\$s</b> Υݡ <b>%2\$s</b> ³뤳ȤǤޤ<br /><br />Υɥ쥹 2 (о) FTP ΤΤǤ?  HTTP (web) ФΤΤȤϰۤʤäƤޤʤ ISPΥݡȥǥ ޤ ƥ 䤤碌Ƥ<br />";
$net2ftp_messages["Unable to login to the second (target) FTP server <b>%1\$s</b> with username <b>%2\$s</b>.<br /><br />Are you sure your username and password are correct? Please contact your ISP helpdesk or system administrator for help.<br />"] = "2 (о) FTP <b>%1\$s</b> ˥桼̾ <b>%2\$s</b> ǥ󤹤뤳ȤǤޤ<br /><br />ʤΥ桼̾ȥѥɤǤ? ʤ ISPΥݡȥǥ ޤ ƥ 䤤碌Ƥ<br />";
$net2ftp_messages["Unable to switch to the passive mode on the second (target) FTP server <b>%1\$s</b>."] = "2 (о) FTP <b>%1\$s</b> Υѥå֥⡼ɤڤؤ뤳ȤǤޤ";

// ftp_myrename()
$net2ftp_messages["Unable to rename directory or file <b>%1\$s</b> into <b>%2\$s</b>"] = "ǥ쥯ȥʤޤϥեˤ̾ <b>%1\$s</b>  <b>%2\$s</b> ѹǤޤ";

// ftp_mychmod()
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>. Note that the CHMOD command is only available on Unix FTP servers, not on Windows FTP servers."] = "ȥޥ<b>%1\$s</b> ϼ¹ԤǤޤCHMOD ޥɤ Windows FTPФǤϤʤ Unix FTPФǤΤͭǤ뤳ȤդƤ";
$net2ftp_messages["Directory <b>%1\$s</b> successfully chmodded to <b>%2\$s</b>"] = "ǥ쥯ȥ <b>%1\$s</b> εľ <b>%2\$s</b> ѹޤ";
$net2ftp_messages["Processing entries within directory <b>%1\$s</b>:"] = "ǥ쥯ȥ <b>%1\$s</b> ΥȥƤޤ:";
$net2ftp_messages["File <b>%1\$s</b> was successfully chmodded to <b>%2\$s</b>"] = "ե <b>%1\$s</b> εľ <b>%2\$s</b> ѹޤ";
$net2ftp_messages["All the selected directories and files have been processed."] = "򤵤줿٤ƤΥǥ쥯ȥꡢեνλޤ";

// ftp_rmdir2()
$net2ftp_messages["Unable to delete the directory <b>%1\$s</b>"] = "ǥ쥯ȥ <b>%1\$s</b> ϺǤޤ";

// ftp_delete2()
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "ե <b>%1\$s</b> ϺǤޤ";

// ftp_newdirectory()
$net2ftp_messages["Unable to create the directory <b>%1\$s</b>"] = "ǥ쥯ȥ <b>%1\$s</b> κϤǤޤ";

// ftp_readfile()
$net2ftp_messages["Unable to create the temporary file"] = "ƥݥեκԤޤ";
$net2ftp_messages["Unable to get the file <b>%1\$s</b> from the FTP server and to save it as temporary file <b>%2\$s</b>.<br />Check the permissions of the %3\$s directory.<br />"] = "FTP ե <b>%1\$s</b>  ե <b>%2\$s</b> Ȥ¸뤳ȤǤޤ<br />ǥ쥯ȥ %3\$s εľǧƤ<br />";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "ƥݥե򳫤ȤǤޤ󡣥ǥ쥯ȥ %1\$s εľǧƤ";
$net2ftp_messages["Unable to read the temporary file"] = "ƥݥեɤ߹ळȤǤޤ";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "ƥݥեĤ뤳ȤǤޤ";
$net2ftp_messages["Unable to delete the temporary file"] = "ƥݥե뤳ȤǤޤ";

// ftp_writefile()
$net2ftp_messages["Unable to create the temporary file. Check the permissions of the %1\$s directory."] = "ƥݥեκԤޤ󡣥ǥ쥯ȥ %1\$s εľǧƤ";
$net2ftp_messages["Unable to open the temporary file. Check the permissions of the %1\$s directory."] = "ƥݥե򳫤ȤǤޤ󡣥ǥ쥯ȥ %1\$s εľǧƤ";
$net2ftp_messages["Unable to write the string to the temporary file <b>%1\$s</b>.<br />Check the permissions of the %2\$s directory."] = "ƥݥե <b>%1\$s</b> ˽񤭹ळȤǤޤ<br />ǥ쥯ȥ %2\$s εľǧƤ";
$net2ftp_messages["Unable to close the handle of the temporary file"] = "ƥݥեĤ뤳ȤǤޤ";
$net2ftp_messages["Unable to put the file <b>%1\$s</b> on the FTP server.<br />You may not have write permissions on the directory."] = "FTPо˥ե <b>%1\$s</b> ֤ȤǤޤ<br />ǥ쥯ȥؤν񤭹ߵĤޤ";
$net2ftp_messages["Unable to delete the temporary file"] = "ƥݥե뤳ȤǤޤ";

// ftp_copymovedelete()
$net2ftp_messages["Processing directory <b>%1\$s</b>"] = "ǥ쥯ȥ <b>%1\$s</b> ν";
$net2ftp_messages["The target directory <b>%1\$s</b> is the same as or a subdirectory of the source directory <b>%2\$s</b>, so this directory will be skipped"] = "оݤΥǥ쥯ȥ <b>%1\$s</b> ϸΥǥ쥯ȥ <b>%2\$s</b> Υ֥ǥ쥯ȥ꤫ޤƱǥ쥯ȥǤΥǥ쥯ȥν򥹥åפޤ";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped"] = "The directory <b>%1\$s</b> contains a banned keyword, so this directory will be skipped";
$net2ftp_messages["The directory <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The directory <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing the copy/move process..."] = "֥ǥ쥯ȥ <b>%1\$s</b> ϤǤ¸ߤ뤿ᡢ뤳ȤǤޤ󡣥ԡư³ޤ...";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "оݤΥ֥ǥ쥯ȥ <b>%1\$s</b> ";
$net2ftp_messages["The directory <b>%1\$s</b> could not be selected, so this directory will be skipped"] = "ǥ쥯ȥ <b>%1\$s</b> 򤹤뤳ȤǤޤ󡣤Υǥ쥯ȥϥåפޤ";
$net2ftp_messages["Unable to delete the subdirectory <b>%1\$s</b> - it may not be empty"] = "֥ǥ쥯ȥ <b>%1\$s</b> 뤳ȤǤޤ - Υǥ쥯ȥ϶ǤϤޤ";
$net2ftp_messages["Deleted subdirectory <b>%1\$s</b>"] = "֥ǥ쥯ȥ <b>%1\$s</b> ";
$net2ftp_messages["Processing of directory <b>%1\$s</b> completed"] = "ǥ쥯ȥ <b>%1\$s</b> νλ";
$net2ftp_messages["The target for file <b>%1\$s</b> is the same as the source, so this file will be skipped"] = "оݤΥե <b>%1\$s</b> ϸΥեƱ̾ǤΥեν򥹥åפޤ";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped"] = "The file <b>%1\$s</b> contains a banned keyword, so this file will be skipped";
$net2ftp_messages["The file <b>%1\$s</b> contains a banned keyword, aborting the move"] = "The file <b>%1\$s</b> contains a banned keyword, aborting the move";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be copied, so this file will be skipped"] = "The file <b>%1\$s</b> is too big to be copied, so this file will be skipped";
$net2ftp_messages["The file <b>%1\$s</b> is too big to be moved, aborting the move"] = "The file <b>%1\$s</b> is too big to be moved, aborting the move";
$net2ftp_messages["Unable to copy the file <b>%1\$s</b>"] = "ե <b>%1\$s</b> 򥳥ԡ뤳ȤǤޤ";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "ե <b>%1\$s</b> 򥳥ԡ";
$net2ftp_messages["Unable to move the file <b>%1\$s</b>, aborting the move"] = "Unable to move the file <b>%1\$s</b>, aborting the move";
$net2ftp_messages["Moved file <b>%1\$s</b>"] = "ե <b>%1\$s</b> ư";
$net2ftp_messages["Unable to delete the file <b>%1\$s</b>"] = "ե <b>%1\$s</b> ϺǤޤ";
$net2ftp_messages["Deleted file <b>%1\$s</b>"] = "ե <b>%1\$s</b> ";
$net2ftp_messages["All the selected directories and files have been processed."] = "򤵤줿٤ƤΥǥ쥯ȥꡢեνλޤ";

// ftp_processfiles()

// ftp_getfile()
$net2ftp_messages["Unable to copy the remote file <b>%1\$s</b> to the local file using FTP mode <b>%2\$s</b>"] = "FTP⡼ <b>%2\$s</b> Ѥƥ⡼ȥե <b>%1\$s</b> ե˥ԡ뤳ȤǤޤ";
$net2ftp_messages["Unable to delete file <b>%1\$s</b>"] = "ե <b>%1\$s</b> 뤳ȤǤޤ";

// ftp_putfile()
$net2ftp_messages["The file is too big to be transferred"] = "The file is too big to be transferred";
$net2ftp_messages["Daily limit reached: the file <b>%1\$s</b> will not be transferred"] = "1¤ã: ե <b>%1\$s</b> žޤ";
$net2ftp_messages["Unable to copy the local file to the remote file <b>%1\$s</b> using FTP mode <b>%2\$s</b>"] = "FTP⡼ <b>%2\$s</b> Ѥƥե⡼ȥե <b>%1\$s</b> ˥ԡ뤳ȤǤޤ";
$net2ftp_messages["Unable to delete the local file"] = "ե뤳ȤǤޤ";

// ftp_downloadfile()
$net2ftp_messages["Unable to delete the temporary file"] = "ƥݥե뤳ȤǤޤ";
$net2ftp_messages["Unable to send the file to the browser"] = "ե֥饦뤳ȤǤޤ";

// ftp_zip()
$net2ftp_messages["Unable to create the temporary file"] = "ƥݥեκԤޤ";
$net2ftp_messages["The zip file has been saved on the FTP server as <b>%1\$s</b>"] = "̥եϤǤFTPо <b>%1\$s</b> Ȥ¸Ƥޤ";
$net2ftp_messages["Requested files"] = "Requested files";

$net2ftp_messages["Dear,"] = "Dear,";
$net2ftp_messages["Someone has requested the files in attachment to be sent to this email account (%1\$s)."] = "Someone has requested the files in attachment to be sent to this email account (%1\$s).";
$net2ftp_messages["If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment."] = "If you know nothing about this or if you don't trust that person, please delete this email without opening the Zip file in attachment.";
$net2ftp_messages["Note that if you don't open the Zip file, the files inside cannot harm your computer."] = "Note that if you don't open the Zip file, the files inside cannot harm your computer.";
$net2ftp_messages["Information about the sender: "] = "Information about the sender: ";
$net2ftp_messages["IP address: "] = "IP address: ";
$net2ftp_messages["Time of sending: "] = "Time of sending: ";
$net2ftp_messages["Sent via the net2ftp application installed on this website: "] = "Sent via the net2ftp application installed on this website: ";
$net2ftp_messages["Webmaster's email: "] = "Webmaster's email: ";
$net2ftp_messages["Message of the sender: "] = "Message of the sender: ";
$net2ftp_messages["net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com."] = "net2ftp is free software, released under the GNU/GPL license. For more information, go to http://www.net2ftp.com.";

$net2ftp_messages["The zip file has been sent to <b>%1\$s</b>."] = "̥ե <b>%1\$s</b> ޤ";

// acceptFiles()
$net2ftp_messages["File <b>%1\$s</b> is too big. This file will not be uploaded."] = "ե <b>%1\$s</b> 礭ޤΥեϥåץɤޤ";
$net2ftp_messages["File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded."] = "File <b>%1\$s</b> is contains a banned keyword. This file will not be uploaded.";
$net2ftp_messages["Could not generate a temporary file."] = "ե뤳ȤǤޤ";
$net2ftp_messages["File <b>%1\$s</b> could not be moved"] = "ե <b>%1\$s</b> ϰưǤޤ";
$net2ftp_messages["File <b>%1\$s</b> is OK"] = "ե <b>%1\$s</b>  OK";
$net2ftp_messages["Unable to move the uploaded file to the temp directory.<br /><br />The administrator of this website has to <b>chmod 777</b> the /temp directory of net2ftp."] = "åץɤեƥݥǥ쥯ȥذư뤳ȤǤޤ<br /><br />ΥȤδԤ net2ftp  /temp ǥ쥯ȥεľ <b>777</b> ꤹɬפޤ";
$net2ftp_messages["You did not provide any file to upload."] = "åץɤե뤬ꤵƤޤ";

// ftp_transferfiles()
$net2ftp_messages["File <b>%1\$s</b> could not be transferred to the FTP server"] = "ե <b>%1\$s</b>  FTPФž뤳ȤǤޤǤ";
$net2ftp_messages["File <b>%1\$s</b> has been transferred to the FTP server using FTP mode <b>%2\$s</b>"] = "ե <b>%1\$s</b>  FTP⡼ <b>%2\$s</b> Ѥ FTPФžޤ";
$net2ftp_messages["Transferring files to the FTP server"] = "ե FTPФžƤޤ";

// ftp_unziptransferfiles()
$net2ftp_messages["Processing archive nr %1\$s: <b>%2\$s</b>"] = "̥եν顼 %1\$s: <b>%2\$s</b>";
$net2ftp_messages["Archive <b>%1\$s</b> was not processed because its filename extension was not recognized. Only zip, tar, tgz and gz archives are supported at the moment."] = "եĥҤȽǽʤᡢ̥ե <b>%1\$s</b> ϽޤǤߥݡȤƤ밵̥ե zip, tar, tgz, gz Ǥ";
$net2ftp_messages["Unable to extract the files and directories from the archive"] = "Unable to extract the files and directories from the archive";
$net2ftp_messages["Created directory %1\$s"] = "Created directory %1\$s";
$net2ftp_messages["Could not create directory %1\$s"] = "Could not create directory %1\$s";
$net2ftp_messages["Copied file %1\$s"] = "Copied file %1\$s";
$net2ftp_messages["Could not copy file %1\$s"] = "Could not copy file %1\$s";
$net2ftp_messages["Unable to delete the temporary directory"] = "Unable to delete the temporary directory";
$net2ftp_messages["Unable to delete the temporary file %1\$s"] = "Unable to delete the temporary file %1\$s";

// ftp_mysite()
$net2ftp_messages["Unable to execute site command <b>%1\$s</b>"] = "ȥޥ <b>%1\$s</b> ¹Ԥ뤳ȤǤޤ";

// shutdown()
$net2ftp_messages["Your task was stopped"] = "Ȥߤޤ";
$net2ftp_messages["The task you wanted to perform with net2ftp took more time than the allowed %1\$s seconds, and therefor that task was stopped."] = "ʤ net2ftpǼ¹Ԥ褦ȤȤϡƻ֤ %1\$s äĹ֤ɬפǤäơȤߤޤ";
$net2ftp_messages["This time limit guarantees the fair use of the web server for everyone."] = "λ¤ϡͤʿ webФѤǤ褦ݾ㤹ΤǤ";
$net2ftp_messages["Try to split your task in smaller tasks: restrict your selection of files, and omit the biggest files."] = "Ȥ꾮ʺȤʬ䤷ƤߤƲ: ե¤礭ʥեʤƤ";
$net2ftp_messages["If you really need net2ftp to be able to handle big tasks which take a long time, consider installing net2ftp on your own server."] = "⤷ɤƤ net2ftpȤäĹ礭ʺȤ򤹤ɬפϡʬΥФ net2ftpƳ뤳ȤƤƲ";

// SendMail()
$net2ftp_messages["You did not provide any text to send by email!"] = "Żҥ᡼åޤ!";
$net2ftp_messages["You did not supply a From address."] = "пͥɥ쥹̤ϤǤ";
$net2ftp_messages["You did not supply a To address."] = "襢ɥ쥹̤ϤǤ";
$net2ftp_messages["Due to technical problems the email to <b>%1\$s</b> could not be sent."] = "Ū <b>%1\$s</b> ؤ Żҥ᡼ޤǤ";


// -------------------------------------------------------------------------
// /includes/registerglobals.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Please enter your username and password for FTP server "] = "FTPоΤʤΥ桼̾ȥѥɤϤƲ";
$net2ftp_messages["You did not fill in your login information in the popup window.<br />Click on \"Go to the login page\" below."] = "ݥåץåץɥˤʤΥϤƤޤ<br /> \"ڡذư\" 򥯥åƤ";
$net2ftp_messages["Access to the net2ftp Admin panel is disabled, because no password has been set in the file settings.inc.php. Enter a password in that file, and reload this page."] = "ե settings.inc.php ˥ѥɤꤵƤʤᡢnet2ftp ѥѥͥؤΥ̵Ǥե˥ѥɤϤΥڡɤƲ";
$net2ftp_messages["Please enter your Admin username and password"] = "ԤΥ桼̾ȥѥɤϤƲ"; 
$net2ftp_messages["You did not fill in your login information in the popup window.<br />Click on \"Go to the login page\" below."] = "ݥåץåץɥˤʤΥϤƤޤ<br /> \"ڡذư\" 򥯥åƤ";
$net2ftp_messages["Wrong username or password for the net2ftp Admin panel. The username and password can be set in the file settings.inc.php."] = "net2ftp ѥѥͥΥ桼̾ѥɤְäƤޤ桼̾ȥѥɤϥե settings.inc.php ꤹ뤳ȤǤޤ";


// -------------------------------------------------------------------------
// /skins/skins.inc.php
// -------------------------------------------------------------------------
$net2ftp_messages["Blue"] = "Ŀ";
$net2ftp_messages["Grey"] = "";
$net2ftp_messages["Black"] = "";
$net2ftp_messages["Yellow"] = "";
$net2ftp_messages["Pastel"] = "ø";

// getMime()
$net2ftp_messages["Directory"] = "ե";
$net2ftp_messages["Symlink"] = "ܥå";
$net2ftp_messages["ASP script"] = "ASP ץ";
$net2ftp_messages["Cascading Style Sheet"] = "CSS 륷";
$net2ftp_messages["HTML file"] = "HTML ɥ";
$net2ftp_messages["Java source file"] = "Java ե";
$net2ftp_messages["JavaScript file"] = "JavaScript ե";
$net2ftp_messages["PHP Source"] = "PHP ";
$net2ftp_messages["PHP script"] = "PHP ץ";
$net2ftp_messages["Text file"] = "ץ졼ƥ ɥ";
$net2ftp_messages["Bitmap file"] = "BMP ᡼";
$net2ftp_messages["GIF file"] = "GIF ᡼";
$net2ftp_messages["JPEG file"] = "JPEG ᡼";
$net2ftp_messages["PNG file"] = "PNG ᡼";
$net2ftp_messages["TIF file"] = "TIFF ᡼";
$net2ftp_messages["GIMP file"] = "GIMP ͥƥ֥᡼եޥå";
$net2ftp_messages["Executable"] = "¹Բǽե";
$net2ftp_messages["Shell script"] = "륹ץ";
$net2ftp_messages["MS Office - Word document"] = "MS Office - Word ɥ";
$net2ftp_messages["MS Office - Excel spreadsheet"] = "MS Office - Excel ";
$net2ftp_messages["MS Office - PowerPoint presentation"] = "MS Office - PowerPoint ץ쥼ơ";
$net2ftp_messages["MS Office - Access database"] = "MS Office - Access ǡ١";
$net2ftp_messages["MS Office - Visio drawing"] = "MS Office - Visio ɥ";
$net2ftp_messages["MS Office - Project file"] = "MS Office - Project ե";
$net2ftp_messages["OpenOffice - Writer 6.0 document"] = "OpenOffice - Writer 6.0 ƥȥɥ";
$net2ftp_messages["OpenOffice - Writer 6.0 template"] = "OpenOffice - Writer 6.0 ƥץ졼";
$net2ftp_messages["OpenOffice - Calc 6.0 spreadsheet"] = "OpenOffice - Calc 6.0 ץåɥ";
$net2ftp_messages["OpenOffice - Calc 6.0 template"] = "OpenOffice - Calc 6.0 ƥץ졼";
$net2ftp_messages["OpenOffice - Draw 6.0 document"] = "OpenOffice - Draw 6.0 ɥ";
$net2ftp_messages["OpenOffice - Draw 6.0 template"] = "OpenOffice - Draw 6.0 ƥץ졼";
$net2ftp_messages["OpenOffice - Impress 6.0 presentation"] = "OpenOffice - Impress 6.0 ץ쥼ơ";
$net2ftp_messages["OpenOffice - Impress 6.0 template"] = "OpenOffice - Impress 6.0 ƥץ졼";
$net2ftp_messages["OpenOffice - Writer 6.0 global document"] = "OpenOffice - Writer 6.0 ޥɥ";
$net2ftp_messages["OpenOffice - Math 6.0 document"] = "OpenOffice - Math 6.0 ";
$net2ftp_messages["StarOffice - StarWriter 5.x document"] = "StarOffice - StarWriter 5.x ƥȥɥ";
$net2ftp_messages["StarOffice - StarWriter 5.x global document"] = "StarOffice - StarWriter 5.x ޥɥ";
$net2ftp_messages["StarOffice - StarCalc 5.x spreadsheet"] = "StarOffice - StarCalc 5.x ץåɥ";
$net2ftp_messages["StarOffice - StarDraw 5.x document"] = "StarOffice - StarDraw 5.x ɥ";
$net2ftp_messages["StarOffice - StarImpress 5.x presentation"] = "StarOffice - StarImpress 5.x ץ쥼ơ";
$net2ftp_messages["StarOffice - StarImpress Packed 5.x file"] = "StarOffice - StarImpress Packed 5.x ե";
$net2ftp_messages["StarOffice - StarMath 5.x document"] = "StarOffice - StarMath 5.x ";
$net2ftp_messages["StarOffice - StarChart 5.x document"] = "StarOffice - StarChart 5.x ɥ";
$net2ftp_messages["StarOffice - StarMail 5.x mail file"] = "StarOffice - StarMail 5.x mail ե";
$net2ftp_messages["Adobe Acrobat document"] = "Adobe Acrobat ɥ";
$net2ftp_messages["ARC archive"] = "ARC ";
$net2ftp_messages["ARJ archive"] = "ARJ ";
$net2ftp_messages["RPM"] = "RPM ѥåե";
$net2ftp_messages["GZ archive"] = "Gzip ե";
$net2ftp_messages["TAR archive"] = "TAR ";
$net2ftp_messages["Zip archive"] = "Zip ";
$net2ftp_messages["MOV movie file"] = "MOV ӥǥ";
$net2ftp_messages["MPEG movie file"] = "MPEG ӥǥ";
$net2ftp_messages["Real movie file"] = "ꥢӥǥ ե";
$net2ftp_messages["Quicktime movie file"] = "Quicktime ӥǥ";
$net2ftp_messages["Shockwave flash file"] = "Shockwave flash ǥ";
$net2ftp_messages["Shockwave file"] = "Shockwave ե";
$net2ftp_messages["WAV sound file"] = "WAV ǥ";
$net2ftp_messages["Font file"] = "եȥե";
$net2ftp_messages["%1\$s File"] = "%1\$s ե";
$net2ftp_messages["File"] = "ե";

// getAction()
$net2ftp_messages["Back"] = "";
$net2ftp_messages["Submit"] = "";
$net2ftp_messages["Refresh"] = "";
$net2ftp_messages["Details"] = "ܺ";
$net2ftp_messages["Icons"] = "";
$net2ftp_messages["List"] = "ꥹ";
$net2ftp_messages["Logout"] = "";
$net2ftp_messages["Help"] = "إ";
$net2ftp_messages["Bookmark"] = "֥åޡ";
$net2ftp_messages["Save"] = "¸";
$net2ftp_messages["Default"] = "ǥե";


// -------------------------------------------------------------------------
// /skins/[skin]/footer.template.php and statusbar.template.php
// -------------------------------------------------------------------------
$net2ftp_messages["Help Guide"] = "إץ";
$net2ftp_messages["Forums"] = "ե";
$net2ftp_messages["License"] = "饤";
$net2ftp_messages["Powered by"] = "븵";
$net2ftp_messages["You are now taken to the net2ftp forums. These forums are for net2ftp related topics only - not for generic webhosting questions."] = "ʤ net2ftp եعԤȤƤޤΥե net2ftp ˴ϢΤΤǤ - Ūʥ֥ۥƥ󥰤ˤĤƤμϤƲ";


// -------------------------------------------------------------------------
// Admin module
if ($net2ftp_globals["state"] == "admin") {
// -------------------------------------------------------------------------

// /modules/admin/admin.inc.php
$net2ftp_messages["Admin functions"] = "ѵǽ";

// /skins/[skin]/admin1.template.php
$net2ftp_messages["Version information"] = "С";
$net2ftp_messages["This version of net2ftp is up-to-date."] = "ΥС net2ftp ϺǿΤΤǤ";
$net2ftp_messages["The latest version information could not be retrieved from the net2ftp.com server. Check the security settings of your browser, which may prevent the loading of a small file from the net2ftp.com server."] = "ǿС net2ftp.com Ф鸡ޤǤѤΥ֥饦 net2ftp.com Ф龮ե뤬ɤ߹ޤΤɻߤƤ붲줬ޤ֥饦ΥƥǧƲ";
$net2ftp_messages["Logging"] = "Ͽ";
$net2ftp_messages["Date from:"] = ":";
$net2ftp_messages["to:"] = ":";
$net2ftp_messages["Empty logs"] = "ξõ";
$net2ftp_messages["View logs"] = "ɽ";
$net2ftp_messages["Go"] = "ư";
$net2ftp_messages["Setup MySQL tables"] = "MySQL ơ֥";
$net2ftp_messages["Create the MySQL database tables"] = "MySQL ǡ١ơ֥κ";

} // end admin

// -------------------------------------------------------------------------
// Admin_createtables module
if ($net2ftp_globals["state"] == "admin_createtables") {
// -------------------------------------------------------------------------

// /modules/admin_createtables/admin_createtables.inc.php
$net2ftp_messages["Admin functions"] = "ѵǽ";
$net2ftp_messages["The handle of file %1\$s could not be opened."] = "ե %1\$s Υϥɥ򳫤ȤǤޤǤ";
$net2ftp_messages["The file %1\$s could not be opened."] = "ե %1\$s 򳫤ȤǤޤǤ";
$net2ftp_messages["The handle of file %1\$s could not be closed."] = "ե %1\$s ΥϥɥĤ뤳ȤǤޤǤ";
$net2ftp_messages["The connection to the server <b>%1\$s</b> could not be set up. Please check the database settings you've entered."] = " <b>%1\$s</b> ؤ³ꤵޤǤʤϤǡ١ͤǧƤ";
$net2ftp_messages["Unable to select the database <b>%1\$s</b>."] = "ǡ١ <b>%1\$s</b> 򤹤뤳ȤǤޤ";
$net2ftp_messages["The SQL query nr <b>%1\$s</b> could not be executed."] = "SQLꥨ顼 <b>%1\$s</b> ¹Ԥ뤳ȤǤޤǤ";
$net2ftp_messages["The SQL query nr <b>%1\$s</b> was executed successfully."] = "SQL <b>%1\$s</b> ˼¹Ԥޤ";

// /skins/[skin]/admin_createtables1.template.php
$net2ftp_messages["Please enter your MySQL settings:"] = "ʤ MySQL ͤϤƤ:";
$net2ftp_messages["MySQL username"] = "MySQL 桼̾";
$net2ftp_messages["MySQL password"] = "MySQL ѥ";
$net2ftp_messages["MySQL database"] = "MySQL ǡ١";
$net2ftp_messages["MySQL server"] = "MySQL ";
$net2ftp_messages["This SQL query is going to be executed:"] = " SQL꤬¹Ԥ褦ȤƤޤ:";
$net2ftp_messages["Execute"] = "¹";

// /skins/[skin]/admin_createtables2.template.php
$net2ftp_messages["Settings used:"] = "Ѥ:";
$net2ftp_messages["MySQL password length"] = "MySQL ѥĹ";
$net2ftp_messages["Results:"] = ":";

} // end admin_createtables


// -------------------------------------------------------------------------
// Admin_viewlogs module
if ($net2ftp_globals["state"] == "admin_viewlogs") {
// -------------------------------------------------------------------------

// /modules/admin_createtables/admin_viewlogs.inc.php
$net2ftp_messages["Admin functions"] = "ѵǽ";
$net2ftp_messages["Unable to execute the SQL query <b>%1\$s</b>."] = "SQL <b>%1\$s</b> ¹Ԥ뤳ȤǤޤ";
$net2ftp_messages["No data"] = "ǡ̵";

} // end admin_viewlogs


// -------------------------------------------------------------------------
// Admin_emptylogs module
if ($net2ftp_globals["state"] == "admin_emptylogs") {
// -------------------------------------------------------------------------

// /modules/admin_createtables/admin_emptylogs.inc.php
$net2ftp_messages["Admin functions"] = "ѵǽ";
$net2ftp_messages["The table <b>%1\$s</b> was emptied successfully."] = "ơ֥ <b>%1\$s</b> ˶ˤʤޤ";
$net2ftp_messages["The table <b>%1\$s</b> could not be emptied."] = "ơ֥ <b>%1\$s</b> ˤ뤳ȤǤޤǤ";
$net2ftp_messages["The table <b>%1\$s</b> was optimized successfully."] = "ơ֥ <b>%1\$s</b> ˺Ŭޤ";
$net2ftp_messages["The table <b>%1\$s</b> could not be optimized."] = "ơ֥ <b>%1\$s</b> Ŭ뤳ȤǤޤǤ";

} // end admin_emptylogs


// -------------------------------------------------------------------------
// Advanced module
if ($net2ftp_globals["state"] == "advanced") {
// -------------------------------------------------------------------------

// /modules/advanced/advanced.inc.php
$net2ftp_messages["Advanced functions"] = "ĥǽ";

// /skins/[skin]/advanced1.template.php
$net2ftp_messages["Go"] = "ư";
$net2ftp_messages["Disabled"] = "̵";
$net2ftp_messages["Advanced FTP functions"] = "ĥ FTP ǽ";
$net2ftp_messages["Send arbitrary FTP commands to the FTP server"] = "FTPФǤդ FTPޥɤ";
$net2ftp_messages["This function is available on PHP 5 only"] = "εǽ PHP 5 ǤΤͭǤ";
$net2ftp_messages["Troubleshooting functions"] = "ȥ֥륷塼ƥ󥰵ǽ";
$net2ftp_messages["Troubleshoot net2ftp on this webserver"] = "webФ net2ftp Υȥ֥륷塼";
$net2ftp_messages["Troubleshoot an FTP server"] = "FTPФΥȥ֥륷塼";
$net2ftp_messages["Test the net2ftp list parsing rules"] = "net2ftp ΥꥹȲϥ롼ƥ";
$net2ftp_messages["Translation functions"] = "ǽ";
$net2ftp_messages["Introduction to the translation functions"] = "ǽμ";
$net2ftp_messages["Extract messages to translate from code files"] = "ɥե뤿åФ";
$net2ftp_messages["Check if there are new or obsolete messages"] = "åΤ켰ΤΤĴ٤";

$net2ftp_messages["Beta functions"] = "ȯεǽ";
$net2ftp_messages["Send a site command to the FTP server"] = "FTPФإȥޥɤ";
$net2ftp_messages["Apache: password-protect a directory, create custom error pages"] = "Apache: ǥ쥯ȥΥѥݸ२顼ڡκ";
$net2ftp_messages["MySQL: execute an SQL query"] = "MySQL: SQL¹";


// advanced()
$net2ftp_messages["The site command functions are not available on this webserver."] = "webФǤϡȥޥɵǽѤǤޤ";
$net2ftp_messages["The Apache functions are not available on this webserver."] = "webФǤϡ ApacheǽѤǤޤ";
$net2ftp_messages["The MySQL functions are not available on this webserver."] = "webФǤϡ MySQLǽѤǤޤ";
$net2ftp_messages["Unexpected state2 string. Exiting."] = "ͽʤ state2 ȥ󥰤ǤλƤޤ";

} // end advanced


// -------------------------------------------------------------------------
// Advanced_ftpserver module
if ($net2ftp_globals["state"] == "advanced_ftpserver") {
// -------------------------------------------------------------------------

// /modules/advanced_ftpserver/advanced_ftpserver.inc.php
$net2ftp_messages["Troubleshoot an FTP server"] = "FTPФΥȥ֥륷塼";

// /skins/[skin]/advanced_ftpserver1.template.php
$net2ftp_messages["Connection settings:"] = "³:";
$net2ftp_messages["FTP server"] = "FTP ";
$net2ftp_messages["FTP server port"] = "FTPХݡ";
$net2ftp_messages["Username"] = "桼̾";
$net2ftp_messages["Password"] = "ѥ";
$net2ftp_messages["Password length"] = "ѥĹ";
$net2ftp_messages["Passive mode"] = "Passive ⡼";
$net2ftp_messages["Directory"] = "ե";
$net2ftp_messages["Printing the result"] = "̤ϤƤޤ";

// /skins/[skin]/advanced_ftpserver2.template.php
$net2ftp_messages["Connecting to the FTP server: "] = "FTPФ³: ";
$net2ftp_messages["Logging into the FTP server: "] = "FTPФ˥: ";
$net2ftp_messages["Setting the passive mode: "] = "ѥå֥⡼ɤ: ";
$net2ftp_messages["Getting the FTP server system type: "] = "FTPФΥƥ̤: ";
$net2ftp_messages["Changing to the directory %1\$s: "] = "ǥ쥯ȥ %1\$s ѹ: ";
$net2ftp_messages["The directory from the FTP server is: %1\$s "] = "FTPФΥǥ쥯ȥ: %1\$s ";
$net2ftp_messages["Getting the raw list of directories and files: "] = "ǥ쥯ȥȥեꥹȤ: ";
$net2ftp_messages["Trying a second time to get the raw list of directories and files: "] = "ǥ쥯ȥȥեꥹȤƼ: ";
$net2ftp_messages["Closing the connection: "] = "³: ";
$net2ftp_messages["Raw list of directories and files:"] = "ǥ쥯ȥȥեꥹ:";
$net2ftp_messages["Parsed list of directories and files:"] = "ǥ쥯ȥȥեβϺѤߥꥹ:";

$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["not OK"] = "";

} // end advanced_ftpserver


// -------------------------------------------------------------------------
// Advanced_parsing module
if ($net2ftp_globals["state"] == "advanced_parsing") {
// -------------------------------------------------------------------------

$net2ftp_messages["Test the net2ftp list parsing rules"] = "net2ftp ΥꥹȲϥ롼ƥ";
$net2ftp_messages["Sample input"] = "ץ";
$net2ftp_messages["Parsed output"] = "ϸν";

} // end advanced_parsing


// -------------------------------------------------------------------------
// Advanced_webserver module
if ($net2ftp_globals["state"] == "advanced_webserver") {
// -------------------------------------------------------------------------

$net2ftp_messages["Troubleshoot your net2ftp installation"] = "ʤ net2ftp Ƴȥ֥륷塼";
$net2ftp_messages["Printing the result"] = "̤ϤƤޤ";

$net2ftp_messages["Checking if the FTP module of PHP is installed: "] = "PHP  FTP⥸塼뤬󥹥ȡ뤵Ƥ뤫Ĵ٤Ƥޤ: ";
$net2ftp_messages["yes"] = "Ϥ";
$net2ftp_messages["no - please install it!"] = " - 󥹥ȡ뤷Ƥ!";

$net2ftp_messages["Checking the permissions of the directory on the web server: a small file will be written to the /temp folder and then deleted."] = "webоΥǥ쥯ȥεľĴ٤Ƥޤ: /temp ե˾ʥե뤬ޤǺޤ";
$net2ftp_messages["Creating filename: "] = "ե̾: ";
$net2ftp_messages["OK. Filename: %1\$s"] = "OK. ե̾: %1\$s";
$net2ftp_messages["not OK"] = "";
$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["not OK. Check the permissions of the %1\$s directory"] = "ԡǥ쥯ȥ %1\$s εľǧƤ";
$net2ftp_messages["Opening the file in write mode: "] = "ե񤭹ߥ⡼ɤǳƤޤ: ";
$net2ftp_messages["Writing some text to the file: "] = "ե˥ƥȤ񤭹Ǥޤ: ";
$net2ftp_messages["Closing the file: "] = "եĤƤޤ: ";
$net2ftp_messages["Deleting the file: "] = "եƤޤ: ";

$net2ftp_messages["Testing the FTP functions"] = "FTPǽƥȤƤޤ";
$net2ftp_messages["Connecting to a test FTP server: "] = "ƥFTPФ³: ";
$net2ftp_messages["Connecting to the FTP server: "] = "FTPФ³: ";
$net2ftp_messages["Logging into the FTP server: "] = "FTPФ˥: ";
$net2ftp_messages["Setting the passive mode: "] = "ѥå֥⡼ɤ: ";
$net2ftp_messages["Getting the FTP server system type: "] = "FTPФΥƥ̤: ";
$net2ftp_messages["Changing to the directory %1\$s: "] = "ǥ쥯ȥ %1\$s ѹ: ";
$net2ftp_messages["The directory from the FTP server is: %1\$s "] = "FTPФΥǥ쥯ȥ: %1\$s ";
$net2ftp_messages["Getting the raw list of directories and files: "] = "ǥ쥯ȥȥեꥹȤ: ";
$net2ftp_messages["Trying a second time to get the raw list of directories and files: "] = "ǥ쥯ȥȥեꥹȤƼ: ";
$net2ftp_messages["Closing the connection: "] = "³: ";
$net2ftp_messages["Raw list of directories and files:"] = "ǥ쥯ȥȥեꥹ:";
$net2ftp_messages["Parsed list of directories and files:"] = "ǥ쥯ȥȥեβϺѤߥꥹ:";
$net2ftp_messages["OK"] = "OK";
$net2ftp_messages["not OK"] = "";

} // end advanced_webserver


// -------------------------------------------------------------------------
// Bookmark module
if ($net2ftp_globals["state"] == "bookmark") {
// -------------------------------------------------------------------------
$net2ftp_messages["Add this link to your bookmarks:"] = "Υ󥯤֥åޡɲäޤ:";
$net2ftp_messages["Internet Explorer: right-click on the link and choose \"Add to Favorites...\""] = "Internet Explorer: 󥯤򱦥å\"ɲ...\"";
$net2ftp_messages["Netscape, Mozilla, Firefox: right-click on the link and choose \"Bookmark This Link...\""] = "Netscape, Mozilla, Firefox: 󥯤򱦥å\"Bookmark This Link...\"";
$net2ftp_messages["Note: when you will use this bookmark, a popup window will ask you for your username and password."] = ": Υ֥åޡѤȡݥåץåץɥǥ桼̾ȥѥɤϤޤ";

} // end bookmark


// -------------------------------------------------------------------------
// Browse module
if ($net2ftp_globals["state"] == "browse") {
// -------------------------------------------------------------------------

// /modules/browse/browse.inc.php
$net2ftp_messages["Choose a directory"] = "ǥ쥯ȥ";
$net2ftp_messages["Please wait..."] = "Ф餯Ԥ...";

// browse()
$net2ftp_messages["Directories with names containing \' cannot be displayed correctly. They can only be deleted. Please go back and select another subdirectory."] = "̾ \' ޤǥ쥯ȥɽޤ󡣺Ƥޤޤä̤Υ֥ǥ쥯ȥ򤷤Ƥ";

$net2ftp_messages["Daily limit reached: you will not be able to transfer data"] = "1ž¤ã: ǡž뤳ȤϤǤޤ";
$net2ftp_messages["In order to guarantee the fair use of the web server for everyone, the data transfer volume and script execution time are limited per user, and per day. Once this limit is reached, you can still browse the FTP server but not transfer data to/from it."] = "webФͤǸʿѤ뤳Ȥݾ㤹뤿ᡢǡž̤ȥץȤμ¹Ի֤ϥ桼Ȥ1ñ̤¤Ƥޤ¤ã FTPФɽ뤳ȤϤǤޤǡϤǤޤ";
$net2ftp_messages["If you need unlimited usage, please install net2ftp on your own web server."] = "̵¤˻Ѥϡʬ webФ net2ftp 򥤥󥹥ȡ뤷Ʋ";

// printdirfilelist()
// Keep this short, it must fit in a small button!
$net2ftp_messages["New dir"] = "ǥ쥯ȥ";
$net2ftp_messages["New file"] = "ե";
$net2ftp_messages["HTML templates"] = "HTML ƥץ졼";
$net2ftp_messages["Upload"] = "åץ";
$net2ftp_messages["Java Upload"] = "Java åץ";
$net2ftp_messages["Install"] = "Install";
$net2ftp_messages["Advanced"] = "ĥǽ";
$net2ftp_messages["Copy"] = "ԡ";
$net2ftp_messages["Move"] = "ư";
$net2ftp_messages["Delete"] = "";
$net2ftp_messages["Rename"] = "̾ѹ";
$net2ftp_messages["Chmod"] = "ľѹ";
$net2ftp_messages["Download"] = "";
$net2ftp_messages["Unzip"] = "Unzip";
$net2ftp_messages["Zip"] = "";
$net2ftp_messages["Size"] = "";
$net2ftp_messages["Search"] = "";
$net2ftp_messages["Go to the parent directory"] = "ҤȤľذư";
$net2ftp_messages["Go"] = "ư";
$net2ftp_messages["Transform selected entries: "] = "򤵤줿ȥ: ";
$net2ftp_messages["Transform selected entry: "] = "Transform selected entry: ";
$net2ftp_messages["Make a new subdirectory in directory %1\$s"] = "ǥ쥯ȥ %1\$s β˥֥ǥ쥯ȥ";
$net2ftp_messages["Create a new file in directory %1\$s"] = "ǥ쥯ȥ %1\$s ˿ե";
$net2ftp_messages["Create a website easily using ready-made templates"] = "Υƥץ졼ȤѤƴñ webȤ";
$net2ftp_messages["Upload new files in directory %1\$s"] = "ǥ쥯ȥ %1\$s ˿ե򥢥åץ";
$net2ftp_messages["Upload directories and files using a Java applet"] = "JavaץåȤѤƥǥ쥯ȥȥե򥢥åץ";
$net2ftp_messages["Install software packages (requires PHP on web server)"] = "Install software packages (requires PHP on web server)";
$net2ftp_messages["Go to the advanced functions"] = "ĥǽβ̤򳫤";
$net2ftp_messages["Copy the selected entries"] = "򤵤줿ȥ򥳥ԡ";
$net2ftp_messages["Move the selected entries"] = "򤵤줿ȥư";
$net2ftp_messages["Delete the selected entries"] = "򤵤줿ȥ";
$net2ftp_messages["Rename the selected entries"] = "򤵤줿ȥ̾ѹ";
$net2ftp_messages["Chmod the selected entries (only works on Unix/Linux/BSD servers)"] = "򤵤줿ȥεľѹUnix/Linux/BSD ФΤͭ";
$net2ftp_messages["Download a zip file containing all selected entries"] = "򤵤줿ȥ򤹤٤ƴޤవ̥ե";
$net2ftp_messages["Unzip the selected archives on the FTP server"] = "Unzip the selected archives on the FTP server";
$net2ftp_messages["Zip the selected entries to save or email them"] = "򤵤줿ȥ򰵽";
$net2ftp_messages["Calculate the size of the selected entries"] = "򤵤줿ȥΥե륵׻";
$net2ftp_messages["Find files which contain a particular word"] = "ʸޤե򸡺";
$net2ftp_messages["Click to sort by %1\$s in descending order"] = "å %1\$s ǹ߽祽";
$net2ftp_messages["Click to sort by %1\$s in ascending order"] = "å %1\$s Ǿ祽";
$net2ftp_messages["Ascending order"] = "";
$net2ftp_messages["Descending order"] = "߽";
$net2ftp_messages["Up"] = "";
$net2ftp_messages["Click to check or uncheck all rows"] = "åܤڤؤ";
$net2ftp_messages["All"] = "";
$net2ftp_messages["Name"] = "̾";
$net2ftp_messages["Type"] = "";
//$net2ftp_messages["Size"] = "Size";
$net2ftp_messages["Owner"] = "ͭ";
$net2ftp_messages["Group"] = "롼";
$net2ftp_messages["Perms"] = "ľ";
$net2ftp_messages["Mod Time"] = "";
$net2ftp_messages["Actions"] = "";
$net2ftp_messages["Select the directory %1\$s"] = "ǥ쥯ȥ %1\$s ";
$net2ftp_messages["Select the file %1\$s"] = "ե %1\$s ";
$net2ftp_messages["Select the symlink %1\$s"] = "ܥå %1\$s ";
$net2ftp_messages["Go to the subdirectory %1\$s"] = "֥ǥ쥯ȥ %1\$s ذư";
$net2ftp_messages["Download the file %1\$s"] = "ե %1\$s Υ";
$net2ftp_messages["Follow symlink %1\$s"] = "Follow symlink %1\$s";
$net2ftp_messages["View"] = "";
$net2ftp_messages["Edit"] = "Խ";
$net2ftp_messages["Update"] = "";
$net2ftp_messages["Open"] = "";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "ե %1\$s Υɤդɽ";
$net2ftp_messages["Edit the source code of file %1\$s"] = "ե %1\$s ΥɤԽ";
$net2ftp_messages["Upload a new version of the file %1\$s and merge the changes"] = "СΥե %1\$s 򥢥åץɤѹʬʻ";
$net2ftp_messages["View image %1\$s"] = " %1\$s ɽ";
$net2ftp_messages["View the file %1\$s from your HTTP web server"] = "ե %1\$s 򤢤ʤ HTTP webФɽ";
$net2ftp_messages["(Note: This link may not work if you don't have your own domain name.)"] = "(: ʬΥɥᥤͭƤʤˤϡΥ󥯤ϵǽޤ)";
$net2ftp_messages["This folder is empty"] = "Υե϶Ǥ";

// printSeparatorRow()
$net2ftp_messages["Directories"] = "ǥ쥯ȥ";
$net2ftp_messages["Files"] = "ե";
$net2ftp_messages["Symlinks"] = "ܥå";
$net2ftp_messages["Unrecognized FTP output"] = " FTP ";
$net2ftp_messages["Number"] = "";
$net2ftp_messages["Size"] = "";
$net2ftp_messages["Skipped"] = "ά";

// printLocationActions()
$net2ftp_messages["Language:"] = ":";
$net2ftp_messages["Skin:"] = "ơ:";
$net2ftp_messages["View mode:"] = "ɽ⡼:";
$net2ftp_messages["Directory Tree"] = "ĥ꡼ɽ";

// ftp2http()
$net2ftp_messages["Execute %1\$s in a new window"] = "%1\$s 򿷤ɥǼ¹";
$net2ftp_messages["This file is not accessible from the web"] = "Υե web夫饢Ǥޤ";


// printDirectorySelect()
$net2ftp_messages["Double-click to go to a subdirectory:"] = "֥륯åǥ֥ǥ쥯ȥذư:";
$net2ftp_messages["Choose"] = "";
$net2ftp_messages["Up"] = "";

} // end browse


// -------------------------------------------------------------------------
// Calculate size module
if ($net2ftp_globals["state"] == "calculatesize") {
// -------------------------------------------------------------------------
$net2ftp_messages["Size of selected directories and files"] = "򤵤줿ǥ쥯ȥȥեΥ";
$net2ftp_messages["The total size taken by the selected directories and files is:"] = "򤵤줿ǥ쥯ȥȥեιץ:";
$net2ftp_messages["The number of files which were skipped is:"] = "ά줿եθĿ:";

} // end calculatesize


// -------------------------------------------------------------------------
// Chmod module
if ($net2ftp_globals["state"] == "chmod") {
// -------------------------------------------------------------------------
$net2ftp_messages["Chmod directories and files"] = "ǥ쥯ȥȥեεľѹ";
$net2ftp_messages["Set all permissions"] = "";
$net2ftp_messages["Read"] = "ɤ߼";
$net2ftp_messages["Write"] = "񤭹";
$net2ftp_messages["Execute"] = "¹";
$net2ftp_messages["Owner"] = "ͭ";
$net2ftp_messages["Group"] = "롼";
$net2ftp_messages["Everyone"] = "";
$net2ftp_messages["To set all permissions to the same values, enter those permissions above and click on the button \"Set all permissions\""] = "ƤεľƱͤˤˤϡǵľϤ \"\" ܥ򥯥åƤ";
$net2ftp_messages["Set the permissions of directory <b>%1\$s</b> to: "] = "ǥ쥯ȥ <b>%1\$s</b> εľѹ: ";
$net2ftp_messages["Set the permissions of file <b>%1\$s</b> to: "] = "ե <b>%1\$s</b> εľѹ: ";
$net2ftp_messages["Set the permissions of symlink <b>%1\$s</b> to: "] = "ܥå <b>%1\$s</b> εľѹ: ";
$net2ftp_messages["Chmod value"] = "";
$net2ftp_messages["Chmod also the subdirectories within this directory"] = "Υǥ쥯ȥΥ֥ǥ쥯ȥѹ";
$net2ftp_messages["Chmod also the files within this directory"] = "Υǥ쥯ȥΥեѹ";
$net2ftp_messages["The chmod nr <b>%1\$s</b> is out of the range 000-777. Please try again."] = "ͥ顼: <b>%1\$s</b>  000  777 ͤǤϤޤ󡣺ꤷƲ";

} // end chmod


// -------------------------------------------------------------------------
// Clear cookies module
// -------------------------------------------------------------------------
// No messages


// -------------------------------------------------------------------------
// Copy/Move/Delete module
if ($net2ftp_globals["state"] == "copymovedelete") {
// -------------------------------------------------------------------------
$net2ftp_messages["Choose a directory"] = "ǥ쥯ȥ";
$net2ftp_messages["Copy directories and files"] = "ǥ쥯ȥȥեΥԡ";
$net2ftp_messages["Move directories and files"] = "ǥ쥯ȥȥեΰư";
$net2ftp_messages["Delete directories and files"] = "ǥ쥯ȥȥեκ";
$net2ftp_messages["Are you sure you want to delete these directories and files?"] = "ΥեƤǤ?";
$net2ftp_messages["All the subdirectories and files of the selected directories will also be deleted!"] = "򤵤줿ǥ쥯ȥΥ֥ǥ쥯ȥȥեޤ!";
$net2ftp_messages["Set all targetdirectories"] = "Ƥоݥǥ쥯ȥ";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "̤оݥǥ쥯ȥꤹˤϡΥƥȥܥåоݥǥ쥯ȥϤ \"Ƥоݥǥ쥯ȥ\" ܥ򥯥åƲ";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = ": ԡˡоݥǥ쥯ȥ꤬¸ߤƤʤФʤޤ";
$net2ftp_messages["Different target FTP server:"] = "̤о FTP :";
$net2ftp_messages["Username"] = "桼̾";
$net2ftp_messages["Password"] = "ѥ";
$net2ftp_messages["Leave empty if you want to copy the files to the same FTP server."] = "Ʊ FTP Ф˥ե򥳥ԡȤϡϤʤǲ";
$net2ftp_messages["If you want to copy the files to another FTP server, enter your login data."] = "̤ FTP Ф˥ե򥳥ԡȤϡʤΥϤƲ";
$net2ftp_messages["Leave empty if you want to move the files to the same FTP server."] = "Ʊ FTP Ф˥եưȤϡϤʤǲ";
$net2ftp_messages["If you want to move the files to another FTP server, enter your login data."] = "̤ FTP Ф˥եưȤϡʤΥϤƲ";
$net2ftp_messages["Copy directory <b>%1\$s</b> to:"] = "ǥ쥯ȥ <b>%1\$s</b> Υԡ:";
$net2ftp_messages["Move directory <b>%1\$s</b> to:"] = "ǥ쥯ȥ <b>%1\$s</b> ΰư:";
$net2ftp_messages["Directory <b>%1\$s</b>"] = "ǥ쥯ȥ <b>%1\$s</b>";
$net2ftp_messages["Copy file <b>%1\$s</b> to:"] = "ե <b>%1\$s</b> Υԡ:";
$net2ftp_messages["Move file <b>%1\$s</b> to:"] = "ե <b>%1\$s</b> ΰư:";
$net2ftp_messages["File <b>%1\$s</b>"] = "ե <b>%1\$s</b>";
$net2ftp_messages["Copy symlink <b>%1\$s</b> to:"] = "ܥå <b>%1\$s</b> Υԡ:";
$net2ftp_messages["Move symlink <b>%1\$s</b> to:"] = "ܥå <b>%1\$s</b> ΰư:";
$net2ftp_messages["Symlink <b>%1\$s</b>"] = "ܥå <b>%1\$s</b>";
$net2ftp_messages["Target directory:"] = "оݥǥ쥯ȥ:";
$net2ftp_messages["Target name:"] = "о̾:";
$net2ftp_messages["Processing the entries:"] = "ȥƤޤ:";

} // end copymovedelete


// -------------------------------------------------------------------------
// Download file module
// -------------------------------------------------------------------------
// No messages


// -------------------------------------------------------------------------
// EasyWebsite module
if ($net2ftp_globals["state"] == "easyWebsite") {
// -------------------------------------------------------------------------
$net2ftp_messages["Create a website in 4 easy steps"] = "webȤñ4ĤΥƥåפǺ";
$net2ftp_messages["Template overview"] = "ƥץ졼Ȱ";
$net2ftp_messages["Template details"] = "ƥץ졼Ⱦܺ";
$net2ftp_messages["Files are copied"] = "ԡե";
$net2ftp_messages["Edit your pages"] = "ڡԽ";

// Screen 1 - printTemplateOverview
$net2ftp_messages["Click on the image to view the details of a template."] = "򥯥åȥƥץ졼Ȥξܺ٤ɽޤ";
$net2ftp_messages["Back to the Browse screen"] = "֥饦̤";
$net2ftp_messages["Template"] = "ƥץ졼";
$net2ftp_messages["Copyright"] = "Copyright";
$net2ftp_messages["Click on the image to view the details of this template"] = "򥯥åȤΥƥץ졼Ȥξܺ٤ɽޤ";

// Screen 2 - printTemplateDetails
$net2ftp_messages["The template files will be copied to your FTP server. Existing files with the same filename will be overwritten. Do you want to continue?"] = "ƥץ졼ȥե뤬ʤ FTPФ˥ԡޤƱ̾Υե뤬¸ߤȾ񤭤ޤ³ޤ";
$net2ftp_messages["Install template to directory: "] = "ƥץ졼Ȥǥ쥯ȥ˥󥹥ȡ: ";
$net2ftp_messages["Install"] = "Install";
$net2ftp_messages["Size"] = "";
$net2ftp_messages["Preview page"] = "ץӥ塼";
$net2ftp_messages["opens in a new window"] = "ɥǳ";

// Screen 3
$net2ftp_messages["Please wait while the template files are being transferred to your server: "] = "ƥץ졼ȥե뤬ʤΥФžޤФ餯Ԥ: ";
$net2ftp_messages["Done."] = "λ";
$net2ftp_messages["Continue"] = "³";

// Screen 4 - printEasyAdminPanel
$net2ftp_messages["Edit page"] = "ڡԽ";
$net2ftp_messages["Browse the FTP server"] = "FTPФ";
$net2ftp_messages["Add this link to your favorites to return to this page later on!"] = "󥯤򤪵ɲäơǤޤΥڡ褦ˤ!";
$net2ftp_messages["Edit website at %1\$s"] = "web %1\$s Խ";
$net2ftp_messages["Internet Explorer: right-click on the link and choose \"Add to Favorites...\""] = "Internet Explorer: 󥯤򱦥å\"ɲ...\"";
$net2ftp_messages["Netscape, Mozilla, Firefox: right-click on the link and choose \"Bookmark This Link...\""] = "Netscape, Mozilla, Firefox: 󥯤򱦥å\"Bookmark This Link...\"";

// ftp_copy_local2ftp
$net2ftp_messages["WARNING: Unable to create the subdirectory <b>%1\$s</b>. It may already exist. Continuing..."] = "ٹ: ֥ǥ쥯ȥ <b>%1\$s</b> 뤳ȤǤޤ󡣤⤦Ǥ¸ߤƤޤ³Ԥޤ...";
$net2ftp_messages["Created target subdirectory <b>%1\$s</b>"] = "оݤΥ֥ǥ쥯ȥ <b>%1\$s</b> ";
$net2ftp_messages["WARNING: Unable to copy the file <b>%1\$s</b>. Continuing..."] = "ٹ: ե <b>%1\$s</b> 򥳥ԡ뤳ȤǤޤ³Ԥޤ...";
$net2ftp_messages["Copied file <b>%1\$s</b>"] = "ե <b>%1\$s</b> 򥳥ԡ";
}


// -------------------------------------------------------------------------
// Edit module
if ($net2ftp_globals["state"] == "edit") {
// -------------------------------------------------------------------------

// /modules/edit/edit.inc.php
$net2ftp_messages["Unable to open the template file"] = "ƥץ졼ȥե뤬ޤ";
$net2ftp_messages["Unable to read the template file"] = "ƥץ졼ȥե뤬ɤ߹ޤ";
$net2ftp_messages["Please specify a filename"] = "ե̾ꤷƤ";
$net2ftp_messages["Status: This file has not yet been saved"] = "ơ: ΥեϤޤ¸Ƥޤ";
$net2ftp_messages["Status: Saved on <b>%1\$s</b> using mode %2\$s"] = "ơ: %2\$s ⡼ɤ <b>%1\$s</b> ¸ޤ";
$net2ftp_messages["Status: <b>This file could not be saved</b>"] = "ơ: <b>Υե¸Ǥޤ</b>";

// /skins/[skin]/edit.template.php
$net2ftp_messages["Directory: "] = "ǥ쥯ȥ: ";
$net2ftp_messages["File: "] = "ե: ";
$net2ftp_messages["New file name: "] = "ե̾: ";
$net2ftp_messages["Character encoding: "] = "Character encoding: ";
$net2ftp_messages["Note: changing the textarea type will save the changes"] = ": ƥȥꥢפѹȡѹս¸뤳Ȥˤʤޤ";
$net2ftp_messages["Copy up"] = "˥ԡ";
$net2ftp_messages["Copy down"] = "˥ԡ";

} // end if edit


// -------------------------------------------------------------------------
// Find string module
if ($net2ftp_globals["state"] == "findstring") {
// -------------------------------------------------------------------------

// /modules/findstring/findstring.inc.php 
$net2ftp_messages["Search directories and files"] = "եȥǥ쥯ȥ򸡺";
$net2ftp_messages["Search again"] = "Ƹ";
$net2ftp_messages["Search results"] = "";
$net2ftp_messages["Please enter a valid search word or phrase."] = "ͭñޤϸϤƤ";
$net2ftp_messages["Please enter a valid filename."] = "ͭʥե̾ϤƤ";
$net2ftp_messages["Please enter a valid file size in the \"from\" textbox, for example 0."] = "ͭʥե륵 \"from\" ƥȥܥåϤƲ(: 0)";
$net2ftp_messages["Please enter a valid file size in the \"to\" textbox, for example 500000."] = "ͭʥե륵 \"to\" ƥȥܥåϤƲ(: 500000)";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"from\" textbox."] = "Y-m-d ͭդ \"from\" ƥȥܥåϤƲ";
$net2ftp_messages["Please enter a valid date in Y-m-d format in the \"to\" textbox."] = "Y-m-d ͭդ \"to\" ƥȥܥåϤƲ";
$net2ftp_messages["The word <b>%1\$s</b> was not found in the selected directories and files."] = "ʸ <b>%1\$s</b> 򤵤줿ǥ쥯ȥȥեˤϸĤޤǤ";
$net2ftp_messages["The word <b>%1\$s</b> was found in the following files:"] = "ʸ <b>%1\$s</b> ϼΥե˸Ĥޤ:";

// /skins/[skin]/findstring1.template.php
$net2ftp_messages["Search for a word or phrase"] = "ʸθ";
$net2ftp_messages["Case sensitive search"] = "ܺٸ";
$net2ftp_messages["Restrict the search to:"] = ":";
$net2ftp_messages["files with a filename like"] = "ե̾";
$net2ftp_messages["(wildcard character is *)"] = "(磻ɥ: *)";
$net2ftp_messages["files with a size"] = "ե륵";
$net2ftp_messages["files which were last modified"] = "եκǽǻ";
$net2ftp_messages["from"] = "from";
$net2ftp_messages["to"] = "to";

$net2ftp_messages["Directory"] = "ե";
$net2ftp_messages["File"] = "ե";
$net2ftp_messages["Line"] = "";
$net2ftp_messages["Action"] = "";
$net2ftp_messages["View"] = "";
$net2ftp_messages["Edit"] = "Խ";
$net2ftp_messages["View the highlighted source code of file %1\$s"] = "ե %1\$s Υɤդɽ";
$net2ftp_messages["Edit the source code of file %1\$s"] = "ե %1\$s ΥɤԽ";

} // end findstring


// -------------------------------------------------------------------------
// Help module
// -------------------------------------------------------------------------
// No messages yet


// -------------------------------------------------------------------------
// Install size module
if ($net2ftp_globals["state"] == "install") {
// -------------------------------------------------------------------------

// /modules/install/install.inc.php
$net2ftp_messages["Install software packages"] = "Install software packages";
$net2ftp_messages["Unable to open the template file"] = "ƥץ졼ȥե뤬ޤ";
$net2ftp_messages["Unable to read the template file"] = "ƥץ졼ȥե뤬ɤ߹ޤ";
$net2ftp_messages["Unable to get the list of packages"] = "Unable to get the list of packages";

// /skins/blue/install1.template.php
$net2ftp_messages["The net2ftp installer script has been copied to the FTP server."] = "The net2ftp installer script has been copied to the FTP server.";
$net2ftp_messages["This script runs on your web server and requires PHP to be installed."] = "This script runs on your web server and requires PHP to be installed.";
$net2ftp_messages["In order to run it, click on the link below."] = "In order to run it, click on the link below.";
$net2ftp_messages["net2ftp has tried to determine the directory mapping between the FTP server and the web server."] = "net2ftp has tried to determine the directory mapping between the FTP server and the web server.";
$net2ftp_messages["Should this link not be correct, enter the URL manually in your web browser."] = "Should this link not be correct, enter the URL manually in your web browser.";

} // end install


// -------------------------------------------------------------------------
// Java upload module
if ($net2ftp_globals["state"] == "jupload") {
// -------------------------------------------------------------------------
$net2ftp_messages["Upload directories and files using a Java applet"] = "JavaץåȤѤƥǥ쥯ȥȥե򥢥åץ";
$net2ftp_messages["Number of files:"] = "ե:";
$net2ftp_messages["Size of files:"] = "ե륵:";
$net2ftp_messages["Add"] = "ɲ";
$net2ftp_messages["Remove"] = "";
$net2ftp_messages["Upload"] = "åץ";
$net2ftp_messages["Add files to the upload queue"] = "ե򥭥塼ɲ";
$net2ftp_messages["Remove files from the upload queue"] = "ե򥭥塼";
$net2ftp_messages["Upload the files which are in the upload queue"] = "塼Υե򥢥åץ";
$net2ftp_messages["Maximum server space exceeded. Please select less/smaller files."] = "̤θ³ãե򾯤ʤ/Ʋ";
$net2ftp_messages["Total size of the files is too big. Please select less/smaller files."] = "եιץ礭ޤե򾯤ʤ/Ʋ";
$net2ftp_messages["Total number of files is too high. Please select fewer files."] = "եι׿¿ޤե򾯤ʤƲ";
$net2ftp_messages["Note: to use this applet, Sun's Java plugin must be installed (version 1.4 or newer)."] = ": ΥץåȤѤˤϡSun  Javaץ饰ʥС 1.4 ʾˤ󥹥ȡ뤵Ƥɬפޤ";

} // end jupload



// -------------------------------------------------------------------------
// Login module
if ($net2ftp_globals["state"] == "login") {
// -------------------------------------------------------------------------
$net2ftp_messages["Login!"] = "󤷤褦!";
$net2ftp_messages["Once you are logged in, you will be able to:"] = "Once you are logged in, you will be able to:";
$net2ftp_messages["Navigate the FTP server"] = "FTP Ф";
$net2ftp_messages["Once you have logged in, you can browse from directory to directory and see all the subdirectories and files."] = "٥󤹤Сǥ쥯ȥȥǥ쥯ȥΥ֥ǥ쥯ȥꡢեƤ뤳ȤǤޤ";
$net2ftp_messages["Upload files"] = "եΥåץ";
$net2ftp_messages["There are 3 different ways to upload files: the standard upload form, the upload-and-unzip functionality, and the Java Applet."] = "3ˡǥե򥢥åץɤǤޤ: ɸΥåץɡåץɸ弫ưൡǽJavaץåȤˤ륢åץɡ";
$net2ftp_messages["Download files"] = "եΥ";
$net2ftp_messages["Click on a filename to quickly download one file.<br />Select multiple files and click on Download; the selected files will be downloaded in a zip archive."] = "ե̾򥯥åƤΥե¨¤˥ɤ뤳ȤǤޤ<br />ʣΥե򥯥åƥɤȡ1Ĥΰ̥եˤƥɤޤ";
$net2ftp_messages["Zip files"] = "եΰ";
$net2ftp_messages["... and save the zip archive on the FTP server, or email it to someone."] = "ե򰵽̤ FTPо¸ꡢŻҥ᡼뤳ȤǤޤ";
$net2ftp_messages["Unzip files"] = "Unzip files";
$net2ftp_messages["Different formats are supported: .zip, .tar, .tgz and .gz."] = "Different formats are supported: .zip, .tar, .tgz and .gz.";
$net2ftp_messages["Install software"] = "Install software";
$net2ftp_messages["Choose from a list of popular applications (PHP required)."] = "Choose from a list of popular applications (PHP required).";
$net2ftp_messages["Copy, move and delete"] = "ԡư";
$net2ftp_messages["Directories are handled recursively, meaning that their content (subdirectories and files) will also be copied, moved or deleted."] = "ǥ쥯ȥ򷫤֤ǤޤΥƥġʥ֥ǥ쥯ȥȥեˤ⥳ԡưǤޤ";
$net2ftp_messages["Copy or move to a 2nd FTP server"] = "̤FTPФؤΥԡư";
$net2ftp_messages["Handy to import files to your FTP server, or to export files from your FTP server to another FTP server."] = "ñˤʤ FTPФ˥ե򥤥ݡȤꡢʤ FTPФ̤ FTPФإե򥨥ݡȤ뤳ȤǤޤ";
$net2ftp_messages["Rename and chmod"] = "ե̾ѹȵľѹ";
$net2ftp_messages["Chmod handles directories recursively."] = "ǥ쥯ȥεľѹ򷫤֤Ǥޤ";
$net2ftp_messages["View code with syntax highlighting"] = "դǥɽ";
$net2ftp_messages["PHP functions are linked to the documentation on php.net."] = "PHPǽ php.net ΥɥȤȥ󥯤Ƥޤ";
$net2ftp_messages["Plain text editor"] = "ץ졼ƥȥǥ";
$net2ftp_messages["Edit text right from your browser; every time you save the changes the new file is transferred to the FTP server."] = "֥饦ǥƥȤΤԽǤޤѹ¸ե FTPФžޤ";
$net2ftp_messages["HTML editors"] = "HTMLǥ";
$net2ftp_messages["Edit HTML a What-You-See-Is-What-You-Get (WYSIWYG) form; there are 2 different editors to choose from."] = "Edit HTML a What-You-See-Is-What-You-Get (WYSIWYG) form; there are 2 different editors to choose from.";
$net2ftp_messages["Code editor"] = "ɥǥ";
$net2ftp_messages["Edit HTML and PHP in an editor with syntax highlighting."] = "HTML  PHP դɽԽǤޤ";
$net2ftp_messages["Search for words or phrases"] = "ʸθ";
$net2ftp_messages["Filter out files based on the filename, last modification time and filesize."] = "ɽեե̾ǽѹե륵ǥե륿󥰤Ǥޤ";
$net2ftp_messages["Calculate size"] = "η׻";
$net2ftp_messages["Calculate the size of directories and files."] = "ǥ쥯ȥȥեΥ׻Ǥޤ";

$net2ftp_messages["FTP server"] = "FTP ";
$net2ftp_messages["Example"] = "";
$net2ftp_messages["Port"] = "ݡ";
$net2ftp_messages["Username"] = "桼̾";
$net2ftp_messages["Password"] = "ѥ";
$net2ftp_messages["Anonymous"] = "ƿ̾";
$net2ftp_messages["Passive mode"] = "Passive ⡼";
$net2ftp_messages["Initial directory"] = "ǥ쥯ȥ";
$net2ftp_messages["Language"] = "";
$net2ftp_messages["Skin"] = "ơ";
$net2ftp_messages["FTP mode"] = "FTP⡼";
$net2ftp_messages["Automatic"] = "ư";
$net2ftp_messages["Login"] = "";
$net2ftp_messages["Clear cookies"] = "åκ";
$net2ftp_messages["Admin"] = "Admin";
$net2ftp_messages["Please enter an FTP server."] = "FTPФϤƲ";
$net2ftp_messages["Please enter a username."] = "桼̾ϤƲ";
$net2ftp_messages["Please enter a password."] = "ѥɤϤƲ";

} // end login


// -------------------------------------------------------------------------
// Login module
if ($net2ftp_globals["state"] == "login_small") {
// -------------------------------------------------------------------------

$net2ftp_messages["Please enter your Administrator username and password."] = "ԤΥ桼̾ȥѥɤϤƲ";
$net2ftp_messages["Please enter your username and password for FTP server <b>%1\$s</b>."] = "Please enter your username and password for FTP server <b>%1\$s</b>.";
$net2ftp_messages["Username"] = "桼̾";
$net2ftp_messages["Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your session has expired; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue."] = "Your IP address has changed; please enter your password for FTP server <b>%1\$s</b> to continue.";
$net2ftp_messages["Password"] = "ѥ";
$net2ftp_messages["Login"] = "";
$net2ftp_messages["Continue"] = "³";

} // end login_small


// -------------------------------------------------------------------------
// Logout module
if ($net2ftp_globals["state"] == "logout") {
// -------------------------------------------------------------------------

// logout.inc.php
$net2ftp_messages["Login page"] = "ڡ";

// logout.template.php
$net2ftp_messages["You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>."] = "You have logged out from the FTP server. To log back in, <a href=\"%1\$s\" title=\"Login page (accesskey l)\" accesskey=\"l\">follow this link</a>.";
$net2ftp_messages["Note: other users of this computer could click on the browser's Back button and access the FTP server."] = ": ֥饦ܥ򥯥åȡΥԥ塼¾Υ桼 FTPФ˥뤳ȤǤƤޤޤ";
$net2ftp_messages["To prevent this, you must close all browser windows."] = "ɤˤϡƤΥ֥饦ΥɥĤɬפޤ";
$net2ftp_messages["Close"] = "Ĥ";
$net2ftp_messages["Click here to close this window"] = "򥯥åȤΥɥĤޤ";

} // end logout


// -------------------------------------------------------------------------
// New directory module
if ($net2ftp_globals["state"] == "newdir") {
// -------------------------------------------------------------------------
$net2ftp_messages["Create new directories"] = "ǥ쥯ȥκ";
$net2ftp_messages["The new directories will be created in <b>%1\$s</b>."] = "ǥ쥯ȥ <b>%1\$s</b> ˺ޤ";
$net2ftp_messages["New directory name:"] = "ǥ쥯ȥ̾:";
$net2ftp_messages["Directory <b>%1\$s</b> was successfully created."] = "ǥ쥯ȥ <b>%1\$s</b> ޤ";
$net2ftp_messages["Directory <b>%1\$s</b> could not be created."] = "ǥ쥯ȥ <b>%1\$s</b> 뤳ȤǤޤǤ";

} // end newdir


// -------------------------------------------------------------------------
// Raw module
if ($net2ftp_globals["state"] == "raw") {
// -------------------------------------------------------------------------

// /modules/raw/raw.inc.php
$net2ftp_messages["Send arbitrary FTP commands"] = "Ǥդ FTPޥɤ";


// /skins/[skin]/raw1.template.php
$net2ftp_messages["List of commands:"] = "ޥɤΥꥹ:";
$net2ftp_messages["FTP server response:"] = "FTPФα:";

} // end raw


// -------------------------------------------------------------------------
// Rename module
if ($net2ftp_globals["state"] == "rename") {
// -------------------------------------------------------------------------
$net2ftp_messages["Rename directories and files"] = "ǥ쥯ȥ̾ȥե̾ѹ";
$net2ftp_messages["Old name: "] = "̾: ";
$net2ftp_messages["New name: "] = "̾: ";
$net2ftp_messages["The new name may not contain any dots. This entry was not renamed to <b>%1\$s</b>"] = "ե̾˥ɥå(.)ޤळȤϤǤޤ󡣤Υȥ <b>%1\$s</b> ˲̾ޤǤ";
$net2ftp_messages["The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>"] = "The new name may not contain any banned keywords. This entry was not renamed to <b>%1\$s</b>";
$net2ftp_messages["<b>%1\$s</b> was successfully renamed to <b>%2\$s</b>"] = "<b>%1\$s</b>  <b>%2\$s</b> ˲̾ޤ";
$net2ftp_messages["<b>%1\$s</b> could not be renamed to <b>%2\$s</b>"] = "<b>%1\$s</b>  <b>%2\$s</b> ˲̾뤳ȤϤǤޤ";

} // end rename


// -------------------------------------------------------------------------
// Unzip module
if ($net2ftp_globals["state"] == "unzip") {
// -------------------------------------------------------------------------

// /modules/unzip/unzip.inc.php
$net2ftp_messages["Unzip archives"] = "Unzip archives";
$net2ftp_messages["Getting archive %1\$s of %2\$s from the FTP server"] = "Getting archive %1\$s of %2\$s from the FTP server";
$net2ftp_messages["Unable to get the archive <b>%1\$s</b> from the FTP server"] = "Unable to get the archive <b>%1\$s</b> from the FTP server";

// /skins/[skin]/unzip1.template.php
$net2ftp_messages["Set all targetdirectories"] = "Ƥоݥǥ쥯ȥ";
$net2ftp_messages["To set a common target directory, enter that target directory in the textbox above and click on the button \"Set all targetdirectories\"."] = "̤оݥǥ쥯ȥꤹˤϡΥƥȥܥåоݥǥ쥯ȥϤ \"Ƥоݥǥ쥯ȥ\" ܥ򥯥åƲ";
$net2ftp_messages["Note: the target directory must already exist before anything can be copied into it."] = ": ԡˡоݥǥ쥯ȥ꤬¸ߤƤʤФʤޤ";
$net2ftp_messages["Unzip archive <b>%1\$s</b> to:"] = "Unzip archive <b>%1\$s</b> to:";
$net2ftp_messages["Target directory:"] = "оݥǥ쥯ȥ:";
$net2ftp_messages["Use folder names (creates subdirectories automatically)"] = "ե̾ (֥ǥ쥯ȥμư)";

} // end unzip


// -------------------------------------------------------------------------
// Update file module
if ($net2ftp_globals["state"] == "updatefile") {
// -------------------------------------------------------------------------
$net2ftp_messages["Update file"] = "եΥåץǡ";
$net2ftp_messages["<b>WARNING: THIS FUNCTION IS STILL IN EARLY DEVELOPMENT. USE IT ONLY ON TEST FILES! YOU HAVE BEEN WARNED!"] = "<b>ٹ: εǽϤޤȯʳǤƤ⹽ʤƥȥեΤߤѤˤȤɤᡢ褷ڤʥեˤѤʤǲ! ϷٹǤ!";
$net2ftp_messages["Known bugs: - erases tab characters - doesn't work well with big files (> 50kB) - was not tested yet on files containing non-standard characters</b>"] = "̤ΤΥХ: - ʸξõ - 礭ʥΥեǤϾ꤯ưʤ (> 50kB) - ɸʸʳʸޤե̤ƥ</b>";
$net2ftp_messages["This function allows you to upload a new version of the selected file, to view what are the changes and to accept or reject each change. Before anything is saved, you can edit the merged files."] = "εǽ򤵤줿ե򿷤СΥեء줾ѹɽʤ顢ġѹŬѤ뤫ݤ򤷤ƥåץɤ뤳ȤǤޤ. ¸ˡʻ礵줿եԽ뤳ȤǤޤ.";
$net2ftp_messages["Old file:"] = "Υե:";
$net2ftp_messages["New file:"] = "ե:";
$net2ftp_messages["Restrictions:"] = ":";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s kB</b> and by PHP to <b>%2\$s</b>"] = "1ĤΥեξ¥ net2ftp  <b>%1\$s kB</b> ޤǡ PHP  <b>%2\$s</b> ޤǤ¤Ƥޤ";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "֤ξ¤ <b>%1\$s </b> Ǥ";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "FTP ž⡼ (ASCII ޤ Хʥ) ϥե̾γĥҤˤäƼưŪ˷ꤵޤ";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "žƱ̾Υե뤬Ǥ¸ߤϾ񤭤ޤ";
$net2ftp_messages["You did not provide any files or archives to upload."] = "åץɤեޤϰ̥ե뤬ꤵƤޤ";
$net2ftp_messages["Unable to delete the new file"] = "ե뤳ȤϤǤޤ";

// printComparisonSelect()
$net2ftp_messages["Please wait..."] = "Ф餯Ԥ...";
$net2ftp_messages["Select lines below, accept or reject changes and submit the form."] = "ιԤ򤷤 ġѲ ѹեƤ";

} // end updatefile


// -------------------------------------------------------------------------
// Upload module
if ($net2ftp_globals["state"] == "upload") {
// -------------------------------------------------------------------------
$net2ftp_messages["Upload to directory:"] = "åץΥǥ쥯ȥ:";
$net2ftp_messages["Files"] = "ե";
$net2ftp_messages["Archives"] = "̥ե";
$net2ftp_messages["Files entered here will be transferred to the FTP server."] = "Ϥե뤬 FTP Фžޤ";
$net2ftp_messages["Archives entered here will be decompressed, and the files inside will be transferred to the FTP server."] = "Ϥ̥ե뤬व졢Υե뤬 FTP Фžޤ";
$net2ftp_messages["Add another"] = "ɲ";
$net2ftp_messages["Use folder names (creates subdirectories automatically)"] = "ե̾ (֥ǥ쥯ȥμư)";

$net2ftp_messages["Choose a directory"] = "ǥ쥯ȥ";
$net2ftp_messages["Please wait..."] = "Ф餯Ԥ...";
$net2ftp_messages["Uploading... please wait..."] = "åץ... Ф餯Ԥ...";
$net2ftp_messages["If the upload takes more than the allowed <b>%1\$s seconds<\/b>, you will have to try again with less/smaller files."] = "åץɤƻ <b>%1\$s <\/b>Ķ褦ʤС꾮/ʤեǤľɬפޤ";
$net2ftp_messages["This window will close automatically in a few seconds."] = "ΥɥϿø˼ưĤޤ";
$net2ftp_messages["Close window now"] = "Ĥ";

$net2ftp_messages["Upload files and archives"] = "եȰ̥եΥåץ";
$net2ftp_messages["Upload results"] = "åץɷ";
$net2ftp_messages["Checking files:"] = "եΥå:";
$net2ftp_messages["Transferring files to the FTP server:"] = "ե FTP Фž:";
$net2ftp_messages["Decompressing archives and transferring files to the FTP server:"] = "̥եषե FTP Фž:";
$net2ftp_messages["Upload more files and archives"] = "¾ΥեȰ̥ե⥢åץɤ";

} // end upload


// -------------------------------------------------------------------------
// Messages which are shared by upload and jupload
if ($net2ftp_globals["state"] == "upload" || $net2ftp_globals["state"] == "jupload") {
// -------------------------------------------------------------------------
$net2ftp_messages["Restrictions:"] = ":";
$net2ftp_messages["The maximum size of one file is restricted by net2ftp to <b>%1\$s kB</b> and by PHP to <b>%2\$s</b>"] = "1ĤΥեξ¥ net2ftp  <b>%1\$s kB</b> ޤǡ PHP  <b>%2\$s</b> ޤǤ¤Ƥޤ";
$net2ftp_messages["The maximum execution time is <b>%1\$s seconds</b>"] = "֤ξ¤ <b>%1\$s </b> Ǥ";
$net2ftp_messages["The FTP transfer mode (ASCII or BINARY) will be automatically determined, based on the filename extension"] = "FTP ž⡼ (ASCII ޤ Хʥ) ϥե̾γĥҤˤäƼưŪ˷ꤵޤ";
$net2ftp_messages["If the destination file already exists, it will be overwritten"] = "žƱ̾Υե뤬Ǥ¸ߤϾ񤭤ޤ";

} // end upload or jupload


// -------------------------------------------------------------------------
// View module
if ($net2ftp_globals["state"] == "view") {
// -------------------------------------------------------------------------

// /modules/view/view.inc.php
$net2ftp_messages["View file %1\$s"] = "ե %1\$s ɽ";
$net2ftp_messages["View image %1\$s"] = " %1\$s ɽ";
$net2ftp_messages["View Macromedia ShockWave Flash movie %1\$s"] = "Macromedia ShockWave Flash ࡼӡ %1\$s ɽ";
$net2ftp_messages["Image"] = "";

// /skins/[skin]/view1.template.php
$net2ftp_messages["Syntax highlighting powered by <a href=\"http://geshi.org\">GeSHi</a>"] = "դɽ <a href=\"http://geshi.org\">GeSHi</a> 鶡뤵Ƥޤ";
$net2ftp_messages["To save the image, right-click on it and choose 'Save picture as...'"] = "¸ˤϡξǱå '̾դƲ¸...' 򤷤Ƥ";

} // end view


// -------------------------------------------------------------------------
// Zip module
if ($net2ftp_globals["state"] == "zip") {
// -------------------------------------------------------------------------

// /modules/zip/zip.inc.php
$net2ftp_messages["Zip entries"] = "̥ե륨ȥ";

// /skins/[skin]/zip1.template.php
$net2ftp_messages["Save the zip file on the FTP server as:"] = "FTP оǼΥե򰵽:";
$net2ftp_messages["Email the zip file in attachment to:"] = "Email ˰̥եź:";
$net2ftp_messages["Note that sending files is not anonymous: your IP address as well as the time of the sending will be added to the email."] = ": եƿ̾Ǥޤ󡣤ʤ IP ɥ쥹 email ɲäޤ";
$net2ftp_messages["Some additional comments to add in the email:"] = "email ɲä륳:";

$net2ftp_messages["You did not enter a filename for the zipfile. Go back and enter a filename."] = "̥եΥե̾ϤƤޤ򥯥åƥե̾ϤƲ";
$net2ftp_messages["The email address you have entered (%1\$s) does not seem to be valid.<br />Please enter an address in the format <b>username@domain.com</b>"] = "Ϥ줿 email ɥ쥹 (%1\$s) ͭǤϤޤ<br />ν񼰤§äɥ쥹ϤƲ <b>username@domain.com</b>";

} // end zip

?>