/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Attempts to display a post via AJAX, falling back to opening a new window if AJAX not available
*
* @param	integer	Post ID
*
* @return	boolean	False
*/
function display_post(postid)
{
	if (AJAX_Compatible)
	{
		vB_PostLoader[postid] = new vB_AJAX_PostLoader(postid);
		vB_PostLoader[postid].init();
	}
	else
	{
		pc_obj = fetch_object('postcount' + this.postid);
		openWindow('showthread.php?' + (SESSIONURL ? 's=' + SESSIONURL : '') + (pc_obj != null ? '&postcount=' + PHP.urlencode(pc_obj.name) : '') + '&p=' + postid + "#post" + postid);
	}
	return false;
};

// #############################################################################
// vB_AJAX_PostLoader
// #############################################################################

var vB_PostLoader = new Array();

/**
* Class to load a postbit via AJAX
*
* @package	vBulletin
* @version	$Revision: 35508 $
* @date		$Date: 2010-02-23 07:07:31 -0800 (Tue, 23 Feb 2010) $
* @author	Kier Darby, vBulletin Development Team
*
* @param	integer	Post ID
*/
function vB_AJAX_PostLoader(postid)
{
	this.postid = postid;
	this.post = YAHOO.util.Dom.get('post_' + this.postid);
};

/**
* Initiates the AJAX send to showpost.php
*/
vB_AJAX_PostLoader.prototype.init = function()
{
	if (this.post)
	{
		postid = this.postid;
		pc_obj = fetch_object('postcount' + this.postid);

		YAHOO.util.Connect.asyncRequest("POST", "showpost.php?p=" + this.postid, {
			success: this.display,
			failure: this.handle_ajax_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&ajax=1&postid=" + this.postid + (pc_obj != null ? "&postcount=" + PHP.urlencode(pc_obj.name) : ""));
	}
};

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
vB_AJAX_PostLoader.prototype.handle_ajax_error = function(ajax)
{
	//TODO: Something bad happened, try again
	vBulletin_AJAX_Error_Handler(ajax);
};

/**
* Takes the AJAX HTML output and replaces the existing post placeholder with the new HTML
*
* @param	object	YUI AJAX
*/
vB_AJAX_PostLoader.prototype.display = function(ajax)
{
	if (ajax.responseXML)
	{
		var postbit = ajax.responseXML.getElementsByTagName("postbit");

		if (postbit.length)
		{
			var newpostbit = string_to_node(postbit[0].firstChild.nodeValue);
			this.post.parentNode.replaceChild(newpostbit, this.post);

			//this.container.innerHTML = postbit[0].firstChild.nodeValue;
			PostBit_Init(newpostbit, this.postid);
		}
		else
		{	// parsing of XML failed, probably IE
			openWindow('showthread.php?' + (SESSIONURL ? 's=' + SESSIONURL : '') + (pc_obj != null ? '&postcount=' + PHP.urlencode(pc_obj.name) : '') + '&p=' + this.postid + "#post" + this.postid);
		}
	}
};

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 35508 $
|| ####################################################################
\*======================================================================*/