/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Array to store initialized vB_AJAX_ReadMarker objects
*
* @var	array
*/
var vB_ReadMarker = {
	'forum_statusicon_prefix'  : 'forum_statusicon_',
	'thread_statusicon_prefix' : 'thread_statusicon_',
	'thread_gotonew_prefix'    : 'thread_gotonew_',
	'thread_title_prefix'      : 'thread_title_'
};

// #############################################################################
// vB_AJAX_ReadMarker
// #############################################################################

/**
* vBulletin AJAX forum read marker class
*
* Allows a forum, its child forums and all contained threads to be marked as read
*
* @package	vBulletin
* @version	$Revision: 26385 $
* @date		$Date: 2008-04-22 03:40:28 -0700 (Tue, 22 Apr 2008) $
* @author	Kier Darby, vBulletin Development Team
*
* @param	integer	Forum ID to be marked as read
*/
function vB_AJAX_ReadMarker(forumid)
{
	this.forumid = forumid;
};

/**
* Initializes the AJAX request to mark the forum as read
*/
vB_AJAX_ReadMarker.prototype.mark_read = function()
{
	YAHOO.util.Connect.asyncRequest("POST", 'ajax.php?do=markread&f=' + this.forumid, {
		success: this.handle_ajax_request,
		failure: this.handle_ajax_error,
		timeout: vB_Default_Timeout,
		scope: this
	}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + '&do=markread&forumid=' + this.forumid);
};

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
vB_AJAX_ReadMarker.prototype.handle_ajax_error = function(ajax)
{
	//TODO: Something bad happened, try again
	vBulletin_AJAX_Error_Handler(ajax);
};

/**
* Handles the XML response from the AJAX response
*
* Passes forum IDs in XML to handler functions
*
* @param	object	YUI AJAX
*/
vB_AJAX_ReadMarker.prototype.handle_ajax_request = function(ajax)
{
	/* TODO: Update forumbits, see vbulletin_read_marker.js
	var forumbits = YAHOO.util.Dom.getElementsByClassName("forum", "li", "forums");
	
	for (var i = 0; i < forumbits.length; i++)
	{
		YAHOO.util.Dom.removeClass(forumbits[i], 'new');
	}
	*/
	
	var threadbits = YAHOO.util.Dom.getElementsByClassName("threadbit", "li", "threadlist");
	
	for (var i = 0; i < threadbits.length; i++)
	{
		YAHOO.util.Dom.removeClass(threadbits[i], 'new');
		var threadTitle = YAHOO.util.Dom.getElementsByClassName("threadtitle_unread", "a", threadbits[i]);
		threadTitle = threadTitle[0];
		if (threadTitle) {
			YAHOO.util.Dom.removeClass(threadTitle, 'threadtitle_unread');
		}
	}
	if (window.YAHOO && YAHOO.vBulletin && YAHOO.vBulletin.vBPopupMenu) {
		YAHOO.vBulletin.vBPopupMenu.close_all();
	}
};


// #############################################################################
// Ancilliary functions
// #############################################################################

/**
* Initializes a request to mark a forum and its children as read
*
* @param	integer	Forum ID to be marked as read
*
* @return	boolean	false
*/
function mark_forum_read(forumid)
{
	if (AJAX_Compatible)
	{
		vB_ReadMarker[forumid] = new vB_AJAX_ReadMarker(forumid);
		vB_ReadMarker[forumid].mark_read();
	}
	else
	{
		window.location = 'forumdisplay.php?' + SESSIONURL + 'do=markread&forumid=' + forumid;
	}

	return false;
};

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 26385 $
|| ####################################################################
\*======================================================================*/