/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// Handle Post Icon Preview
vB_XHTML_Ready.subscribe(init_posticons);

function init_posticons()
{
	var posticons = YAHOO.util.Dom.get("posticons");
	var posticon_preview = YAHOO.util.Dom.get("posticon_preview");
	var previews = new Array();

	if (posticons && posticon_preview)
	{		
		containers = YAHOO.util.Dom.get("posticons").getElementsByTagName("li");
		
		for (i = 0; i < containers.length; i++)
		{
			previews[i] = new PostIconPreview(containers[i], posticon_preview);
			
			if (previews[i].control.checked)
			{
				previews[i].choose();
			}
		}
	}		
};

function PostIconPreview(container, posticon_preview)
{
	this.posticon_preview = posticon_preview;
	this.control = container.getElementsByTagName("input")[0];
	this.icon = container.getElementsByTagName("img")[0];
	
	YAHOO.util.Event.on(this.control, "click", this.choose, this, true);
};

PostIconPreview.prototype.choose = function(e)
{
	this.clear_preview();
	
	this.set_preview();
};

PostIconPreview.prototype.clear_preview = function(e)
{	
	this.posticon_preview.src = "images/clear.gif";
};

PostIconPreview.prototype.set_preview = function(e)
{
	if (this.control.value != 0)
	{
		this.posticon_preview.src = "images/icons/icon" + this.control.value + ".gif";
	}
};

// Handle Dependent Controls

vB_XHTML_Ready.subscribe(function (e) {return handle_dep(document.body);});

var DepCtrls = new Object();

function handle_dep(container)
{
	var ctrls = YAHOO.util.Dom.getElementsByClassName("dep_ctrl", "input", container);
	var ctrl = null;
	
	for (var i = 0; i < ctrls.length; i++)
	{
		ctrl = new DepCtrl(ctrls[i]);
		if (!ctrl.fail)
		{
			console.log("Dep Ctrl: %s", ctrls[i].id);
			DepCtrls[ctrls[i].id] = ctrl;
		}
	}
}

function DepCtrl(ctrl)
{
	// the control that does the enable/disabling
	this.ctrl = YAHOO.util.Dom.get(ctrl);
	
	if (!this.ctrl)
	{
		console.log("Dep Ctrl (ctrl) FAIL: %s", ctrl.id);
		this.fail = true;
		return false;
	}
	
	// container for dependent controls
	this.deps = YAHOO.util.Dom.get(ctrl.id + "_deps");
	
	if (!this.deps)
	{
		console.log("Dep Ctrl (deps_x) FAIL: %s", ctrl.id);
		this.fail = true;
		return false;
	}
	
	this.set_disabled_state(this.deps, true);
	
	if (this.ctrl.type == "checkbox")
	{
		console.log("Checkbox %s", this.ctrl.id);
		this.add_click_event(this.ctrl);
	}
	else if (this.ctrl.type == "radio")
	{
		console.log("Radio %s (%s)", this.ctrl.id, this.ctrl.name);
		var ctrls = document.getElementsByName(this.ctrl.name);
		
		for (var i = 0; i < ctrls.length; i++)
		{
			this.add_click_event(ctrls[i]);
		}
	}
}

DepCtrl.prototype.add_click_event = function(element)
{
	YAHOO.util.Event.on(element, "click", this.check_state, this, true);
}

DepCtrl.prototype.check_state = function(e)
{
	this.set_disabled_state(this.deps, true);
	
	this.set_focus();
}

DepCtrl.prototype.set_disabled_state = function(element, force)
{
	if (element.tagName && (element.tagName != "DD" || force))
	{		
		element.disabled = !this.ctrl.checked || this.ctrl.disabled;
		
		if (element.tagName == "INPUT" && YAHOO.util.Dom.hasClass(element, "dep_ctrl") && DepCtrls[element.id])
		{
			DepCtrls[element.id].set_disabled_state(DepCtrls[element.id].deps, true);
		}
		
		if (element.hasChildNodes())
		{
			for (var i = 0; i < element.childNodes.length; i++)
			{
				this.set_disabled_state(element.childNodes[i]);
			}
		}
	}
}
	

DepCtrl.prototype.is_form_element = function(element)
{
	switch (element.tagName)
	{
		case "INPUT":				
		case "SELECT":
		case "TEXTAREA":
			return true;
		default:
			return false;
	}
}

DepCtrl.prototype.set_focus = function(e)
{
	var ctrls = YAHOO.util.Dom.getElementsBy(this.is_form_element, "*", this.deps);
	
	try
	{
		try { ctrls[0].focus(); }
		catch(e) { ctrls[0].focus(); }
	}
	catch(e) {}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 26385 $
|| ####################################################################
\*======================================================================*/
