/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/*
	Doesn't currently work with labels that contain anchors -- need to figure out why
*/

vBulletin.widget = new Object();
vBulletin.widget.TreeView = function(id, oConfig)
{
	vBulletin.widget.TreeView.superclass.constructor.apply(this, arguments);
	this.createEvent("nodeMove");

	/*
		Event handlers -- for some reason the "onEventName" convention used Yahoo's
		examples for most events isn't working here.
	*/
	this.subscribe("expandComplete",
		function(n) {
			this.walkNode(n, this.attachDragDrop);
		}
	);
}

YAHOO.extend(vBulletin.widget.TreeView, YAHOO.widget.TreeView,
	{
		render_lock : false,

		render : function()
		{
			vBulletin.widget.TreeView.superclass.render.apply(this, arguments);
			this.walkTree(this.attachDragDrop);
		},

		walkTree : function(fn)
		{
			return this.walkNode(this.getRoot(), fn);
		},

		walkNode : function(n, fn)
		{
			for (var i = 0; i < n.children.length; i++)
			{
				fn(n.children[i]);
				this.walkNode(n.children[i], fn);
			}
		},

		get_expanded : function()
		{
			var expanded = [];
			this.walkTree(
				function(n)
				{
					/*
						nodes with no children can be marked expaned and have isLeaf = false
						this doesn't make any sense and could come back to bite us, but excluding
						children from expanded nodes seems to work
					*/
					if(n.expanded && n.children.length > 0)
					{
						expanded.push(n);
					}
				}
			);
			return expanded;
		},

		/*
			"static" function.  Does not use "this", so it can be used
			as a callback without binding
		*/
		attachDragDrop : function(n)
		{
			var el = n.getContentEl();
			if (el)
			{
				var dd = new vBulletin.widget.DDTreeNode(n, el.id, null, {centerFrame:true, resizeFrame:false});
				dd.addInvalidHandleType("a");
			}
		},

		/*
			Should be on the node class, but I don't really want to try to extend
			that.
		*/
		is_ancestor : function(n, a)
		{
			current = n;
			while (current)
			{

				if (current.getEl().id == a.getEl().id)
				{
					return true;
				}
				current = current.parent;
			}
			return false;
		}
	}
);

// Our custom drag and drop implementation, extending YAHOO.util.DD
vBulletin.widget.DDTreeNode = function(node, id, sGroup, config)
{
	vBulletin.widget.DDTreeNode.superclass.constructor.apply(this, new Array(id, sGroup, config));
	this.tree_node = node;
	//the border looks weird for the tree
	this.getDragEl().style.border = "none";
	this.getDragEl().style.cursor = "pointer";
};


YAHOO.extend(vBulletin.widget.DDTreeNode, YAHOO.util.DDProxy,
	{
 		tree_node: null,
		current_target: null,

		startDrag: function(x, y)
		{
		},

		endDrag: function(e) {
		},

		onDragOver: function(e, id) {
			this.remove_drag_classes(this.current_target);
			this.current_target = id;
			YAHOO.util.Dom.addClass(id, "drag" + this.get_drop_location(id));
		},

		onDragOut : function(e, id)
		{
			var id = this.current_target;
			this.remove_drag_classes(this.current_target);
			this.current_target = null;
		},

		onDrag: function(e) {
			this.remove_drag_classes(this.current_traget);
			if(this.current_target)
			{
				YAHOO.util.Dom.addClass(this.current_target, "drag" +
					this.get_drop_location(this.current_target));
			}
		},

		remove_drag_classes : function(id)
		{
			if(id) {
				YAHOO.util.Dom.removeClass(id, "dragbefore");
				YAHOO.util.Dom.removeClass(id, "dragafter");
				YAHOO.util.Dom.removeClass(id, "dragon");
			}
		},

		onDragDrop: function(e, id) {
			var Dom = YAHOO.util.Dom;
			var DDM = YAHOO.util.DragDropMgr;
			var tree = this.tree_node.tree;

			var target = DDM.getDDById(id);
			//var location = this.get_drop_location(DDM.interactionInfo.point, Dom.getRegion(id));
			var location = this.get_drop_location(id);


			//the treeview really doesn't like it if you create cycles
			if (tree.is_ancestor(target.tree_node, this.tree_node))
			{
				return false;
			}

			tree.popNode(this.tree_node);

			if (location == "on")
			{
				this.tree_node.appendTo(target.tree_node);
				target.tree_node.expand();
			}
			else if (location == "before")
			{
				this.tree_node.insertBefore(target.tree_node);
			}
			else if (location == "after")
			{
				this.tree_node.insertAfter(target.tree_node);
			}

	//		insert_function.apply(this.tree_node, new Array(target.tree_node));


			//redraw the tree -- we may want to try to allow the use of the
			//node refresh functions, but if so we'll need to implement
			//node level instrumenting of the drag drop controls.
			tree.render();
		//	this.change(this.tree_node);
			tree.fireEvent("nodeMove", this.tree_node);
		},


/*
	"static" functions
*/
		get_drop_location : function (id)
		{
			var drop_point =  YAHOO.util.DragDropMgr.interactionInfo.point;
			var target_region = YAHOO.util.Dom.getRegion(id);

			var y_margin = (target_region.bottom - target_region.top) /3;
			if (drop_point.top < target_region.top + y_margin)
			{
				return "before"
			}
			else if (drop_point.top > target_region.bottom - y_margin)
			{
				return "after"
			}
			else {
				return "on"
			}
		}
	}
);

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 26385 $
|| ####################################################################
\*======================================================================*/