/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* vBulletin Facebook Object
*
* @package	vBulletin
* @version	$Revision: 37602 $
* @date		$Date: 2010-06-18 11:37:15 -0700 (Fri, 18 Jun 2010) $
* @author	Michael Henretty, vBulletin Development Team
* @copyright	vBulletin Solutions Inc.
*/
function vB_Facebook(config)
{
	this.config = config;

	// a multi dimensional list of id strings for Facebook elements we will need later
	this.ids = {
		loginform_id : "navbar_loginform",
		loginform_usernameid : "navbar_username",
		loginform_passwordid : "navbar_password",
		
		fb_usernameid : "facebookusername",
		fb_passwordid : "facebookpassword",
		fb_associateid : "facebookassociate",
		
		invisibles : 
			[{id : "fb_headerbox"}, {id : "fbregbox"}],
		
		publishcheckboxid : "fb_dopublish",

		loginbtns : 
			[{id : "fb_loginbtn"}, {id : "fb_regloginbtn"}, {id : "fb_getconnected"}]
	};

	// if auto-reg is enabled, we need to prompt
	// for email permissions on first login
	this.loginperms = this.get_config('autoreg') ? {perms:'email'} : {perms:'email,user_about_me,user_activities,user_birthday,user_interests,user_likes,user_website,user_location,user_work_history'};

	// init the Facebook API
	FB.init({
		appId  : this.get_config('appid'),
		status : true, 
		cookie : true, 
		xfbml  : false
	});

	// prepare the page to publish content to Facebook if applicable
	if (LOGGEDIN && this.get_config('connected'))
	{
		this.prepare_publishtofacebook();
	}

	// add the handle click event to the login buttons
	this.register_loginbtns();
	
	// now that Facebook has been initialized, unhide all elements
	// that interact with the vBulletin Facebook object
	this.make_visible();
}

/**
* checks a configuration option for vB Facebook
* 
* @param	string - the config value to check
* @return	mixed - the config value in question, or false if not found
*/
vB_Facebook.prototype.get_config = function(value)
{
	if (typeof(this.config) == "undefined" || typeof(this.config[value]) == "undefined")
	{
		return false;
	}
	else {
		return this.config[value];
	}
}

/**
* binds events to any facebook related elements
*/
vB_Facebook.prototype.register_loginbtns = function()
{
	for (var i = 0; i < this.ids.loginbtns.length; i++)
	{
		var el = fetch_object(this.ids.loginbtns[i].id);
		if (el)
		{
			YAHOO.util.Event.on(el, 'click', this.handle_fbLogin, this, true);
		}
	}

	// if the register form is up, bind events to the "Already a member?" form
	var fb_username_element = fetch_object(this.ids.fb_usernameid);
	var fb_password_element = fetch_object(this.ids.fb_passwordid);
	var fb_associate_element = fetch_object(this.ids.fb_associateid);
	if (fb_username_element && fb_password_element && fb_associate_element)
	{
		// event for when associate button is submitted
		YAHOO.util.Event.on(fb_associate_element, 'click', this.login_and_associate, this, true);
		
		// event for when associate form is submitted with enter key
		this.fb_username_listener = new YAHOO.util.KeyListener(fb_username_element, {keys:13}, {fn:this.handle_associate_keypress, scope:this, correctScope:true});
		this.fb_username_listener.enable();
		this.fb_password_listener = new YAHOO.util.KeyListener(fb_password_element, {keys:13}, {fn:this.handle_associate_keypress, scope:this, correctScope:true});
		this.fb_password_listener.enable();
	}
}

/**
* checks a configuration option for vB Facebook
* 
* @param	string - the config value to check
* @return	mixed - the config value in question, or false if not found
*/
vB_Facebook.prototype.make_visible = function()
{
	for (var i = 0; i < this.ids.invisibles.length; i++)
	{
		var el = fetch_object(this.ids.invisibles[i].id);
		if (el)
		{
			YAHOO.util.Dom.removeClass(el, "hidden");
		}
	}
}

/**
* reloads the page from the server with the additional fbredirect parameter
*/
vB_Facebook.prototype.do_fbRedirect = function()
{
	// redirect to current page with facebook redirect parameter in query string
	var strippedurl = window.top.location.href.replace(/#.*/, ""); // strip the hash
	var joinchar = (window.top.location.search.substring(1) ? "&" : "?");
	window.top.location = strippedurl + joinchar + "dofbredirect=1" + window.top.location.hash;
}

/**
* invoked when user logins in using facebook connect
*/
vB_Facebook.prototype.handle_fbLogin = function(e)
{
	// stop the link from being processed
	YAHOO.util.Event.stopEvent(e);
	
	// check server for current session, and use it if avaliable
	if (FB.getSession(true))
	{
		this.do_fbRedirect();
	}

	// if no current FB session, invoke the login
	else
	{
		FB.login(function(response) {
			if (response.session) {
				vBfb.do_fbRedirect();
			}
		}, this.loginperms);
	}
}

/**
* invoked from the registration page when a users presses ENTER key on the "Already a member?" form
* 
* @param	string - the type of event
* @param	array - arguments for the event
*/
vB_Facebook.prototype.handle_associate_keypress = function(type, args)
{
	// stop the form from being submitted through enter key
	YAHOO.util.Event.preventDefault(args[1]);
	
	// now we perform the association login
	this.login_and_associate();
}

/**
* invoked from the registration page, used to login a vb user
* 	- and associate with facebook user
*/
vB_Facebook.prototype.login_and_associate = function()
{
	// get the login form, and username and password fields
	var loginformEl = fetch_object(this.ids.loginform_id);
	var loginformUsernameEl = fetch_object(this.ids.loginform_usernameid);
	var loginformPasswordEl = fetch_object(this.ids.loginform_passwordid);
	
	// get the fb association form username and password fields
	var fb_usernameEl = fetch_object(this.ids.fb_usernameid);
	var fb_passwordEl = fetch_object(this.ids.fb_passwordid);
	
	// set the navbar login form fields
	if (loginformUsernameEl && fb_usernameEl)
	{
		loginformUsernameEl.value = fb_usernameEl.value;
	}
	if (loginformPasswordEl && fb_passwordEl)
	{
		loginformPasswordEl.value = fb_passwordEl.value;
	}
	
	// now submit the login form
	if (loginformEl)
	{
		// run the javascript sumbit routine
		// before submitting the form
		loginformEl.onsubmit();
		loginformEl.submit();
	}
}

/**
* invoked from the registration page, used to logout of facebook
*/
vB_Facebook.prototype.register_logout = function()
{
	FB.logout(vBfb.do_fbRedirect);
}

/**
* checks page context and prepares to publish content to Facebook if applicable
*/
vB_Facebook.prototype.prepare_publishtofacebook = function()
{
	// get the checkbox, and walk the DOM to find the containing form, if it exists
	var cbObject = fetch_object(this.ids.publishcheckboxid);
	var searchObj = cbObject;
	while (searchObj && searchObj.tagName.toLowerCase() != 'form')
	{
		searchObj = searchObj.parentNode;
	}
	this.editFormEl = searchObj;
	
	// if we were able to find a Facebook publishing enabled edit form,
	// intercept the onsubmit event, and add facebook stream publish permissions check
	if (this.editFormEl)
	{
		// special handling for vbcms comment form where we intercept click event rather than submit
		// if vb is a radio, we are editing an article and can use normal logic
		if (this.editFormEl.id == 'form_widget_comments' && cbObject.type != 'radio')
		{
			this.onSubmitEvent = this.editFormEl.sbutton['onclick'];
			this.editFormEl.sbutton['onclick'] = null;
			YAHOO.util.Event.on(this.editFormEl.sbutton, 'click', this.check_publishingperms_cmscomment, this, true);
		}
		
		// most forms in vB can be handled by intercepting the onsubmit event
		else
		{
			this.onSubmitEvent = this.editFormEl['onsubmit'];
			this.editFormEl['onsubmit'] = null;
			YAHOO.util.Event.on(this.editFormEl, 'submit', this.check_publishingperms, this, true);
	
			// grab all the inputs from the form, so we can track
			// which submit button was pressed
			var inputs = this.editFormEl.getElementsByTagName('input');
			for (var i = 0; i < inputs.length; i++)
			{
				var submitBtn = inputs[i];
				if (submitBtn.type == 'submit' || submitBtn.type == 'image')
				{
					YAHOO.util.Event.on(submitBtn, 'click', this.track_submitbutton, this, true);
				}
			}
		}
	}	
}

/**
* tracks which submit button was clicked for the edit form
*/
vB_Facebook.prototype.track_submitbutton = function(e)
{
	this.btnClicked = YAHOO.util.Event.getTarget(e);
}

/**
* checks if the publish to Facebook checkbox is checked
*/
vB_Facebook.prototype.is_pubCbChecked = function()
{
	var pubCb = fetch_object(this.ids.publishcheckboxid);
	return (typeof(pubCb) != 'undefined' && pubCb.checked == 1);
}

/**
* verifies that user has FB publishing permissions with this app before submitting
* 	new content to vB and FB
*/
vB_Facebook.prototype.check_publishingperms = function(e)
{
	// prevent the submit from happening automatically,
	// we will manually submit if all validation passes
	YAHOO.util.Event.stopEvent(e);

	// if user wants to publish to FB, verify permission before 
	// invoking our override onsubmit handler
	if (this.is_pubCbChecked() && (this.btnClicked.name == 'sbutton' || this.btnClicked.id == 'save_btn' || this.btnClicked.id == 'apply_btn'))
	{
		FB.login(function(response) {
			vBfb.handle_submit_override();
		}, {perms:'publish_stream'});
	}

	// if we dont need to verify FB permissions, just invoke overriden submit
	else
	{
		this.handle_submit_override();
	}
}

/**
* verifies that user has FB publishing permissions with this app before submitting
* 	new content to vB and FB, special handling for vbcms comment form
*/
vB_Facebook.prototype.check_publishingperms_cmscomment = function(e)
{
	if (this.is_pubCbChecked())
	{
		FB.login(function(response) {
			vBfb.onSubmitEvent();
		}, {perms:'publish_stream'});
	}
	else
	{
		this.onSubmitEvent();
	}
}

/**
* this is the override to the old submit handler
*  invokes the old onsubmit handler and submits the form if it returns true
*/
vB_Facebook.prototype.handle_submit_override = function()
{
	// perform onsubmit form validation, and if successful manually submit form
	// also, if there was no onsubmit funtion defined, just submit the form
	if (typeof(this.onSubmitEvent) == 'undefined' || this.onSubmitEvent.call(this.editFormEl))
	{
		// add the submit button to the post before submission
		var hiddenField = document.createElement("input");
        hiddenField.setAttribute("type", "hidden");
        hiddenField.setAttribute("name", this.btnClicked.name);
        hiddenField.setAttribute("value", this.btnClicked.value);
        this.editFormEl.appendChild(hiddenField);
        
		this.editFormEl.submit();
	}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 37602 $
|| ####################################################################
\*======================================================================*/