/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
vBulletin.events.systemInit.subscribe(function()
{
	if (AJAX_Compatible)
	{
		vB_AJAX_TagEditor_Factory = new vB_AJAX_TagEditor_Factory();
	}
});

// #############################################################################
// vB_AJAX_TagEditor_Factory
// #############################################################################

/**
* Class for inline modification of blog entry tags
*
* @package	vBulletin
* @version	$Revision: 25662 $
* @date		$Date: 2008-02-04 14:33:20 -0800 (Mon, 04 Feb 2008) $
* @author	Freddie Bingham
*/
function vB_AJAX_TagEditor_Factory()
{
	this.controls = new Array();
	this.init();
}

// =============================================================================
// vB_AJAX_TagEditor_Factory methods

vB_AJAX_TagEditor_Factory.prototype.init = function()
{
	if (vBulletin.elements["vB_AJAX_TagEditor"])
	{
		for (var i = 0; i < vBulletin.elements["vB_AJAX_TagEditor"].length; i++)
		{
			var contenttype = vBulletin.elements["vB_AJAX_TagEditor"][i][0];
			var objectid = vBulletin.elements["vB_AJAX_TagEditor"][i][1];
			var prefix = vBulletin.elements["vB_AJAX_TagEditor"][i][2];
			var extraparams = vBulletin.elements["vB_AJAX_TagEditor"][i][3];

			if (typeof(prefix) == "undefined")
			{
				prefix = "";
			}

			if (typeof(extraparams) == "undefined")
			{
				extraparams = {};
			}

			var openlink = YAHOO.util.Dom.get(prefix + "tag_" + objectid);
			if (openlink)
			{
				this.controls[objectid] = new vB_AJAX_TagEditor(contenttype, objectid, prefix, extraparams, this);
			}
		}
		vBulletin.elements["vB_AJAX_TagEditor"] = null;
	}
}

/**
* Redirect upon failed Ajax
* Appears to be unused.
*/
vB_AJAX_TagEditor_Factory.prototype.redirect = function(contenttype, objectid)
{
	window.location = "threadtag.php?do=manage" + SESSIONURL + 
		"contenttype=" + contenttype + "&contentid=" + objectid;
}

// #############################################################################

/**
* Loads a single item
*
* @package	vBulletin
* @version	$Revision: 24798 $
* @date		$Date: 2007-11-22 13:59:49 +0000 (Thu, 22 Nov 2007) $
* @author	Freddie Bingham
*
* @param	mixed	Contenttype identifier (either string representation or internal id)
* @param	string	Objectid of the message to be edited
* @param 	string	A prefix for the containing page element ids
* @param	vB_AJAX_TagEditor_Factory	Controlling factory class
*/
function vB_AJAX_TagEditor(contenttype, objectid, prefix, extraparams, factory)
{
	this.divobj = null;
	this.vbmenu = null;
	this.do_ajax_submit = true;

	//containing page elements, use prefix as part of name.
	this.divname = prefix + 'tagmenu_' + objectid + '_menu';
	this.vbmenuname = prefix + 'tagmenu_' + objectid;
	
	//items required in the html markup.
	this.tag_container = prefix + 'tagcontainer_' + objectid;
	this.tag_list = prefix + 'taglist_' + objectid;

	//popup form elements, centralized template, so don't use prefix
	this.edit_submit = 'tageditsubmit_' + objectid;
	this.edit_cancel = 'tageditcancel_' + objectid;
	this.edit_input = 'tageditinput_' + objectid;
	this.submit_progress = 'tageditprogress_' + objectid;
	
	this.extraparams = extraparams;

	//not sure why this is a seperate function
	this.init(contenttype, objectid, prefix, factory);
}

/**
* Initialize the onclick action
*
* @return	boolean
*/
vB_AJAX_TagEditor.prototype.init = function(contenttype, objectid, prefix, factory)
{
	if (contenttype)
	{
		this.contenttype = contenttype;
	}
	if (objectid)
	{
		this.objectid = objectid;
	}
	if (factory)
	{
		this.factory = factory;
	}

	var loadlink = YAHOO.util.Dom.get(prefix + "tag_" + objectid);
	YAHOO.util.Event.on(loadlink, "click", this.load, this, true);
}

/**
* Prepare to display the tag popup
*
* @return	boolean	false
*/
vB_AJAX_TagEditor.prototype.load = function(e)
{
	if (e)
	{
		YAHOO.util.Event.stopEvent(e);
	}

	 if (vBmenu.activemenu == this.vbmenuname)
	{
		this.vbmenu.hide();
	}
	else
	{
		YAHOO.util.Connect.asyncRequest("POST", "threadtag.php?popup=1&contenttype=" + this.contenttype + "&contentid=" + this.objectid, {
			success: this.display,
			failure: this.handle_ajax_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + 
			"&do=manage&contenttype=" + this.contenttype + "&contentid=" + this.objectid);
	}

	return false;
}

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
vB_AJAX_TagEditor.prototype.handle_ajax_error = function(ajax)
{
	//TODO: Something bad happened, try again
	vBulletin_AJAX_Error_Handler(ajax);
}

/**
* Handles an error in the AJAX submission of form contents.
*/
vB_AJAX_TagEditor.prototype.handle_ajax_submit_error = function(ajax)
{
	vBulletin_AJAX_Error_Handler(ajax);
	this.do_ajax_submit = false;
}

/**
* Display the editor HTML when AJAX says fetch_editor() is ready
*
* @param	object	YUI AJAX
*/
vB_AJAX_TagEditor.prototype.display = function(ajax)
{
	if (ajax.responseXML)
	{
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			if (!this.divobj)
			{
				this.divobj = document.createElement('div');
				this.divobj.id = this.divname;
				this.divobj.style.display = 'none';
				this.divobj.style.width = '300px';
				this.divobj.style.background = '#ffffff';
				this.divobj.style.border = '1px solid #000000';
				this.divobj.style.padding = '10px';
				document.body.appendChild(this.divobj);
				
				this.vbmenu = vbmenu_register(this.vbmenuname, true);
				YAHOO.util.Dom.get(this.vbmenu.controlkey).onmouseover = '';
				YAHOO.util.Dom.get(this.vbmenu.controlkey).onclick = '';
			}

			this.divobj.innerHTML = ajax.responseXML.getElementsByTagName('tagpopup')[0].firstChild.nodeValue;
			YAHOO.util.Event.on(this.edit_submit, 'click', this.submit_tag_edit, this, true);
			YAHOO.util.Event.on(this.edit_cancel, 'click', this.cancel_tag_edit, this, true);
			YAHOO.util.Event.on(this.divobj, "keydown", this.tagmenu_keypress);

	    if (YAHOO.util.Dom.get('tag_add_wrapper_menu') && YAHOO.util.Dom.get(this.edit_input))
			{
				//doesn't currently work -- vbmenu assumes that only one menu should show, so opening
				//this menu will hid the tag popup...
				//vbmenu_register('tag_add_wrapper', true);
				tag_add_comp = new vB_AJAX_TagSuggest('tag_add_comp', this.edit_input, 'tag_add_wrapper');
				tag_add_comp.allow_multiple = true;

				var delimiters = ajax.responseXML.getElementsByTagName('delimiters')[0];
				if (delimiters && delimiters.firstChild)
				{
					tag_add_comp.set_delimiters(delimiters.firstChild.nodeValue);
				}
			}

			this.vbmenu.show(YAHOO.util.Dom.get(this.vbmenuname));
			// see #25376 -- double focus to get around IE bug
			YAHOO.util.Dom.get(this.edit_input).focus();
			YAHOO.util.Dom.get(this.edit_input).focus();
		}
	}
}

/**
*	Catches the keypress of the controls to keep them from submitting to inlineMod
*
* @param	event
*/
vB_AJAX_TagEditor.prototype.tagmenu_keypress = function (e)
{
	switch (e.keyCode)
	{
		case 13:
		{
			vB_AJAX_TagEditor_Factory.controls[this.id.split(/_/)[1]].submit_tag_edit();
			if (e)
			{
				YAHOO.util.Event.stopEvent(e);
			}
			return false;
		}
		default:
		{
			return true;
		}
	}
}

/**
*	Submit tag data
*
* @param	event
*/
vB_AJAX_TagEditor.prototype.submit_tag_edit = function (e)
{
	if (this.do_ajax_submit)
	{
		if (e)
		{
			YAHOO.util.Event.stopEvent(e);
		}

		var hidden_form = new vB_Hidden_Form("threadtag.php");

		hidden_form.add_variables_from_object(YAHOO.util.Dom.get(this.divobj));

		for (key in this.extraparams)
		{
			hidden_form.add_variable(key, this.extraparams[key]);
		}
		
		YAHOO.util.Connect.asyncRequest("POST", "threadtag.php?contenttype=" + this.contenttype + "&contentid=" + this.objectid, {
			success: this.handle_ajax_submit,
			failure: this.handle_ajax_submit_error,
			timeout: vB_Default_Timeout,
			scope: this
		}, hidden_form.build_query_string());

		if (YAHOO.util.Dom.get(this.submit_progress))
		{
			YAHOO.util.Dom.get(this.submit_progress).style.display = '';
		}
	}
}

/**
*	Submit tag data
*
* @param	event
*/
vB_AJAX_TagEditor.prototype.cancel_tag_edit = function (e)
{
	this.vbmenu.hide();
}

/**
* Handles the AJAX response to submitting the tag form.
*/
vB_AJAX_TagEditor.prototype.handle_ajax_submit = function(ajax)
{
	if (ajax.responseXML)
	{
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			var taghtml = ajax.responseXML.getElementsByTagName('taghtml');
			if (taghtml.length && taghtml[0].firstChild && taghtml[0].firstChild.nodeValue !== '')
			{
				// this should only happen if they didn't add any tags, and we want to leave the "none" option
				YAHOO.util.Dom.get(this.tag_list).innerHTML = taghtml[0].firstChild.nodeValue;
				YAHOO.util.Dom.get(this.tag_container).style.display = '';
			}
			else
			{
				YAHOO.util.Dom.get(this.tag_container).style.display = 'none';
			}

			var warning = ajax.responseXML.getElementsByTagName('warning');
			if (warning.length && warning[0].firstChild)
			{
				alert(warning[0].firstChild.nodeValue);
			}

			this.vbmenu.hide();
		}
	}
	else 
	{
		//not sure what to do here, maybe show an error?  At least make the form react
		//and go away.  Nothing worse than a non functioning form you can't dismiss
		this.vbmenu.hide();
	}

	if (YAHOO.util.Dom.get(this.submit_progress))
	{
		YAHOO.util.Dom.get(this.submit_progress).style.display = 'none';
	}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 25811 $
|| ####################################################################
\*======================================================================*/
