/*
*  Color Scheme Designer application library
*
*  Copyright (c) 2009, Petr Stanicek, pixy@pixy.cz ("the author")
*  All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions are met:
*   * Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*   * Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in the
*     documentation and/or other materials provided with the distribution.
*   * Any commercial use of this software is not allowed unless an exemption
*     was granted by the author.
*
*  This software is provided by the author "as is" and any express or implied
*  warranties, including, but not limited to, the implied warranties or
*  merchantability and fitness for a particular purpose are disclaimed.
*  In no event shall the author be liable for any direct, indirect, incidental,
*  special, exemplary, or consequential damages (including, but not limited to,
*  procurement of substitute goods or services; loss of use, data, or profits;
*  or business interruption) however caused and on any theory of liability,
*  whether in contract, strict liability, or tort (including negligence or
*  otherwise) arising in any way out of the use of this software, even if
*  advised of the possibility of such damage.
*/


// Supporting objects

var drag = {
	on : false,
	dot : null
	}

var defs = {
	FPSlimiter : 10, // msec
	MaxRedrawRate : 200, // msec
	dotSize : 6,  // half the size
	wheelMid : { X:190,Y:190 },
	sliderMid : { X:95,Y:95 },
	sliderWidth : 140,
	CBPreview : 0
	}

var API = {
	on : false
	}

var SchemeID;

// INIT

$(function() {

	// browser check

	var v = parseInt($.browser.version,10);
	if ($.browser.msie && v<7) {
		alert(vbphrase['style_generator_browser_not_supported']);
		return;
	}

	$('#jscheck').hide();

	// event handlers

	$('a').click( function(){ $(this).blur()} );
	$('#model a').click(function(){ setScheme(this.id);return false });

	$('#tab-wheel').click( function() { togglePane('wheel');return false } );
	$('#tab-vars').click( function() { togglePane('vars');return false } );

	$('#wheel,#saturation,#contrast')
		.bind('mousedown',function(e) {
			e.preventDefault();
			var elm = $(this);
			var pos = elm.offset();
			drag.on = true;
			drag.dW = elm.width();
			drag.dH = elm.height();
			drag.dX = pos.left + drag.dW/2;
			drag.dY = pos.top + drag.dH/2;
			elm.bind('mousemove',function(e) {
				e.preventDefault();
				dragMove(e,this);
				});
			if (!drag.dot) dragMove(e,this);
			})
		.bind('mouseup',function(e) {
			e.preventDefault();
			$(this).unbind('mousemove');
			drag.on = false;
			drag.dot = null;
			updateColorData();
			});

	$('.dot')
		.bind('mousedown',function(e) {
			drag.dot = this;
			})
		.bind('mouseup',function(e) {
			drag.dot = null;
			});
	$('#dot1').bind('dblclick',enterHue);
	$('#hue-val').bind('click',enterHue);
	$('#dot2').bind('dblclick',enterComplHue);
	$('#dot3').bind('dblclick',enterDist);
	$('#dist-val').bind('click',enterDist);
	$('#rgb-val').bind('click',enterRGB);

	$('#sample-val')
		.bind('dblclick',function(e) {
			var h = prompt(vbphrase['enter_hex']);
			})

	toggleContrast();

	// Change preview style set
	$('#tab-light-ps').click( function(){ pagePreview('light-ps');return false } );
	$('#tab-light-pt').click( function(){ pagePreview('light-pt');return false } );
	$('#tab-grey').click( function(){ pagePreview('grey');return false } );
	$('#tab-dark').click( function(){ pagePreview('dark');return false } );

	// menu

	$(document).ready(function() {
		$('#menu').droppy({speed:100,persist:250});
		});
	$('#menu a').click( function(e){ e.preventDefault();$(this).blur() });
 	$('#menu-undo').click( function(){ History.back();return false } );
 	$('#menu-redo').click( function(){ History.fwd();return false } );

	$('#menu-export-light-ps').click( function(){ exportCols('lps');return false } );
	$('#menu-export-light-pt').click( function(){ exportCols('lpt');return false } );
	$('#menu-export-grey').click( function(){ exportCols('gry');return false } );
	$('#menu-export-dark').click( function(){ exportCols('drk');return false } );

	$('#menu-tooltips').click( function(){ useShowTooltips();return false } );

	$('#preview-palette .cbox').click( function(){
		if ($('#tab-vars').hasClass('sel') && UseManualVars) {
			var rel = $(this).attr('rel');
			var id = rel.split('-'); id = id[0];
			$('#manualvars a.ttl').filter( function(){ return $(this).attr('rel')==id } ).click();
			$('#manualvars a.col').filter( function(){ return $(this).attr('rel')==rel } ).click();
			}
		return false;
		});

	showTooltips();
	History.updateMenu();

	// initialize

	var search = document.location.search.substring(1);
	if (search) {
		search = search.split('&');
		var i,l,s,key,val;
		API.data = {};
		for (i=0,l=search.length;i<l;i++) {
			s = search[i].split('=');
			key = s[0].toString();
			val = s[1].toString();
			API.data[key] = val;
			}
		if (API.data.returnurl) {
			API.on = true;
			if (API.data.format!='hex' && API.data.format!='rgb') API.data.format = 'hex';
			if (API.data.method!='get' && API.data.method!='post') API.data.format = 'get';
			}
		}

	// used to input a previous color palette
	var hash = document.location.hash.substring(1);
	if (hash) loadScheme(hash);
	else {
		usePreset('default');
		updateScheme();
		if (Palette.UseVarsOverlay) toggleContrast();
		}

	populatePaletteText('light-ps');
	});

function loadScheme(id) {
	Palette.unserialize(id);
	updateScheme();
	if (Palette.UseVarsOverlay) toggleContrast();
	}

//Actions

function togglePane(id,ignore) {
	if(ignore==undefined){var ignore=true;}
	if(!$('#tab-'+id).hasClass('sel')) {
		$('.pane').hide();
		$('#pane-'+id).fadeIn(250);
		$('#tabs-color a').removeClass('sel');
		$('#tab-'+id).addClass('sel').blur();
	}
	if (id=='wheel') {
		updateWheel();
		$('#manualvars a.sel').removeClass('sel');
		$('#manualvars a#pal-pri-0').addClass('sel');
	}
	else if ((id=='vars')&&(ignore)) {
		updateVars();
		setOriginalColor();
	}
	}


function toggleContrast(id) {
	if (id=='c1') {
		Palette.resetVarsOverlay();
		}
	else {
		$('#manualvars, #ttl-c2').fadeIn(750);
		UseManualVars = true;
		}
	updateVars();
	}

function setScheme(m) {
	Palette.setScheme(m);
	updateScheme();
	}

function usePreset(id) {
	if (!id) return;
	var p = Palette.usePreset(id);
	updateVars();
	}

function useColorBlind(n) {
	defs.CBPreview = n;
	$('#menu-vision, #colorblind a').removeClass('sel');
	if (n>0) {
		$('#menu-vision').addClass('sel');
		$('#colorblind a').eq(n).addClass('sel');
		$('#cb-warning').show();
		}
	else {
		$('#cb-warning').hide();
		}
	colorize();
	}

function useShowTooltips() {
	var on = !$('#menu-tooltips').hasClass('sel');
	if (on) showTooltips();
	else hideTooltips();
	}

// Redraw

var t0;
function checkFPS_on() {
	t0 = new Date();
	}
function checkFPS_off() {
	var t1 = new Date()-t0;
	if (t1>defs.FPSlimiter) defs.FPSlimiter = t1+50;
	else if (t1<defs.FPSlimiter-50 && defs.FPSlimiter>10) defs.FPSlimiter = t1;
	$('#fps').text( 'fps: ' + Math.round(1/defs.FPSlimiter*1000) );
	}

function updateScheme() {
	var m = Palette.Scheme;
	$('#model a').removeClass('sel');
	$('#'+m).addClass('sel').blur();
	$('#dot3').css('display',Boolean(Palette.Sec1) ? 'block':'none');
	$('#dist-val').css('display',Boolean(Palette.Sec1) ? 'block':'none');
	updateWheel();
	if ($('#tab-vars').hasClass('sel')) updateVars();
	}


function updateWheel() {
	checkFPS_on();
	moveDot(1,Palette.Primary);
	moveDot(3,Palette.Sec1);
	var rgb = Palette.Primary.Col[0].RGB;
	$('#hue-val span').text(Palette.H+'');
	$('#rgb-val span').text(rgb.getHex());
	$('#rgb-r').html(Math.round(rgb.R/255*100) + ' %');
	$('#rgb-g').html(Math.round(rgb.G/255*100) + ' %');
	$('#rgb-b').html(Math.round(rgb.B/255*100) + ' %');
	$('#dist-val span').text(Palette.Dist+'');
	colorize();
	checkFPS_off();
	}


// Vars Pane

function updateVars() {
	if (UseManualVars) updateManualVars();
	else {
		$('#saturation').css( 'background-color',Palette.Primary.Base.RGB.getCSS() );
		updateContrast();
		}
	updateSV();
	}
function updateSV() {
	checkFPS_on();
	var x,y;
	if (UseManualVars) {
		var v = Palette.getVarOverlay(VarSelected[0],VarSelected[1]);
		x = v[0];
		y = v[1];
		x = x - 0.5;
		y = y - 0.5;
		moveSliderDot('#dots,#dotv'+VarSelected[1],x,-y);
		}
	else {
		x = Palette.dS;
		y = Palette.dV;
		x = x<0 ? (x+1)*0.9-0.5 : 0.4+x*0.1;
		y = y<0 ? (y+1)*0.9-0.5 : 0.4+y*0.1;
		moveSliderDot('#dots',x,-y);
		}
	colorize();
	checkFPS_off();
	}
function updateContrast() {
	checkFPS_on();
	var x = Palette.cL, y = Palette.cS;
	moveSliderDot('#dotc',x-0.5,0.5-y);
	colorize();
	checkFPS_off();
	}


var UseManualVars = false;
var VarSelected = [0,0];
var ColorHash = {'pri':0,'sec1':1,'sec2':2,'compl':3};

function updateManualVars() {
	function col(c,id,ttl) {
		var hex,id2,v,s = '<a class="ttl" rel="'+id+'" href="#"></a>';
		s += '<div class="var-set" id="">';
		for (var i=0;i<5;i++) {
			hex = c.getVarRGB(i).getHex();
			id2 = id+'-'+i;
			s += '<li><a class="col" id="pal-'+id2+'" rel="'+id2+'" href="#"><img src="../images/style_generator/e.png" id="cbox-bg-'+id2+'" class="cbox bg-'+id2+'">';
			s += '<span id ="info-' + id + '-' + i + '" class="paletteInfo"></span>';
			s += '</a></li>';
			}
		return s;
		}
	var s = '<ul class="palettedisplay">';
	s += col(Palette.Primary,'pri','');
	s += col(Palette.Sec1,'sec1','');
	s += '</ul>';

	$('#manualvars').html(s);
	$('#manualvars a.ttl').click( function() {
		var i,v,id = $(this).attr('rel');
		for (i=0;i<5;i++) {
			v = Palette.getVarOverlay(ColorHash[id],i);
			moveSliderDot('#dotv'+i,v[0]-0.5,-v[1]+0.5);
			}
		if ($(this).next('.var-set').hasClass('sel')) return false;
		$('#manualvars .var-set.sel').removeClass('sel').slideUp('fast');
		$(this).blur().next('.var-set').addClass('sel').slideDown('fast').find('a.col').eq(0).click();
		return false;
		});
	$('#manualvars a.col')
	.mouseenter( function() {
		var $td = $('#preview-palette').find('.bg-'+$(this).attr('rel')).addClass('hilite');
		})
	.mouseleave( function() {
		var $td = $('#preview-palette').find('.bg-'+$(this).attr('rel')).removeClass('hilite');
		})
	.click( function() {
		$('#manualvars a.sel').removeClass('sel');
		$(this).blur().addClass('sel');
		VarSelected = $(this).attr('rel').split('-');
		VarSelected[0] = ColorHash[VarSelected[0]];
		$('#saturation').css( 'background-color',Palette.getColorByIdx(VarSelected[0]).Base.RGB.getCSS() );
		setOriginalColor();
		updateSV();
		return false;
		});
	$('#manualvars a.ttl').eq(0).click();
	$('#manualvars a.col').click(function(){
		togglePane('vars',false);
		});
		populatePaletteText($('#tabs-preview a.sel').attr('id').replace(/tab-/g,''));
	}



function exportCols(type) {

	if (check_save_valid !== undefined)
	{
		if (! check_save_valid())
		{
			return false;
		}
	}

	function col(c,id,ttl) {
		var s = '"'+id+'":{"ttl":"'+ttl+'","col":[';
		for (var i=0;i<5;i++) {
			v = c.getVarRGB(i);
			code = v.getHex();
			if (i>0) s += ',';
			s += '{"hex":"'+code+'","r":'+v.R+',"g":'+v.G+',"b":'+v.B+'}';
			}
		s += ']}';
		return s;
		}

	var s = '{\
"type":"'+type+'",\
"id":"'+SchemeID+'",\
"scheme":{';
	s += col(Palette.Primary, 'primary', vbphrase['primary_color']);
	if (Palette.Sec1) s += ',' + col(Palette.Sec1, 'secondary-a', vbphrase['secondary_color_a']);
	if (Palette.Compl) s += ',' + col(Palette.Compl, 'complement', vbphrase['complementary_color']);
	s += '}}';

	$('#form').attr('action','template.php?do=stylegenerator&save=true').attr('method','POST').attr('target','_self');
	$('#form-data').val(s);
	$('#form').submit();
	}

// Preview

function pagePreview(nr) {

		// Gets the currently selected preview tab, which I'll strip and use for the preview classes
		var active = $('a.selected').attr('id').replace('menu-export-','');

		// Removes the currently in focus save option
		$('a.previewtab').removeClass('sel');
		$('#tab-'+nr).addClass('sel').blur();

		// Displays the new save option
		$('a.previewing').removeClass('selected');
		$('li.savemenu').removeClass('selected');
		$('#menu-'+nr).addClass('selected').blur();
		$('#menu-export-'+nr).addClass('selected').blur();

		populatePaletteText(nr);

		// Changes the preview to the correct preview
		changePreview(active,nr);
		colorize();
	}

function changePreview(old,current) {

	function removeClasses(j) {
		$.each(j, function(key, value) {
			$(key).removeClass(value);
			$(key).attr('style', '');
		});
	}
	function addClasses(j)
	{
		$.each(j, function(key, value)
		{
			$(key).addClass(value);
			$(key).attr('style', 'background-color:');
		});
	}
	var lightpsClasses = {
			'#previewoverride':'bg-pri-0',
			'#header':'bg-pri-2',
			'#navbar':'bg-pri-2',
			'#navtabs':'bg-sec1-0',
			'.navtab':'bg-sec1-0',
			'#body_wrapper':'bg-pri-3',
			'#forumhead':'bg-pri-1',
			'#subforumdescription':'bg-pri-3',
			'#footer':'bg-pri-2',
			'.mainforum':'col-pri-2',
			'.navlinks':'col-pri-2'
	};
	var lightptClasses = {
			'#previewoverride':'',
			'#header':'bg-pri-1',
			'#navbar':'bg-pri-1',
			'#navtabs':'bg-pri-0',
			'.navtab':'bg-pri-0',
			'#body_wrapper':'',
			'#forumhead':'bg-pri-0',
			'#subforumdescription':'',
			'#footer':'bg-pri-1',
			'.mainforum':'col-pri-0',
			'.navlinks':'col-pri-0'
	};
	var greyClasses = {
			'#previewoverride':'bg-gy-pri0',
			'#header':'bg-gy-pri0',
			'#navbar':'bg-gy-pri0',
			'#navtabs':'bg-pri-0',
			'.navtab':'bg-pri-0',
			'#popupbody':'bg-gy-sec0',
			'#body_wrapper':'bg-gy-sec0',
			'#forumhead':'bg-pri-0',
			'#subforumdescription':'bg-gy-pri0',
			'#footer':'bg-pri-0 bg-gy-sec0-border',
			'.mainforum':'col-pri-3',
			'.navlinks':'col-pri-3'
	};
	var darkClasses = {
			'#previewoverride':'bg-dk-pri0',
			'#header':'bg-dk-pri0',
			'#navbar':'bg-dk-pri0',
			'#navtabs':'bg-pri-0',
			'.navtab':'bg-pri-0',
			'#popupbody':'bg-dk-sec0',
			'#body_wrapper':'bg-dk-pri0',
			'#forumhead':'bg-pri-0',
			'#subforumdescription':'bg-dk-pri0',
			'#footer':'bg-pri-0 bg-dk-sec0-border',
			'.mainforum':'col-pri-3',
			'.navlinks':'col-pri-3'
	};

	switch(old) {
		case 'light-ps':
			removeClasses(lightpsClasses);
			break;
		case 'light-pt':
			removeClasses(lightptClasses);
			break;
		case 'grey':
			removeClasses(greyClasses);
			break;
		case 'dark':
			removeClasses(darkClasses);
			break;
	   default: // It shouldn't ever get here, but if it does blank them all. It won't hurt anything other than performance.
			removeClasses(lightpsClasses);
			removeClasses(lightptClasses);
			removeClasses(greyClasses);
			removeClasses(darkClasses);
	}

	switch(current) {
		case 'light-ps':
			addClasses(lightpsClasses);
			break;
		case 'light-pt':
			addClasses(lightptClasses);
			break;
		case 'grey':
			addClasses(greyClasses);
			break;
		case 'dark':
			addClasses(darkClasses);
			break;
	   default:
		   addClasses(lightpsClasses);
	}
}

// Colorize Queue

var LastRefresh = 0, RefreshTimerID;

function colorize() {
	var t = new Date().valueOf();
	var delta = t - LastRefresh;
	if (delta<defs.MaxRedrawRate) {
		if (!RefreshTimerID) RefreshTimerID = setTimeout(doColorize, defs.MaxRedrawRate-delta);
		}
	else doColorize();
	}

// Colorize

function doColorize() {

	if (RefreshTimerID) clearTimeout(RefreshTimerID);
	RefreshTimerID = null;
	LastRefresh = new Date().valueOf();

	var pri,sec1;
	var priCol,sec1Col;

	$('.bg-pri').css('background-color',Palette.Primary.Base.RGB.getCSS());

	for (var i=0;i<5;i++) {
		priCol = Palette.Primary.Col[i];
		if (Palette.Sec1) sec1Col = Palette.Sec1.Col[i];
		else sec1Col = Palette.Primary.Col[3];

		pri = priCol.RGB; sec1 = sec1Col.RGB;

		if (defs.CBPreview) {
			pri = '#'+ ColorBlind.getHex(pri.R,pri.G,pri.B,defs.CBPreview);
			sec1 = '#'+ ColorBlind.getHex(sec1.R,sec1.G,sec1.B,defs.CBPreview);
			}
		else {
			pri = pri.getCSS();
			sec1 = sec1.getCSS();
			}

		var v = parseInt($.browser.version,10);
		if ($.browser.msie && v == 7)
		{
			$('#cbox-bg-pri-' + i).attr('title', rgb2hex(pri));
			$('#cbox-bg-sec1-' + i).attr('title', rgb2hex(sec1));
		}

		$('.col-pri-'+i).css('color',pri);
		$('.col-sec1-'+i).css('color',sec1);
		$('.bg-pri-'+i).css('background-color',pri).each( function(){
			this.paletteInfo = { col:priCol,out:pri }
			});
		$('.bg-sec1-'+i).css('background-color',sec1).each( function(){
			this.paletteInfo = { col:sec1Col,out:sec1 }
			});
		$('#currentcolor').css('background-color',$('.var-set .sel img').css('background-color'));
		$('.brd-pri-'+i).css('border-color',pri);
		$('.brd-sec1-'+i).css('border-color',sec1);

		}
	SchemeID = Palette.serialize();
	var sID = SchemeID;
	if (sID.length>64) sID = 'ID too long to display';
	$('#schemeid a').html(sID).attr('href',document.location.pathname+'#'+SchemeID);

	if (!drag.on) updateColorData();

	}

function updateColorData()
{
	History.add();

	var v = parseInt($.browser.version,10);
	if ($.browser.msie && v == 7)
	{
		return;
	}
	colorTooltips();
}

// History
var History = {
		List : [],
		Ptr : -1,
		add : function() {
			setOriginalColor();
			if (this.Ptr<0 || this.List[this.Ptr]!=SchemeID) {
				if (this.List.length>this.Ptr+1) this.List = this.List.splice(0,this.Ptr+1);
				this.List.push(SchemeID);
				this.Ptr++;
				this.updateMenu();
				}
			},
		back : function () {
			if (this.Ptr<1) return;
			this.Ptr--;
			loadScheme(this.List[this.Ptr]);
			this.updateMenu();
			},
		fwd : function () {
			if (this.Ptr>=this.List.length-1) return;
			this.Ptr++;
			loadScheme(this.List[this.Ptr]);
			this.updateMenu();
			},
		updateMenu : function () {
			if (this.Ptr>0) $('#menu-undo').removeClass('disabled');
			else $('#menu-undo').addClass('disabled');
			if (this.Ptr<this.List.length-1) $('#menu-redo').removeClass('disabled');
			else $('#menu-redo').addClass('disabled');
			}
		};

// drag & drop

var moveTimer = 0;
function dragMove(e,elm) {
	var t0 = new Date();
	if (t0-moveTimer<defs.FPSlimiter) return false;
	moveTimer = t0;
	if (elm.id=='wheel') moveOnWheel(e);
	else moveOnSlider(e,elm);
	}

function moveOnWheel(e) {
	var x,y,h,r,movedHue = false, movedDist = false;
	if (e) {
		x = e.pageX - drag.dX;
		y = e.pageY - drag.dY;
		h = Math.round(((Math.atan2(-x,y) * 180/Math.PI) + 180) % 360);
		r = Math.sqrt(x*x + y*y);
		}
	else {
		movedHue = true, movedDist = true;
		}
	if (r>60 && r<160) {
		var dot = 'dot1';
		if (drag.dot) dot = drag.dot.id;
		if (dot=='dot1' || dot=='dot2') {
			if (r>125) {
				if (r<135) h = (Math.floor((h-7.5)/15 + 1) * 15) % 360;
				else h = (Math.floor((h-15)/30 + 1) * 30) % 360;
				}
			if (dot=='dot2') h = (h+180)%360;
			movedHue = Palette.setHue(h);
			}
		else {//secondary dot
			if (Palette.Scheme=='m1' && dot=='dot4') h = (h+180)%360;
			movedDist = Palette.setDist(h);
			}
		}
	if (movedHue || movedDist) updateWheel();
	}


function moveOnSlider(e,elm) {
	var x = e.pageX - drag.dX;
	var y = e.pageY - drag.dY;
	x = x / defs.sliderWidth;
	y = y / defs.sliderWidth;
	if (x<-0.5) x = -0.5; if (x>0.5) x = 0.5;
	if (y<-0.5) y = -0.5; if (y>0.5) y = 0.5;
	if (elm.id=='saturation') {
		var s,v;
		if (UseManualVars) {
			// -0.5..0.9 => 0..1
			s = x + 0.5;
			v = -y + 0.5;
			Palette.setVarOverlay(VarSelected[0],VarSelected[1],s,v);
			}
		else {
			// -0.5..0.4 => -1..0; 0.4..0.5 => 0..1
			s = x>0.4 ? (x-0.4)/0.1 : (x+0.5)/0.9-1;
			y = -y;
			v = y>0.4 ? (y-0.4)/0.1 : (y+0.5)/0.9-1;
			Palette.setSV(s,v);
			}
		updateSV();
		}
	else if (elm.id=='contrast') {
	// -0.5..0.5 => 0..1
		var cL = x + 0.5;
		var cS = 0.5 - y;
		Palette.setContrast(cS,cL);
		updateContrast();
		}
	}

function moveDot(n,col) {
	if (!col) return;
	var h = col.Col[0].HSV.H;
	var r = (h-90)/360 * 2*Math.PI;
	x = Math.round( defs.wheelMid.X + 109*Math.cos(r) ) - defs.dotSize;
	y = Math.round( defs.wheelMid.Y + 109*Math.sin(r) ) - defs.dotSize;
	$('#dot'+n).css('left',x+'px').css('top',y+'px');
	}

function moveSliderDot(sel,x,y) {
	x = defs.sliderMid.X + x * defs.sliderWidth - defs.dotSize + 1;
	y = defs.sliderMid.Y + y * defs.sliderWidth - defs.dotSize + 3;
	$(sel).css('left',x+'px').css('top',y+'px');
	}


// prompts

function myPrompt(str,val,callback) {
	var s = '<div id="prompt"><p>'+str+'</p>';
	s += '<p class="input"><input id="prompt-input" name="prompt-input" type="text" value="'+val+'"></p>';
	s += '<p class="submit"><button id="prompt-cancel" class="close-floatbox">' +
		vbphrase['cancel_js'] + '</button> <button id="prompt-ok" class="close-floatbox">' +
		vbphrase['ok_js'] + '</button></p>';
	s += '</div>';
	var fl = new $.floatbox({
		content:s,
		button: '',
		fade:false,
		boxConfig : {
			position : ($.browser.msie) ? "absolute" : "fixed",
			zIndex: 999,
			width: "360px",
			marginLeft: "-180px",
			height: "auto",
			top: "33%",
			left: "50%",
			backgroundColor: "transparent",
			display: "none"
			}
		});
	$('#prompt-ok').click( function(){ callback($('#prompt-input').val()); } )
	$('#prompt-input').keypress( function(e){ if(e.keyCode==13) $('#prompt-ok').click() } ).focus().select();
	}

function getExpr(s) {
	if (!s) return '';
	if (s.match(/[0-9\.\+\-\*/ ]+/)) s = eval(s);
	return s;
	}

function enterHue() {
	myPrompt(vbphrase['enter_hue'] + ' (0&deg;-360&deg;)',Palette.H,enterHue2);
	}
function enterHue2(h) {
	h = parseInt(getExpr(h),10)%360;
	if (h>=0 && h<=360) {
		Palette.setHue(h%360);
		updateWheel();
		}
	}
function enterComplHue() {
	myPrompt(vbphrase['enter_complement_hue'] + ' (0&deg;&ndash;360&deg;)', (Palette.H+180)%360, enterComplHue2 );
	}
function enterComplHue2(h) {
	h = parseInt(getExpr(h),10)%360;
	if (h>=0 && h<=360) {
		Palette.setHue((h+180)%360);
		updateWheel();
		}
	}
function enterDist() {
	var min = Palette.SchemeModel.minD, max = Palette.SchemeModel.maxD;
	myPrompt(vbphrase['enter_distance_angle'] + ' ('+min+'&deg;&ndash;'+max+'&deg;)', Palette.Dist, enterDist2);
	}
function enterDist2(a)
{
	var min = Palette.SchemeModel.minD, max = Palette.SchemeModel.maxD;
	a = Math.abs(parseInt(getExpr(a), 10));
	if (a >= min && a <= max)
	{
		Palette.setDistNum(a);
		updateWheel();
	}
}

function enterRGB()
{
	myPrompt(vbphrase['enter_hex_value'] + ' (000000&ndash;FFFFFF)', Palette.Primary.getVarRGB(0).getHex(), enterRGB2);
}

function enterRGB2(s)
{
	if (s && s.match(/^\s*#?([0-9a-f]{6}|[0-9a-f]{3})\s*$/i))
	{
		if (s.length == 3)
		{
			s = '#' + s;
		}
		if (s.length == 4)
		{
			s = s.substr(1,1) + s.substr(1,1) + s.substr(2,1) + s.substr(2,1) + s.substr(3,1) + s.substr(3,1);
		}
		if (s.length == 6)
		{
			s = '#' + s;
		}
		s = s.substr(1,6);
		var r = hex2dec(s.substring(0,2))
		var g = hex2dec(s.substring(2,4));
		var b = hex2dec(s.substring(4,6));
		var rgb = new RGB(r,g,b);

		var hsv = ColorWheel.getColorByRGB(rgb);
		Palette.setHSV(hsv);
		updateWheel();
		}
	}

function colorTooltips() {
	$('.cbox').tooltip({
		bodyHandler : function() {
			var src = '#' + this.paletteInfo.col.RGB.getHex();
			var out = this.paletteInfo.out;
			var s = src;
			if (defs.CBPreview) s += '<br>(as '+out+')';
			return  s;
			},
		showURL : false,
		delay: 500,
		fade : 0,
		track : true,
		extraClass : 'color',
		top: 15,
		left: 10
		});
	}

function showTooltips() {
	$('#menu-tooltips').addClass('sel').html(vbphrase['hide_tooltips']);
	$('.help').tooltip({
		bodyHandler : function() {
			return $('#help-'+$(this).attr('id')).html();
			},
		showURL : false,
		delay: 500,
		fade : 0,
		track : true,
		left: -50
		});
	}
function hideTooltips() {
	$('#menu-tooltips').removeClass('sel').html(vbphrase['show_tooltips']);
	$('.help').tooltipOff();
	}

function populatePaletteText(paletteText)
{
	switch(paletteText)
	{
		case 'light-ps':
			var pri = palInfoColorPri;
			var sec = palInfoColorSec;
			break;
		case 'light-pt':
			var pri = palInfoWhitePri;
			var sec = palInfoWhiteSec;
			break;
		default:
			var pri = palInfoDarkPri;
			var sec = palInfoDarkSec;
	}
	for (var i=0;i<5;i++)
	{
		// Hide options that have no descriptive text
		$('#pal-pri-' + i).parent().css('display', pri[i] == '' ? 'none' : '');
		$('#pal-sec1-' + i).parent().css('display', sec[i] == '' ? 'none' : '');

		var v = parseInt($.browser.version,10);
		if ($.browser.msie && v == 7)
		{
			var rgbcolor = $('#cbox-bg-pri-' + i).css('background-color');
			var hexcolor = rgb2hex(rgbcolor);
			$('#cbox-bg-pri-' + i).attr('title', hexcolor);
			$('#cbox-bg-sec1-' + i).attr('title', hexcolor);
		}

		// truncate long descriptions, and add title tooltip with full text
		$('#info-pri-'+i).html(truncate_to_word(pri[i], 30));
		$('#info-pri-'+i).attr('title', PHP.unhtmlspecialchars(pri[i], true));
		$('#info-sec1-'+i).html(truncate_to_word(sec[i], 30));
		$('#info-sec1-'+i).attr('title', PHP.unhtmlspecialchars(sec[i], true));
	}
}

function rgb2hex(rgb)
{
	rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
	if (!rgb)
	{
		return '';
	}

	return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
}

function hex(x)
{
	hexDigits = new Array("0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F");
	return isNaN(x) ? "00" : hexDigits[(x - x % 16) / 16] + hexDigits[x % 16];
}

function setOriginalColor() {
	$('#originalcolor').css( 'background-color',$('#manualvars a.sel img').css('background-color'));
}

function check_save_valid()
{
	//we have a couple of variables passed in from php
	//err_please_complete_all
	//err_invalid_name
	//err_order_too_large
	//err_order_zero.
	title = document.getElementById('form-name');

	if (title === null)
	{
		alert(vbphrase['err_order_need_name']);
		return false;
	}
	if (title.value == '')
	{
		alert(vbphrase['err_order_need_name']);
		return false;
	}

	if (title.value.length == 0 ||title.value.length > 128 || title.value.indexOf("'") !==  -1 || title.value.indexOf('"') !==  -1 )
	{
		alert(vbphrase['err_invalid_name']);
		return false;
	}

	order = document.getElementById('form-displayorder');

	if (order === null)
	{
		alert(vbphrase['err_order_need_order']);
		return false;
	}

	if (isNaN(parseInt(order.value)))
	{
		alert(vbphrase['err_order_need_order']);
		return false;
	}

	if (parseInt(order.value) <= 0)
	{
		alert(vbphrase['err_order_negative']);
		return false;
	}

	if (parseInt(order.value) >= 1000)
	{
		alert(vbphrase['err_order_too_large']);
		return false;
	}

	return true;
}
