/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

vBulletin.events.systemInit.subscribe(function()
{
	var i, elementid = null, element = null;
	
	// activate filter objects
	if (vBulletin.elements["vB_List_Filter"])
	{
		for (i = 0; i < vBulletin.elements["vB_List_Filter"].length; i++)
		{
			element = vBulletin.elements["vB_List_Filter"][i];
			new vB_List_Filter(element[0], element[1], element[2], element[3], element[4]);
		}
		vBulletin.elements["vB_List_Filter"] = null;
	}
});


// #############################################################################
/**
* Allows a text input box to be used to filter the results of lists contains {inputvalue}
* Modified from vB_UserList_Filter (vbulletin_ajax_userlist.js)
*
* @package	vBulletin
* @version	$Revision: 34392 $
* @date		$Date: 2009-12-14 07:55:49 -0800 (Mon, 14 Dec 2009) $
* @author	Andy Huang
*
* @param	mixed	Filter box element
* @param	array	Array of container IDs
* @param	array	Array of haystack in { "name", id } format
*				   IE: { "username", userid }, { "stylevar", "stylevar" }
* @param	string	Descriptive template mid padding element descriptor / identifier
*					IE: "_user", "_stylevar"
*/
function vB_List_Filter(filterbox, containers, haystack, descriptor, eventfn)
{
	this.filterbox = YAHOO.util.Dom.get(filterbox);
	this.containers = containers;
	this.haystack = haystack;	
	this.descriptor = descriptor;
	this.containershtml = new Array(i);
	this.containerlisteners = new Array(i);
	this.eventfn = eventfn;
	
	for (i = 0; i < this.containers.length; i++)
	{
		this.containershtml[i] = YAHOO.util.Dom.get(this.containers[i]).parentNode.innerHTML;
	}
	
	// activate textbox events
	YAHOO.util.Event.on(this.filterbox, "keyup", this.perform_filter, this, true);
	YAHOO.util.Event.on(this.filterbox, "focus", this.handle_focus, this, true);
	YAHOO.util.Event.on(this.filterbox, "blur", this.handle_blur, this, true);

	// show the textbox
	this.labeltext = new String(this.filterbox.value);
	YAHOO.util.Dom.setStyle(this.filterbox, "display", "inline");
}

/**
* Performs the filter, showing or hiding list elements as necessary
*/
vB_List_Filter.prototype.perform_filter = function(e)
{
	var inputvalue, filtertext, needle, item, display, i;
	
	inputvalue = this.filterbox.value;
	
	if (inputvalue == this.labeltext)
	{
		return;
	}
	
	// Restore container innerhtml
	for (i = 0; i < this.containers.length; i++)
	{
		this.containerlisteners[i] = YAHOO.util.Event.getListeners(this.containers[i]);
		YAHOO.util.Dom.get(this.containers[i]).parentNode.innerHTML = this.containershtml[i];
		// Restore select events
		for (j = 0; j < this.containerlisteners[i].length; j++)
		{
			var listener = this.containerlisteners[i][j];
			YAHOO.util.Event.addListener(this.containers[i], listener.type, listener.fn, listener.obj, listener.adjust);
		}
	}
	if (this.eventfn != null)
	{
		this.eventfn();
	}
	
	filtertext = PHP.trim(inputvalue.toLowerCase());
	
	console.log("vB_List_Filter :: Filtering results to entries containing '%s'.", filtertext);
	
	for (needle in this.haystack)
	{
		if (this.filterbox.value == inputvalue)
		{	
			display = (needle.toLowerCase().indexOf(filtertext) != -1 ? "block" : "none");
			
			for (i = 0; i < this.containers.length; i++)
			{
				var currentcontainer = YAHOO.util.Dom.get(this.containers[i]);
				
				item = YAHOO.util.Dom.get(this.containers[i] + this.descriptor + this.haystack[needle]);
				if (item != null)
				{
					if (display == "none")
					{
						item.parentNode.removeChild(item);
					}
					//item.style.display = display;
				}
			}
		}
		else
		{
			console.warn("vB_List_Filter :: Filter race condition; search string '%s' does not match input value '%s'. Aborting.", inputvalue, this.filterbox.value);
			return;
		}
	}
}

/**
* Handles focus events - prepares the text input box for entry
*/
vB_List_Filter.prototype.handle_focus = function(e)
{
	YAHOO.util.Dom.removeClass(this.filterbox, "filterbox_inactive");
	
	if (this.filterbox.value == this.labeltext)
	{
		this.filterbox.value = "";
	}
}

/**
* Handles blur events - resets the text input box if necessary
*/
vB_List_Filter.prototype.handle_blur = function(e)
{
	if (PHP.trim(this.filterbox.value) == "")
	{
		YAHOO.util.Dom.addClass(this.filterbox, "filterbox_inactive");
		this.filterbox.value = this.labeltext;
	}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 34392 $
|| ####################################################################
\*======================================================================*/