/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/


// #############################################################################
// vB_Attachment
// #############################################################################

/**
* Class to deal with attachments
*
* @param	string	ID of the HTML element to contain the list of attachments
* @param	string	ID of the editor object
* @param	object	Required settings
*
*/
function vB_Attachment(listobjid, content)
{
	var elements = YAHOO.util.Dom.getElementsByClassName("uploadlaunchlink");
	if (elements.length)
	{
		for (var i = 0; i < elements.length; i++)
		{
			YAHOO.util.Event.on(elements[i], "click", this.attachmanage, this, true);
		}
	}
	var buttons = YAHOO.util.Dom.getElementsByClassName("uploadlaunchbutton");
	if (buttons.length)
	{
		for (var i = 0; i < buttons.length; i++)
		{
			YAHOO.util.Event.on(buttons[i], "click", this.attachmanage, this, true);
			YAHOO.util.Dom.setStyle(buttons[i], "display", "");
		}
	}
	var links = YAHOO.util.Dom.getElementsByClassName("uploadlaunchfallback");
	if (links.length)
	{
		for (var i = 0; i < links.length; i++)
		{
			YAHOO.util.Dom.setStyle(links[i], "display", "none");
		}
	}

	this.assetobj = null;
	this.content = content;

	this.attachments = new Array();
	this.menu_contents = new Array();
	this.windows = new Array();
	this.editor = null;

	this.listobjid = listobjid;

	if (this.content.editorid == '')
	{
		for (editorid in vB_Editor)
		{
			if (YAHOO.lang.hasOwnProperty(vB_Editor, editorid))
			{
				this.editor = vB_Editor[editorid];
				break;
			}
		}
	}
	else
	{
	this.editor = (this.content.editorid ? vB_Editor[this.content.editorid] : null);
	}
};

// =============================================================================
// vB_Attachment methods

vB_Attachment.prototype.attachmanage = function(e)
{
	if (typeof(e) != "undefined")
	{
		YAHOO.util.Event.stopEvent(e);
	}
	if (AJAX_Compatible && this.content.enhanced == 1)
	{
		this.open_window("newattachment.php?" +  SESSIONURL + "do=assetmanager&" + PHP.unhtmlspecialchars(this.content.values) + "&contenttypeid=" + this.content.contenttypeid + "&poststarttime=" + this.content.poststarttime + "&posthash=" + this.content.posthash + "&insertinline=" + this.content.insertinline, 725, 520, this.content.contenttypeid + "_" + this.content.posthash);
	}
	else
	{	// the pre 4.0 upload system
		this.open_window("newattachment.php?" +  SESSIONURL + PHP.unhtmlspecialchars(this.content.values) + "&contenttypeid=" + this.content.contenttypeid + "&poststarttime=" + this.content.poststarttime + "&posthash=" + this.content.posthash, 480, 480, this.content.posthash);
	}
}

/**
* Does the editor popup exist in a built state?
*
* @package	vBulletin
* @version	$Revision: 37230 $
* @date		$Date: 2010-05-28 11:50:59 -0700 (Fri, 28 May 2010) $
* @author	Freddie Bingham, vBulletin Development Team
*
* @return	boolean
*/
vB_Attachment.prototype.popup_exists = function()
{
	if (
		this.editor
			&&
		((typeof this.editor.popups['attach'] != 'undefined' && this.editor.popups['attach'] != null)
			||
		(!this.editor.popupmode && typeof this.editor.buttons['attach'] != 'undefined' && this.editor.buttons['attach'] != null))
	)
	{
		return true;
	}
	else
	{
		return false;
	}
};

/**
* Add a new attachment
*
* @param	integer	Attachment ID
* @param	string	HTML that comprises the list item
* @param	string	File name
* @param	string	File size
* @param	string	Path to item's image (images/attach/jpg.gif etc.)
*/
vB_Attachment.prototype.add = function(id, html, filename, filesize, imgpath)
{
	this.attachments[id] = new Array();
	this.attachments[id] = {
		'html'     : html,
		'filename' : filename,
		'filesize' : filesize,
		'imgpath'  : imgpath
	};

	this.update_list();
};

/**
* Remove an attachment
*
* @param	integer	Attachment ID
*/
vB_Attachment.prototype.remove = function(id)
{
	if (typeof this.attachments[id] != 'undefined')
	{
		this.attachments[id] = null;

		this.update_list();
	}
};

/**
* Do we have any attachments?
*
* @return	boolean
*/
vB_Attachment.prototype.has_attachments = function()
{
	for (var id in this.attachments)
	{
		if (YAHOO.lang.hasOwnProperty(this.attachments, id) && this.attachments[id] != null)
		{
			return true;
		}
	}
	return false;
};

/**
* Reset the attachments array
*/
vB_Attachment.prototype.reset = function()
{
	this.attachments = new Array();

	this.update_list();
};

/**
* Build Attachments List
*
* @param	string	ID of the HTML element to contain the list of attachments
*/
vB_Attachment.prototype.build_list = function(listobjid, start)
{
	var listobj = YAHOO.util.Dom.get(listobjid);

	if (listobj)
	{
		var li = listobj.getElementsByTagName("li");

		if (li[start] != null)
		{
			while (li[start].nextSibling)
			{
				listobj.removeChild(li[start].nextSibling);
			}
		}

		var count = 0;
		for (var id in this.attachments)
		{
			if (!YAHOO.lang.hasOwnProperty(this.attachments, id))
			{
				continue;
			}

			var node = string_to_node(this.attachments[id]["html"]);
			node.attachmentid = id;
			listobj.appendChild(node);
			count++;
		}

		// At present, only albums make use of this
		if (count)
		{
			YAHOO.util.Dom.removeClass("uploaddisplay", "hidden");
			YAHOO.util.Dom.removeClass(listobj, "hidden");
		}
		else
		{
			YAHOO.util.Dom.addClass("uploaddisplay", "hidden");
			YAHOO.util.Dom.addClass(listobj, "hidden");
		}
	}
};

/**
* Update the places we show a list of attachments
*/
vB_Attachment.prototype.update_list = function()
{
	this.build_list(this.listobjid, 1);
	this.build_list(this.listobjid + "_list2", 0);

	if (this.popup_exists())
	{
		this.editor.build_attachments_popup(
			this.editor.popupmode ? this.editor.popups['attach'] : this.editor.buttons['attach'],
			this.editor.buttons['attach']
		);
	}
};

/**
* Opens the attachment manager window
*
* @param	string	URL
* @param	integer	Width
* @param	integer	Height
* @param	string	Hash
*
* @return	window
*/
vB_Attachment.prototype.open_window = function(url, width, height, hash)
{
	if (typeof(this.windows[hash]) != 'undefined' && this.windows[hash].closed == false)
	{
		this.windows[hash].focus();
	}
	else
	{
		this.windows[hash] = openWindow(url, width, height, 'Attach' + hash);
	}

	return this.windows[hash];
};

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 37230 $
|| ####################################################################
\*======================================================================*/