<?php
/*======================================================================*\
|| #################################################################### ||
|| # Icecast2 Statistic || Copyright 2010 Hitsi.                        || 
|| #################################################################### ||
\*======================================================================*/

class vB_BlockType_icecast extends vB_BlockType
{
	protected $productid = 'icecast_stat';

	protected $title = 'Icecast2';

	protected $description = 'Icecast2 status';

	protected $settings = array(
		'ice_stat_ip' => array(
			'defaultvalue' => '127.0.0.1',
			'displayorder' => 1,
			'datatype'     => 'string'
		),
		'ice_stat_port' => array(
			'defaultvalue' => 8000,
			'displayorder' => 2,
			'datatype'     => 'integer'
		),
		'ice_stat_login' => array(
			'defaultvalue' => 'admin',
			'displayorder' => 3,
			'datatype'     => 'string'
		),
		'ice_stat_password' => array(
			'defaultvalue' => '',
			'displayorder' => 4,
			'datatype'     => 'string'
		),
		'ice_stat_radio' => array(
			'defaultvalue' => '',
			'optioncode'   => 'textarea',
			'displayorder' => 5,
			'datatype'     => 'free'
		)
	);
	public function getHTML()
	{
		$ice_stat = $this->getData();	
		if(!empty($ice_stat))
               {
                        $templater = vB_Template::create('icecast_stat_block');
			$templater->register('blockinfo', $this->blockinfo);
                        $templater->register('content', $ice_stat);
                        return $templater->render(); 
               }
	}
	
	public function getData()
	{
		$ice_ip = $this->config['ice_stat_ip']; //IP адрес сервера              
		$ice_port = $this->config['ice_stat_port']; //Порт сервера            
		$ice2_U_name = $this->config['ice_stat_login'];  //Логин админа
		$ice2_U_pass = $this->config['ice_stat_password']; //пароль админа
		$url='http://'.$ice2_U_name.':'.$ice2_U_pass.'@'.$ice_ip.':'.$ice_port.'/admin/stats.xml'; 
		
		if($stats=@simplexml_load_file($url)) {
			foreach ($stats->source as $source) {
				$mount=str_replace("/","",$source['mount']);
				$icecast[$mount]['listener_peak']=$source->listener_peak; //максимум слушателей было
				$icecast[$mount]['listeners']=$source->listeners; //сейчас слушают
				$icecast[$mount]['listenurl']="http://".$ice_ip.":".$ice_port."/".$mount.".m3u"; //ссылка для плеера
				$icecast[$mount]['max_listeners']=$source->max_listeners; //максимульно возмжное кол-во слушателей
				$icecast[$mount]['on_demand']=$source->on_demand; //запрашивать поток (1 - всегда, 0 - по запросу)
				$icecast[$mount]['public']=$source->public; 
				$icecast[$mount]['name']=$mount; 
	
				//Если радио слушают, то будет доступна еще следующая информация
				$temp=explode(";",$source->audio_info);
				$samplerate=explode("=", $temp[0]);
				$bitrate=explode("=", $temp[1]);
				$channels=explode("=", $temp[2]);
				$icecast[$mount]['bitrate']=$bitrate[1]; //битрейт передаваемого потока
				$icecast[$mount]['channels']=$channels[1]; //каналы (2- стерео, 1-моно)
				$icecast[$mount]['samplerate']=$samplerate[1]; //частота
				$icecast[$mount]['server_description']=$source->server_description; //информация о сервере радиостанции (откуда 	забираем поток)
				$icecast[$mount]['server_name']=$source->server_name; //имя сервера радиостанции
				$icecast[$mount]['server_type']=$source->server_type; //тип сервера
				$icecast[$mount]['server_url']=$source->server_url; //адресс веб страницы сервера откуда забираем поток
				$icecast[$mount]['source_ip']=$source->source_ip; //адресс сервера откуда забираем поток
				$icecast[$mount]['stream_start']=$source->stream_start; //когда началось прослушивание
				$icecast[$mount]['title']=$source->title; //заголовок (исполнитель, название песни...)
				$icecast[$mount]['total_bytes_read']=$source->total_bytes_read; //получено байт с сервера радиостанции
				$icecast[$mount]['total_bytes_sent']=$source->total_bytes_sent; //передано байт слушателям
			}
			//Переименовываем радиостанции, как в конфиге
			if (!empty($this->config['ice_stat_radio'])) {
				$radio=explode("\n",$this->config['ice_stat_radio']);
				if (is_array($radio)) {
					for ($i=0;$i<count($radio);$i++) {
						$radio_name=explode("|",$radio[$i]);
						if (is_array($radio_name) and isset($icecast[$radio_name[0]]))
							$icecast[$radio_name[0]]['name']=$radio_name[1];
					}
				} else {
					$radio_name=explode("|",$radio);
					if (is_array($radio_name) and isset($icecast[$radio_name]))
						$icecast[$radio_name]['name']=$radio_name[1];
				}
			}
		} else $icecast="noconnect";
	return $icecast;
	}


}
