/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

function vB_ImageUpload(uploadform)
{
	this.ready = false;
	this.uploadform = YAHOO.util.Dom.get(uploadform);

	this.events = {
		complete   : new YAHOO.util.CustomEvent("complete",   this),
		uploaddone : new YAHOO.util.CustomEvent("uploaddone", this)
	};

	var yuipostvars = {
		'do'          : "manageattach",
		upload        : 1,
		ajax          : 1,
		flash         : 1,
		poststarttime : vBulletin.attachinfo.poststarttime,
		posthash      : vBulletin.attachinfo.posthash,
		contenttypeid : vBulletin.attachinfo.contenttypeid,
		userid        : vBulletin.attachinfo.userid,
		securitytoken : SECURITYTOKEN
	};

	for (var i in vBulletin.attachinfo.values)
	{
		yuipostvars["values[" + i + "]"] = vBulletin.attachinfo.values[i];
	}

	this.yuiupload = new vB_YUI_Upload(vBulletin.attachinfo.auth_type, vBulletin.attachinfo.asset_enable, BBURL + "/newattachment.php", yuipostvars, "attachment[]", uploadform);
	// If the flash uploader fails to embed then yui_selectfiles should be empty, this check on length may not be atomic.
//this.yuiupload.uploader = 0;
	if (vBulletin.attachinfo.asset_enable == 1 && this.yuiupload.uploader && PHP.trim(YAHOO.util.Dom.get("yui_selectfiles").innerHTML) != "")
	{
		YAHOO.util.Dom.removeClass("upload_controls_container", "hidden");
		this.ready = true;
		this.yuiupload.events.ready.subscribe(this.yuiuploadevent_ready, this);
		this.extensions = {
			"jpg"  : 3024000,
			"jpeg" : 3024000,
			"gif"  : 3024000,
			"png"  : 3024000
		};
		//this.yuiupload.events.updatetotal.subscribe(this.yuiuploadevent_updatetotal, this);
		//this.yuiupload.events.upload.subscribe(this.yuiuploadevent_upload, this);
		this.yuiupload.events.handleresponse.subscribe(this.yuiuploadevent_handleresponse, this);
		this.yuiupload.events.uploaddone.subscribe(this.yuiuploadevent_uploaddone, this);
		//this.yuiupload.events.handleresponse_noerrors.subscribe(this.yuiuploadevent_handleresponse_noerrors, this);
		YAHOO.util.Event.on("yui_basicupload", "click", this.show_basic_upload, this, true);
	}
	else
	{
		YAHOO.util.Event.on("uploadbutton", "click", this.submitupload, this, true);
		YAHOO.util.Dom.removeClass("fileupload", "hidden");
	}
}

vB_ImageUpload.prototype.show_basic_upload = function(e)
{
	this.yuiupload.uploader = false;
	YAHOO.util.Dom.addClass("upload_controls_container", "hidden");
	YAHOO.util.Dom.removeClass("fileupload", "hidden");
	YAHOO.util.Event.on("uploadbutton", "click", this.submitupload, this, true);
}

vB_ImageUpload.prototype.submitupload = function(e)
{
	YAHOO.util.Event.stopEvent(e);
	var el = YAHOO.util.Dom.get("fileupload1");
	if (el.value != "")
	{
		// Showprogress here...
		var callback =
		{
			upload  : this.uploadasset,
			failure : function(ajax)
			{
				alert(vbphrase["upload_failed"]);
				// this.process_ajax_error(ajax);
			},
			scope   : this
		}

		this.uploadform.upload.value = 1;
		this.uploadform.flash.value = 0;
		this.uploadform.contenttypeid.value = vBulletin.attachinfo.contenttypeid;
		this.uploadform.posthash.value = vBulletin.attachinfo.posthash;
		this.uploadform.poststarttime.value = vBulletin.attachinfo.poststarttime;

		for (var i in vBulletin.attachinfo.values)
		{
			var input = document.createElement("input");
			input.name = "values[" + i + "]";
			input.value = vBulletin.attachinfo.values[i];
			input.type = "hidden";
			this.uploadform.appendChild(input);
		}

		YAHOO.util.Connect.setForm(this.uploadform, true, true)
		YAHOO.util.Connect.asyncRequest("POST", "newattachment.php", callback, "ajax=1");
	}
}

vB_ImageUpload.prototype.uploadasset = function(ajax)
{
	YAHOO.util.Dom.get("fileupload1").value = "";
	if (ajax.responseXML)
	{
		// We need one central error function for Ajax -- send all ajax responses through it first!
		var text = '';
		var error = ajax.responseXML.getElementsByTagName("error");
		if (error.length)
		{
			for (var i = 0; i < error.length; i++)
			{
				text += error[i].firstChild.nodeValue;
				if (i < error.length)
				{
					text += "\r\n";
				}
			}
			alert(text);
			return;
		}
		var uploaderror = ajax.responseXML.getElementsByTagName("uploaderror");
		if (uploaderror.length)
		{
			for (var i = 0; i < uploaderror.length; i++)
			{
				text += uploaderror[i].firstChild.nodeValue;
				if (i < uploaderror.length)
				{
					text += "\r\n";
				}
			}
			alert(text);
			return;
		}

		var attachmentids = ajax.responseXML.getElementsByTagName("attachmentid");
		var thumbnails = ajax.responseXML.getElementsByTagName("hasthumbnail");
		var newfile = ajax.responseXML.getElementsByTagName("new");
		if (attachmentids.length)
		{
			for (var i = 0; i < attachmentids.length; i++)
			{
				if (newfile[i].firstChild.nodeValue == 1)
				{
					this.events.uploaddone.fire(attachmentids[i].firstChild.nodeValue, vBulletin.attachinfo.contenttypeid, thumbnails[i].firstChild.nodeValue);
				}
			}
		}
	}

	this.events.complete.fire();
}

vB_ImageUpload.prototype.yuiuploadevent_ready = function(type, args, me)
{
	me.yuiupload.setvars(me.extensions, vbphrase, vBulletin.attachinfo.attachlimit, vBulletin.attachinfo.max_file_size);
	YAHOO.util.Event.onAvailable("yui_selectfiles", function() { me.yuiupload.moveflashobj() });
}

vB_ImageUpload.prototype.yuiuploadevent_uploaddone = function(type, args, me)
{
	var attachmentid = args[0];
	var hasthumbnail = args[1];
	me.events.uploaddone.fire(attachmentid, vBulletin.attachinfo.contenttypeid, hasthumbnail);
}

vB_ImageUpload.prototype.yuiuploadevent_handleresponse = function(type, args, me)
{
	me.events.complete.fire();
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 31986 $
|| ####################################################################
\*======================================================================*/