/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

function vB_Asset(varname, tree, posthash, poststarttime, contenttypeid, userid, auth_type, asset_enable, insertinline)
{
	this.showprogress();
	this.setvars = false;
	this.phrases = Array();
	this.posthash = posthash;
	this.poststarttime = poststarttime;
	this.contenttypeid = contenttypeid;
	this.userid = userid;
	this.varname = varname;
	this.treeel = tree;
	this.currenttextnode = null;
	this.currentasset = null;
	this.currentclose = null;
	this.currentfiledataid = null;
	this.currentassettimer = null;
	this.currentcategoryid = null;
	this.textnodemap = {};
	this.loadingNode = {};
	this.popupimg = null;
	this.totalassets = 0;
	this.startasset = 0;
	this.endasset = 0;
	this.pagenumber = 1;
	this.totalpages = 0;

	this.extensions = Array();
	this.textdirection = document.body.dir  == "rtl" ? "right" : "left";

	if (insertinline == 0)
	{
		YAHOO.util.Dom.setStyle("insert_inline", "display", "none");
	}

	YAHOO.util.Event.on("insert_attachment", "click", this.close, this, true);
	YAHOO.util.Event.on("insert_inline", "click", this.close, this, true);
	//YAHOO.util.Event.on("filemenu_filetypes", "click", this.showkey, this);
	YAHOO.util.Event.on("filemenu_help", "click", this.showkey, this);

	this.layout = new YAHOO.widget.Layout({
		units: [
			{
				position: "top",
				header  : "&nbsp;",
				body    : "asset_header_body",
				height  : 57,
				scroll  : null,
				gutter  : "2 2 0 2",
				zIndex  : 2
			},
			{
				position: this.textdirection,
				width   : 150,
				minWidth: 150,
				height  : 100,
				scroll  : true,
				header  : "&nbsp;",
				gutter  : "2 5 0 2",
				body    : "asset_category_tree_container",
				resize  : true
				//collapse: true
			},
			{
				header  : "&nbsp;",
				position: "center",
				scroll  : true,
				body    : "asset_attachment_list",
				footer  : "asset_attachment_list_footer",
				gutter  : "2 2 0 0"
			},
			{
				header  : "&nbsp;",
				position: "bottom",
				scroll  : true,
				body    : "asset_upload_container",
				height  : YAHOO.util.Dom.get("asset_quota") ? 170 : 157,
				footer  : "asset_addfiles",
				gutter  : "5 2 2 2",
				resize  : true
			}
		]
	});

	YAHOO.util.Dom.removeClass(document.body, "invisible");
	this.layout.render();

	// This code is for setting the header from markup in the code, which yui panel only supports for the footer by default! Why!?
	this.layout.getUnitByPosition(this.textdirection).header.replaceChild(YAHOO.util.Dom.get("asset_category_header"), this.layout.getUnitByPosition(this.textdirection).header.firstChild);
	this.layout.getUnitByPosition("top").header.replaceChild(YAHOO.util.Dom.get("asset_header"), this.layout.getUnitByPosition("top").header.firstChild);
	this.layout.getUnitByPosition("center").header.replaceChild(YAHOO.util.Dom.get("asset_attachment_list_header"), this.layout.getUnitByPosition("center").header.firstChild);
	this.layout.getUnitByPosition("bottom").header.replaceChild(YAHOO.util.Dom.get("asset_upload_header"), this.layout.getUnitByPosition("bottom").header.firstChild);
	this.layout.getUnitByPosition(this.textdirection).subscribe("widthChange", this.layoutchange, this, true);
	this.layout.getUnitByPosition("bottom").subscribe("heightChange", this.layoutchange, this, true);

	this.layout.render();

	var yuiurlupload = window.location.href.split('?');

	// When changing category in asset manager, set this.yuiupload.postvars.categoryid = categoryid

	var yuipostvars = {
		'do'          : "manageattach",
		upload        : 1,
		ajax          : 1,
		flash         : 1,
		poststarttime : this.poststarttime,
		posthash      : this.posthash,
		contenttypeid : this.contenttypeid,
		userid        : this.userid,
		securitytoken : SECURITYTOKEN
	};

	this.yuiupload = new vB_YUI_Upload(auth_type, asset_enable, yuiurlupload[0], yuipostvars, "attachment[]", "uploadform");
	if (this.yuiupload.uploader)
	{
		this.yuiupload.events.updatetotal.subscribe(this.yuiuploadevent_updatetotal, this);
		this.yuiupload.events.upload.subscribe(this.yuiuploadevent_upload, this);
		this.yuiupload.events.handleresponse.subscribe(this.yuiuploadevent_handleresponse, this);
		this.yuiupload.events.handleresponse_noerrors.subscribe(this.yuiuploadevent_handleresponse_noerrors, this);
	}

	this.hideuploader();

	// Move the url inputs div into layout-doc to get around the z-index issue in IE6
	YAHOO.util.Dom.get("layout-doc").appendChild(YAHOO.util.Dom.get("upload_controls_container"));

	this.container = YAHOO.util.Dom.get("asset_container");
	this.uploadlist = YAHOO.util.Dom.get("asset_upload_list");

	// Assign filedataid and attachmentid
	var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", this.uploadlist);
	if (attachments.length)
	{
		for (var i = 0; i < attachments.length; i++)
		{
			this.init_attachment(attachments[i]);
		}
	}

	// Init tree view object
	this.tree = new vB_Treeview(this.treeel, "", this, this.layout.getUnitByPosition(this.textdirection).body.parentNode.id);
	// turn on dynamic loading for tree
	this.tree.setDynamicLoad(this.load_node_data, 0);

	// Get root categories, set label to the parentid that we wish to load, root categories have a parentid of 0
	this.tree.getRoot().categoryid = 0;

	this.rootel = YAHOO.util.Dom.get("asset_category_tree_root");
	ddobj = new vB_Asset_Node_DD(this.tree.getRoot(), this.rootel, "vB_Asset", "");
	YAHOO.util.Event.on(this.rootel, "click", this.clicknode, true, this);
	this.tree.selectednode = this.tree.getRoot();
	YAHOO.util.Dom.addClass(this.rootel, "ygtvfocus");
	YAHOO.util.Dom.get("currentfolder").innerHTML = YAHOO.util.Dom.get("asset_category_tree_root").innerHTML;
	this.tree.selectednode.label = YAHOO.util.Dom.get("asset_category_tree_root").innerHTML;

	this.tree.subscribe("nodeMove", this.movenode, this);
	this.tree.subscribe("clickEvent", this.clicknode, true, this);
	this.tree.subscribe("render", this.rendertree, true, this);

	this.load_node_data(this.tree.getRoot());
	this.load_asset_data(0, 'init');

	YAHOO.util.Event.on(["selectallbox1", "selectallbox2"], "click", this.selectallassets, this, true);
	YAHOO.util.Event.on("asset_attachment_list", "mousemove", this.assetover, this, true);
	YAHOO.util.Event.on("asset_attachment_list", "mouseout", this.assetout, this, true);
	YAHOO.util.Event.on("asset_attachment_list", "click", this.assetclick, this, true);
	YAHOO.util.Event.on("asset_upload_list", "mousemove", this.assetover, this, true);
	YAHOO.util.Event.on("asset_upload_list", "mouseout", this.assetout, this, true);
	YAHOO.util.Event.on("asset_upload_list", "click", this.assetclick, this, true);
	YAHOO.util.Event.on("gobutton", "click", this.load_asset_data, this, true);
	YAHOO.util.Event.on(["firstpage", "prevpage", "nextpage", "lastpage"], "click", this.load_asset_data, this, true);
	YAHOO.util.Event.on(["adduploadbutton1", "adduploadbutton2"], "click", this.add_upload_input, this);
	YAHOO.util.Event.on("addfiles", "click", this.show_upload_controls, this, true);
	YAHOO.util.Event.on(["upload_controls_close1", "upload_controls_close2", "upload_controls_close3"], "click", this.hide_upload_controls, this, true);
	YAHOO.util.Event.on(["switch_url_link1", "switch_url_link2"], "click", this.show_url_controls, this, true);
	YAHOO.util.Event.on("yui_basicupload", "click", this.show_basic_upload, this, true);
	YAHOO.util.Event.on("switch_upload_link", "click", this.show_computer_controls, this, true);
	// You would think this would work with "submit" on the form but Safari is being obtuse and forces the form to submit through
	YAHOO.util.Event.on(["uploadbutton1", "uploadbutton2"], "click", this.submitupload, this);
	YAHOO.util.Event.on("help_close", "click", this.hidehelp, this);
	YAHOO.util.Event.on("uploadform", "submit", this.submitupload, this);

	var ContextMenu = new YAHOO.widget.ContextMenu(varname + "contextmenu", {
		trigger: this.layout.getUnitByPosition(this.textdirection).body.parentNode.id,
		lazyload: true,
		itemdata: [
			{ text: "a", onclick: {fn: this.addnode, obj: this } },
			{ text: "b", onclick: {fn: this.editnode, obj: this } },
			{ text: "c", onclick: {fn: this.deletenode, obj: this } }
		]
	 });
	ContextMenu.subscribe("beforeShow", this.BeforeShowContextMenu, this);

	this.uploadcontainer = new YAHOO.util.DDTarget(this.layout.getUnitByPosition("bottom").body.parentNode.id, "vB_Asset");
}

vB_Asset.prototype.canceluploadform = function()
{
	return false;
}

vB_Asset.prototype.yuiuploadevent_updatetotal = function(type, args, me)
{
	YAHOO.util.Dom.setStyle("upload_controls_container", "z-index", 1);
	YAHOO.util.Dom.removeClass("upload_controls_close3", "invisible");
	me.hideprogress();
}

vB_Asset.prototype.yuiuploadevent_upload = function(type, args, me)
{
	this.yuiupload.postvars.categoryid = me.tree.selectednode.categoryid;
	me.showprogress();
	YAHOO.util.Dom.addClass("upload_controls_close3", "invisible");
	YAHOO.util.Dom.setStyle("upload_controls_container", "z-index", 10000);
	me.hideuploader();
}

vB_Asset.prototype.yuiuploadevent_handleresponse = function(type, args, me)
{
//	if (this.success)
//	{
		YAHOO.util.Dom.get("uploadform").upload.value = 1;
		assetobj = me;
		var callback =
		{
			success: me.uploadassets,
			failure: function(ajax)
			{
				assetobj.process_ajax_error(ajax);
			},
			scope  : me,
			argument: ["upload"]
		};
		YAHOO.util.Connect.setForm(YAHOO.util.Dom.get("uploadform"));
		YAHOO.util.Connect.asyncRequest("POST", "newattachment.php", callback, "ajax=1");
//	}
//	else
//	{
//		me.hideprogress();
//	}
}

vB_Asset.prototype.yuiuploadevent_handleresponse_noerrors = function(type, args, me)
{
	me.hide_upload_controls();
}

vB_Asset.prototype.close = function(e)
{
	var button = YAHOO.util.Event.getTarget(e);

	var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", "asset_upload_list");
	if (attachments.length > 0)
	{
		if (button.id == "insert_inline")
		{
			var count = 0;
			for (var i = 0; i < attachments.length; i++)
			{
				if (YAHOO.util.Dom.hasClass(attachments[i], "ygtvfocus"))
				{
					count++;
					var hasthumbnail = YAHOO.util.Dom.getElementsByClassName("asset_attachment", "", attachments[i]);
					window.opener.vB_Attachments.editor.insert_attachment(attachments[i].attachmentid, this.contenttypeid, hasthumbnail.length);
					YAHOO.util.Dom.removeClass(attachments[i], "ygtvfocus");
					YAHOO.util.Dom.get("upload_checkme_" + attachments[i].filedataid).checked = false;
				}
			}
			if (!count)
			{
				alert(this.phrases["please_select_attachment"]);
			}
			else
			{
				this.update_checked_count();
			}
			return;
		}
		window.close();
		return;
	}
	else
	{
		alert(this.phrases["please_drag_and_drop"]);
	}
}

vB_Asset.prototype.selectallassets = function(e)
{
	var target = YAHOO.util.Event.getTarget(e);
	if (target.id == "selectallbox1")
	{
		var assetnode = YAHOO.util.Dom.get("asset_attachment_list");
		var checked = YAHOO.util.Dom.get("selectallbox1").checked;
		var checkme = "checkme_";
	}
	else
	{
		var assetnode = YAHOO.util.Dom.get("asset_upload_list");
		var checked = YAHOO.util.Dom.get("selectallbox2").checked;
		var checkme = "upload_checkme_";
	}

	var assets = YAHOO.util.Dom.getElementsByClassName("asset_div", "", assetnode);
	if (assets.length)
	{
		for (var i = 0; i < assets.length; i++)
		{
			if (checked)
			{
				YAHOO.util.Dom.addClass(assets[i], "ygtvfocus");
				YAHOO.util.Dom.get(checkme + assets[i].filedataid).checked = true;
			}
			else
			{
				YAHOO.util.Dom.removeClass(assets[i], "ygtvfocus");
				YAHOO.util.Dom.get(checkme + assets[i].filedataid).checked = false;
			}
		}
		if (target.id != "selectallbox1")
		{
			this.update_checked_count();
		}
	}
}

vB_Asset.prototype.layoutchange = function(e)
{
	this.tree.walknode(this.tree.getRoot(), 1);
	this.verify_select_overlap();
	var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", this.uploadlist);
	if (attachments.length)
	{
		for (var i = 0; i < attachments.length; i++)
		{
			attachments[i].ddobj.initConstraints();
		}
	}
}

vB_Asset.prototype.show_computer_controls = function(e)
{
	YAHOO.util.Dom.addClass("upload_controls_url", "hidden");
	YAHOO.util.Dom.removeClass("upload_controls_computer", "hidden");
	this.show_upload_controls(e);
}

vB_Asset.prototype.show_url_controls = function(e)
{
	this.hideuploader();
	YAHOO.util.Dom.addClass("upload_controls_computer", "hidden");
	YAHOO.util.Dom.addClass("upload_controls_yui", "hidden");
	YAHOO.util.Dom.removeClass("upload_controls_url", "hidden");
}

vB_Asset.prototype.hideuploader = function()
{
	YAHOO.util.Dom.setStyle("yui_selectfiles", "width", "1px");
	YAHOO.util.Dom.setStyle("yui_selectfiles", "height", "1px");
}

vB_Asset.prototype.verify_select_overlap = function()
{
	if (!is_ie6)
	{
		return;
	}

	var uploadcontrolsr = YAHOO.util.Dom.getRegion("upload_controls_container");
	if (uploadcontrolsr)
	{
		var select1 = YAHOO.util.Dom.getRegion("asset_attachment_orderby");
		if (!select1)
		{
			YAHOO.util.Dom.removeClass("asset_attachment_orderby", "hidden");
			select1 = YAHOO.util.Dom.getRegion("asset_attachment_orderby");
			YAHOO.util.Dom.addClass("asset_attachment_orderby", "hidden");
		}

		var select2 = YAHOO.util.Dom.getRegion("asset_attachment_sortorder");
		if (!select2)
		{
			YAHOO.util.Dom.removeClass("asset_attachment_sortorder", "hidden");
			select2 = YAHOO.util.Dom.getRegion("asset_attachment_sortorder");
			YAHOO.util.Dom.addClass("asset_attachment_sortorder", "hidden");
		}

		var select3 = YAHOO.util.Dom.getRegion("asset_attachment_view");
		if (!select3)
		{
			YAHOO.util.Dom.removeClass("asset_attachment_view", "hidden");
			select3 = YAHOO.util.Dom.getRegion("asset_attachment_view");
			YAHOO.util.Dom.addClass("asset_attachment_view", "hidden");
		}

		if (uploadcontrolsr.intersect(select1))
		{
			YAHOO.util.Dom.addClass("asset_attachment_orderby", "hidden");
		}
		else
		{
			YAHOO.util.Dom.removeClass("asset_attachment_orderby", "hidden");
		}
		if (uploadcontrolsr.intersect(select2))
		{
			YAHOO.util.Dom.addClass("asset_attachment_sortorder", "hidden");
		}
		else
		{
			YAHOO.util.Dom.removeClass("asset_attachment_sortorder", "hidden");
		}
			if (uploadcontrolsr.intersect(select3))
		{
			YAHOO.util.Dom.addClass("asset_attachment_view", "hidden");
		}
		else
		{
			YAHOO.util.Dom.removeClass("asset_attachment_view", "hidden");
		}
	}
}

vB_Asset.prototype.show_basic_upload = function(e)
{
	this.hide_upload_controls(e, true)
	this.yuiupload.active = false;
	this.show_upload_controls(e);
}

vB_Asset.prototype.show_upload_controls = function(e)
{
	YAHOO.util.Event.stopEvent(e);

	var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", "asset_upload_list");
	if (this.attachlimit && attachments.length >= this.attachlimit)
	{
		alert(this.phrases["maximum_number_of_attachments_reached"]);
		return false;
	}

	var havefile = YAHOO.util.Dom.get("upload_controls_computer");
	var haveurl = YAHOO.util.Dom.get("upload_controls_url");

	YAHOO.util.Dom.setStyle("upload_controls_container", "top", "");
	YAHOO.util.Dom.setStyle("upload_controls_container", this.textdirection, "");
	YAHOO.util.Dom.removeClass("upload_controls_container", "hidden");

	if (havefile)
	{
		YAHOO.util.Dom.addClass("upload_controls_url", "hidden");
		if (this.yuiupload.active)
		{
			YAHOO.util.Dom.addClass("upload_controls_computer", "hidden");
			YAHOO.util.Dom.removeClass("upload_controls_yui", "hidden");
			var text = YAHOO.util.Dom.get("yui_selectfilestext");
			var selectfiles = YAHOO.util.Dom.get("yui_selectfiles");
			YAHOO.util.Dom.setStyle(selectfiles, "display", "");
			YAHOO.util.Event.on(window, "resize", this.yuiupload.moveflashobj, this, true);
			this.yuiupload.moveflashobj();
		}
		else
		{
			YAHOO.util.Dom.removeClass("upload_controls_computer", "hidden");
			var boxes = YAHOO.util.Dom.getElementsByClassName("uploadinput", "input", "upload_controls_computer");
			if (boxes.length >= this.attachboxcount)
			{
				YAHOO.util.Dom.addClass("adduploadbutton1", "hidden");
			}
			else
			{
				var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", "asset_upload_list");
				if (this.attachlimit && attachments.length + boxes.length >= this.attachlimit)
				{
					YAHOO.util.Dom.addClass("adduploadbutton1", "hidden");
				}
			}
		}
	}
	else
	{
		YAHOO.util.Dom.removeClass("upload_controls_url", "hidden");
	}

	if (haveurl)
	{
		var boxes = YAHOO.util.Dom.getElementsByClassName("urlinput");
		if (boxes.length >= this.attachurlcount)
		{
			YAHOO.util.Dom.setStyle("adduploadbutton2", "display", "none");
		}
	}
	this.verify_select_overlap();

	return false;
}

vB_Asset.prototype.hide_upload_controls = function(e, quick)
{
	if (this.yuiupload.active)
	{
		this.hideuploader();
		YAHOO.util.Event.removeListener(window, "resize", this.yuiupload.moveflashobj);
	}
	if (quick)
	{
			YAHOO.util.Dom.removeClass("asset_attachment_orderby", "hidden");
			YAHOO.util.Dom.removeClass("asset_attachment_sortorder", "hidden");
			YAHOO.util.Dom.removeClass("asset_attachment_view", "hidden");
			YAHOO.util.Dom.setStyle("upload_controls_container", "width", "auto");
			YAHOO.util.Dom.addClass("upload_controls_container", "hidden");
			YAHOO.util.Dom.addClass("upload_controls_yui", "hidden");
			return;
	}
	var region = YAHOO.util.Dom.getRegion("upload_controls_container");
	YAHOO.util.Dom.setStyle("upload_controls_container", "width", region.right - region.left + "px");
	var xy = YAHOO.util.Dom.getXY("upload_controls_container");
	var height = YAHOO.util.Dom.getViewportHeight();
	var width = YAHOO.util.Dom.getViewportWidth();
	var pointsx = new Array(
		0 - width - 2,
		0 - width - 2,
		xy[0]
	);
	var pointsy = new Array(
		0 - height - 2,
		xy[1],
		0 - height - 2
	);

	var rand = Math.floor(pointsx.length * Math.random());
	var a = new YAHOO.util.Motion
	(
		"upload_controls_container",
		{
			points:
			{
				//to: [pointsx[rand], pointsy[rand]]
				to: [width, xy[1]]
			}
		},
		0.2,
		YAHOO.util.Easing.easeOut
	)

	// Hide the dragEl and show the source element when finished with the animation
	a.onComplete.subscribe(
		function()
		{
			YAHOO.util.Dom.removeClass("asset_attachment_orderby", "hidden");
			YAHOO.util.Dom.removeClass("asset_attachment_sortorder", "hidden");
			YAHOO.util.Dom.removeClass("asset_attachment_view", "hidden");
			YAHOO.util.Dom.setStyle("upload_controls_container", "width", "auto");
			YAHOO.util.Dom.addClass("upload_controls_container", "hidden");
			YAHOO.util.Dom.setStyle("yui_basicupload", "display", "");
		}
	);
	a.animate();
}

vB_Asset.prototype.add_upload_input = function(e, assetobj)
{
	YAHOO.util.Event.stopEvent(e);

	if (this.id == "adduploadbutton1")
	{
		var boxes = YAHOO.util.Dom.getElementsByClassName("uploadinput", "input", "upload_controls_computer");
		if (boxes.length >= assetobj.attachboxcount || (boxes.length + 1) == assetobj.attachboxcount)
		{
			YAHOO.util.Dom.addClass("adduploadbutton1", "hidden");
		}
		else
		{
			var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", "asset_upload_list");
			if (assetobj.attachlimit && attachments.length + boxes.length + 1 >= assetobj.attachlimit)
			{
				YAHOO.util.Dom.addClass("adduploadbutton1", "hidden");
			}
		}
		var uploadelement = YAHOO.util.Dom.get("uploadinput");
		var inputel = uploadelement.cloneNode(true);

		var firstuploadinput = YAHOO.util.Dom.get("firstuploadinput");
		YAHOO.util.Dom.setAttribute(firstuploadinput, "id", "");
		YAHOO.util.Dom.setAttribute(inputel, "id", "firstuploadinput");
		YAHOO.util.Dom.setStyle(inputel, "display", "");
		firstuploadinput.parentNode.insertBefore(inputel, firstuploadinput);
	}
	else
	{
		var boxes = YAHOO.util.Dom.getElementsByClassName("urlinput");
		if (boxes.length >= assetobj.attachurlcount || (boxes.length + 1) == assetobj.attachurlcount)
		{
			YAHOO.util.Dom.setStyle("adduploadbutton2", "display", "none");
		}

		var uploadelement = YAHOO.util.Dom.get("urlinput");
		var inputel = uploadelement.cloneNode(true);
		inputel.value = "";
		YAHOO.util.Dom.setAttribute(uploadelement, "id", "");
		uploadelement.parentNode.insertBefore(inputel, uploadelement);
		inputel.focus();
	}

	return false;
}

vB_Asset.prototype.preparepostdata = function(postdata)
{
	return SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&posthash=" + this.posthash + "&poststarttime=" + this.poststarttime + "&ajax=1&" + postdata;
}

vB_Asset.prototype.showfilehelp = function(e, assetobj)
{
	assetobj.showprogress();
	var callback =
	{
		failure: assetobj.process_ajax_error,
		timeout: vB_Default_Timeout,
		success: assetobj.displayhelp,
		scope  : assetobj
	};
	var postdata = assetobj.preparepostdata("ajax=1&do=help&type=help");
	YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
}

vB_Asset.prototype.showkey = function(e, assetobj)
{
	var keyt = YAHOO.util.Dom.get("key_title");
	var keyc = YAHOO.util.Dom.get("key_content");
	assetobj.showhelp(keyt.innerHTML, keyc.innerHTML);
}

vB_Asset.prototype.showhelp = function(title, content)
{
	var help = YAHOO.util.Dom.get("help_container");
	YAHOO.util.Dom.get("help_title").innerHTML = title;
	YAHOO.util.Dom.get("help_content").innerHTML = content;
	YAHOO.util.Dom.removeClass(help, "hidden");
	center_element(help, true);
	YAHOO.util.Event.on(window, "resize", this.centerhelp);
}

vB_Asset.prototype.centerhelp = function()
{
	var help = YAHOO.util.Dom.get("help_container");
	center_element(help, true);
}

vB_Asset.prototype.hidehelp = function(e, assetobj)
{
	YAHOO.util.Dom.addClass("help_container", "hidden");
	YAHOO.util.Event.removeListener(window, "resize", assetobj.centerhelp);
	YAHOO.util.Dom.get("help_close").blur();
}

vB_Asset.prototype.showprogress = function()
{
	YAHOO.util.Dom.setStyle("overlay", "display", "block");
	YAHOO.util.Dom.removeClass("progressimage", "hidden");
}

vB_Asset.prototype.hideprogress = function()
{
	YAHOO.util.Dom.setStyle("overlay", "display", "none");
	YAHOO.util.Dom.addClass("progressimage", "hidden");
}

vB_Asset.prototype.assetclick = function(e)
{
	var target = YAHOO.util.Event.getTarget(e);

	if (YAHOO.util.Dom.hasClass(target, "asset_attach_delete"))
	{
		if (YAHOO.util.Dom.getAncestorBy(target, function(element)
			{	if (element.id == "asset_upload_list") {return true;}return false; })
		)
		{
			var assets = {};
			var deleteattach = "";
			var asset_div = YAHOO.util.Dom.getAncestorByClassName(target, "asset_div");
			var counter = 0;
			if (YAHOO.util.Dom.hasClass(asset_div, "ygtvfocus"))
			{
				var assetnode = YAHOO.util.Dom.get("asset_upload_list");
				if (assetnode.childNodes.length)
				{
					for (var i = 0; i < assetnode.childNodes.length; i++)
					{
						if (YAHOO.util.Dom.hasClass(assetnode.childNodes[i], "ygtvfocus"))
						{
							counter++;
							deleteattach += "&delete[" + assetnode.childNodes[i].attachmentid + "]=1";
							assets[assetnode.childNodes[i].attachmentid] = true;
						}
					}
				}
			}

			if (counter > 1)
			{
				if (!confirm(this.phrases["are_you_sure_delete_assets"]))
				{
					return;
				}
			}
			else
			{
				if (confirm(this.phrases["are_you_sure_delete_asset"]))
				{
					deleteattach = "&delete[" + asset_div.attachmentid + "]=1";
				}
				else
				{
					return;
				}
			}

			var attachmentid;
			for (attachmentid in assets)
			{
				window.opener.vB_Attachments.editor.remove_attachment(attachmentid);
			}

			this.showprogress();
			YAHOO.util.Dom.get("uploadform").upload.value = 0;
			var callback =
			{
				success: this.uploadassets,
				failure: function(ajax)
				{
					this.process_ajax_error(ajax);
				},
				scope  : this,
				argument: ["delete"]
			};

			YAHOO.util.Connect.setForm(YAHOO.util.Dom.get("uploadform"));
			YAHOO.util.Connect.asyncRequest("POST", "newattachment.php", callback, "ajax=1" + deleteattach);
		}
		else
		{
			// This item is on the "asset" list and this bit is disabled at the moment
			alert("This doesn't do anything at present.");
		}
	}
	else if (YAHOO.util.Dom.hasClass(target, "asset_attach_usage"))
	{
		var assetdiv = YAHOO.util.Dom.getAncestorByClassName(target, "asset_div");
		this.showprogress();
		var callback =
		{
			failure: this.process_ajax_error,
			timeout: vB_Default_Timeout,
			success: this.displayhelp,
			scope  : this
		};
		var postdata = this.preparepostdata("do=help&type=assetusage&filedataid=" + assetdiv.filedataid);
		YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
	}
	else if (e.ctrlKey || YAHOO.util.Dom.hasClass(target, "checkme"))
	{
		var isuploadlist = YAHOO.util.Dom.getAncestorBy(target, function(element) {	if (element.id == "asset_upload_list") {return true;}return false; });
		var assetdiv = YAHOO.util.Dom.getAncestorByClassName(target, "asset_div");
		// Kill the highlight added by IE
		if (document.selection && document.selection.empty)
		{
			document.selection.empty();
		}
		if (assetdiv)
		{
			var checkme = (isuploadlist ? "upload_checkme_" : "checkme_");
			if (YAHOO.util.Dom.hasClass(assetdiv, "ygtvfocus"))
			{
				YAHOO.util.Dom.removeClass(assetdiv, "ygtvfocus");
				YAHOO.util.Dom.get(checkme + assetdiv.filedataid).checked = false;
			}
			else
			{
				YAHOO.util.Dom.addClass(assetdiv, "ygtvfocus");
				YAHOO.util.Dom.get(checkme + assetdiv.filedataid).checked = true;
			}
			if (isuploadlist)
			{
				this.update_checked_count();
			}
		}
	}
}

vB_Asset.prototype.displayhelp = function(ajax)
{
	if (ajax.responseXML && this.process_ajax_response(ajax, 1, 0))
	{
		if (ajax.responseXML.getElementsByTagName("content")[0].firstChild)
		{
			this.showhelp(ajax.responseXML.getElementsByTagName("title")[0].firstChild.nodeValue, ajax.responseXML.getElementsByTagName("content")[0].firstChild.nodeValue);
		}
	}
	this.hideprogress();
}

vB_Asset.prototype.assetout = function(e)
{
	var targetleft = YAHOO.util.Event.getTarget(e);
	var targetentered = YAHOO.util.Event.getRelatedTarget(e);

	if (this.currentasset)
	{
		this.currentasset = null;
	}
	if (this.currentassetdelete)
	{
		this.currentassetdelete = null;
	}
	clearTimeout(this.currentassettimer);

	// Hide delete button
	var leftparent = null;
	var enteredparent = null;
	try
	{
		leftparent = YAHOO.util.Dom.hasClass(targetleft, "asset_div") ? targetleft : YAHOO.util.Dom.getAncestorByClassName(targetleft, "asset_div");
		enteredparent = YAHOO.util.Dom.hasClass(targetentered, "asset_div") ? targetentered : YAHOO.util.Dom.getAncestorByClassName(targetentered, "asset_div");
	}
	catch(e)
	{}
	if (leftparent != enteredparent)
	{
		YAHOO.util.Dom.setStyle("asset_delete_" + this.currentfiledataid, "display", "none");
		YAHOO.util.Dom.setStyle("upload_asset_delete_" + this.currentfiledataid, "display", "none");
		YAHOO.util.Dom.setStyle("asset_usage_" + this.currentfiledataid, "display", "none");
		YAHOO.util.Dom.setStyle("upload_asset_usage_" + this.currentfiledataid, "display", "none");
		this.currentfiledataid = null;
	}
}

vB_Asset.prototype.assetover = function(e, foo)
{
	var targetentered = YAHOO.util.Event.getTarget(e);
	var targetleft = YAHOO.util.Event.getRelatedTarget(e);

	// Show delete button
	var parentdiv = YAHOO.util.Dom.hasClass(targetentered, "asset_div") ? targetentered : YAHOO.util.Dom.getAncestorByClassName(targetentered, "asset_div");
	if (parentdiv && targetentered != targetleft)
	{
		if (this.currentfiledataid)
		{
			YAHOO.util.Dom.setStyle("asset_delete_" + this.currentfiledataid, "display", "none");
			YAHOO.util.Dom.setStyle("upload_asset_delete_" + this.currentfiledataid, "display", "none");
			YAHOO.util.Dom.setStyle("asset_usage_" + this.currentfiledataid, "display", "none");
			YAHOO.util.Dom.setStyle("upload_asset_usage_" + this.currentfiledataid, "display", "none");
		}

		var match = parentdiv.id.match(/^(upload_)?asset_div_?(\d+)$/);
		if (match)
		{
			this.currentfiledataid = match[2];
			// this bit allows for the delete button on assets as well, which is currently disabled
			//YAHOO.util.Dom.setStyle((match[1] ? "upload_" : "") + "asset_delete_" + this.currentfiledataid, "display", "");
			if (match[1] == "upload_")
			{
				YAHOO.util.Dom.setStyle("upload_asset_delete_" + this.currentfiledataid, "display", "");
				YAHOO.util.Dom.setStyle("upload_asset_usage_" + this.currentfiledataid, "display", "");
			}
			else
			{
				YAHOO.util.Dom.setStyle("asset_usage_" + this.currentfiledataid, "display", "");
			}
		}
	}

	if (this.currentasset == targetentered || this.currentassetdelete == targetentered)
	{
		return;
	}

	if (this.currentasset)
	{
		this.currentasset = null;
		clearTimeout(this.currentassettimer);
	}

	if (this.currentassetdelete)
	{
		this.currentassetdelete = null;
	}

	if (YAHOO.util.Dom.hasClass(targetentered, "asset_attach_delete"))
	{
		this.currentassetdelete = targetentered;
	}
	else if (YAHOO.util.Dom.hasClass(targetentered, "asset_attachment") && !e.ctrlKey)
	{
		this.currentasset = targetentered;
		thisC = this;
		this.currentassettimer = setTimeout(function(){ thisC.popupasset(); }, 1000);
	}
}

vB_Asset.prototype.popupout = function()
{
	YAHOO.util.Dom.setStyle(this.popupimg, "display", "none");
	YAHOO.util.Dom.setStyle(this.assetinvisible, "visibility", "visible");

	YAHOO.util.Event.removeListener(document, "mousemove", this.verifypopup);
	if (!is_moz)
	{
		YAHOO.util.Event.removeListener(window, "scroll", this.verifypopup);
	}
}

vB_Asset.prototype.popupasset = function()
{
	if (this.popupimg == null)
	{
		this.popupimg = document.body.appendChild(document.createElement("img"));
		YAHOO.util.Dom.addClass(this.popupimg, "asset_popup_img");
		if (is_moz)
		{
			// YAHOO.util.Dom.setXY only seems to work with position = fixed in Firefox
			YAHOO.util.Dom.setStyle(this.popupimg, "position", "fixed");
		}
	}

	var currentregion = YAHOO.util.Dom.getRegion(this.currentasset);
	this.popupimg.src = this.currentasset.src;

	YAHOO.util.Dom.setStyle(this.popupimg, "visibility", "hidden");
	YAHOO.util.Dom.setStyle(this.popupimg, "display", "");
	var popupregion = YAHOO.util.Dom.getRegion(this.popupimg);

	if ((popupregion.right - popupregion.left) <= (currentregion.right - currentregion.left))
	{
		return;
	}

	this.assetinvisible = this.currentasset;
	YAHOO.util.Dom.setStyle(this.currentasset, "visibility", "hidden");
	YAHOO.util.Dom.setStyle(this.popupimg, "visibility", "");
	var xy = YAHOO.util.Dom.getXY(this.currentasset);
	YAHOO.util.Dom.setXY(this.popupimg, xy);

	var popupregion = YAHOO.util.Dom.getRegion(this.popupimg);
	var layoutregion = YAHOO.util.Dom.getRegion("layout-doc");

	if (popupregion.right > layoutregion.right)
	{
		YAHOO.util.Dom.setX(this.popupimg, popupregion.left - (popupregion.right - layoutregion.right));
	}
	if (popupregion.bottom > layoutregion.bottom)
	{
		YAHOO.util.Dom.setY(this.popupimg, popupregion.top - (popupregion.bottom - layoutregion.bottom));
	}

	YAHOO.util.Event.on(document, "mousemove", this.verifypopup, this, true);
	if (!is_moz)
	{
		YAHOO.util.Event.on(window, "scroll", this.verifypopup, this, true);
	}
}

vB_Asset.prototype.verifypopup = function(e)
{
	var target = YAHOO.util.Event.getTarget(e);
	if (target != this.popupimg)
	{
		this.popupout();
	}
}

vB_Asset.prototype.clearuploadinputs = function()
{
	YAHOO.util.Dom.get("uploadform").reset();
}

vB_Asset.prototype.submitupload = function(e, assetobj)
{
	YAHOO.util.Event.stopEvent(e);

	// Verify that we have a file
	var inputname = (this.id == "uploadbutton2" || this.id == "uploadform") ? "urlinput" : "uploadinput";

	var upload = false;
	var uploads = YAHOO.util.Dom.getElementsByClassName(inputname);
	for (var i = 0; i < uploads.length; i++)
	{
		if (uploads[i].value != "")
		{
			upload = true;
			continue;
		}
	}

	if (!upload)
	{
		return;
	}

	assetobj.hide_upload_controls();
	assetobj.showprogress();
	var callback =
	{
		upload  : assetobj.uploadassets,
		failure : function(ajax)
		{
			alert(assetobj.phrases["upload_failed"]);
			assetobj.process_ajax_error(ajax);
		},
		scope   : assetobj,
		argument: ["upload"]
	};

	YAHOO.util.Dom.get("uploadform").upload.value = 1;
	YAHOO.util.Connect.setForm(YAHOO.util.Dom.get("uploadform"), true, true);
	YAHOO.util.Connect.asyncRequest("POST", "newattachment.php", callback, "ajax=1&categoryid=" + assetobj.tree.selectednode.categoryid);

	// this is for Safari
	return false;
}

vB_Asset.prototype.uploadassets = function(ajax)
{
	if (ajax.argument[0] == "upload")
	{
		this.clearuploadinputs();
	}
	if (this.process_ajax_response(ajax, true))
	{
		var stats = ajax.responseXML.getElementsByTagName("stats");
		if (stats.length)
		{
			if (ajax.argument[0] == "upload" || ajax.argument[0] == "url")
			{
				this.clicknode(this.tree.selectednode, true);
			}
			// Clear out the upload list
			var clickedlist = {};
			var count = 0;
			var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", this.uploadlist);
			var length = attachments.length;
			if (length)
			{
				for (var i = 0; i < length; i++)
				{
					clickedlist[attachments[i].attachmentid] = YAHOO.util.Dom.hasClass(attachments[i], "ygtvfocus") ? 1 : 0;
					attachments[i].parentNode.removeChild(attachments[i]);
				}
			}
			// Process sent in elements now
			var attachments = ajax.responseXML.getElementsByTagName("attachment");
			var displaybits = ajax.responseXML.getElementsByTagName("displaybit");
			var filenames = ajax.responseXML.getElementsByTagName("filename");
			var filesizes = ajax.responseXML.getElementsByTagName("filesize");
			var icons = ajax.responseXML.getElementsByTagName("icon");

			if (window.opener)
			{
				try
				{
					window.opener.vB_Attachments.reset();
				}
				catch(e)
				{}
			}

			if (attachments.length)
			{
				for (var i = 0; i < attachments.length; i++)
				{
					var node = string_to_node(attachments[i].firstChild.nodeValue);
					var newnode = this.uploadlist.appendChild(node);
					this.init_attachment(newnode);
					if (typeof(clickedlist[newnode.attachmentid]) == "undefined" || clickedlist[newnode.attachmentid] == 1)
					{
						YAHOO.util.Dom.addClass(newnode, "ygtvfocus");
						YAHOO.util.Dom.get("upload_checkme_" + newnode.filedataid).checked = true;
					}
					count++;
					if (window.opener)
					{
						try
						{
							window.opener.vB_Attachments.add(newnode.attachmentid, displaybits[i].firstChild.nodeValue, filenames[i].firstChild.nodeValue, filesizes[i].firstChild.nodeValue, icons[i].firstChild.nodeValue);
						}
						catch(e)
						{}
					}
				}
			}

			var boxes = YAHOO.util.Dom.getElementsByClassName("uploadinput", "input", "upload_controls_computer");
			if (boxes.length < this.attachboxcount)
			{
				var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", "asset_upload_list");
				if (attachments.length + boxes.length >= this.attachlimit)
				{
					YAHOO.util.Dom.addClass("adduploadbutton1", "hidden");
				}
				else
				{
					YAHOO.util.Dom.removeClass("adduploadbutton1", "hidden");
				}
			}

			YAHOO.util.Dom.get("upload_header").innerHTML = ajax.responseXML.getElementsByTagName("stats")[0].firstChild.nodeValue;
			var quotaattachsum = YAHOO.util.Dom.get("quotaattachsum");
			var quotaattach = YAHOO.util.Dom.get("quotaattach");
			if (quotaattachsum && quotaattach)
			{
				YAHOO.util.Dom.setStyle(quotaattachsum, 'width', ajax.responseXML.getElementsByTagName("attachsize")[0].firstChild.nodeValue);
				YAHOO.util.Dom.setAttribute(quotaattachsum, "title", ajax.responseXML.getElementsByTagName("attachtotal")[0].firstChild.nodeValue);
				YAHOO.util.Dom.setAttribute(quotaattach, "title", ajax.responseXML.getElementsByTagName("attachstorage")[0].firstChild.nodeValue);
				YAHOO.util.Dom.get("attachsum").innerHTML = ajax.responseXML.getElementsByTagName("attachsum")[0].firstChild.nodeValue;
			}

			this.update_checked_count();
		}
		if (typeof(attachments) == "undefined" || !attachments.length)
		{
			YAHOO.util.Dom.addClass("selectall2", "hidden");
		}
		else
		{
			YAHOO.util.Dom.removeClass("selectall2", "hidden");
		}
		YAHOO.util.Dom.get("selectallbox2").checked = false;
	}
	this.hideprogress();
}

vB_Asset.prototype.update_checked_count = function()
{
	var count = 0;
	var attachments = YAHOO.util.Dom.getElementsByClassName("asset_div", "", this.uploadlist);
	for (var i = 0; i < attachments.length; i++)
	{
		if (YAHOO.util.Dom.hasClass(attachments[i], "ygtvfocus"))
		{
			count++;
		}
	}
	YAHOO.util.Dom.get("insert_inline").innerHTML = construct_phrase(this.phrases["insert_inline_x"], count);
}

vB_Asset.prototype.init_attachment = function(attachment)
{
	var fid_aid = YAHOO.util.Dom.getElementsByClassName("asset_attachment_container", "", attachment)[0].id;
	var match = fid_aid.match(/^attachment_(\d+)_(\d+)$/);
	attachment.filedataid = match[1];
	attachment.attachmentid = match[2];
	var ddobj = new vB_Asset_DD_Attachment(attachment, "vB_Asset", "", this);
	ddobj.subscribe("b4MouseDownEvent", this.cancelassetdrag);
	ddobj.filedataid = match[1];
	attachment.ddobj = ddobj;
}

vB_Asset.prototype.rendertree = function(obj)
{
	if (this.tree.selectednode == null)
	{
		this.clicknode(this, true)
	}
}

// This function handles data coming from different areas, either by an event or called directly
vB_Asset.prototype.clicknode = function(obj, forcerefresh)
{
	if (typeof(obj.node) == "undefined")
	{
		if (typeof(obj.parent) != "undefined")
		{
			var node = obj;
		}
		else
		{
			// a click on the pseudo root element because the treeview gives no option to display the hidden root node. We have to fake it.
			var node = this.tree.getRoot();
		}
	}
	else
	{
		var node = obj.node
	}
	YAHOO.util.Dom.get("currentfolder").innerHTML = node.label;
	if (this.tree.selectednode == null)
	{
		this.tree.selectednode = this.tree.getRoot();
	}

	if (this.tree.selectednode == node && !forcerefresh)
	{
		return false;
	}
	YAHOO.util.Dom.removeClass(this.tree.selectednode.isRoot() ? this.rootel : this.tree.selectednode.getLabelEl().parentNode.parentNode, "ygtvfocus");
	this.tree.selectednode = node;
	YAHOO.util.Dom.addClass(node.isRoot() ? this.rootel : node.getLabelEl().parentNode.parentNode, "ygtvfocus");
	this.load_asset_data(node.categoryid);

	// Stop the node from expanding when the label is clicked by returning false here
	return false;
}

vB_Asset.prototype.reload_tree = function()
{
	this.tree.removeChildren(this.tree.getRoot());
	this.load_node_data(this.tree.getRoot());
}

vB_Asset.prototype.load_asset_data = function(categoryid, init)
{
	if (typeof(categoryid) == "object")
	{	// fired by the "Go" button so categoryid is a mouseevent
		var target = YAHOO.util.Event.getTarget(categoryid);
		switch(target.id)
		{
			case "firstpage":
				this.pagenumber = 1;
				break;
			case "prevpage":
				this.pagenumber--;
				break;
			case "nextpage":
				this.pagenumber++;
				break;
			case "lastpage":
				this.pagenumber = this.totalpages;
				break;
		}
		categoryid = this.currentcategoryid;
	}
	else
	{
		this.pagenumber = 1;
		this.currentcategoryid = categoryid;
	}

	// Grab settings
	var orderby = YAHOO.util.Dom.get("asset_attachment_orderby").value;
	var sortorder = YAHOO.util.Dom.get("asset_attachment_sortorder").value;
	var view = YAHOO.util.Dom.get("asset_attachment_view").value;

	this.showprogress();
	var callback =
	{
		failure: this.process_ajax_error,
		timeout: vB_Default_Timeout,
		success: this.loadassets,
		scope  : this
	}

	var postdata = this.preparepostdata("do=loadassets&contenttypeid=" + this.contenttypeid + "&categoryid=" + categoryid + "&orderby=" + PHP.urlencode(orderby) + "&sortorder=" + PHP.urlencode(sortorder) + "&view=" + PHP.urlencode(view) + "&page=" + this.pagenumber + (typeof(init) != "undefined" ? "&init=1" : ""));
	YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
}

vB_Asset.prototype.log = function(msg)
{
	console.log("vB_Asset :: %d", msg);
}

vB_Asset.prototype.cancelassetdrag = function(e)
{
	if (e.ctrlKey)
	{
		return false;
	}
}

vB_Asset.prototype.loadassets = function(ajax)
{
	if (ajax.responseXML)
	{
		if (this.process_ajax_response(ajax, true))
		{
			this.log("Assets Loaded");
			var assetnode = YAHOO.util.Dom.get("asset_attachment_list");
			// Empty assetnode of any existing assets

			var length = assetnode.childNodes.length;
			if (length)
			{
				for (var i = 0; i < length; i++)
				{
					assetnode.removeChild(assetnode.childNodes[0]);
				}
			}

			var count = 0;
			var assets = ajax.responseXML.getElementsByTagName("asset");
			if (assets.length > 0)
			{
				for (var i = 0; i < assets.length; i++)
				{
					if (assets[i].firstChild)
					{
						var node = string_to_node(assets[i].firstChild.nodeValue);
						var newnode = assetnode.appendChild(node);
						var match = newnode.id.match(/^asset_div_(\d+)$/);
						newnode.filedataid = match[1];

						// Add drag drop item to asset
						var ddobj = new vB_Asset_DD(newnode, "vB_Asset", "", this.layout.getUnitByPosition("bottom").body.parentNode.id);
						ddobj.createEvent("assetMove");
						ddobj.createEvent("assetUpload");
						ddobj.subscribe("assetMove", this.moveasset, this);
						ddobj.subscribe("assetUpload", this.uploadasset, this);
						ddobj.subscribe("b4MouseDownEvent", this.cancelassetdrag);
						ddobj.filedataid = match[1];
						count++;
					}
				}
			}

			this.totalassets = parseInt(ajax.responseXML.getElementsByTagName("totalassets")[0].firstChild.nodeValue);
			this.startasset = parseInt(ajax.responseXML.getElementsByTagName("startasset")[0].firstChild.nodeValue);
			this.endasset = parseInt(ajax.responseXML.getElementsByTagName("endasset")[0].firstChild.nodeValue);
			this.pagenumber = parseInt(ajax.responseXML.getElementsByTagName("pagenumber")[0].firstChild.nodeValue);
			this.totalpages = parseInt(ajax.responseXML.getElementsByTagName("totalpages")[0].firstChild.nodeValue);
			if (ajax.responseXML.getElementsByTagName("attachboxcount").length)
			{
				this.attachboxcount = parseInt(ajax.responseXML.getElementsByTagName("attachboxcount")[0].firstChild.nodeValue);
				this.attachurlcount = parseInt(ajax.responseXML.getElementsByTagName("attachurlcount")[0].firstChild.nodeValue);
				this.attachlimit = parseInt(ajax.responseXML.getElementsByTagName("attachlimit")[0].firstChild.nodeValue);
				this.max_file_size = parseInt(ajax.responseXML.getElementsByTagName("max_file_size")[0].firstChild.nodeValue);
			}
			var phrases = ajax.responseXML.getElementsByTagName("phrases");
			if (phrases.length && phrases[0].childNodes.length)
			{
				for(var i = 0; i < phrases[0].childNodes.length; i++)
				{
					if (phrases[0].childNodes[i].nodeName != "#text")
					{
						if (typeof(phrases[0].childNodes[i].childNodes[0]) == "undefined")
						{
							alert("Missing Phrase: " + phrases[0].childNodes[i].nodeName);
						}
						else
						{
							this.phrases[phrases[0].childNodes[i].nodeName] = phrases[0].childNodes[i].childNodes[0].nodeValue
						}
					}
				}
			}
			var extensions = ajax.responseXML.getElementsByTagName("extensions");
			if (extensions.length && extensions[0].childNodes.length)
			{
				for(var i = 0; i < extensions[0].childNodes.length; i++)
				{
					if (extensions[0].childNodes[i].nodeName != "#text")
					{
						this.extensions[YAHOO.util.Dom.getAttribute(extensions[0].childNodes[i], 'name')] = extensions[0].childNodes[i].childNodes[0].nodeValue;
					}
				}
			}
			if (!this.setvars)
			{
				this.yuiupload.setvars(this.extensions, this.phrases, this.attachlimit, this.max_file_size);
				this.setvars = true;
			}

			YAHOO.util.Dom.get("currentpage").innerHTML = ajax.responseXML.getElementsByTagName("currentpage")[0].firstChild.nodeValue;
			YAHOO.util.Dom.get("pagestats").innerHTML = ajax.responseXML.getElementsByTagName("pagestats")[0].firstChild.nodeValue;
			this.updateassetsheader();
		}
	}
	this.hideprogress();
}

vB_Asset.prototype.updateassetsheader = function()
{
	if (this.endasset < this.startasset)
	{
		this.startasset = this.endasset = 0;
	}

	if (this.totalassets <= 0)
	{
		YAHOO.util.Dom.addClass("firstpage", "invisible");
		YAHOO.util.Dom.addClass("prevpage", "invisible");
		YAHOO.util.Dom.addClass("nextpage", "invisible");
		YAHOO.util.Dom.addClass("lastpage", "invisible");
		YAHOO.util.Dom.addClass("currentpage", "hidden");
		YAHOO.util.Dom.removeClass("noassets", "hidden");
		YAHOO.util.Dom.addClass("pagestats", "hidden");
		YAHOO.util.Dom.addClass("selectall1", "hidden");
	}
	else
	{
		YAHOO.util.Dom.removeClass("selectall1", "hidden");
		YAHOO.util.Dom.get("pagestats").innerHTML = construct_phrase(this.phrases["assets_x_to_y_of_z"], this.startasset, this.endasset, this.totalassets);
		YAHOO.util.Dom.removeClass("currentpage", "hidden");
		YAHOO.util.Dom.removeClass("pagestats", "hidden");
		YAHOO.util.Dom.addClass("noassets", "hidden");
		if (this.pagenumber > 1)
		{
			YAHOO.util.Dom.removeClass("firstpage", "invisible");
			YAHOO.util.Dom.removeClass("prevpage", "invisible");
		}
		else
		{
			YAHOO.util.Dom.addClass("firstpage", "invisible");
			YAHOO.util.Dom.addClass("prevpage", "invisible");
		}
		if (this.pagenumber < this.totalpages)
		{
			YAHOO.util.Dom.removeClass("lastpage", "invisible");
			YAHOO.util.Dom.removeClass("nextpage", "invisible");
		}
		else
		{
			YAHOO.util.Dom.addClass("lastpage", "invisible");
			YAHOO.util.Dom.addClass("nextpage", "invisible");
		}
	}
	YAHOO.util.Dom.get("selectallbox1").checked = false;
}

vB_Asset.prototype.uploadasset = function(obj, assetobj)
{
	// Copy the element, give it a new ID.
	var exists = YAHOO.util.Dom.get("upload_asset_div_" + this.filedataid);
	if (!exists)
	{
		assetobj.showprogress();
		YAHOO.util.Dom.get("uploadform").upload.value = 1;
		var callback =
		{
			success: assetobj.uploadassets,
			failure: function(ajax)
			{
				assetobj.process_ajax_error(ajax);
			},
			scope  : assetobj,
			argument: ["dragdrop"]
		};
		YAHOO.util.Connect.setForm(YAHOO.util.Dom.get("uploadform"));

		var filedata = "";
		if (YAHOO.util.Dom.hasClass(this.getEl(), "ygtvfocus"))
		{
			var assetnode = YAHOO.util.Dom.get("asset_attachment_list");
			// Empty assetnode of any existing assets

			if (assetnode.childNodes.length)
			{
				for (var i = 0; i < assetnode.childNodes.length; i++)
				{
					if (YAHOO.util.Dom.hasClass(assetnode.childNodes[i], "ygtvfocus"))
					{
						filedata += "&filedata[]=" + assetnode.childNodes[i].filedataid;
						YAHOO.util.Dom.removeClass(assetnode.childNodes[i], "ygtvfocus");
						YAHOO.util.Dom.get("checkme_" + assetnode.childNodes[i].filedataid).checked = false;
					}
				}
			}
		}
		else
		{
			filedata += "&filedata[]=" + this.filedataid;
		}
		YAHOO.util.Connect.asyncRequest("POST", "newattachment.php", callback, "ajax=1" + filedata);
	}
	else
	{
		YAHOO.util.Dom.removeClass(this.getEl(), "ygtvfocus");
		YAHOO.util.Dom.get("checkme_" + this.getEl().filedataid).checked = false;
		//alert(assetobj.phrases["asset_already_attached"]);
	}
}

vB_Asset.prototype.moveasset = function(obj, assetobj)
{
	var me = this;
	assetobj.showprogress();
	var filedata = "";
	var nodes = Array();

	if (YAHOO.util.Dom.hasClass(this.getEl(), "ygtvfocus"))
	{
		var assetnode = YAHOO.util.Dom.get("asset_attachment_list");
		// Empty assetnode of any existing assets

		if (assetnode.childNodes.length)
		{
			for (var i = 0; i < assetnode.childNodes.length; i++)
			{
				if (YAHOO.util.Dom.hasClass(assetnode.childNodes[i], "ygtvfocus") && assetnode.childNodes[i].filedataid != this.filedataid)
				{
					filedata += "&filedata[]=" + assetnode.childNodes[i].filedataid;
					nodes[nodes.length] = assetnode.childNodes[i];
				}
			}
		}
	}

	filedata += "&filedata[]=" + this.filedataid;
	nodes[nodes.length] = this.getEl();

	var callback =
	{
		failure: assetobj.process_ajax_error,
		timeout: vB_Default_Timeout,
		success: function (ajax)
		{
			if (assetobj.process_ajax_response(ajax, true))
			{
				this.log("Asset Moved");
				var success = ajax.responseXML.getElementsByTagName("results");
				if (success.length)
				{
					// kill the item
					for (var x = 0; x < nodes.length; x++)
					{
						nodes[x].parentNode.removeChild(nodes[x]);
					}
					assetobj.totalassets = assetobj.totalassets - nodes.length;
					assetobj.endasset = assetobj.endasset - nodes.length;
					assetobj.updateassetsheader();
				}
			}
			assetobj.hideprogress();
		},
		scope  : assetobj
	}
	var postdata = assetobj.preparepostdata("do=moveasset&categoryid=" + obj.targetcategoryid + filedata);
	YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
}

vB_Asset.prototype.movenode = function(obj, assetobj)
{
	var pid = obj.pid;
	assetobj.showprogress();

	var siblings = new Array();
	if (obj.node.parent != null)
	{
		for (var i = 0; i < obj.node.parent.children.length; i++)
		{
			siblings.push(obj.node.parent.children[i].categoryid);
		}
	}

	var callback =
	{
		failure: assetobj.process_ajax_error,
		timeout: vB_Default_Timeout,
		success: assetobj.process_ajax_response,
		scope  : assetobj
	}
	var postdata = assetobj.preparepostdata("do=movenode&categoryid=" + obj.node.categoryid + "&parentid=" + pid + "&siblingids=" + siblings.join(","));
	YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
}

vB_Asset.prototype.editnode = function(e, mouse, assetobj)
{
	assetobj.tree.onEventEditNode(assetobj.currenttextnode);
}

vB_Asset.prototype.deletenode = function(e, mouse, assetobj)
{
	this.parent.hide();
	if (confirm(construct_phrase(assetobj.phrases["are_you_sure_delete_folder_x"], PHP.unhtmlspecialchars(assetobj.currenttextnode.label))))
	{
		assetobj.showprogress();
		var callback =
		{
			failure: vBulletin_AJAX_Error_Handler,
			timeout: vB_Default_Timeout,
			success: assetobj.process_ajax_response,
			success: function (ajax)
			{
				if (assetobj.process_ajax_response(ajax, true))
				{
					delete assetobj.textnodemap[assetobj.currenttextnode.labelElId];
					if (assetobj.tree.is_ancestor(assetobj.tree.selectednode, assetobj.currenttextnode))
					{
						assetobj.clicknode(assetobj.tree.selectednode.parent);
					}
					assetobj.tree.removeNode(assetobj.currenttextnode, true);
					assetobj.tree.render();
				}
				assetobj.hideprogress();
			},
			scope  : assetobj
		}

		var postdata = assetobj.preparepostdata("do=removenode&categoryid=" + assetobj.currenttextnode.categoryid);
		YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
	}
}

vB_Asset.prototype.addnode = function(e, mouse, assetobj)
{
	this.parent.hide();
	var label = PHP.trim(window.prompt(assetobj.phrases["enter_title"], ""));

	if (label && label.length > 0)
	{
		assetobj.showprogress();
		var callback =
		{
			argument:
			{
				"node"  : assetobj.currenttextnode,
				"label" : label
			},
			success:  assetobj.currenttextnode.dynamicLoadComplete ? assetobj.insertnode : assetobj.displaynode,
			failure:  assetobj.process_ajax_error,
			timeout:  vB_Default_Timeout,
			scope:    assetobj
		}
		var returnall = !assetobj.currenttextnode.dynamicLoadComplete ? 1 : 0;

		var postdata = assetobj.preparepostdata("do=insertnode&parentid=" + assetobj.currenttextnode.categoryid + "&title=" + PHP.urlencode(label) + "&returnall=" + returnall);
		YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
	}
}

vB_Asset.prototype.insertnode = function(ajax)
{
	if (ajax.responseXML)
	{
		if (this.process_ajax_response(ajax, true))
		{
			this.log("Node Inserted");
			var categoryid = ajax.responseXML.getElementsByTagName("categoryid");
			if (categoryid.length)
			{
				ajax.argument.node.expand();
				var childnode = new YAHOO.widget.TextNode(ajax.argument.label, ajax.argument.node, false);
				childnode.dynamicLoadComplete = true;
				if (this.tree.getRoot().getNodeCount() == 1)
				{
					this.tree.render();
				}
				this.textnodemap[childnode.labelElId] = childnode;
				this.tree.setnodeinfo(childnode, categoryid[0].firstChild.nodeValue);
				ajax.argument.node.showChildren();
				ajax.argument.node.refresh();
				this.tree.walknode(ajax.argument.node);
				this.tree.fixnode(ajax.argument.node);
			}
		}
	}
	this.hideprogress();
}

vB_Asset.prototype.BeforeShowContextMenu = function(e, mouse, assetobj)
{
	var target = this.contextEventTarget;
	var TextNode = YAHOO.util.Dom.hasClass(target, "asset_category_label") ? target : YAHOO.util.Dom.getAncestorByClassName(target, "asset_category_label");

	var candelete = true;
	var canrename = true;

	this.getItem(1).cfg.setProperty("text", assetobj.phrases["rename"]);
	this.getItem(2).cfg.setProperty("text", assetobj.phrases["delete"]);

	if (TextNode)
	{
		assetobj.currenttextnode = assetobj.textnodemap[target.id];
		// Add Header row to menu?
		this.getItem(0).cfg.setProperty("text", construct_phrase(assetobj.phrases["add_folder_to_x"], assetobj.currenttextnode.label));
	}
	else
	{
		candelete = false;
		canrename = false;
		assetobj.currenttextnode = assetobj.tree.getRoot()
		this.getItem(0).cfg.setProperty("text", assetobj.phrases["add_folder_to_home"]);
	}

	this.getItem(1).cfg.setProperty("disabled", !canrename);
	this.getItem(2).cfg.setProperty("disabled", !candelete);

	var menucontainer = YAHOO.util.Dom.get(assetobj.varname + "contextmenu");
	// Bump the menu's z-index over the overlay's
	//YAHOO.util.Dom.setStyle(menucontainer, "z-index", 12);
	// Move the menu container under the asset container so that it inherits the proper CSS
	if (menucontainer.parentNode.nodeName.toLowerCase() == "body")
	{
		assetobj.container.appendChild(menucontainer);
	}
}

vB_Asset.prototype.load_node_data = function(node, fnLoadComplete)
{
	var assetobj = (this == "RootNode") ? node.tree.parentobj : this;

	if (assetobj.loadingNode[node.categoryid])
	{
		return;
	}
	else
	{
		assetobj.loadingNode[node.categoryid] = true;
	}
	assetobj.showprogress();
	var callback =
	{
		argument:
		{
			"node"           : node,
			"fnLoadComplete" : fnLoadComplete
		},
		success:  assetobj.displaynode,
		failure:  function(ajax)
		{
			if (typeof ajax.argument.fnLoadComplete != "undefined")
			{
				ajax.argument.fnLoadComplete();
				assetobj.loadingNode[node.categoryid] = false;
			}
			assetobj.process_ajax_error(ajax);
		},
		timeout:  vB_Default_Timeout,
		scope:    assetobj
	}
	var postdata = assetobj.preparepostdata("do=loadnode&parentid=" + node.categoryid);
	YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
}

vB_Asset.prototype.process_ajax_error = function(ajax)
{
	vBulletin_AJAX_Error_Handler(ajax);
	this.hideprogress();
}

vB_Asset.prototype.process_ajax_response = function(ajax, skipprogress, reload)
{
	if (ajax.responseXML)
	{
		var text = this.phrases["the_following_errors_occurred"];
		var error = ajax.responseXML.getElementsByTagName("error");
		if (error.length)
		{
			for (var i = 0; i < error.length; i++)
			{
				text += error[i].firstChild.nodeValue;
				if (i < error.length)
				{
					text += "\r\n";
				}
			}
			alert(text);

			if (typeof(reload) == "undefined" || reload == 1)
			{
				this.reload_tree();
			}

			if (typeof(skipprogress) == "undefined" || skipprogress == 1)
			{
				this.hideprogress();
			}
			return false;
		}
		var uploaderror = ajax.responseXML.getElementsByTagName("uploaderror");
		if (uploaderror.length)
		{
			for (var i = 0; i < uploaderror.length; i++)
			{
				text += uploaderror[i].firstChild.nodeValue;
				if (i < uploaderror.length)
				{
					text += "\r\n";
				}
			}
			alert(text);
		}

		if (typeof(skipprogress) == "undefined" || skipprogress == 1)
		{
			this.hideprogress();
		}
		return true;
	}
	if (typeof(skipprogress) == "undefined" || skipprogress == 1)
	{
		this.hideprogress();
	}
	return false;
}

vB_Asset.prototype.displaynode = function(ajax)
{
	this.loadingNode[ajax.argument.node.categoryid] = false;

	if (ajax.responseXML)
	{
		if (this.process_ajax_response(ajax, true))
		{
			this.log("Node Displayed");
			var categories = ajax.responseXML.getElementsByTagName("category");
			if (categories.length)
			{
				for (var i = 0; i < categories.length; i++)
				{
					var tempNode = new YAHOO.widget.TextNode(categories[i].firstChild.nodeValue, ajax.argument.node, false);
					this.textnodemap[tempNode.labelElId] = tempNode;
					this.tree.setnodeinfo(tempNode, YAHOO.util.Dom.getAttribute(categories[i], "categoryid"));
					YAHOO.util.Dom.setStyle("imagereg", "cursor", pointer_cursor);
				}
			}
		}
	}

	if (typeof ajax.argument.fnLoadComplete != "undefined")
	{
		ajax.argument.fnLoadComplete();
		this.tree.walknode(ajax.argument.node);
	}
	else
	{
		this.tree.render();

		if (!ajax.argument.node.isRoot())
		{
			ajax.argument.node.refresh();
			ajax.argument.node.expand();
		}
		ajax.argument.node.dynamicLoadComplete = true;
	}
	this.tree.fixnode(ajax.argument.node);
	this.hideprogress();
}

/**
* Extend YAHOO.util.DD
*
* @param	string Objectid
* @param	Unique identifier for drag and drop objects, limiting interaction between items that share this id
*/
vB_Asset_Node_DD = function(node, id, sGroup, config, container)
{
	vB_Asset_Node_DD.superclass.constructor.call(this, id, sGroup, config);

	this.container = container;
	this.tree_node = node;
	if (node.isRoot())
	{
		// Remove mousedown listener so you can't drag the fake root node around
		YAHOO.util.Event.removeListener(this.id, "mousedown");
	}

	this.initConstraints();

	YAHOO.util.Event.on(window, "resize", function() {
		this.initConstraints();
	}, this, true);
}

YAHOO.extend(vB_Asset_Node_DD, YAHOO.util.DDProxy,
{
	tree_node : null,
	current_target : null,

	initConstraints: function()
	{
		var region = YAHOO.util.Dom.getRegion(this.container);
		var el = this.getEl();

		var xy = YAHOO.util.Dom.getXY(el);

		var width = parseInt(YAHOO.util.Dom.getStyle(el, 'width'), 10);
		var height = parseInt(YAHOO.util.Dom.getStyle(el, 'height'), 10);
		if (!width || !height)
		{
			var elregion = YAHOO.util.Dom.getRegion(el);
			width = elregion.right - elregion.left;
			height = elregion.bottom - elregion.top;
		}

		var left = xy[0] - region.left;
		var right = region.right - xy[0] - width;
		var top = xy[1] - region.top;
		var bottom = region.bottom - xy[1] - height;

		this.resetConstraints();
		this.setXConstraint(left, right - 5);
		this.setYConstraint(top, bottom - 5);
	},

	/**
	* Extend YAHOO.util.DD.startDrag
	*
	* @param	int	X Coordinate
	* @param	int	Y Coordinate
	*/
	startDrag : function(x, y)
	{
		var dragEl = this.getDragEl();
		var clickEl = this.getEl();
		this.animate = true;

		dragEl.innerHTML = clickEl.innerHTML;
		dragEl.className = clickEl.className;

		YAHOO.util.Dom.setStyle(dragEl, "padding", "0 6px 4px 4px");
		YAHOO.util.Dom.setStyle(dragEl, "border", "1px solid #000000");
	},

	onDrag: function(e, id)
	{
		if (this.current_target && typeof this.current_target.tree_node == "undefined")
		{
			return;
		}

		this.remove_drag_classes(this.current_traget);
		if(this.current_target)
		{
			var target = YAHOO.util.DragDropMgr.getDDById(this.current_target);
			if (!target.tree_node.isRoot())
			{
				YAHOO.util.Dom.addClass(this.current_target, "drag" + this.get_drop_location(this.current_target));
			}
			else
			{
				YAHOO.util.Dom.addClass(this.current_target, "dragon");
				YAHOO.util.Dom.addClass(this.current_target, "active");
			}
		}
	},

	onDragOver : function(e, id)
	{
		var target = YAHOO.util.DragDropMgr.getDDById(id);

		if (typeof target.tree_node == "undefined")
		{
			return;
		}

		var location = this.get_drop_location(id);
		var tree = this.tree_node.tree;
		if (tree.is_ancestor(target.tree_node, this.tree_node))
		{
			return;
		}

		this.remove_drag_classes(this.current_target);
		this.current_target = id;

		if (!target.tree_node.isRoot())
		{
			YAHOO.util.Dom.addClass(id, "drag" + this.get_drop_location(id));
		}
		else
		{
			YAHOO.util.Dom.addClass(this.current_target, "dragon");
			YAHOO.util.Dom.addClass(this.current_target, "active");
		}
	},

	onDragOut : function(e, id)
	{
		this.remove_drag_classes(this.current_target);
		this.current_target = null;
	},

	onDragDrop : function(e, id)
	{
		this.remove_drag_classes(this.current_target);

		var target = YAHOO.util.DragDropMgr.getDDById(id);
		var location = this.get_drop_location(id);

		if (typeof target.tree_node == "undefined")
		{
			return;
		}

		var tree = this.tree_node.tree;

		if (tree.is_ancestor(target.tree_node, this.tree_node))
		{
			return false;
		}

		var pid = 0;
		tree.popNode(this.tree_node);
		if (target.tree_node.isRoot() || location == "on")
		{
			if (target.tree_node.dynamicLoadComplete)
			{
				this.tree_node.appendTo(target.tree_node);
				target.tree_node.expand();
			}
			else if (tree.selectednode = this.tree_node)
			{
				tree.selectednode = null;
			}
			pid = target.tree_node.categoryid;
		}
		else if (location == "before")
		{
			this.tree_node.insertBefore(target.tree_node);
			pid = target.tree_node.parent.categoryid;
		}
		else if (location == "after")
		{
			this.tree_node.insertAfter(target.tree_node);
			pid = target.tree_node.parent.categoryid;
		}

		tree.render();
		tree.fixnode(tree.getRoot());
		this.animate = false;
		tree.fireEvent("nodeMove",
			{
				node        : this.tree_node,
				tree        : tree,
				pid         : pid
			}
		);
	},

	endDrag : function(e)
	{
		var srcEl = this.getEl();
		var dragEl = this.getDragEl();

		if (dragEl && this.animate)
		{
			// Show the dragEl element and animate it to the src element's location
			YAHOO.util.Dom.setStyle(dragEl, "visibility", "");
			var a = new YAHOO.util.Motion
			(
				dragEl,
				{
					points:
					{
						to: YAHOO.util.Dom.getXY(srcEl)
					}
				},
				0.2,
				YAHOO.util.Easing.easeOut
			)
			var dragElid = dragEl.id;
			var thisid = this.id;

			// Hide the dragEl and show the source element when finished with the animation
			a.onComplete.subscribe(
				function()
				{
					YAHOO.util.Dom.setStyle(dragElid, "visibility", "hidden");
					YAHOO.util.Dom.setStyle(thisid, "visibility", "");
					YAHOO.util.Dom.get(dragElid).innerHTML = "";
				}
			);
			a.animate();
		}
	},

	remove_drag_classes : function(id)
	{
		if (id)
		{
			YAHOO.util.Dom.removeClass(id, "dragbefore");
			YAHOO.util.Dom.removeClass(id, "dragafter");
			YAHOO.util.Dom.removeClass(id, "dragon");
			YAHOO.util.Dom.removeClass(id, "active");
		}
	},

	get_drop_location : function (id)
	{
		var drop_point =  YAHOO.util.DragDropMgr.interactionInfo.point;
		var target_region = YAHOO.util.Dom.getRegion(id);

		var y_margin = (target_region.bottom - target_region.top) /3;
		if (drop_point.top < target_region.top + y_margin)
		{
			return "before";
		}
		else if (drop_point.top > target_region.bottom - y_margin)
		{
			return "after";
		}
		else
		{
			return "on";
		}
	}
}
);

/**
* Extend YAHOO.util.DD for Attachments
*
* @param	string Objectid
* @param	Unique identifier for drag and drop objects, limiting interaction between items that share this id
*/
vB_Asset_DD_Attachment = function(id, sGroup, config)
{
	vB_Asset_DD_Attachment.superclass.constructor.call(this, id, sGroup, config);

	var el = this.getDragEl();
	YAHOO.util.Dom.setStyle(el, "opacity", 0.67);
	this.goingLeft = false;
	this.lastY = 0;
	this.vB_Asset = vB_Asset;
	this.initConstraints();
	YAHOO.util.Event.on(window, "resize", function() {
		this.initConstraints();
	}, this, true);
}

YAHOO.extend(vB_Asset_DD_Attachment, YAHOO.util.DDProxy,
{
	/**
	* Extend YAHOO.util.DD.startDrag
	*
	* @param	int	X Coordinate
	* @param	int	Y Coordinate
	*/
	init: function()
	{
		vB_Asset_DD_Attachment.superclass.init.apply(this, arguments);
	},

	initConstraints: function()
	{
		var yui_layout_bd = YAHOO.util.Dom.getAncestorByClassName("asset_upload_container", "yui-layout-bd");
		var region = YAHOO.util.Dom.getRegion(yui_layout_bd);
		var el = this.getEl();
		var xy = YAHOO.util.Dom.getXY(el);
		var width = parseInt(YAHOO.util.Dom.getStyle(el, 'width'), 10);
		var height = parseInt(YAHOO.util.Dom.getStyle(el, 'height'), 10);
		var left = xy[0] - region.left;
		var right = region.right - xy[0] - width;
		var top = xy[1] - region.top;
		var bottom = region.bottom - xy[1] - height;

		this.resetConstraints();
		this.setXConstraint(left, right - 5);
		this.setYConstraint(top, bottom - 5);
	},

	startDrag : function(x, y)
	{
		var dragEl = this.getDragEl();
		var clickEl = this.getEl();
		this.animate = true;
		YAHOO.util.Dom.setStyle(clickEl, "visibility", "hidden");

		var listitems = clickEl.parentNode.getElementsByTagName("div");
		clickEl.parentNode.blockorder = "";
		var count = 1;
		for (var i = 0; i < listitems.length; i++)
		{
			if (listitems[i].id.match(/^upload_asset_div_(\d+)$/))
			{
				clickEl.parentNode.blockorder += listitems[i].id;
			}
		}

		var match = clickEl.id.match(/^upload_asset_div_(\d+)$/);
		var currentfiledataid = match[1];

		YAHOO.util.Dom.setStyle("asset_delete_" + currentfiledataid, "display", "none");

		dragEl.innerHTML = clickEl.innerHTML;
		dragEl.className = clickEl.className;
		YAHOO.util.Dom.removeClass(dragEl, "ygtvfocus");
		// remove input elements from drag el
		var inputs = dragEl.getElementsByTagName("input");
		if (inputs.length)
		{
			var length = inputs.length;
			for (var x = 0; x < length; x++)
			{
				inputs[0].parentNode.removeChild(inputs[0]);
			}
		}

		YAHOO.util.Dom.setStyle(dragEl, "border", "none");
		YAHOO.util.Dom.setStyle(dragEl, "padding", "0");
	},

	onDrag: function(e, id)
	{
		var y = YAHOO.util.Event.getPageY(e);

		if (y < this.lastY)
		{
			this.goingLeft = true;
		}
		else if (y > this.lastY)
		{
			this.goingLeft = false;
		}

		this.lastY = y;
	},

	onDragOver : function(e, id)
	{
		var srcEl = this.getEl();
		var destEl = YAHOO.util.Dom.get(id);

		if (destEl.nodeName.toLowerCase() == "div" && (destEl.id.match(/^upload_asset_div_(\d+)$/)))
		{
			var orig_p = srcEl.parentNode;
			var p = destEl.parentNode;

			if (this.goingLeft)
			{
				p.insertBefore(srcEl, destEl); // insert above
			}
			else
			{
				p.insertBefore(srcEl, destEl.nextSibling); // insert below
			}
		}

		YAHOO.util.DDM.refreshCache();
	},

	onDragOut : function(e, id)
	{},

	onDragDrop : function(e, id)
	{
		this.animate = false;
		this.fireEvent("assetUpload");
		YAHOO.util.Dom.setStyle(this.getDragEl(), "visibility", "hidden");
	},

	endDrag : function(e)
	{
		var srcEl = this.getEl();
		var dragEl = this.getDragEl();

		var blockorder = "";
		var submitstring = "";
		var listitems = srcEl.parentNode.getElementsByTagName("div");
		var count = 1;
		for (var i = 0; i < listitems.length; i++)
		{
			if (listitems[i].id.match(/^upload_asset_div_(\d+)$/))
			{
				blockorder += listitems[i].id;
				submitstring += "&attachment[" + listitems[i].attachmentid + "]=" + count;
				count++;
			}
		}

		// Block order changed - update data
		if (blockorder != srcEl.parentNode.blockorder)
		{
			var callback =
			{
				timeout: vB_Default_Timeout,
				scope  : this
			};
			var postdata = assetobj.preparepostdata("do=orderattachments&ajax=1" + submitstring);
			YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);
		}

		// Show the dragEl element and animate it to the src element's location
		YAHOO.util.Dom.setStyle(dragEl, "visibility", "");
		var a = new YAHOO.util.Motion
		(
			dragEl,
			{
				points:
				{
					to: YAHOO.util.Dom.getXY(srcEl)
				}
			},
			0.2,
			YAHOO.util.Easing.easeOut
		)
		var dragElid = dragEl.id;
		var thisid = this.id;

		// Hide the dragEl and show the source element when finished with the animation
		a.onComplete.subscribe(
			function()
			{
				YAHOO.util.Dom.setStyle(dragElid, "visibility", "hidden");
				YAHOO.util.Dom.setStyle(thisid, "visibility", "");
				YAHOO.util.Dom.get(dragElid).innerHTML = "";
			}
		);
		a.animate();

	}
}
);

/**
* Extend YAHOO.util.DD for Assets
*
* @param	string Objectid
* @param	Unique identifier for drag and drop objects, limiting interaction between items that share this id
*/
vB_Asset_DD = function(id, sGroup, config, targetcontainer)
{
	vB_Asset_DD.superclass.constructor.call(this, id, sGroup, config);

	var el = this.getDragEl();
	YAHOO.util.Dom.setStyle(el, "opacity", 0.67);
	this.targetcontainer = targetcontainer;
}

YAHOO.extend(vB_Asset_DD, YAHOO.util.DDProxy,
{
	/**
	* Extend YAHOO.util.DD.startDrag
	*
	* @param	int	X Coordinate
	* @param	int	Y Coordinate
	*/
	init: function()
	{
		vB_Asset_DD.superclass.init.apply(this, arguments);
		this.initConstraints();

		YAHOO.util.Event.on(window, "resize", function() {
			this.initConstraints();
		}, this, true);
	},

	initConstraints: function()
	{
		var region = YAHOO.util.Dom.getRegion("layout-doc");
		var el = this.getEl();
		var xy = YAHOO.util.Dom.getXY(el);
		var width = parseInt(YAHOO.util.Dom.getStyle(el, 'width'), 10);
		var height = parseInt(YAHOO.util.Dom.getStyle(el, 'height'), 10);
		var left = xy[0] - region.left;
		var right = region.right - xy[0] - width;
		var top = xy[1] - region.top;
		var bottom = region.bottom - xy[1] - height;

		this.resetConstraints();
		this.setXConstraint(left, right - 5);
		this.setYConstraint(top, bottom - 5);
	},

	startDrag : function(x, y)
	{
		var dragEl = this.getDragEl();
		var clickEl = this.getEl();
		this.animate = true;

		var match = clickEl.id.match(/^(?:upload_)?asset_div_(\d+)$/);
		var currentfiledataid = match[1];

		YAHOO.util.Dom.setStyle("asset_delete_" + currentfiledataid, "display", "none");

		var counter = 0;
		if (YAHOO.util.Dom.hasClass(clickEl, "ygtvfocus"))
		{
			dragEl.innerHTML = "";
			YAHOO.util.Dom.setStyle(dragEl, "width", "");
			YAHOO.util.Dom.setStyle(dragEl, "height", "");
			YAHOO.util.Dom.removeClass(dragEl, "asset_div");
			YAHOO.util.Dom.addClass(dragEl, "composite");
			var assetnode = YAHOO.util.Dom.get("asset_attachment_list");
			for (var i = 0; i < assetnode.childNodes.length; i++)
			{
				if (YAHOO.util.Dom.hasClass(assetnode.childNodes[i], "ygtvfocus"))
				{
					var newdiv = dragEl.appendChild(document.createElement("div"));
					var newimg = newdiv.appendChild(document.createElement("img"));
					var img = YAHOO.util.Dom.getElementsByClassName("asset_attachment", "img", assetnode.childNodes[i]);
					if (!img.length)
					{
						var img = YAHOO.util.Dom.getElementsByClassName("asset_attachment_nothumb", "img", assetnode.childNodes[i])
					}
					newimg.src = img[0].src;
					counter++;
					if (counter > 15)
					{
						break;
					}
				}
			}
		}

		if (counter <= 1)
		{
			dragEl.innerHTML = clickEl.innerHTML;
			dragEl.className = clickEl.className;
			YAHOO.util.Dom.removeClass(dragEl, "ygtvfocus");
			// remove input elements from drag el
			var inputs = dragEl.getElementsByTagName("input");
			if (inputs.length)
			{
				var length = inputs.length;
				for (var x = 0; x < length; x++)
				{
					inputs[0].parentNode.removeChild(inputs[0]);
				}
			}

			var isthumb = YAHOO.util.Dom.getElementsByClassName("thumbnail", "div", clickEl);
			var islist = YAHOO.util.Dom.getElementsByClassName("listview", "div", clickEl);
			var isdetailed = YAHOO.util.Dom.getElementsByClassName("detailedview", "div", clickEl);
			if (isthumb.length || isdetailed.length)
			{
				YAHOO.util.Dom.setStyle(dragEl, "border", "none");
				YAHOO.util.Dom.setStyle(dragEl, "padding", "0");
			}
			else if (islist.length)
			{
				YAHOO.util.Dom.setStyle(dragEl, "padding", "0 6px 4px 4px");
				YAHOO.util.Dom.setStyle(dragEl, "border", "1px solid #000000");
			}
		}
	},

	onDrag: function(e, id)
	{},

	onDragOver : function(e, id)
	{
		var target = YAHOO.util.DragDropMgr.getDDById(id);
		if (typeof target.tree_node != "undefined" && target.tree_node != target.tree_node.tree.selectednode)
		{
			YAHOO.util.Dom.addClass(id, "dragon");
			YAHOO.util.Dom.addClass(id, "active");
		}
	},

	onDragOut : function(e, id)
	{
		var target = YAHOO.util.DragDropMgr.getDDById(id);
		if (typeof target.tree_node != "undefined" && target.tree_node != target.tree_node.tree.selectednode)
		{
			YAHOO.util.Dom.removeClass(id, "dragon");
			YAHOO.util.Dom.removeClass(id, "active");
		}
	},

	onDragDrop : function(e, id)
	{
		var target = YAHOO.util.DragDropMgr.getDDById(id);

		if (typeof target.tree_node != "undefined" && target.tree_node != target.tree_node.tree.selectednode)
		{
			YAHOO.util.Dom.removeClass(id, "dragon");
			YAHOO.util.Dom.removeClass(id, "active");
			this.animate = false;
			// abstracting this to be event based isn't working since these classes are quite intertwined
			this.fireEvent("assetMove",
			{
				targetcategoryid : target.tree_node.categoryid
			});
		}
		else if (target.id == this.targetcontainer)
		{
			this.animate = false;
			this.fireEvent("assetUpload");
		}

		YAHOO.util.Dom.setStyle(this.getDragEl(), "visibility", "hidden");
	},

	endDrag : function(e)
	{
		var srcEl = this.getEl();
		var dragEl = this.getDragEl();

		if (dragEl && this.animate)
		{
			// Show the dragEl element and animate it to the src element's location
			YAHOO.util.Dom.setStyle(dragEl, "visibility", "");
			var a = new YAHOO.util.Motion
			(
				dragEl,
				{
					points:
					{
						to: YAHOO.util.Dom.getXY(srcEl)
					}
				},
				0.2,
				YAHOO.util.Easing.easeOut
			)
			var dragElid = dragEl.id;
			var thisid = this.id;

			// Hide the dragEl and show the source element when finished with the animation
			a.onComplete.subscribe(
				function()
				{
					YAHOO.util.Dom.setStyle(dragElid, "visibility", "hidden");
					YAHOO.util.Dom.setStyle(thisid, "visibility", "");
					YAHOO.util.Dom.get(dragElid).innerHTML = "";
				}
			);
			a.animate();
		}
	}
}
);

vB_Treeview = function(id, oConfig, parentobj, container)
{
	vB_Treeview.superclass.constructor.apply(this, arguments);
	this.createEvent("nodeMove");
	this.createEvent("render");
	this.parentobj = parentobj;
	this.container = container;
}

YAHOO.extend(vB_Treeview, YAHOO.widget.TreeView,
{
	fixnode : function(node)
	{
		// Replace the <a anchors with <div anchors so that our +/- images aren't overridden when we have long label text
		// See .ygtvspacer in the CSS, we increase the width to what it should be
		nodeelm = YAHOO.util.Dom.get(node.getElId());
		var as = nodeelm.getElementsByTagName("a");
		if (as.length)
		{
			var length = as.length;
			for (var x = 0; x < length; x++)
			{
				var newdiv = document.createElement("div");
				YAHOO.util.Dom.setAttribute(newdiv, "href", "#");
				newdiv.innerHTML = "&nbsp;";
				YAHOO.util.Dom.addClass(newdiv, "ygtvspacer");
				as[0].parentNode.replaceChild(newdiv, as[0]);
			}
		}
	},

	render : function()
	{
		vB_Treeview.superclass.render.apply(this, arguments);
		this.walknode(this.getRoot());
		this.fixnode(this.getRoot());
		this.fireEvent("render");
	},

	walknode : function(node, initConstraints)
	{
		if (!node.isRoot())
		{
			YAHOO.util.Dom.setStyle(node.labelElId, "cursor", pointer_cursor);
			var ddobj = YAHOO.util.DragDropMgr.getDDById(node.labelElId);
			if (ddobj)
			{
				// Verify that DDobj hasn't been wiped out
				if (!YAHOO.util.DragDropMgr.verifyEl(ddobj._domRef))
				{
					delete(ddobj);
					node.ddobj = new vB_Asset_Node_DD(node, node.labelElId, "vB_Asset", "", this.container);
				}
				else if (typeof(initConstraints) != "undefined")
				{
					node.ddobj.initConstraints();
				}
			}
			else
			{
				node.ddobj = new vB_Asset_Node_DD(node, node.labelElId, "vB_Asset", "", this.container);
			}
			if (this.selectednode && this.selectednode.categoryid == node.categoryid && this.selectednode != "RootNode")
			{
				this.selectednode = node;
				YAHOO.util.Dom.addClass(this.selectednode.getLabelEl().parentNode.parentNode, "ygtvfocus");
			}
		}

		for (var i = 0; i < node.children.length; i++)
		{
			this.walknode(node.children[i], initConstraints);
		}
	},

	is_ancestor : function(n, a)
	{
		current = n;
		while (current)
		{
			if (current.getEl().id == a.getEl().id)
			{
				return true;
			}
			current = current.parent;
		}
		return false;
	},

	savelabel : function(H)
	{
		var value = PHP.trim(H.inputElement.value);

		if (value == "")
		{
			return;
		}

		var assetobj = H.node.tree.parentobj;
		assetobj.showprogress();
		var callback =
		{
			failure: assetobj.process_ajax_error,
			timeout: vB_Default_Timeout,
			success: assetobj.process_ajax_response,
			scope  : assetobj
		}
		var postdata = assetobj.preparepostdata("do=updatelabel&categoryid=" + H.node.categoryid + "&title=" + PHP.urlencode(value));
		YAHOO.util.Connect.asyncRequest("POST", "assetmanage.php", callback, postdata);

		value = PHP.htmlspecialchars(value);
		H.node.label = value;
		H.node.data.label = value;
		H.node.getLabelEl().innerHTML = value;
	},

	setnodeinfo : function(node, categoryid)
	{
		node.iconMode = false;
		node.editable = true;
		// Class controlling the label's style
		node.labelStyle = 'asset_category_label';
		node.nowrap = true;
		node.saveEditorValue = this.savelabel;
		node.fillEditorContainer = this.preparelabel;
		node.categoryid = categoryid;
	},

	_nodeEditing : function()
	{
		// Deal with the folder rename popup not having a clue what do with RTL
		vB_Treeview.superclass._nodeEditing.apply(this, arguments);
		var textdirection = document.body.dir  == "rtl" ? "right" : "left";
		if (textdirection == "right")
		{
			var editors = YAHOO.util.Dom.getElementsByClassName("ygtv-label-editor", "div");
			if (editors.length)
			{
				var editbox = editors[0];
				var span = YAHOO.util.Dom.getRegion(arguments[0].getContentEl());
				var region = YAHOO.util.Dom.getRegion(editbox);
				YAHOO.util.Dom.setStyle(editbox, 'left', (region.left - region.width + span.width) + 'px');
			}
		}
	},

	preparelabel: function(I)
	{
		var H;
		if (I.nodeType != this._type)
		{
			I.nodeType = this._type;
			I.saveOnEnter = true;
			I.node.destroyEditorContents(I);
			I.inputElement = H = I.inputContainer.appendChild(document.createElement("input"));
		}
		else
		{
			H = I.inputElement;
		}
		H.value = PHP.unhtmlspecialchars(this.label);
		H.focus();
		H.select();
	}
});

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 26385 $
|| ####################################################################
\*======================================================================*/