/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Adds onclick events to appropriate elements for thread rating
*
* @param	string	The ID of the form that contains the rating options
*/
function vB_AJAX_ThreadRate_Init(formid, threadid)
{
	var formobj = YAHOO.util.Dom.get(formid);
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2) && formobj)
	{
		var rateobj = new vB_AJAX_ThreadRate(formobj, threadid); 

		for (var i = 0; i < formobj.elements.length; i++)
		{
			if (formobj.elements[i].type == 'submit')
			{
				// prevent the form from submitting when clicking the submit button
				var sbutton = formobj.elements[i];
				var button = document.createElement('input');
				button.type = 'button';
				button.className = sbutton.className;
				button.value     = sbutton.value;
//				button.onclick   = vB_AJAX_ThreadRate.prototype.form_click;
				YAHOO.util.Event.addListener(button, 'click', rateobj.form_click, undefined, rateobj);
				sbutton.parentNode.insertBefore(button, sbutton);
				sbutton.parentNode.removeChild(sbutton);
			}
		}
	}
};

/**
* Class to handle thread rating
*
* @param	object	The form object containing the vote options
*/
function vB_AJAX_ThreadRate(formobj, threadid)
{
	this.formobj = formobj;
	this.threadid = threadid;



	// Output object
	this.output_element_id = 'threadrating_current';
};

/**
* Handles AJAX request response
*
* @param	object	YUI AJAX
*/
vB_AJAX_ThreadRate.prototype.handle_ajax_response = function(ajax)
{
	if (ajax.responseXML)
	{
		//close the menu.
		YAHOO.vBulletin.vBPopupMenu.close_all();
		
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			var threshold = this.get_child_value(ajax.responseXML, 'vote_threshold_met');
			if (threshold)
			{
				var rating = this.get_child_value(ajax.responseXML, 'rating');
				var rating_elements = YAHOO.util.Dom.getElementsByClassName('rating', undefined, this.output_element_id);
				console.log(rating_elements);

				//update current rating element should only be one, but you never know
				for (var i = 0; i < rating_elements.length; i++)
				{
					//remove any existing ratings classes -- will break if we increase the 
					//number of stars, but is not likely and more complex processing would 
					//be a pain.
					for (var j = 1; j <= 5; j++)
					{
						YAHOO.util.Dom.removeClass(rating_elements[i], 'r' + j);
					}

					YAHOO.util.Dom.addClass(rating_elements[i], 'r' + rating);
				}

				YAHOO.util.Dom.removeClass(this.output_element_id, 'hidden');
			}

			var message = ajax.responseXML.getElementsByTagName('message');
			if (message.length)
			{
				alert(message[0].firstChild.nodeValue);
			}
		}
	}
}

vB_AJAX_ThreadRate.prototype.get_child_value = function(xml, name)
{
	var value = xml.getElementsByTagName(name);
	if (value.length && value[0].firstChild)
	{
		return value[0].firstChild.nodeValue;
	}
	return "";
}

/**
* Places the vote
*/
vB_AJAX_ThreadRate.prototype.rate = function()
{
	// vB_Hidden_Form object to handle form variables
	var pseudoform = new vB_Hidden_Form('threadrate.php');
	pseudoform.add_variable('ajax', 1);
	pseudoform.add_variables_from_object(this.formobj);

	if (pseudoform.fetch_variable('vote') != null)
	{
		YAHOO.util.Connect.asyncRequest(
			"POST", 
			"threadrate.php?t=" + this.threadid + "&vote=" + PHP.urlencode(pseudoform.fetch_variable("vote")), 
			{
				success: this.handle_ajax_response,
				failure: this.handle_ajax_error,
				timeout: vB_Default_Timeout,
				scope: this
			}, 
			SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&" + pseudoform.build_query_string()
		);
	}
};

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
vB_AJAX_ThreadRate.prototype.handle_ajax_error = function(ajax)
{
	vBulletin_AJAX_Error_Handler(ajax);
	this.formobj.submit();
}

/**
* Handles the form 'submit' action
*/
vB_AJAX_ThreadRate.prototype.form_click = function()
{
//	var AJAX_ThreadRate = new vB_AJAX_ThreadRate(this.form);
//	AJAX_ThreadRate.rate();
	this.rate();
	return false;
};

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 32878 $
|| ####################################################################
\*======================================================================*/
