/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// Handle Post Icon Preview
vB_XHTML_Ready.subscribe(init_tabslight);

function init_tabslight()
{
	var tabsets = YAHOO.util.Dom.getElementsByClassName("tabslight", "dl", document.body);

	for (var i = 0; i < tabsets.length; i++)
	{
		if (YAHOO.util.Dom.hasClass(tabsets[i], "js"))
		{
			new TabsLightJS(tabsets[i]);
		}
	}
}

function TabsLightJS(tabset)
{
	this.tabset = YAHOO.util.Dom.get(tabset);
	this.tabsetid = tabset.id;
	this.selected_index = null;

	this.tabs = this.tabset.getElementsByTagName("dd");
	for (var i = 0; i < this.tabs.length; i++)
	{
		this.init_tab(i);
	}
}

TabsLightJS.prototype.init_tab = function(index)
{
	// get and index tab link
	var tablink = this.tabs[index].getElementsByTagName("a")[0];
	tablink.index = index;

	// handle tab clicks
	YAHOO.util.Event.on(tablink, "click", this.click_tab, this, true);

	// selected tab?
	if (YAHOO.util.Dom.hasClass(this.tabs[index], "selected"))
	{
		this.selected_index = index;
	}
	else
	{
		YAHOO.util.Dom.setStyle(this.tabsetid + index, "display", "none");
	}
}

TabsLightJS.prototype.click_tab = function(e)
{
	var tablink = YAHOO.util.Event.getTarget(e);

	YAHOO.util.Event.stopEvent(e);

	if (this.selected_index != tablink.index)
	{
		YAHOO.util.Dom.removeClass(this.tabs[this.selected_index], "selected");
		YAHOO.util.Dom.setStyle(this.tabsetid + this.selected_index, "display", "none");

		this.selected_index = tablink.index;

		YAHOO.util.Dom.addClass(this.tabs[this.selected_index], "selected");
		YAHOO.util.Dom.setStyle(this.tabsetid + this.selected_index, "display", "");

		if (!YAHOO.util.Dom.hasClass(this.tabs[this.selected_index], "notabfocus"))
		{
			try
			{
				YAHOO.util.Dom.get(this.tabsetid + this.selected_index).getElementsByTagName("input")[0].focus();
				if (YAHOO.util.Dom.get(this.tabsetid + this.selected_index).getElementsByTagName("input")[0].type != "file")
				{
					YAHOO.util.Dom.get(this.tabsetid + this.selected_index).getElementsByTagName("input")[0].click();
				}
			}
			catch(e) {}
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 26385 $
|| ####################################################################
\*======================================================================*/