/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

var vB_ThreadTitle_Editor = null;

if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
{
	vB_XHTML_Ready.subscribe(function () { vB_AJAX_Threadlist_Init('threadlist'); });
}

/**
* Adds ondblclick events to appropriate elements for title editing
*
* @package	vBulletin
* @version	$Revision: 28338 $
* @date		$Date: 2008-11-07 05:56:44 -0800 (Fri, 07 Nov 2008) $
* @author	Kier Darby, vBulletin Development Team
*
* @param	string	The ID of the thread list element (usually 'threadslist')
*/
function vB_AJAX_Threadlist_Init(threadlistid)
{
		// This check is above outside the function but here as well for any calls to vB_AJAX_ThreadList_Init made outside of this file
		if (!YAHOO.util.Dom.get(threadlistid) || !AJAX_Compatible || (typeof(vb_disable_ajax) != "undefined" && vb_disable_ajax >= 2))
		{
			return;
		}

		var threadbits = YAHOO.util.Dom.getElementsByClassName("threadbit", "li", threadlistid);
		for (var i = 0; i < threadbits.length; i++)
		{
			if (threadbits[i].id.match(/^thread_/))
			{
				YAHOO.util.Event.on(threadbits[i], "dblclick", vB_AJAX_ThreadList_Events.prototype.threadtitle_doubleclick);

				/* Attach closeopen control to statusicon */
				var statuslinks = YAHOO.util.Dom.getElementsByClassName("threadstatus", "a", threadbits[i]);
				if (statuslinks.length > 0)
				{
					statuslinks[0].style.cursor = pointer_cursor;
					YAHOO.util.Event.on(statuslinks[0], "dblclick", vB_AJAX_ThreadList_Events.prototype.threadicon_doubleclick);
				}
			}
		}
}

// #############################################################################
// vB_AJAX_OpenClose
// #############################################################################

/**
* Class to handle opening and closing of threads from forumdisplay with XML-HTTP
*
* @package	vBulletin
* @version	$Revision: 28338 $
* @date		$Date: 2008-11-07 05:56:44 -0800 (Fri, 07 Nov 2008) $
* @author	Kier Darby, vBulletin Development Team
*
* @param	object	The clickable status icon image for the thread
*/
function vB_AJAX_OpenClose(statuslink)
{
	this.statuslink = statuslink;
	this.threadbit = false;

	if (!this.threadbit)
	{
		this.threadbit = YAHOO.util.Dom.getAncestorByClassName(this.statuslink, 'threadbit');
		this.threadid = this.threadbit.id.substr(this.threadbit.id.lastIndexOf('_') + 1);
	}

	this.closed = YAHOO.util.Dom.hasClass(this.threadbit, 'lock');

	// =============================================================================
	// vB_AJAX_OpenClose methods

	/**
	* Function to switch the open/closed state of a thread / thread status icon
	*/
	this.toggle = function()
	{
		YAHOO.util.Connect.asyncRequest("POST", "ajax.php?do=updatethreadopen&t=" + this.threadid, {
			success: this.handle_ajax_response,
			failure: vBulletin_AJAX_Error_Handler,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=updatethreadopen&t=" + this.threadid + '&open=' + this.closed);
	}

	/**
	* Handles AJAX response request
	*
	* @param	object	YUI AJAX
	*/
	this.handle_ajax_response = function(ajax)
	{
		if (ajax.responseXML)
		{
			var status = ajax.responseXML.getElementsByTagName('status')[0].firstChild.nodeValue;
			if ('closed' == status)
			{
				YAHOO.util.Dom.addClass(this.threadbit, 'lock');
				this.closed = true;
			}
			else if ('open' == status)
			{
				YAHOO.util.Dom.removeClass(this.threadbit, 'lock');
				this.closed = false;
			}
		}
	}

	// send the data
	this.toggle();
}

// #############################################################################
// vB_AJAX_TitleEdit
// #############################################################################

/**
* Class to handle thread title editing with XML-HTTP
*
* @param	object	The <td> containing the title element
*/
function vB_AJAX_TitleEdit(obj)
{
	this.obj = obj;
	this.threadid = this.obj.id.substr(this.obj.id.lastIndexOf('_') + 1);
	this.linkobj = fetch_object('thread_title_' + this.threadid);
	this.container = this.linkobj.parentNode;
	this.editobj = null;
	this.xml_sender = null;

	this.origtitle = '';
	this.editstate = false;

	this.progress_image = new Image();
	this.progress_image.src = IMGDIR_MISC + "/11x11progress.gif";

	// =============================================================================
	// vB_AJAX_TitleEdit methods

	/**
	* Function to initialize the editor for a thread title
	*/
	this.edit = function()
	{
		if (this.editstate == false)
		{
			// create the new editor input box properties...
			this.inputobj = document.createElement('input');
			this.inputobj.type = 'text';
			this.inputobj.size = 50;
			// read in value for titlemaxchars from $vbulletin->options['titlemaxchars'], specified in template or default to 85
			this.inputobj.maxLength = ((typeof(titlemaxchars) == "number" && titlemaxchars > 0) ? titlemaxchars : 85);
			this.inputobj.style.width = Math.max(this.linkobj.offsetWidth, 250) + 'px';
			this.inputobj.className = 'textbox';
			this.inputobj.value = PHP.unhtmlspecialchars(this.linkobj.innerHTML);
			this.inputobj.title = this.inputobj.value;

			// ... and event handlers
			this.inputobj.onblur = vB_AJAX_ThreadList_Events.prototype.titleinput_onblur;
			this.inputobj.onkeypress = vB_AJAX_ThreadList_Events.prototype.titleinput_onkeypress;

			// insert the editor box and select it
			this.editobj = this.container.insertBefore(this.inputobj, this.linkobj);
			this.editobj.select();

			// store the original text
			this.origtitle = this.linkobj.innerHTML;

			// hide the link object
			this.linkobj.style.display = 'none';

			// declare that we are in an editing state
			this.editstate = true;
		}
	}

	/**
	* Function to restore a thread title in the editing state
	*/
	this.restore = function()
	{
		if (this.editstate == true)
		{
			// do we actually need to save?
			if (this.editobj.value != this.origtitle)
			{
				this.container.appendChild(this.progress_image);
				this.save(this.editobj.value);
			}
			else
			{
				// set the new contents for the link
				this.linkobj.innerHTML = this.editobj.value;
			}

			// remove the editor box
			this.container.removeChild(this.editobj);

			// un-hide the link
			this.linkobj.style.display = '';

			// declare that we are in a normal state
			this.editstate = false;
			this.obj = null;
		}
	}

	/**
	* Function to save an edited thread title
	*
	* @param	string	Edited title text
	*
	* @return	string	Validated title text
	*/
	this.save = function(titletext)
	{
		YAHOO.util.Connect.asyncRequest("POST", "ajax.php?do=updatethreadtitle&t=" + this.threadid, {
			success: this.handle_ajax_response,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=updatethreadtitle&t=" + this.threadid + '&title=' + PHP.urlencode(titletext));
	}

	/**
	* Handles AJAX response request
	*
	* @param	object	YUI AJAX
	*/
	this.handle_ajax_response = function(ajax)
	{
		if (ajax.responseXML)
		{
			this.linkobj.innerHTML = ajax.responseXML.getElementsByTagName('linkhtml')[0].firstChild.nodeValue;
			this.linkobj.href = ajax.responseXML.getElementsByTagName('linkhref')[0].firstChild.nodeValue;
		}

		this.container.removeChild(this.progress_image);
		vB_ThreadTitle_Editor.obj = null;
	}

	// start the editor
	this.edit();
}

// #############################################################################
// Threadlist event handlers

/**
* Class to handle events in the threadlist
*/
function vB_AJAX_ThreadList_Events()
{
}

/**
* Handles double-clicking on thread title cells to initialize title edit
*/
vB_AJAX_ThreadList_Events.prototype.threadtitle_doubleclick = function(e)
{
	if (vB_ThreadTitle_Editor && vB_ThreadTitle_Editor.obj == this)
	{
		return false;
	}
	else
	{
		try
		{
			vB_ThreadTitle_Editor.restore();
		}
		catch(e) {}

		vB_ThreadTitle_Editor = new vB_AJAX_TitleEdit(this);
	}
};

/**
* Handles double-clicking on thread icon cells to toggle open/close state
*/
vB_AJAX_ThreadList_Events.prototype.threadicon_doubleclick = function(e)
{
	YAHOO.util.Event.stopPropagation(e);
	openclose = new vB_AJAX_OpenClose(this);
};

/**
* Handles blur events on thread title input boxes
*/
vB_AJAX_ThreadList_Events.prototype.titleinput_onblur = function(e)
{
	vB_ThreadTitle_Editor.restore();
};

/**
* Handles keypress events on thread title input boxes
*/
vB_AJAX_ThreadList_Events.prototype.titleinput_onkeypress = function (e)
{
	e = e ? e : window.event;
	switch (e.keyCode)
	{
		case 13: // return / enter
		{
			vB_ThreadTitle_Editor.inputobj.blur();
			return false;
		}
		case 27: // escape
		{
			vB_ThreadTitle_Editor.inputobj.value = vB_ThreadTitle_Editor.origtitle;
			vB_ThreadTitle_Editor.inputobj.blur();
			return true;
		}
	}
};

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 28338 $
|| ####################################################################
\*======================================================================*/