/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* vBulletin Editor Class
*
* Activates any HTML controls for an editor
*
* @package	vBulletin
* @version	$Revision: 30309 $
* @date		$Date: 2009-04-15 17:46:34 +0100 (Wed, 15 Apr 2009) $
* @author	Kier Darby, Scott MacVicar, Mike Sullivan, vBulletin Development Team
*
* @param	string	Unique key for this editor
* @param	boolean	Initialise to WYSIWYG mode?
* @param	string	Forumid / Calendar etc.
* @param	boolean	Parse smilies?
* @param	string	(Optional) Initial text for the editor
* @param	string	(Optional) Extra arguments to pass when switching editor modes
*/
function vB_Text_Editor_CMS(editorid, mode, parsetype, parsesmilies, initial_text, ajax_extra, content)
{
	this._construct(editorid, mode, parsetype, parsesmilies, initial_text, ajax_extra, content);
	this.init(initial_text);
}

vBulletin.extend(vB_Text_Editor_CMS, vB_Text_Editor);
vB_Text_Editor_CMS.prototype._parent = vB_Text_Editor.prototype;

/* Methods */

vB_Text_Editor_CMS.prototype._construct = function(editorid, mode, parsetype, parsesmilies, initial_text, ajax_extra, content)
{
	this._parent._construct.call(this, editorid, mode, parsetype, parsesmilies, initial_text, ajax_extra, content);

	this.dialog_props = {};
	this.dialog = null;
	this.dialog_overlay = null;
	this.dialog_submitted = false;
	this.dialog_confirm_callback = null;

	this.formatstate = null;
	this.formatoptions = {
		'p'  : {'description' : vbphrase['formatting_normal']},
		'pagebreak' : {'description' : vbphrase['page_break'], 'extra' : 'pagebreak', 'tag' : 'h3'},
		'h1' : {'description' : vbphrase['heading_1']},
		'h2' : {'description' : vbphrase['heading_2']},
		'h3' : {'description' : vbphrase['heading_3']},
		'h4' : {'description' : vbphrase['heading_4']},
		'h5' : {'description' : vbphrase['heading_5']},
		'h6' : {'description' : vbphrase['heading_6']}
	};

	this.tablebuttons = YAHOO.util.Dom.getElementsByClassName('tablebutton', 'img', editorid + '_controls');
	for (var i = 0; i < this.tablebuttons.length; i++)
	{
		this.button_context(this.tablebuttons[i], 'mouseout');
		YAHOO.util.Dom.addClass(this.tablebuttons[i], "imagebutton_disabled");
	}
	YAHOO.util.Dom.removeClass(editorid + "_cmd_configtable", "imagebutton_selected");
}

vB_Text_Editor_CMS.prototype.init = function(initial_text)
{
	this._parent.init.call(this, initial_text);

	if (this.wysiwyg_mode)
	{
		// todo: hack
		if (PHP.in_array('subscript', contextcontrols) < 0)
		{
			contextcontrols.push('subscript');
			contextcontrols.push('superscript');
		}

		if (is_moz)
		{
			this.editdoc.execCommand('enableInlineTableEditing', false, false);
		}
	}
}

vB_Text_Editor_CMS.prototype.init_popup_formatting = function(obj)
{
	menu = this.init_menu_container('formatting', 'auto', 'auto', 'auto');

	for (var tag in this.formatoptions)
	{
		if (YAHOO.lang.hasOwnProperty(this.formatoptions, tag))
		{
			var option = document.createElement(this.formatoptions[tag].tag ? this.formatoptions[tag].tag : tag);
			option.innerHTML = this.formatoptions[tag].description;
			option.title = this.formatoptions[tag].description;
			option.extra = this.formatoptions[tag].extra;
			option.cmd = obj.cmd;
			option.controlkey = obj.id;
			option.editorid = this.editorid;
			option.className = 'oformat';
			option.onmouseover = option.onmouseout = option.onmouseup = option.onmousedown = vB_Text_Editor_Events.prototype.menuoption_onmouseevent;
			option.onclick = vB_Text_Editor_Events.prototype.formatting_option_format_onclick;
			menu.appendChild(option);
		}
	}

	return menu;
}

vB_Text_Editor_CMS.prototype.recreate_editor = function(editorid, mode, parsetype, parsesmilies, initial_text, ajax_extra)
{
	return new vB_Text_Editor_CMS(editorid, mode, parsetype, parsesmilies, initial_text, ajax_extra);
}

vB_Text_Editor_CMS.prototype.set_context = function()
{
	this._parent.set_context.call(this);
	this.set_table_context();
	this.set_format_context();
}

vB_Text_Editor_CMS.prototype.set_table_context = function()
{
	var unset = true;
	var unsetconfig = true;
	var configtablebutton = YAHOO.util.Dom.get(this.editorid + "_cmd_configtable");
	var selection_container = this.get_selection_container_element();
	if (selection_container)
	{
		var ancestor = YAHOO.util.Dom.getAncestorByTagName(selection_container, 'table');
		if (ancestor && YAHOO.util.Dom.hasClass(ancestor, 'wysiwyg_dashes'))
		{
			//if (configtablebutton.state != true)
			//{
				configtablebutton.state = true;
				if (selection_container.tagName.toLowerCase() != 'tr' && selection_container.tagName.toLowerCase() != 'tbody')
				{
					for (var i = 0; i < this.tablebuttons.length; i++)
					{
						YAHOO.util.Dom.removeClass(this.tablebuttons[i], 'imagebutton_disabled');
					}
					unset = false;
				}
				else
				{
					YAHOO.util.Dom.removeClass(this.editorid + "_cmd_configtable", "imagebutton_disabled");
					unsetconfig = false;
				}
				this.button_context(configtablebutton, 'mouseout');
		//	}
		}
	}
	if (unset)
	{
		configtablebutton.state = false;
		if (unsetconfig)
		{
			this.button_context(configtablebutton, 'mouseout');
		}
		for (var i = 0; i < this.tablebuttons.length; i++)
		{
			this.button_context(this.tablebuttons[i], 'mouseout');
			YAHOO.util.Dom.addClass(this.tablebuttons[i], "imagebutton_disabled");
		}
		if (!unsetconfig)
		{
			YAHOO.util.Dom.removeClass(this.editorid + "_cmd_configtable", "imagebutton_disabled");
		}
	}
}

vB_Text_Editor_CMS.prototype.set_format_context = function()
{
	if (!this.buttons['formatting'] || !this.wysiwyg_mode)
	{
		return;
	}

	var formatstate;
	try
	{
		formatstate = this.editdoc.queryCommandValue('formatblock');
	}
	catch(e)
	{
		formatstate = '';
	}


	var match = formatstate.match(/(\d+)/);
	if (match)
	{
		formatstate = 'h' + match[1];
	}
	else
	{
		formatstate = 'p';
	}

	if (formatstate == 'h3')
	{
		var selection_container = this.get_selection_container_element();
		if (selection_container)
		{
			// selection is or contains h3's with a pagebreak class
			if ((selection_container.tagName.toLowerCase() == 'h3' && YAHOO.util.Dom.hasClass(selection_container, 'wysiwyg_pagebreak'))
				|| YAHOO.util.Dom.getElementsByClassName('wysiwyg_pagebreak', 'h3', selection_container).length
			)
			{
				formatstate = 'pagebreak';
			}
			else
			{
				// selection is contained within an h3 with a pagebreak class
				var ancestor = YAHOO.util.Dom.getAncestorByTagName(selection_container, 'h3');
				if (ancestor && YAHOO.util.Dom.hasClass(ancestor, 'wysiwyg_pagebreak'))
				{
					formatstate = 'pagebreak';
				}
			}
		}
	}

	if (formatstate != this.formatstate)
	{
		this.formatstate = formatstate;

		if (this.popupmode)
		{
			var format_out = fetch_object(this.editorid + '_formatting_out');
			format_out.innerHTML = this.formatoptions[formatstate].description;
		}
		else
		{
			// TODO
		}

		// page button state management
		var pb_button = fetch_object(this.editorid + '_cmd_insertpagebreak');
		pb_button.state = (formatstate == 'pagebreak');
		this.button_context(pb_button, 'mouseout');
	}
}

vB_Text_Editor.prototype.switch_editor_ajax = function()
{
	var mode = (this.wysiwyg_mode ? 0 : 1);

	YAHOO.util.Connect.asyncRequest("POST", 'editor.php?r=switch', {
		success: do_switch_editor_mode,
		timeout: vB_Default_Timeout,
		argument: [this.editorid, mode]
	//	scope: this
	}, SESSIONURL
		+ 'securitytoken=' + SECURITYTOKEN
		+ '&do=editorswitch'
		+ '&towysiwyg='	+ mode
		+ '&parsetype=' + this.parsetype
		+ '&allowsmilie=' + this.parsesmilies
		+ '&message=' + PHP.urlencode(this.get_editor_contents())
		+ (this.ajax_extra ? ('&' + this.ajax_extra) : '')
		+ (typeof this.textobj.form['options[allowbbcode]']  != 'undefined' ? '&allowbbcode=' + this.textobj.form['options[allowbbcode]'].checked : '')
	);
}

/* Editor functionality */

/**
* Insert Preview Break
*
* @param	event	Event object
*
* @return	boolean
*/
vB_Text_Editor_CMS.prototype.previewbreak = function(e)
{
	if (this.wysiwyg_mode)
	{
		var hr = YAHOO.util.Dom.getElementsByClassName("previewbreak", "hr", this.editdoc.documentElement.childNodes[1]);
		if (hr.length == 0)
		{
			return this.insert_text('<hr class="previewbreak" title="' + vbphrase['preview_break'] + '">', false);
		}
		else
		{
			alert(vbphrase['this_message_already_contains_a_preview_break']);
		}
	}
	else
	{
		var matches = this.editdoc.value.match(/\[prbreak\]\[\/prbreak\]/i);
		if (matches)
		{
			alert(vbphrase['this_message_already_contains_a_preview_break']);
		}
		else
		{
			return this.insert_text("[PRBREAK][/PRBREAK]");
		}
	}
}

vB_Text_Editor_CMS.prototype.createtablecell = function(table)
{
	if (table['table'])
	{
		var td = document.createElement('td');
		td.className = table['td'].className;
		td.innerHTML = (is_ie) ? "<p></p>" : "<br />";
		return td;
	}
	else
	{
		return false;
	}
}

vB_Text_Editor_CMS.prototype.createtablerow = function(table)
{
	if (table['table'])
	{
		var tr = document.createElement('tr');
		tr.className = table['tr'].className;
		YAHOO.util.Dom.setAttribute(tr, "valign", "top");

		for (var i = 0; i < table['colcount']; i++)
		{
			var td = this.createtablecell(table);
			if (td)
			{
				tr.appendChild(td);
			}
		}

		return tr;
	}
	else
	{
		return false;
	}
}

vB_Text_Editor_CMS.prototype.inserttablecolumn = function(direction)
{
	var table = this.fetchtable();
	if (table['table'])
	{
		for (var i = 0; i < table['rows'].length; i++)
		{
			var count = 0;
			var columns = table['rows'][i].getElementsByTagName('td');
			for (var x = 0; x < columns.length; x++)
			{
				if (columns[x].parentNode == table['rows'][i])
				{
					if (count == table['tdpos'])
					{
						var td = this.createtablecell(table);
						if (td)
						{
							if (direction == 'after')
							{
								table['rows'][i].insertBefore(td, nextSibling(columns[x]))
							}
							else
							{
								table['rows'][i].insertBefore(td, columns[x]);
							}
						}
						break;
					}
					count++;
				}
			}
		}
	}
}

vB_Text_Editor_CMS.prototype.inserttablecolumnafter = function(e)
{
	this.inserttablecolumn('after');
}

vB_Text_Editor_CMS.prototype.inserttablecolumnbefore = function(e)
{
	this.inserttablecolumn('before');
}

vB_Text_Editor_CMS.prototype.inserttablerowafter = function(e)
{
	var table = this.fetchtable();
	var row = this.createtablerow(table);
	if (row)
	{
		table['tr'].parentNode.insertBefore(row, nextSibling(table['tr']));
	}
}

vB_Text_Editor_CMS.prototype.inserttablerowbefore = function(e)
{
	var table = this.fetchtable();
	var row = this.createtablerow(table);
	if (row)
	{
		table['tr'].parentNode.insertBefore(row, table['tr']);
	}
}

vB_Text_Editor_CMS.prototype.focuscell = function(targetcell)
{
	if (targetcell)
	{
		if (is_moz)
		{
			var range = this.editdoc.createRange();
			range.selectNode(targetcell.firstChild);
			var s = this.editwin.getSelection();
			s.removeAllRanges();
			s.addRange(range);
			range.collapse(true);
		}
		else
		{
			// this borks in IE sometimes?
			try
			{
				var range = this.editdoc.selection.createRange();
				range.moveToElementText(targetcell);
				range.select();
				range.collapse(true);
				range.select();
			}
			catch(e) {}
		}
	}
}

vB_Text_Editor_CMS.prototype.deletetablecolumn = function(e)
{
	var table = this.fetchtable();
	if (table['table'])
	{
		if (table['colcount'] > 1)
		{
			if (table['tdpos'] == 0)
			{
				this.focuscell(nextSibling(table['td']));
			}
			else
			{
				this.focuscell(previousSibling(table['td']));
			}

			for (var i = 0; i < table['rows'].length; i++)
			{
				var count = 0;
				var columns = table['rows'][i].getElementsByTagName('td');
				for (var x = 0; x < columns.length; x++)
				{
					if (columns[x].parentNode == table['rows'][i])
					{
						if (count == table['tdpos'])
						{
							table['rows'][i].removeChild(columns[x]);
							break;
						}
						count++;
					}
				}
			}
		}
		else
		{
			table['table'].parentNode.removeChild(table['table']);
		}
	}
}

vB_Text_Editor_CMS.prototype.deletetablerow = function(e)
{
	var table = this.fetchtable();
	if (table['table'])
	{
		if (table['rowcount'] > 1)
		{
			if (table['trpos'] == 0)
			{
				var targetrow = nextSibling(table['tr']);
			}
			else
			{
				var targetrow = previousSibling(table['tr']);
			}

			var count = 0;
			var targetcell = null;
			var columns = targetrow.getElementsByTagName('td');

			for (var x = 0; x < columns.length; x++)
			{
				if (columns[x].parentNode == targetrow)
				{
					if (count == table['tdpos'])
					{
						this.focuscell(columns[x]);
						break;
					}
					count++;
				}
			}
			table['tr'].parentNode.removeChild(table['tr']);
		}
		else
		{
			table['table'].parentNode.removeChild(table['table']);
		}
	}
}

vB_Text_Editor_CMS.prototype.fetchtable = function(e)
{
	var table = {
		'table'   : null,
		'tbody'   : null,
		'tr'      : null,
		'tdpos'   : 0,
		'td'      : null,
		'tdpos'   : 0,
		'rowcount': 0,
		'colcount': 0,
		'rows'    : null,
		'width'   : null
	};

	var td = this.get_selection_container_element();

	if (td && td.tagName.toLowerCase() != 'td')
	{
		if (td.tagName.toLowerCase() == 'tr')	// Firefox allows one to select table rows & columns
		{
			td = td.firstChild;
		}
		else
		{
			var td = YAHOO.util.Dom.getAncestorByTagName(td, "td");
		}
	}

	if (td)
	{
		if (td.tagName.toLowerCase() != 'td')
		{
			var td = YAHOO.util.Dom.getAncestorByTagName(td, "td");

		}
		table['td'] = td;
		// Get parent <tr>
		var parenttr = td.parentNode;
		if (parenttr && parenttr.tagName.toLowerCase() == 'tr')
		{
			table['tr'] = parenttr;
			var parentnode = parenttr.parentNode;
			if (parentnode)
			{
				if (parentnode.tagName.toLowerCase() == 'table')
				{
					table['table'] = parentnode;
					var parenttable = parentnode;
					var parenttbody = null;
				}
				else if (parentnode.tagName.toLowerCase() == 'tbody')
				{
					table['tbody'] = parentnode;
					var parenttable = parentnode.parentNode;
					var parenttbody = parentnode;
					if (parenttable && parenttable.tagName.toLowerCase() == 'table')
					{
						table['table'] = parenttable;
					}
				}
			}
		}
	}

	if (parenttr)
	{
		var columns = parenttr.getElementsByTagName('td');
		for (var i = 0; i < columns.length; i++)
		{
			if (columns[i] == td)
			{
				table['tdpos'] = i;
			}
			if (columns[i].parentNode == parenttr)
			{
				table['colcount']++;
			}
		}
	}

	if (parenttable)
	{
		table['width1'] = YAHOO.util.Dom.getStyle(parenttable, 'width');
		table['width2'] = parenttable.width;
		table['rows'] = parenttable.getElementsByTagName('tr');
		for (var i = 0; i < table['rows'].length; i++)
		{
			if (table['rows'][i] == parenttr)
			{
				table['trpos'] = i;
			}
			if (table['rows'][i].parentNode == parenttable || table['rows'][i].parentNode == parenttbody)
			{
				table['rowcount']++;
			}
		}
	}

	for (i in table)
	{
		//alert(i + "\r\n" + table[i]);
	}

	return table;
}

vB_Text_Editor_CMS.prototype.tableoverlay = function(type)
{
	this.create_editor_dialog('<img src="' + IMGDIR_MISC + '/lightbox_progress.gif" alt="" />', this.inserttable_confirm);

	this.dialog_props = {
		'range' : this.get_range_from_selection(this.get_selection_object()),
		'type'  : type
	};

	if (type == 'config')
	{
		this.dialog_props['table'] = this.fetchtable();
	}

	YAHOO.util.Connect.asyncRequest("POST", 'editor.php?r=tableoverlay', {
		success: this.inserttable_ajax,
		failure: this.remove_editor_dialog,
		timeout: vB_Default_Timeout,
		scope: this
	}, 'sessionurl=' + SESSIONURL + "&securitytoken=" + SECURITYTOKEN + "&ajax=1" + "&type=" + type);
}

vB_Text_Editor_CMS.prototype.deletetable = function(e)
{
	var table = this.fetchtable();
	if (table) // && confirm('Are you sure?'))
	{
		table['table'].parentNode.removeChild(table['table']);
	}
}

vB_Text_Editor_CMS.prototype.configtable = function(e)
{
	this.tableoverlay('config');
}

vB_Text_Editor_CMS.prototype.inserttable = function(e)
{
	this.tableoverlay('insert');
}

vB_Text_Editor_CMS.prototype.inserttable_ajax = function(ajax)
{
	if (ajax.responseXML)
	{
		var html = ajax.responseXML.getElementsByTagName("html");

		if (html.length)
		{
			this.create_editor_dialog(html[0].firstChild.nodeValue, this.inserttable_confirm, true);

			var me = this;
			YAHOO.util.Event.on(this.dialog.width_percent, "click", function() {me.dialog.width_type[2].checked = true;});
			YAHOO.util.Event.on(this.dialog.width_pixels, "click", function() {me.dialog.width_type[1].checked = true;});

			var type = this.dialog_props['type'];
			if (type == 'config')
			{
				YAHOO.util.Dom.get("irows").disabled = "disabled";
				YAHOO.util.Dom.get("icolumns").disabled = "disabled";
				var table = this.fetchtable();
				YAHOO.util.Dom.get("overlay_width_type_auto").checked = false;
				YAHOO.util.Dom.get("overlay_width_type_percent").checked = false;
				YAHOO.util.Dom.get("overlay_width_type_pixels").checked = false;
				if (!table['width2'])	//auto
				{
					YAHOO.util.Dom.get("overlay_width_type_auto").checked = true;
				}
				else if (table['width2'].match(/%$/))	// percent
				{
					YAHOO.util.Dom.get("overlay_width_type_percent").checked = true;
					this.dialog.width_percent.value = table['width2'].replace(/%$/, '');
				}
				else	// pixels
				{
					YAHOO.util.Dom.get("overlay_width_type_pixels").checked = true;
					this.dialog.width_pixels.value = table['width2'];
				}

				if (YAHOO.util.Dom.hasClass(table['table'], "wysiwyg_cms_table_outer_border"))
				{
					this.dialog['class'].selectedIndex = 1;
				}
				else if (YAHOO.util.Dom.hasClass(table['table'], "wysiwyg_cms_table_grid"))
				{
					this.dialog['class'].selectedIndex = 2;
				}
			}

			return;
		}
	}

	this.remove_editor_dialog();
}

vB_Text_Editor_CMS.prototype.inserttable_confirm = function()
{
	var range = this.dialog_props['range'];
	if (range && type == 'insert')
	{
		this.select_range(range);
	}

	var config = {
		'rows'    : parseInt(this.dialog.elements['rows'].value, 10),
		'columns' : parseInt(this.dialog.elements['columns'].value, 10),
		'width'   : '',
		'class'   : this.dialog.elements['class'].value
	};

	var width_type = '';
	for (var i = 0; i < this.dialog.elements['width_type'].length; i++)
	{
		if (this.dialog.elements['width_type'][i].checked)
		{
			width_type = this.dialog.elements['width_type'][i].value;
		}
	}

	switch (width_type)
	{
		case 'pixels':
			config.width = this.dialog.elements['width_pixels'].value;
			break;

		case 'percent':
			if (this.dialog.elements['width_percent'].value)
			{
				config.width = this.dialog.elements['width_percent'].value + '%';
				break;
			}
			// default to "auto"

		case 'auto':
		default:
			config.width = '';
	}

	var type = this.dialog_props['type'];
	if (type == 'config')
	{
		var table = this.dialog_props['table'];
		var setstyle = '';

		table['table'].width = config.width;

		if (config['class'] == 'outer_border')
		{
			if (!YAHOO.util.Dom.hasClass(table['table'], "wysiwyg_cms_table_outer_border"))
			{
				setstyle = 'outer';
			}
		}
		else if (config['class'] == 'grid')
		{
			if (!YAHOO.util.Dom.hasClass(table['table'], "wysiwyg_cms_table_grid"))
			{
				setstyle = 'grid';
			}
		}
		else
		{
			if (
				YAHOO.util.Dom.hasClass(table['table'], "wysiwyg_cms_table_outer_border")
					||
				YAHOO.util.Dom.hasClass(table['table'], "wysiwyg_cms_table_grid")
			)
			{
				setstyle = 'none';
			}
		}

		if (setstyle)
		{
			if (setstyle == 'grid')
			{
				YAHOO.util.Dom.addClass(table['table'], "wysiwyg_cms_table_grid");
				YAHOO.util.Dom.removeClass(table['table'], "wysiwyg_cms_table_outer_border");
			}
			else if (setstyle == "outer")
			{
				YAHOO.util.Dom.addClass(table['table'], "wysiwyg_cms_table_outer_border");
				YAHOO.util.Dom.removeClass(table['table'], "wysiwyg_cms_table_grid");
			}
			else
			{
				YAHOO.util.Dom.removeClass(table['table'], "wysiwyg_cms_table_outer_border");
				YAHOO.util.Dom.removeClass(table['table'], "wysiwyg_cms_table_grid");
			}
			for (var i = 0; i < table['rows'].length; i++)
			{
				if (setstyle == 'grid')
				{
					YAHOO.util.Dom.addClass(table['rows'][i], "wysiwyg_cms_table_grid_tr");
					YAHOO.util.Dom.removeClass(table['rows'][i], "wysiwyg_cms_table_outer_border_tr");
				}
				else if (setstyle == "outer")
				{
					YAHOO.util.Dom.addClass(table['rows'][i], "wysiwyg_cms_table_outer_border_tr");
					YAHOO.util.Dom.removeClass(table['rows'][i], "wysiwyg_cms_table_grid_tr");
				}
				else
				{
					YAHOO.util.Dom.removeClass(table['rows'][i], "wysiwyg_cms_table_outer_border_tr");
					YAHOO.util.Dom.removeClass(table['rows'][i], "wysiwyg_cms_table_grid_tr");
				}
				var columns = table['rows'][i].getElementsByTagName('td');
				for (var x = 0; x < columns.length; x++)
				{
					if (columns[x].parentNode == table['rows'][i])
					{
						if (setstyle == 'grid')
						{
							YAHOO.util.Dom.addClass(columns[x], "wysiwyg_cms_table_grid_td");
							YAHOO.util.Dom.removeClass(columns[x], "wysiwyg_cms_table_outer_border_td");
						}
						else if (setstyle == "outer")
						{
							YAHOO.util.Dom.addClass(columns[x], "wysiwyg_cms_table_outer_border_td");
							YAHOO.util.Dom.removeClass(columns[x], "wysiwyg_cms_table_grid_td");
						}
						else
						{
							YAHOO.util.Dom.removeClass(columns[x], "wysiwyg_cms_table_outer_border_td");
							YAHOO.util.Dom.removeClass(columns[x], "wysiwyg_cms_table_grid_td");
						}
					}
				}
			}
		}

		this.remove_editor_dialog();
		return;
	}

	if (config.rows < 1)
	{
		config.rows = 1;
	}

	if (config.columns < 1)
	{
		config.columns = 1;
	}

	if (!config.width.match(/^\d+%?$/))
	{
		config.width = '';
	}

	if (!config['class'].match(/^[a-zA-Z0-9_]+$/))
	{
		config['class'] = '';
	}

	var selected_text = this.get_selection(), output_html = '';
	var row, col;

	if (this.wysiwyg_mode)
	{
		if (!config['class'])
		{
			// placeholder class with dashes
			config['class'] = ['wysiwyg_dashes'];
		}
		else
		{
			// add the prefix that's used with the output
			config['class'] = ['wysiwyg_dashes', 'wysiwyg_cms_table_' + config['class']];
		}

		output_html += '<table';

		if (config.width)
		{
			output_html += ' width="' + config.width + '"';
		}
		if (config['class'])
		{
			output_html += ' class="' + config['class'].join(' ') + '"';
		}

		output_html += '>';

		for (row = 0; row < config.rows; row++)
		{
			output_html += '<tr valign="top"';

			if (config['class'])
			{
				output_html += ' class="' + config['class'].join('_tr ') + '_tr"';
			}

			output_html += '>';

			for (col = 0; col < config.columns; col++)
			{
				output_html += '<td';

				if (config['class'])
				{
					output_html += ' class="' + config['class'].join('_td ') + '_td"';
				}

				output_html += '>' + selected_text + '</td>';

				selected_text = '';
			}
			output_html += '</tr>';
		}
		output_html += '</table>';

		if (is_ie)
		{
			output_html += '<p></p>';
		}
		else
		{
			output_html += '<br />';
		}
	}
	else
	{
		var table_options = [];
		if (config.width)
		{
			table_options.push('width:' + config.width);
		}
		if (config['class'])
		{
			table_options.push('class:' + config['class']);
		}

		output_html += '[table';
		if (table_options.length)
		{
			output_html += '="' + table_options.join(', ') + '"';
		}
		output_html += ']\n';

		for (row = 0; row < config.rows; row++)
		{
			output_html += '[tr]\n';
			for (col = 0; col < config.columns; col++)
			{
				output_html += '\t[td]' + selected_text + '[/td]\n';
				selected_text = '';
			}
			output_html += '[/tr]\n';
		}
		output_html += '[/table]\n';
	}

	this.remove_editor_dialog();
	this.insert_text(output_html);
}

vB_Text_Editor_CMS.prototype.subscript = function(e)
{
	if (this.wysiwyg_mode)
	{
		this.editdoc.execCommand('subscript', false, true);
	}
	else
	{
		this.wrap_tags('sub', false);
	}
}

vB_Text_Editor_CMS.prototype.superscript = function(e)
{
	if (this.wysiwyg_mode)
	{
		this.editdoc.execCommand('superscript', false, true);
	}
	else
	{
		this.wrap_tags('sup', false);
	}
}

vB_Text_Editor_CMS.prototype.inserthorizontalrule = function(e)
{
	if (this.wysiwyg_mode)
	{
		this.editdoc.execCommand('inserthorizontalrule', false, true);
	}
	else
	{
		this.wrap_tags('hr', false);
	}
}

vB_Text_Editor_CMS.prototype.insertpagebreak = function(e)
{
	if (this.wysiwyg_mode)
	{
		var pb_button = fetch_object(this.editorid + '_cmd_insertpagebreak');
		if (pb_button && pb_button.state)
		{
			// turn off page breaks (as they are currently on)
			this.apply_formatblock('<p>');

			var selection_container = this.get_selection_container_element();
			if (selection_container)
			{
				YAHOO.util.Dom.removeClass(
					this.find_by_tag_name(selection_container, 'p'),
					'wysiwyg_pagebreak'
				);
			}
		}
		else
		{
			this.apply_formatblock('<h3>');

			var selection_container = this.get_selection_container_element();
			if (selection_container)
			{
				YAHOO.util.Dom.addClass(
					this.find_by_tag_name(selection_container, 'h3'),
					'wysiwyg_pagebreak'
				);
			}
		}
	}
	else
	{
		this.wrap_tags('page', false);
	}
}

vB_Text_Editor_CMS.prototype.formatting = function(e, arg)
{
	var header_match = arg.tagName.match(/^h[1-6]$/i);

	if (this.wysiwyg_mode)
	{
		var format_string;
		if (header_match)
		{
			format_string = '<' + arg.tagName + '>';
		}
		else
		{
			format_string = '<p>';
		}

		this.apply_formatblock(format_string);

		var selection_container = this.get_selection_container_element();
		if (selection_container)
		{
			var headings = this.find_by_tag_name(selection_container, 'h3');
			if (!headings || !headings.length)
			{
				headings = YAHOO.util.Dom.getAncestorByTagName(selection_container, 'h3');
			}

			if (arg.extra == 'pagebreak')
			{
				YAHOO.util.Dom.addClass(
					headings,
					'wysiwyg_pagebreak'
				);
			}
			else
			{
				YAHOO.util.Dom.removeClass(
					headings,
					'wysiwyg_pagebreak'
				);
			}
		}
	}
	else
	{
		if (header_match)
		{
			var wrap = (arg.extra == 'pagebreak' ? 'page' : arg.tagName);
			this.wrap_tags(wrap, false);
		}
		// else, nothing needed for non-wysiwyg
	}
}

/* Helper methods */

vB_Text_Editor_CMS.prototype.find_by_tag_name = function(el, tag_name)
{
	if (!el || !el.tagName)
	{
		return [];
	}

	if (el.tagName.toLowerCase() == tag_name.toLowerCase())
	{
		return [el];
	}
	else
	{
		return el.getElementsByTagName(tag_name);
	}
}

vB_Text_Editor_CMS.prototype.apply_formatblock = function(format_string)
{
	var range = this.get_range_from_selection();
	if (!range)
	{
		return;
	}

	if (range.collapsed && range.insertNode)
	{
		range.insertNode(this.editdoc.createTextNode(' '));
	}

	this.editdoc.execCommand('formatblock', false, format_string);
}

/* Selection management */

vB_Text_Editor_CMS.prototype.get_selection_container_element = function(range)
{
	if (typeof(range) == 'undefined')
	{
		range = this.get_range_from_selection();
	}

	var range_element;
	if (range.commonAncestorContainer)
	{
		if (range.commonAncestorContainer.nodeName == '#text')
		{
			range_element = range.commonAncestorContainer.parentNode;
		}
		else
		{
			range_element = range.commonAncestorContainer;
		}
	}
	else if (typeof(range.parentElement) != "undefined")
	{
		range_element = range.parentElement();
	}

	return range_element;
}

vB_Text_Editor_CMS.prototype.select_range = function(range)
{
	if (range.select)
	{
		range.select();
	}
	else
	{
		var cur = this.get_selection_object();
		if (cur && cur.removeAllRanges)
		{
			cur.removeAllRanges();
			cur.addRange(range);
		}
	}
}

vB_Text_Editor_CMS.prototype.get_selection_object = function()
{
	var selwin, seldoc;

	if (this.wysiwyg_mode)
	{
		selwin = this.editwin;
		seldoc = this.editdoc;
	}
	else
	{
		selwin = window;
		seldoc = document;
	}

	if (selwin.getSelection)
	{
		return selwin.getSelection();
	}
	else
	{
		return seldoc.selection;
	}
}

vB_Text_Editor_CMS.prototype.get_range_from_selection = function(sel)
{
	if (typeof(sel) == 'undefined')
	{
		sel = this.get_selection_object();
	}

	if (!sel)
	{
		return null;
	}

	if (sel.createRange)
	{
		return sel.createRange();
	}
	else if (sel.getRangeAt)
	{
		return sel.getRangeAt(0);
	}
	else if (this.editdoc.createRange)
	{
		return this.editdoc.createRange();
	}
	else
	{
		return null;
	}
}

/* Extra events */

vB_Text_Editor_Events.prototype.formatting_option_format_onclick = function(e)
{
	vB_Editor[this.editorid].format(e, this.cmd, this);
	vBmenu.hide();
};


/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 29616 $
|| ####################################################################
\*======================================================================*/
