/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

var vB_UserList_Highlighters = new Object();

// #############################################################################

vBulletin.events.systemInit.subscribe(function()
{
	var i, elementid = null;

	// activate highlighters
	if (vBulletin.elements["vB_UserList_Highlighter"])
	{
		for (i = 0; i < vBulletin.elements["vB_UserList_Highlighter"].length; i++)
		{
			elementid = vBulletin.elements["vB_UserList_Highlighter"][i][0]
			vB_UserList_Highlighters[elementid] = new vB_UserList_Highlighter(elementid);
		}
		vBulletin.elements["vB_UserList_Highlighter"] = null;
	}
});

// #############################################################################

/**
* Allows images to act as <label> tags in the buddy/friends list, plus other userlist actions
*
* @package	vBulletin
* @version	$Revision: 26407 $
* @date		$Date: 2008-04-22 11:51:55 -0700 (Tue, 22 Apr 2008) $
* @author	Kier Darby
*
* @param	string	ID of HTML element containing all user items
*/
function vB_UserList_Highlighter(parentid)
{
	var i, j, labels, images, element;

	this.parentid = parentid;
	this.parent = YAHOO.util.Dom.get(parentid);
	this.items = new Array();

	labels = this.parent.getElementsByTagName("label");
	if (labels.length)
	{
		for (i = 0; i < labels.length; i++)
		{
			if (YAHOO.util.Dom.hasClass(labels[i], "avatar_label"))
			{
				images = labels[i].getElementsByTagName("img");
				if (images.length)
				{
					for (j = 0; j < images.length; j++)
					{
						if (images[j].id && images[j].id.substr(0, 8 + this.parentid.length) == (this.parentid + "_avatar_"))
						{
							element = new vB_UserList_UserObject(images[j].id.substr(8 + this.parentid.length), this.parentid);
							this.items.push(element);
						}
					}
				}
			}
		}
	}

	this.check_all_checkbox = YAHOO.util.Dom.get(this.parentid + "_checkall");
	YAHOO.util.Event.on(this.check_all_checkbox, "click", this.check_all, this, true);

	this.show_avatars_checkbox = YAHOO.util.Dom.get(this.parentid + "_showavatars");
	YAHOO.util.Event.on(this.show_avatars_checkbox, "click", this.show_avatars, this, true);

	this.show_avatars();
}

/**
* Deactivates all highlighters registered to this object
*/
vB_UserList_Highlighter.prototype.deactivate = function()
{
	for (var i = 0; i < this.items.length; i++)
	{
		this.items[i].deactivate();
	}
}

/**
* Checks / Unchecks all highlighters
*/
vB_UserList_Highlighter.prototype.check_all = function()
{
	var i, inputs;

	if (this.items.length)
	{
		for (i = 0; i < this.items.length; i++)
		{
			this.items[i].usercheck.checked = this.check_all_checkbox.checked;
			this.items[i].shade_avatar();
		}
	}
	else
	{
		var inputs = this.parent.getElementsByTagName("input");
		for (i = 0; i < inputs.length; i++)
		{
			if (inputs[i].type == "checkbox")
			{
				inputs[i].checked = this.check_all_checkbox.checked;
			}
		}
	}
}

/**
* Toggles avatar visibility
*/
vB_UserList_Highlighter.prototype.show_avatars = function()
{
	if (this.items.length && this.show_avatars_checkbox)
	{
		if (this.show_avatars_checkbox.checked)
		{
			YAHOO.util.Dom.replaceClass(this.parent, "userlist_hideavatars", "userlist_showavatars");
			console.info("checked");
		}
		else
		{
			YAHOO.util.Dom.replaceClass(this.parent, "userlist_showavatars", "userlist_hideavatars");
			console.info("not checked");
		}
	}
}

// #############################################################################

/**
* Allows individual images to act as <label> tags in the buddy/friends list, plus more stuff
*
* @package	vBulletin
* @version	$Revision: 26407 $
* @date		$Date: 2008-04-22 11:51:55 -0700 (Tue, 22 Apr 2008) $
* @author	Kier Darby
*
* @param	integer	UserID of user item
* @param	string	ID of HTML element containing all user items
*/
function vB_UserList_UserObject(userid, prefix)
{
	this.avatar = YAHOO.util.Dom.get(prefix + "_avatar_" + userid);
	YAHOO.util.Event.on(this.avatar, "click", this.avatar_click, this, true);

	this.usercheck = YAHOO.util.Dom.get(prefix + "_usercheck_" + userid);
	if (this.usercheck.tagName == "INPUT" && this.usercheck.getAttribute("type") == "checkbox")
	{
		YAHOO.util.Event.on(this.usercheck, "click", this.usercheck_click, this, true);
		this.shade_avatar();
	}
}

/**
* Sets the opacity of the avatar to transparent if the user checkbox is un-checked
*/
vB_UserList_UserObject.prototype.shade_avatar = function()
{
	YAHOO.util.Dom.setStyle(this.avatar, "opacity", (this.usercheck.checked ? 1 : 0.25));
}

/**
* Handles a click on an avatar image
*
* @param	event
*/
vB_UserList_UserObject.prototype.avatar_click = function(e)
{
	YAHOO.util.Event.stopEvent(e);

	if (this.usercheck.tagName == "SELECT")
	{
		this.usercheck.focus();
	}
	else
	{
		this.usercheck.checked = !this.usercheck.checked;
		this.shade_avatar();
	}
}

/**
* Handles a click on a user checkbox
*
* @param	event
*/
vB_UserList_UserObject.prototype.usercheck_click = function(e)
{
	this.shade_avatar();
}

/**
* Unregisters all event listeners attached to this object
*/
vB_UserList_UserObject.prototype.deactivate = function()
{
	yAHOO.util.Event.removeListener(this.avatar, "click", this.avatar_click);
	YAHOO.util.Event.removeListener(this.usercheck, "click", this.usercheck_click);
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 25811 $
|| ####################################################################
\*======================================================================*/