/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vB_Blog_DragDrop
// #############################################################################

/**
* Loads a single item
*
* @package	vBulletin
* @version	$Revision: 24798 $
* @date		$Date: 2007-11-22 13:59:49 +0000 (Thu, 22 Nov 2007) $
* @author	Freddie Bingham, vBulletin Development Team
*
* @param	vB_QuickLoader_Factory	Controlling factory class
*/
function vB_Blog_DragDrop(objectid)
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
	{
		this.init(objectid);
	}
}

/**
* Initialize the onclick action
*
* @return	boolean
*/
vB_Blog_DragDrop.prototype.init = function(objectid)
{
	this.objectid = objectid;
	this.listitem = YAHOO.util.Dom.get(this.objectid);
	this.items = this.listitem.getElementsByTagName("li");
	this.blocks = new Array();

	for (var i = 0; i < this.items.length; i++)
	{
		var item = YAHOO.util.Dom.get(this.items[i]);
		var handle = YAHOO.util.Dom.get(item.id + "_handle");
		if (item.parentNode.id == this.objectid && handle)
		{
			this.blocks[item.id] = new vB_Blog_DragDrop_DDProxy(item.id, this.listitem.id);
			this.blocks[item.id].setHandleElId(item.id + "_handle");
			YAHOO.util.Dom.setStyle(handle, "cursor", "move");
		}
	}
}

vB_Blog_DragDrop_DDProxy = function(id, sGroup, config)
{
	vB_Blog_DragDrop_DDProxy.superclass.constructor.call(this, id, sGroup, config);

	var el = this.getDragEl();
	YAHOO.util.Dom.setStyle(el, "opacity", 0.67);

	this.goingUp = false;
	this.lastY = 0;
}

YAHOO.extend(vB_Blog_DragDrop_DDProxy, YAHOO.util.DDProxy);

vB_Blog_DragDrop_DDProxy.prototype.startDrag = function(x, y)
{
	var dragEl = this.getDragEl();
	var clickEl = this.getEl();
	YAHOO.util.Dom.setStyle(clickEl, "visibility", "hidden");
	if (dragEl.parentNode.nodeName.toLowerCase() == "body")
	{
		// Add our drag element to the sidebar so that we can inherit its properties
		clickEl.parentNode.parentNode.appendChild(dragEl);
	}

	var listitems = clickEl.parentNode.getElementsByTagName("li");
	clickEl.parentNode.blockorder = "";
	for (var i = 0; i < listitems.length; i++)
	{
		var item = YAHOO.util.Dom.get(listitems[i]);
		var handle = YAHOO.util.Dom.get(item.id + "_handle");
		if (item.parentNode.id == clickEl.parentNode.id && handle)
		{
			clickEl.parentNode.blockorder += item.id;
		}
	}

	var licontent = YAHOO.util.Dom.get(clickEl.id + "_div");
	if (licontent)
	{
		var ghostobj = licontent.cloneNode(true);
		ghostobj.style.display = "none";
		clickEl.appendChild(ghostobj);
		ghostobj.style.margin = "0px";
		ghostobj.style.padding = "0px";
		ghostobj.style.borderWidth = "0px";
		dragEl.innerHTML = ghostobj.innerHTML;
		ghostobj.parentNode.removeChild(ghostobj);
	}
	else
	{
		dragEl.innerHTML = clickEl.innerHTML;
	}

	YAHOO.util.Dom.setStyle(dragEl, "color", YAHOO.util.Dom.setStyle(clickEl, "color"));
	YAHOO.util.Dom.setStyle(dragEl, "backgroundColor", YAHOO.util.Dom.setStyle(clickEl, "backgroundColor"));
	YAHOO.util.Dom.setStyle(dragEl, "border", "2px solid gray");

	// Get block order
}

vB_Blog_DragDrop_DDProxy.prototype.endDrag = function (e)
{
	var srcEl = this.getEl();
	var dragEl = this.getDragEl();

	var blockorder = "";
	var submitstring = "";
	var listitems = srcEl.parentNode.getElementsByTagName("li");
	var count = 1;
	for (var i = 0; i < listitems.length; i++)
	{
		var item = YAHOO.util.Dom.get(listitems[i]);
		var handle = YAHOO.util.Dom.get(item.id + "_handle");
		if (item.parentNode.id == srcEl.parentNode.id && handle)
		{
			blockorder += item.id;
			submitstring += "&block[" + item.id + "]=" + count;
			count++;
		}
	}

	// Block order changed - update data
	if (blockorder != srcEl.parentNode.blockorder)
	{
		YAHOO.util.Connect.asyncRequest("POST", "blog_ajax.php?do=moveblock" + submitstring, {
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=moveblock" + submitstring);
	}

	// Show the dragEl element and animate it to the src element's location
	YAHOO.util.Dom.setStyle(dragEl, "visibility", "");
	var a = new YAHOO.util.Motion
	(
		dragEl,
		{
			points:
			{
				to: YAHOO.util.Dom.getXY(srcEl)
			}
		},
		0.2,
		YAHOO.util.Easing.easeOut
	)
	var dragElid = dragEl.id;
	var thisid = this.id;

	// Hide the dragEl and show the source element when finished with the animation
	a.onComplete.subscribe(
		function()
		{
			YAHOO.util.Dom.setStyle(dragElid, "visibility", "hidden");
			YAHOO.util.Dom.setStyle(thisid, "visibility", "");
			YAHOO.util.Dom.get(dragElid).innerHTML = "";
		}
	);
	a.animate();
}

vB_Blog_DragDrop_DDProxy.prototype.onDrag = function(e)
{
	// Keep track of the direction of the drag for use during onDragOver
	var y = YAHOO.util.Event.getPageY(e);

	if (y < this.lastY)
	{
		this.goingUp = true;
	}
	else if (y > this.lastY)
	{
		this.goingUp = false;
	}

	this.lastY = y;
}

vB_Blog_DragDrop_DDProxy.prototype.onDragOver = function (e, id)
{
	var srcEl = this.getEl();
	var destEl = YAHOO.util.Dom.get(id);

	// We are only concerned with list items, we ignore the dragover
	// notifications for the list.
	if (destEl.nodeName.toLowerCase() == "li")
	{
		var orig_p = srcEl.parentNode;
		var p = destEl.parentNode;

		if (this.goingUp)
		{
			p.insertBefore(srcEl, destEl); // insert above
		}
		else
		{
			p.insertBefore(srcEl, destEl.nextSibling); // insert below
		}
	}

	YAHOO.util.DDM.refreshCache();
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 25662 $
|| ####################################################################
\*======================================================================*/