/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/


vB_XHTML_Ready.subscribe(function () {mq_init('posts')});

/**
* Initializes the MQ images, so they are clickable. Additionally, it redoes
* the coloring of the image based on the current value of the cookie. This
* is helpful if a user uses the back button.
*
* @param	object	The object or id to search within for MQ images.
*/
function mq_init(postcontainer)
{
	var cookie_ids = mq_get_selected();
	var quotecontrols = YAHOO.util.Dom.getElementsByClassName("multiquote", "a", postcontainer);
	for (var i = 0; i < quotecontrols.length; i++)
	{
		quotecontrols[i].onclick = function(e) { return mq_click(this.id.substr(3)); };
		
		var postid = quotecontrols[i].id.substr(3);
		set_mq_highlight(postid, (PHP.in_array(postid, cookie_ids) > -1));
	}
}

function mq_get_selected()
{
	var cookie_ids = fetch_cookie('vbulletin_multiquote');
	if (cookie_ids != null && cookie_ids != '')
	{
		cookie_ids = cookie_ids.split(',');
	}
	else
	{
		cookie_ids = new Array();
	}

	return cookie_ids;
}


/**
* Callback function to when an MQ image is clicked. Modifies the cookie and
* updates the look of the image to suit.
*
* @param	integer	Post ID of the image clicked.
*
* @return	false	Always returns false to ensure any href event does not run
*/
function mq_click(postid)
{
	var cookie_ids = mq_get_selected();
	var cookie_text = new Array();

	var is_selected = false;
	for (i in cookie_ids)
	{
		if (!YAHOO.lang.hasOwnProperty(cookie_ids, i))
		{
			continue;
		}

		if (cookie_ids[i] == postid)
		{
			is_selected = true;
		}
		else if (cookie_ids[i])
		{
			cookie_text.push(cookie_ids[i]);
		}
	}

	// flip the image to the other option
	set_mq_highlight(postid, !is_selected);

	// if we don't have the postid in the cookie, add it
	if (!is_selected)
	{
		cookie_text.push(postid);

		//remove any quotes from over the limit
		if (typeof mqlimit != 'undefined' && mqlimit > 0)
		{
			for (var i = 0; i < (cookie_text.length - mqlimit); i++)
			{
				var removal = cookie_text.shift();
				set_mq_highlight(removal, false);
			}
		}
	}

	set_cookie('vbulletin_multiquote', cookie_text.join(','));

	return false;
}

/**
* Changes the MQ image to show as being selected or unselected
*
* @param	integer	ID of the post whose MQ button is changing
* @param	boolean	Whether to make the image selected or not
*/
function set_mq_highlight(postid, to_selected)
{
	// for IE6, we need to use the gif version of the multi-quote images
	var imgext = (is_ie6 ? 'gif' : 'png');
	if (to_selected)
	{
		YAHOO.util.Dom.addClass('mq_' + postid, 'highlight');
		YAHOO.util.Dom.get('mq_image_' + postid).src = IMGDIR_BUTTON + '/multiquote-selected_40b.' + imgext;
	}
	else
	{
		YAHOO.util.Dom.removeClass('mq_' + postid, 'highlight');
		YAHOO.util.Dom.get('mq_image_' + postid).src = IMGDIR_BUTTON + '/multiquote_40b.' + imgext;
	}
}

function mq_unhighlight_all()
{
	// grab all images in the posts area
	var mq_images = fetch_tags(fetch_object('posts'), 'img');
	
	// loop through each image, and set the selected to false for any multiquote ones
	for (var i = 0; i < mq_images.length; i++)
	{		
		if (mq_images[i].id && mq_images[i].id.substr(0, 9) == 'mq_image_')
		{
			set_mq_highlight(mq_images[i].id.substr(9), false);
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 35972 $
|| ####################################################################
\*======================================================================*/
