/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Adds onclick event to the save search prefs buttons
*
* @param	string	The ID of the button that fires the search prefs
*/
function vB_AJAX_SearchPrefs_Init(buttonid)
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2) && fetch_object(buttonid))
	{
		// prevent the form from submitting when clicking the submit button
		var sbutton = fetch_object(buttonid);
		sbutton.onclick = vB_AJAX_SearchPrefs.prototype.form_click;
	}
};

/**
* Class to handle saving search prefs
*
* @package	vBulletin
* @version	$Revision: 37602 $
* @date		$Date: 2010-06-18 11:37:15 -0700 (Fri, 18 Jun 2010) $
* @author	vBulletin Development Team
*
* @param	object	The form object containing the search options
*/
function vB_AJAX_SearchPrefs(formobj)
{
	// vB_Hidden_Form object to handle form variables
	this.pseudoform = new vB_Hidden_Form('search.php');
	this.pseudoform.add_variable('ajax', 1);
	this.pseudoform.add_variable('doprefs', 1);
	this.pseudoform.add_variables_from_object(formobj);
};

/**
* Handles AJAX request response
*
* @param	object	YUI AJAX
*/
vB_AJAX_SearchPrefs.prototype.handle_ajax_response = function(ajax)
{
	if (ajax.responseXML)
	{
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			var message = ajax.responseXML.getElementsByTagName('message');
			if (message.length)
			{
				alert(message[0].firstChild.nodeValue);
			}
		}
	}
}

/**
* Submits the form via Ajax
*/
vB_AJAX_SearchPrefs.prototype.submit = function()
{
	YAHOO.util.Connect.asyncRequest("POST", "search.php", {
		success: this.handle_ajax_response,
		failure: this.handle_ajax_error,
		timeout: vB_Default_Timeout,
		scope: this
	}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&" + this.pseudoform.build_query_string());
};

/**
* Fallback - submits the form normally
*/
vB_AJAX_SearchPrefs.prototype.handle_ajax_error = function(ajax)
{
	vBulletin_AJAX_Error_Handler(ajax);

	this.pseudoform.submit_form();
}

/**
* Handles the form 'submit' action
*/
vB_AJAX_SearchPrefs.prototype.form_click = function()
{
	var AJAX_SearchPrefs = new vB_AJAX_SearchPrefs(this.form);
	AJAX_SearchPrefs.submit();
	return false;
}

vB_XHTML_Ready.subscribe(init_vB_SearchTypes);

/**
* Initialize class
*
*/
function init_vB_SearchTypes()
{
	new vB_SearchTypes();
}

/**
* Class to handle clicking on search type checkboxes
*
* @package	vBulletin
* @version	$Revision: 37602 $
* @date		$Date: 2010-06-18 11:37:15 -0700 (Fri, 18 Jun 2010) $
* @author	vBulletin Development Team
*
*/
function vB_SearchTypes()
{
	this.selectall = YAHOO.util.Dom.get("searchtype_all");
	this.list = YAHOO.util.Dom.get("searchtypelist");
	this.inputs = {};
	var inputs = this.list.getElementsByTagName("input");
	var count = 0;
	for (var x = 0; x < inputs.length; x++)
	{
		if (YAHOO.util.Dom.hasClass(inputs[x], "searchtype"))
		{
			this.inputs[count++] = inputs[x];
		}
	}
	YAHOO.util.Event.on(this.list, "click", this.clickaction, this, true);
}

/**
* Handles the checkbox clicks
*/
vB_SearchTypes.prototype.clickaction = function(e)
{
	var target = YAHOO.util.Event.getTarget(e);
	if (target && target.type == "checkbox")
	{
		if (target == this.selectall)
		{
			for(x in this.inputs)
			{
				this.inputs[x].checked = target.checked;
			}
		}
		else
		{
			var checkit = true;
			for(x in this.inputs)
			{
				if (this.inputs[x].checked == false)
				{
					checkit = false;
					break;
				}
			}
			this.selectall.checked = checkit;
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 37602 $
|| ####################################################################
\*======================================================================*/