<?php
/*
=====================================================
 DataLife Engine - by SoftNews Media Group
 TWS Gallery - by Al-x
-----------------------------------------------------
 http://dle-news.ru/
 http://inker.wonderfullife.ru/
-----------------------------------------------------
 Copyright (c) 2004,2007 SoftNews Media Group
 Copyright (c) 2007,2008 TWS
=====================================================
     
 This file may no be redistributed in whole or significant part.	
           
       
=====================================================
 : thumbnailer.php
-----------------------------------------------------
 :    
=====================================================
  thumbnailer.php 1,0
=====================================================
*/

if(!defined('DATALIFEENGINE'))
{
  die("Hacking attempt!");
}

class thumbnailer {

	var $imagedata;
	var $quality = 90;
	var $current_image = '';
	var $wm_inserted = false;
	var $size = array();
	var $global_error = 0;


	function thumbnailer($file, $quality, $type, $resize_config){

		$this->current_image 	= $file;

		if (!file_exists($this->current_image)){ $this->global_error = 1; return false; }

		$this->type				= $type;
		$this->quality			= $quality;

		switch ($this->type){

			case "jpg" :
			case "jpeg" :
			case "jpe" :
			case "png" :
			case "gif" :

				if (!count($resize_config)) return true;

				$this->loadimage();

				if ($this->global_error == 1) return false;

				for ($i = 0; $i < count($resize_config); $i++){

					$this->resize_image($resize_config[$i][0], $resize_config[$i][1], $resize_config[$i][2], $resize_config[$i][3], $resize_config[$i][4], $resize_config[$i][5]);

				}

				$this->clear_image();

			break;

		}
 	 return true;
	}


	function loadimage(){

		switch ($this->type){

			case "jpg" :
			case "jpeg" :
			case "jpe" :
				if(!defined('DEBUG_MODE')){
					$this->imagedata = @imagecreatefromjpeg ($this->current_image);
				} else {
					$this->imagedata = imagecreatefromjpeg ($this->current_image);
				}
				$this->type = "jpeg";
				break;

			case "png" :
				if(!defined('DEBUG_MODE')){
					$this->imagedata = @imagecreatefrompng ($this->current_image);
				} else {
					$this->imagedata = imagecreatefrompng ($this->current_image);
				}
				break;

			case "gif" :
				if(!defined('DEBUG_MODE')){
					$this->imagedata = @imagecreatefromgif ($this->current_image);
				} else {
					$this->imagedata = imagecreatefromgif ($this->current_image);
				}
				break;

			default :
				$this->global_error = 1;
				return false;

		}

		if (!is_resource($this->imagedata)){ $this->global_error = 1; return false; }

		if(!defined('DEBUG_MODE')){
			$this->size['width'] = @imagesx($this->imagedata);
			$this->size["height"] = @imagesy($this->imagedata);
		} else {
			$this->size['width'] = imagesx($this->imagedata);
			$this->size["height"] = imagesy($this->imagedata);
		}

	  return true;
	}


	function resize_image($new_size, $insert_watermark, $resize_type, $new_width, $new_height, $new_pic_filname){

		if (!$new_size && !$insert_watermark) return true;

		if ($new_size){

			if (!$new_width) $new_width = $new_size;
			if (!$new_height) $new_height = $new_size;

			$this->get_new_size($new_width, $new_height, $resize_type);
			$this->do_image_resize();

		}

		if ($insert_watermark && !$this->wm_inserted){

			$this->wm_inserted = true;
			$this->insert_watermark($insert_watermark);

		}

		if (file_exists($new_pic_filname)){
			if(!defined('DEBUG_MODE')){
				@unlink($new_pic_filname);
				@clearstatcache;
			} else {
				unlink($new_pic_filname);
				clearstatcache;
			}
		}

	  return $this->save_image($new_pic_filname);
	}


	function get_new_size($new_width, $new_height, $resize_type){

		$this->size['new_width'] = $this->size['width'];
		$this->size["new_height"] = $this->size["height"];

		if ($new_width >= $this->size['width'] && $new_height >= $this->size['height']){
			return 0;
		}

		switch ($resize_type){

			case "1" :

				if ($this->size['width'] <= $new_width){
					return 0;
				} else {
					$this->size['new_width'] = $new_width;
					$this->size['new_height'] = ($new_width/$this->size['width'])*$this->size['height'];
				}

				break;

			case "2" :

				if ($this->size['height'] <= $new_height){
					return 0;
				} else {
					$this->size['new_width'] = ($new_height/$this->size['height'])*$this->size['width'];
					$this->size['new_height'] = $new_height;
				}

				break;

			case "3" :

				$this->size['new_width'] = $new_width;
				$this->size['new_height'] = $new_height;

				break;

			default:

				if ($this->size['width'] >= $this->size['height']){
					$this->size['new_width'] = $new_width;
					$this->size['new_height'] = ($new_width/$this->size['width'])*$this->size['height'];
				} else {
					$this->size['new_height'] = $new_height;
					$this->size['new_width'] = ($new_height/$this->size['height'])*$this->size['width'];
				}

		}

	}


	function do_image_resize(){

		$temp = imagecreatetruecolor($this->size['new_width'], $this->size['new_height']);
		imagecopyresampled($temp, $this->imagedata, 0, 0, 0, 0, $this->size['new_width'], $this->size['new_height'], $this->size['width'], $this->size['height']);

		$this->imagedata = $temp;

		if(!defined('DEBUG_MODE')){
			$this->size['width'] = @imagesx($this->imagedata);
			$this->size["height"] = @imagesy($this->imagedata);
		} else {
			$this->size['width'] = imagesx($this->imagedata);
			$this->size["height"] = imagesy($this->imagedata);
		}

	}


	function insert_watermark($min_image){
	global $config, $galConfig;

		$margin = 7;

		if ($galConfig['watermark_light'] != "")
			$watermark_light = ROOT_DIR.'/templates/'.$config['skin'].'/'.$galConfig['watermark_light'];
		else
			$watermark_light =  ROOT_DIR.'/templates/'.$config['skin'].'/dleimages/watermark_light.png';

		if ($galConfig['watermark_dark'] != "")
			$watermark_dark =  ROOT_DIR.'/templates/'.$config['skin'].'/'.$galConfig['watermark_dark'];
		else
			$watermark_dark =  ROOT_DIR.'/templates/'.$config['skin'].'/dleimages/watermark_dark.png';

		list($watermark_width, $watermark_height) = getimagesize($watermark_light);

		$watermark_x = $this->size['width'] - $margin - $watermark_width;
		$watermark_y = $this->size["height"] - $margin - $watermark_height;

		$watermark_x2 = $watermark_x + $watermark_width;
		$watermark_y2 = $watermark_y + $watermark_height;

		if ($watermark_x < 0 OR $watermark_y < 0 OR	$watermark_x2 > $this->size['width'] OR $watermark_y2 > $this->size["height"] OR $this->size['width'] < $min_image OR $this->size["height"] < $min_image)
		{
		return;
		}

		$test = imagecreatetruecolor(1, 1);
		imagecopyresampled($test, $this->imagedata, 0, 0, $watermark_x, $watermark_y, 1, 1, $watermark_width, $watermark_height);
		$rgb = imagecolorat($test, 0, 0);
		$r = ($rgb >> 16) & 0xFF;
		$g = ($rgb >> 8) & 0xFF;
		$b = $rgb & 0xFF;

		$max = min($r, $g, $b);
		$min = max($r, $g, $b);
		$lightness = (double)(($max + $min) / 510.0);
		imagedestroy($test);

		$watermark_image = ($lightness < 0.5) ? $watermark_light : $watermark_dark;

		$watermark = imagecreatefrompng($watermark_image);
		imagealphablending($this->imagedata, TRUE);
		imagealphablending($watermark, TRUE);
		imagecopy($this->imagedata, $watermark, $watermark_x, $watermark_y, 0, 0,$watermark_width, $watermark_height);
		imagedestroy($watermark);

	}


	function save_image($file){

		switch ($this->type){

			case "jpeg" :
				imagejpeg($this->imagedata, "$file", $this->quality);
				break;

			case "png" :
				imagepng($this->imagedata, "$file");
				break;

			case "gif" :
				imagegif($this->imagedata, "$file");
				break;

		}

		if (!file_exists($file)){
			$this->global_error = 1;
			return false;
		}

		@chmod ($file, 0666);
		return true;

	}


	function clear_image(){
		imagedestroy($this->imagedata);
	}


	function error(){
		return $this->global_error;
	}


}

?>