<?PHP
/*
=====================================================
 TWS Gallery - by Al-x
-----------------------------------------------------
 http://inker.wonderfullife.ru/
-----------------------------------------------------
 Copyright (c) 2007,2008 TWS
=====================================================
     
 This file may no be redistributed in whole or significant part.	
           
       
=====================================================
 : upload.php
-----------------------------------------------------
 :   
=====================================================
  class.upload.php 1,1
=====================================================
*/

if(!defined('DATALIFEENGINE'))
{
  die("Hacking attempt!");
}

$max_once_upload = 0;

class upload_images {

	var $upload_result 		= array();
	var $upload_mode 		= 0;
	var $type_upload 		= 0;
	var $config 			= array();
	var $dirrectory			= '';
	var $current_image		= '';
	var $current_url		= '';
	var $current_name		= '';
	var $current_type		= '';
	var $current_foto		= array();
	var $pic_filname		= '';
	var $global_error		= '0';
	var $this_time			= 0;
	var $temp_folder		= array();
	var $temp_user_id		= 0;


	function init ($post_config = 0){
	global $galConfig;

		$this -> config['max_once_upload'] = 100; //   -   
		$this -> config['zip_filesize'] = 100; //    ,  
		$this -> config['allowed_extensions'] = $galConfig['extensions']; //  ,   , . . 
		$this -> config['thumb_res_type'] = $galConfig['thumb_res_type']; //   
		$this -> config['comm_res_type'] = $galConfig['comm_res_type']; //   -
		$this -> config['full_res_type'] = $galConfig['full_res_type']; //    
		$this -> config['global_max_foto_width'] = $galConfig['global_max_foto_width']; //    
		$this -> config['global_max_foto_height'] = $galConfig['global_max_foto_height']; //    
		$this -> config['comm_thumb'] = $galConfig['comms_foto_size']; //  -
		$this -> config['thumb_size'] = $galConfig['max_thumb_size']; //  
		$this -> config['allow_resize'] = $galConfig['allow_foto_resize']; //   
		$galConfig['min_watermark'] = ($galConfig['allow_watermark']) ? $galConfig['min_watermark'] : 0;
		$this -> config['insert_watermark'] = $galConfig['min_watermark'];
		$this -> config['preview_resize'] = 250; //  
		$this -> config['rewrite'] = $galConfig['rewrite_mode']; //   
		$this -> config['quality'] = $galConfig['resize_quality']; //  
		$this -> config['check_double'] = $galConfig['allow_check_double'];
		$this -> config['delete'] = 1; //    

		$delete_user = $this -> config['delete'];

		if ($this -> type_upload == 0){

			if ($this -> get_temp_folder('t_'.$this -> temp_user_id, 'main', $delete_user) == false) return 0;
			if ($this -> get_temp_folder('t_'.$this -> temp_user_id.'/thumbs', 'thumb') == false) return 0;

		}

	  return 1;
	}


	function get_temp_folder($directory, $key = false, $mode = 1){

		$error = false;

		$handle = FOTO_DIR .'/temp/'. $directory;

		if (file_exists($handle)){

			if (is_dir($handle)){
				$this -> delete_folder($handle, true, $mode);
			} else {
				if(!defined('DEBUG_MODE'))
					@unlink($handle);
				else
					unlink($handle);
			}

		}

		if(!defined('DEBUG_MODE')){
			@mkdir($handle, 0777) or $error = true;
		} else {
			mkdir($handle, 0777) or $error = true;
		}

		if (!$error && !is_writable($handle)) $error = true;

		if ($error){
			$this -> upload_result[] = array(false, "20");
			$this -> global_error = '1';
			return false;
		}

		if(!defined('DEBUG_MODE'))
			@chmod($handle, 0777);
		else
			chmod($handle, 0777);

		if ($key !== false)
			$this -> temp_folder[$key] = $directory;

		return true;
	}


	function delete_folder($handle, $delete_dirs = true, $mode = 1){

		if (is_dir($handle))
		{
			if(!defined('DEBUG_MODE'))
				$handle_folder = @opendir($handle);
			else
				$handle_folder = opendir($handle);

			if ($handle_folder)
			{
				while (false !== ($file = @readdir($handle_folder)))
				{
					if ($file != "." && $file != ".htaccess" && $file != "..")
					{
						if (!is_dir($handle . '/' . $file))
						{
							if ($mode){
								if(!defined('DEBUG_MODE'))
									@unlink($handle . '/' . $file);
								else
									unlink($handle . '/' . $file);
							} else
								$this -> move_to_temp($handle . '/' . $file, $file);
						}
						elseif ($delete_dirs)
						{
							$this -> delete_folder($handle . '/' . $file);
						}
					}
				}

				@closedir($handle_folder);

				if ($delete_dirs)
				{
					if(!defined('DEBUG_MODE'))
						@rmdir($handle);
					else
						rmdir($handle);
				}

			}

		}

	}


	function move_to_temp($file, $newfile){

		$error = false;

		$new_file = FOTO_DIR . '/temp/' . $newfile;
		$in = 1;

		while (file_exists($new_file))
		{
			$_name = explode(".", $newfile);
			$_ext = end($_name);
			unset($_name[key($_name)]);
			$_newfile = implode(".", $_name);
			$in++;
			$new_file = FOTO_DIR . '/temp/' . $_newfile . '_' . $in . '.' . $_ext;
		}

		if(!defined('DEBUG_MODE')){
			@rename($file, $new_file) or $error = true;
		} else {
			rename($file, $new_file) or $error = true;
		}

		if (!$error){
			if(!defined('DEBUG_MODE'))
				@chmod ($new_file, 0666);
			else
				chmod ($new_file, 0666);
		}

	 return $error;
	}


	function get_file($current_id){

		if ($this -> config['max_once_upload'] != 0 && $this -> counter >= $this -> config['max_once_upload'])
		{
			$this -> upload_result[] = array(false, "2");
			$this -> global_error = '1';
			return false;
		}

		switch ($this -> upload_mode){

			case '1' :

				$this -> current_image	= $_FILES['image_' . $current_id]['tmp_name'];
				$this -> current_name	= $_FILES['image_' . $current_id]['name'];

			break;

			case '2' :

				$this -> current_image = trim(htmlspecialchars(strip_tags($_POST['url_' . $current_id])));
                $this -> current_image  = str_replace("\\", "/", $this -> current_image);
                $this -> current_name = end(explode ("/", $this -> current_image));

			break;

			case '3' :

				$this -> current_image = trim(htmlspecialchars(strip_tags($_POST['remote_' . $current_id])));
                $this -> current_image  = str_replace("\\", "/", $this -> current_image);
                $this -> current_name = end(explode ("/", $this -> current_image));

			break;

			case '4' :

				$this -> current_image	= $_FILES['zip_archive']['tmp_name'];
				$this -> current_name	= $_FILES['zip_archive']['name'];

			break;

			case '6' :

				$this -> current_image = $_POST['id'][$current_id];

				if (!file_exists($this -> current_image)) return 0;

				$this -> current_name = end(explode ("/", $this -> current_image));

				if (isset($_POST['remote_file_' . $current_id]) && $_POST['remote_file_' . $current_id] != '')
					$this -> current_url = str_replace("\\", "/", trim(htmlspecialchars(strip_tags(rawurldecode($_POST['remote_file_' . $current_id])))));

			break;

		}

		$img_arr = explode(".",$this -> current_name);

		$this -> current_type = strtolower($this -> totranslit(end($img_arr)));

		$curr_key = key($img_arr);
		unset($img_arr[$curr_key]);

		$this -> current_name = strtolower($this -> totranslit(stripslashes(implode("", $img_arr))));

		if ($this -> current_name == ""){
			$this -> upload_result[] = array("", "3");
			return false;
		}

	return true;
	}


	function check_extensions(){

		$this -> current_foto [5] = 0;

		if (array_key_exists($this -> current_type, $this -> config['allowed_extensions'])){
			switch ($this->current_type){
				case "jpg" : $this -> current_foto [5] = 0; break;
				case "jpeg" : $this -> current_foto [5] = 0; break;
				case "jpe" : $this -> current_foto [5] = 0; break;
				case "png" : $this -> current_foto [5] = 0; break;
				case "gif" : $this -> current_foto [5] = 0; break;
				case "mp3" : $this -> current_foto [5] = 1; break;
				case "mp4" : $this -> current_foto [5] = 2; break;
				case "avi" : $this -> current_foto [5] = 3; break;
				case "divx" : $this -> current_foto [5] = 7; break;
				case "wmv" : $this -> current_foto [5] = 4; break;
				case "flv" : $this -> current_foto [5] = 5; break;
				case "mpg" : $this -> current_foto [5] = 6; break;
				default : $this -> current_foto [5] = 10; break;
			}
			return true;
		}

		$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "4");

	return false;
	}


	function get_filesize ($check_file){

		if (strpos($check_file, "http:") !== false || strpos($check_file, "wwww.") !== false){
			if(!defined('DEBUG_MODE')){
				$this -> current_foto [0] = (($data = @file_get_contents($check_file))) ? strlen($data) : false;
			} else {
				$this -> current_foto [0] = (($data = file_get_contents($check_file))) ? strlen($data) : false;
			}
			return;
		}

		if(!defined('DEBUG_MODE'))
			$this -> current_foto [0] = @filesize($check_file);
		else
			$this -> current_foto [0] = filesize($check_file);
	}


	function check_filesize($check_image){

		$this -> get_filesize ($check_image);

		if ($this -> current_foto [0] > ($this -> config['allowed_extensions'][$this -> current_type]['s'] * 1024)){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "5");
			return false;

		}
		
		if ($this -> current_foto [0] < 500){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "24");
			return false;

		}

	return true;
	}


	function check_file_params (){

		if ($this -> current_foto [5]){

			$this -> current_foto [1] = 0;
			$this -> current_foto [2] = 0;

			return $this -> check_filesize($this -> current_image);

		}

		if(!defined('DEBUG_MODE'))
			$img_info = @getimagesize($this -> current_image);
		else
			$img_info = getimagesize($this -> current_image);
		
		$this -> current_foto [1] = $img_info[0];
		$this -> current_foto [2] = $img_info[1];

		if (!$this -> config['allow_resize'])
		{
			 if ($this -> config['global_max_foto_width'] < $img_info[0] || $this -> config['global_max_foto_height'] < $img_info[1]){
				$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "6");
		 		return false;
			}
			return $this -> check_filesize($this -> current_image);
		}

		if ($this -> config['global_max_foto_width'] > $img_info[0] && $this -> config['global_max_foto_height'] > $img_info[1])
		{
			return $this -> check_filesize($this -> current_image);
		}

		$this -> get_filesize ($this -> current_image);

	 return true;
	}


	function get_new_filename ($i = ''){

		$this -> pic_filname = $this -> current_name . $i . '.' . $this -> current_type;

	}


	function check_existing(){
	global $db;

		if ($this -> type_upload == 0)
			$root = FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/';
		else//if ($this -> dirrectory != '')
			$root = FOTO_DIR . '/main/' . $this -> dirrectory .'/';

		$this -> get_new_filename ();

		$found_id = 0;
		$dir = intval($this -> dirrectory);
		$this -> current_foto [3] = 0;

		$check_file = $root . $this -> pic_filname;
		$r_temp = $this -> pic_filname;

		$exists = file_exists($check_file);

		if ($dir && !$exists)
		{
			$control = $db->super_query("SELECT picture_id FROM " . PREFIX . "_gallery_picturies WHERE category_id = '{$dir}' AND picture_filname = '".$this -> pic_filname."'");
			if ($control['picture_id']) $found_id = intval($control['picture_id']);
		}

		if ($this -> type_upload == 0 && $exists){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "21");
			return false;

		}

		if ($exists || $found_id){

			if ($this -> config['rewrite'] == '2'){

				if ($dir && !$found_id)
				{
					$control = $db->super_query("SELECT picture_id FROM " . PREFIX . "_gallery_picturies WHERE category_id = '{$dir}' AND picture_filname = '".$this -> pic_filname."'");
					if ($control['picture_id']) $found_id = intval($control['picture_id']);
				}

				if(!defined('DEBUG_MODE'))
					@unlink($check_file);
				else
					unlink($check_file);

				$this -> current_foto [3] = $found_id;
				return true;

			} elseif ($this -> config['rewrite'] == '1'){

				$in = 2;
				$stop = false;

				while (!$stop){

					$this -> get_new_filename ('_'.$in);
					$in++;
					$check_file = $root . $this -> pic_filname;

					$is = file_exists($check_file);

					if (!$is && !$dir) $stop = true;
					elseif (!$is)
					{
						$control = $db->super_query("SELECT picture_id FROM " . PREFIX . "_gallery_picturies WHERE category_id = '{$dir}' AND picture_filname = '".$this -> pic_filname."'");
						if (!$control['picture_id']) $stop = true;
					}

				}

				$this -> current_name .= '_' . ($in - 1);

				if ($this -> current_url != '' && $this -> type_upload == 1){

					$root = FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/';

					if(!defined('DEBUG_MODE')){
						@rename($root . $r_temp, $root . $this -> pic_filname);
						@chmod ($root . $this -> pic_filname, 0666);
					} else {
						rename($root . $r_temp, $root . $this -> pic_filname);
						chmod ($root . $this -> pic_filname, 0666);
					}	

				}

				return true;

			}

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "7");
			return false;
		}

	return true;
	}


	function check_dir($dirrectory){

		$error = false;

		if (!is_dir(FOTO_DIR.'/' . $dirrectory)){
		
			if(!defined('DEBUG_MODE')){
				@mkdir(FOTO_DIR.'/' . $dirrectory, 0777) or $error = true;
			} else {
				mkdir(FOTO_DIR.'/' . $dirrectory, 0777) or $error = true;
			}

			if (!$error && !is_writable(FOTO_DIR.'/' . $dirrectory)) $error = true;
			if ($error){
				$this -> upload_result[] = array(false, "20");
				$this -> global_error = '1';
				return false;
			}
			
			if(!defined('DEBUG_MODE'))
				@chmod(FOTO_DIR.'/' . $dirrectory, 0777);
			else
				chmod(FOTO_DIR.'/' . $dirrectory, 0777);

		}

	return true;
	}


	function move_file(){

		$error = false;

		if ($this -> dirrectory != '' && $this -> type_upload != 0){

			if ($this -> check_dir('main/' . $this -> dirrectory) == false) return false;
			if ($this -> check_dir('comthumb/' . $this -> dirrectory) == false) return false;
			if ($this -> check_dir('thumb/' . $this -> dirrectory) == false) return false;

		}

		if ($this -> type_upload == 0)
			$root = FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/';
		elseif ($this -> dirrectory != '')
			$root = FOTO_DIR . '/main/' . $this -> dirrectory .'/';

		switch ($this -> upload_mode){

			case '1' :

				if(!defined('DEBUG_MODE')){
					@move_uploaded_file($this -> current_image, $root . $this -> pic_filname) or $error = true;
				} else {
					move_uploaded_file($this -> current_image, $root . $this -> pic_filname) or $error = true;
				}

			break;

			case '2' :
			case '3' :

				if(!defined('DEBUG_MODE')){
					@copy($this -> current_image, $root . $this -> pic_filname) or $error = true;
				} else {
					copy($this -> current_image, $root . $this -> pic_filname) or $error = true;
				}

			break;

			case '4' :

				$this -> pic_filname = $this -> current_name . '_' . $this -> this_time . '.' . $this -> current_type;
				if(!defined('DEBUG_MODE')){
					@move_uploaded_file($this -> current_image, FOTO_DIR . '/temp/' . $this -> temp_folder['zip'] . '/' . $this -> pic_filname) or $error = true;
				} else {
					move_uploaded_file($this -> current_image, FOTO_DIR . '/temp/' . $this -> temp_folder['zip'] . '/' . $this -> pic_filname) or $error = true;
				}

				if ($error){

					$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "8");
					return false;

				}

				if(!defined('DEBUG_MODE'))
					@chmod (FOTO_DIR . '/temp/' . $this -> temp_folder['zip'] . '/' . $this -> pic_filname, 0666);
				else
					chmod (FOTO_DIR . '/temp/' . $this -> temp_folder['zip'] . '/' . $this -> pic_filname, 0666);

				return true;

			break;

			case '5' :
			case '6' :

				if(!defined('DEBUG_MODE')){
					@rename($this -> current_image, $root . $this -> pic_filname) or $error = true;
				} else {
					rename($this -> current_image, $root . $this -> pic_filname) or $error = true;
				}

			break;

		}

		if ($error){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "8");
			return false;

		}

		if(!defined('DEBUG_MODE'))
			@chmod ($root . $this -> pic_filname, 0666);
		else
			chmod ($root . $this -> pic_filname, 0666);

		return true;

	}

	function check_xss(){

		if ($this -> type_upload == 0){
			$fh = @fopen(FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/' . $this -> pic_filname, 'rb' );
		} else {
			$fh = @fopen($this -> current_image, 'rb' );
		}

		$file_check = @fread( $fh, 512 );
		
		@fclose( $fh );
		
		# Thanks to Nicolas Grekas from comments at www.splitbrain.org for helping to identify all vulnerable HTML tags
		
		if($file_check && !preg_match( "#<script|<html|<head|<title|<body|<pre|<table|<a\s+href|<img|<plaintext|<cross\-domain\-policy#si", $file_check ) )
		{
			return true;
		}

		$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "9");
		return false;
	}

	function get_file_hash(){
	global $db;

		if(!defined('DEBUG_MODE')){

			if ($this -> type_upload == 0){
				$this -> current_foto [4] = @md5_file(FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/' . $this -> pic_filname);
			} else {
				$this -> current_foto [4] = @md5_file($this -> current_image);
			}

		} else {

			if ($this -> type_upload == 0){
				$this -> current_foto [4] = md5_file(FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/' . $this -> pic_filname);
			} else {
				$this -> current_foto [4] = md5_file($this -> current_image);
			}

		}

		if ($this -> config['check_double']){}

	 return true;
	}


	function make_preview_thumb(){

		if ($this -> config['preview_resize'] != 0){

			$thumb = new thumbnailer(FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/' . $this -> pic_filname, 50, $this -> current_type, array (array ($this -> config['preview_resize'], 0, 0, 0, 0, FOTO_DIR . '/temp/' . $this -> temp_folder['thumb'] . '/' . $this -> pic_filname)));
			if ($thumb->error()){
				$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "17");
				return false;
			}

		}

	return true;
	}


	function delete_file($file = ""){

		if ($file == "" && $this -> pic_filname != ""){

			if ($this -> type_upload == 0)
				$root = FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/';
			elseif ($this -> dirrectory != '')
				$root = FOTO_DIR . '/main/' . $this -> dirrectory .'/';

			if(!defined('DEBUG_MODE'))
				@unlink ($root . $this -> pic_filname);
			else
				unlink ($root . $this -> pic_filname);

		} elseif ($file != "") {
			if(!defined('DEBUG_MODE'))
				@unlink ($file);
			else
				unlink ($file);
		}

	}


	function check_zip(){

		$allowed_extensions = array("zip");

   		if (!in_array($this -> current_type, $allowed_extensions)){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "10");
			return false;

		}

		if(!defined('DEBUG_MODE'))
			$filesize = @filesize($this -> current_image);
		else
			$filesize = filesize($this -> current_image);

		if ($this -> config['zip_filesize'] && $filesize > ($this -> config['zip_filesize'] * 1024 * 1024)){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "11");
			return false;

		}

		if ($filesize < 1000){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "24");
			return false;

		}

	return true;
	}


	function Unzip (){
	global $allowed_extensions, $i, $max_once_upload;

		include_once(ENGINE_DIR.'/gallery/modules/pclzip.lib.php');

		$max_once_upload = $this -> config['max_once_upload'];

		$archive = new PclZip(FOTO_DIR . '/temp/' . $this -> temp_folder['zip'] . '/' . $this -> pic_filname);

		if ($archive->properties() == 0){

			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "12", "<br />" . $archive->errorInfo(true));
			return false;
		}

		$i = 0;
		$allowed_extensions = $this -> config['allowed_extensions'];

		function myPreExtractCallBack($p_event, &$p_header){
		global $allowed_extensions, $i, $max_once_upload;

	    	$info = pathinfo($p_header['filename']);
			$info['extension'] = strtolower($info['extension']);
			if ($max_once_upload && $i >= $max_once_upload) return 0;
   			if (array_key_exists($info['extension'],$allowed_extensions)){
	 		$p_header['stored_filename'] = $info['basename'];
			$i++;
	 		return 1;
			}
			return 0;
		}

		function myPostExtractCallBack($p_event, &$p_header){
			if ($p_header['status'] == 'ok') {
				$new_name = $this -> totranslit(stripslashes($p_header['filename']));
			}
		}

		$result = $archive->extract(PCLZIP_OPT_PATH, FOTO_DIR .'/temp/'. $this -> temp_folder['zip'], PCLZIP_CB_PRE_EXTRACT, 'myPreExtractCallBack');

		$i = 0;

     	if ($result == 0) {
			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "12", "<br />" . $archive->errorInfo(true));
			return false;
     	}

		foreach ($result as $file){
			if ($file['folder'] != 1) $i++;;
		}

		if ($i == 0){
			$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "13");
			return false;
		}

	 return true;
	}


	function folder_images_upload ($handle, $allow_subdirs, $tp){

		if (is_dir($handle))
		{

		if(!defined('DEBUG_MODE'))
			$handle_folder = @opendir($handle);
		else
			$handle_folder = opendir($handle);

		if ($handle_folder){

		while (false !== ($file = @readdir($handle_folder))){

			if ($file != "." && $file != ".htaccess" && $file != "..") {

				if (!is_dir($handle . '/' . $file)){

					if ($this -> global_error =='1') break;

					$this -> current_foto = array();

					$this -> current_name = $file;
					$this -> current_image = $handle . '/' . $file;

					if ($this->get_file(0) == false) continue;
					if ($this->check_extensions() == false) continue;
					if ($this->check_file_params() == false) continue;
					if ($this->check_existing() == false) continue;
					if ($this->move_file() == false) continue;
					if ($this->check_xss() == false) continue;
					if ($this->get_file_hash() == false) continue;
					if ($this->make_preview_thumb() == false) continue;

					$this -> counter++;
					$this -> upload_result[] = array($this -> pic_filname, "0", $this -> current_foto [5], $this -> current_foto [0], $this -> current_foto [1], $this -> current_foto [2], '', $tp);

				} elseif ($allow_subdirs) {

					$this->folder_images_upload($handle . '/' . $file, $allow_subdirs, $tp);

				}

			}

		}

		@closedir($handle_folder);

		}

		}

	}


	function image_operations (){

		if ($this -> config['allow_resize'] || $this -> config['insert_watermark'] || $this -> config['comm_thumb'] != 0 || $this -> config['thumb_size'] != 0){

			$resize_config = array();

			if ($this -> current_url == ''){
				$resize_config[] = array ($this -> config['allow_resize'], $this -> config['insert_watermark'], $this -> config['full_res_type'], $this -> config['global_max_foto_width'], $this -> config['global_max_foto_height'], FOTO_DIR . '/main/' . $this -> dirrectory .'/' . $this -> pic_filname);
				$root = FOTO_DIR . '/main/' . $this -> dirrectory .'/';
			} else {
				$root = FOTO_DIR . '/temp/' . $this -> temp_folder['main'] . '/';
			}

			$resize_config[] = array ($this -> config['comm_thumb'], $this -> config['insert_watermark'], $this -> config['comm_res_type'], 0, 0, FOTO_DIR . '/comthumb/' . $this -> dirrectory .'/' . $this -> pic_filname);
			$resize_config[] = array ($this -> config['thumb_size'], $this -> config['insert_watermark'], $this -> config['thumb_res_type'], 0, 0, FOTO_DIR . '/thumb/' . $this -> dirrectory .'/' . $this -> pic_filname);

			$thumb = new thumbnailer($root . $this -> pic_filname, $this -> config['quality'], $this -> current_type, $resize_config);

			if ($thumb->error()){
				$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, "17");
				return false;
			}

		}

	return true;
	}


	function do_upload ($image_i = 0){

		$go = true;

		switch ($this -> upload_mode){

		case '1' : // web

			if ($this -> global_error == '1') $go = false;
			if ($go && ($this->get_file($image_i) == false)) $go = false;
			if ($go && ($this->check_extensions() == false)) $go = false;
			if ($go && ($this->check_file_params() == false)) $go = false;
			if ($go && ($this->check_existing() == false)) $go = false;

			if (!$go){
				$this->delete_file($this -> current_image);
				return 0;
			}

			if ($this->move_file() == false) $go = false;

			if (!$go){
				$this->delete_file($this -> current_image);
				return 0;
			}

			if ($this->check_xss() == false) $go = false;
			if ($this->get_file_hash() == false) $go = false;

			if (!$go){
				$this->delete_file();
				return 0;
			}

			if ($this->make_preview_thumb() == false) return 0;

			$this -> counter++;
			$this -> upload_result[] = array($this -> pic_filname, "0", $this -> current_foto [5], $this -> current_foto [0], $this -> current_foto [1], $this -> current_foto [2], '', 1);

		break;

		case '2' : // link

			if ($this -> global_error == '1') return 0;
			if ($this->get_file($image_i) == false) return 0;
			if ($this->check_extensions() == false) return 0;
			if ($this->check_file_params() == false) return 0;
			if ($this->check_existing() == false) return 0;
			if ($this->move_file() == false) return 0;
			if ($this->check_xss() == false) $go = false;
			if ($this->get_file_hash() == false) $go = false;

			if (!$go){
				$this->delete_file();
				return 0;
			}

			if ($this->make_preview_thumb() == false) return 0;

			$this -> counter++;
			$this -> upload_result[] = array($this -> pic_filname, "0", $this -> current_foto [5], $this -> current_foto [0], $this -> current_foto [1], $this -> current_foto [2], '', 2);

		break;

		case '3' : // remote

			if ($this -> global_error =='1') return 0;
			if ($this->get_file($image_i) == false) return 0;
			if ($this->check_extensions() == false) return 0;
			if ($this->check_file_params() == false) return 0;
			if ($this->check_existing() == false) return 0;
			if ($this->move_file() == false) return 0;
			if ($this->check_xss() == false) $go = false;
			if ($this->get_file_hash() == false) $go = false;

			if (!$go){
				$this->delete_file();
				return 0;
			}

			if ($this->make_preview_thumb() == false) return 0;

			$this -> counter++;
			$this -> upload_result[] = array($this -> pic_filname, "0", $this -> current_foto [5], $this -> current_foto [0], $this -> current_foto [1], $this -> current_foto [2], $this -> current_image, 3);

		break;

		case '4' : // zip

			if ($this -> global_error == '1') $go = false;
			if ($go && ($this->get_file(0) == false)) $go = false;
			if ($go && ($this->check_zip() == false)) $go = false;

			if ($go && ($this -> get_temp_folder('zip_'.$this -> temp_user_id, 'zip') == false)) $go = false;

			if ($go && ($this->move_file() == false)) $go = false;

			if (!$go){
				$this->delete_file($this -> current_image);
				return 0;
			}

			if ($this->Unzip() == false){ $this->delete_file(); return 0; }
			$this->delete_file(FOTO_DIR . '/temp/' . $this -> temp_folder['zip'] . '/' . $this -> pic_filname);

			$this -> upload_mode = '5';

			$this->folder_images_upload(FOTO_DIR . '/temp/' . $this -> temp_folder['zip'], true, 4);

			$this -> delete_folder(FOTO_DIR . '/temp/' . $this -> temp_folder['zip']);

		break;

		case '5' : // folder

			$folder = trim(htmlspecialchars(strip_tags($_POST['folder'])));
			$folder  = str_replace("\\", "/", $folder);

			if (!is_dir($folder)){
				$this -> upload_result[] = array(false, "14");
				return 0;
			}

			$this->folder_images_upload($folder, false, 5);

			if ($this -> config['delete']){
				$this -> delete_folder($folder, false);
			}

		break;

		case '6' :

			if ($this -> global_error == '1') return 0;
			if ($this->check_extensions() == false) return 0;
			if ($this->check_file_params() == false) return 0;
			if ($this->get_file_hash() == false) return 0;
			if ($this->check_existing() == false) return 0;

			if ($this -> current_url == ''){
				if ($this->move_file() == false) return 0;
			}

			if ($this->image_operations() == false) return 0;

			if ($this -> current_url == ''){

				if(!defined('DEBUG_MODE')){
					list($this -> current_foto [1], $this -> current_foto [2]) = @getimagesize(FOTO_DIR . '/main/' . $this -> dirrectory .'/' . $this -> pic_filname);
					$this -> current_foto [0] = @filesize(FOTO_DIR . '/main/' . $this -> dirrectory .'/' . $this -> pic_filname);
				} else {
					list($this -> current_foto [1], $this -> current_foto [2]) = getimagesize(FOTO_DIR . '/main/' . $this -> dirrectory .'/' . $this -> pic_filname);
					$this -> current_foto [0] = filesize(FOTO_DIR . '/main/' . $this -> dirrectory .'/' . $this -> pic_filname);
				}

			}

			$this -> counter++;
			$this -> upload_result[] = array($this -> current_name.'.'.$this -> current_type, "0");
			return array($this -> pic_filname, "0", $this -> current_foto [5], $this -> current_foto [0], $this -> current_foto [1], $this -> current_foto [2], $this -> current_url, $this -> current_foto [3], $this -> current_foto [4]);

		break;

		}

	 return 1;
	}

	function move_file_to_temp(){

		if ($this -> config['delete']) return;
		if ($this -> current_url != '') return;
		$this -> move_to_temp($this -> current_image, $this -> current_name . '.' . $this -> current_type);

	}

	function set_result($error, $text = ""){
		$this -> upload_result[] = array($this -> current_name . '.' . $this -> current_type, $error, $text);
	}

	function clear_result(){
		$this -> upload_result = array();
	}

	function clear_foto(){
		$this -> current_image = '';
		$this -> current_name = '';
		$this -> current_type = '';
		$this -> pic_filname = '';
		$this -> current_url = '';
		$this -> current_foto = array();
		@clearstatcache();
	}

	function clear_temp(){
		if ($this -> temp_folder['main'] == '') return;
		$this -> delete_folder(FOTO_DIR .'/temp/'. $this -> temp_folder['main']);
	}

	function totranslit($var){

		$NpjLettersFrom = "";
		$NpjLettersTo   = "abvgdeziklmnoprstufcy";
		$NpjBiLetters = array( 
		"" => "jj", "" => "jo", "" => "zh", "" => "kh", "" => "ch", "" => "sh", "" => "shh", "" => "je", "" => "ju", "" => "ja", "" => "", "" => "",
		);

		$NpjCaps  = "Ũ";
		$NpjSmall = "";

		$var = str_replace(".php", "", $var);
		$var = trim(strip_tags($var));
		$var = preg_replace( "/\s+/ms", "-", $var );
		$var = strtr( $var, $NpjCaps, $NpjSmall );
		$var = strtr( $var, $NpjLettersFrom, $NpjLettersTo );
		$var = strtr( $var, $NpjBiLetters );

		$var = preg_replace("/[^a-z0-9\_\-.]+/mi", "", $var);
		$var=preg_replace('#[\-]+#i', '-', $var);
		$var = strtolower ( $var );

		if (strlen($var) > 30) {
			$var = substr ($var, 0, 30);
			if (($temp_max = strrpos($var, '-')))  $var = substr ($var, 0, $temp_max);
		  }

	  return $var;
	}



}


?>