<?php
/*############################ COPYRIGHT NOTICE ############################*\
|| This script is part of PhotoPost vBGallery, a software application by    ||
|| All Enthusiast, Inc.  Use of any kind of part or all of this             ||
|| script or modification of this script requires a license from All        ||
|| Enthusiast, Inc.  Use or modification of this script without a license   ||
|| constitutes Software Piracy and will result in legal action from All     ||
|| Enthusiast, Inc.  All rights reserved.                                   ||
|| ############################### CONTACT ################################ ||
|| http://www.photopost.com                                                 ||
|| legal@photopost.com                                                      ||
|| PhotoPost Copyright 2008, All Enthusiast, Inc.                           ||
|| ############################### SCRIPT ################################# ||
|| Script: showimage_inlinemod.php                                          ||
|| Version: 1.00                                                            ||
|| Date: 2010/03/21                                                         ||
\*##########################################################################*/
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
if ($_REQUEST['do'] == 'inlinemerge' OR $_POST['do'] == 'doinlinemerge')
{
	define('GET_EDIT_TEMPLATES', true);
}
define('THIS_SCRIPT', 'showimage_inlinemod');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('threadmanage', 'posting', 'inlinemod');

// get special data templates from the datastore
$specialtemplates = array();

$globaltemplates = array(
	'threadadmin_authenticate',
	'adv_gallery_showimage_comment_delete'
);

$actiontemplates = array(
	'inlinedelete'  => array('imagecomment_deletemessages'),
	'picturedelete' => array('moderation_deletepictures'),
);

// ######################### REQUIRE BACK-END ############################
require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_picturecomment.php');
require_once(DIR . '/includes/modfunctions.php');
require_once(DIR . '/includes/functions_log_error.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

require_once(DIR . '/includes/class_bootstrap_framework.php');
require_once(DIR . '/vb/types.php');
vB_Bootstrap_Framework::init();
$types = vB_Types::instance();
$contenttypeid = $types->getContentTypeID('vBForum_Album');

if (($current_memory_limit = ini_size_to_bytes(@ini_get('memory_limit'))) < 128 * 1024 * 1024 AND $current_memory_limit > 0)
{
	@ini_set('memory_limit', 128 * 1024 * 1024);
}
@set_time_limit(0);

$itemlimit = 200;

// This is a list of ids that were checked on the page we submitted from
$vbulletin->input->clean_array_gpc('p', array(
	'imagecommentlist' => TYPE_ARRAY_KEYS_INT,
	'picturelist'        => TYPE_ARRAY_KEYS_INT,
	'imageid'       => TYPE_UINT,
));

$vbulletin->input->clean_array_gpc('c', array(
	'vbulletin_inlineimagecomment' => TYPE_STR,
));

if (!empty($vbulletin->GPC['vbulletin_inlineimagecomment']))
{
	$commentlist = explode('-', $vbulletin->GPC['vbulletin_inlineimagecomment']);
	$commentlist = $vbulletin->input->clean($commentlist, TYPE_ARRAY_UINT);

	$vbulletin->GPC['imagecommentlist'] = array_unique(array_merge($commentlist, $vbulletin->GPC['imagecommentlist']));
}

if ($_POST['do'] == 'doinlinedelete')
{

	$vbulletin->input->clean_array_gpc('p', array(
		'deletetype'   => TYPE_UINT, // 1 - Soft Deletion, 2 - Physically Remove
		'deletereason' => TYPE_NOHTMLCOND,
	));
	
	if($vbulletin->GPC['deletetype'] != 1)
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}
}
// get permissions


switch ($_POST['do'])
{
	case 'doinlinedelete':
	case 'dopicturedelete':
	{
		$inline_mod_authenticate = true;
		break;
	}
	default:
	{
		$inline_mod_authenticate = false;
		($hook = vBulletinHook::fetch_hook('imagecomment_inlinemod_authenticate_switch')) ? eval($hook) : false;
	}
}

if (!$vbulletin->userinfo['userid'])
{
	print_no_permission();
}
$imageid = $vbulletin->GPC['imageid'];

$image = $db->query_first("
	SELECT imageid, title, userid, catid
	FROM " . TABLE_PREFIX . "ppgal_images
	WHERE imageid = '$imageid'
");


// check gallery permissions

$imageid = intval($image['imageid']);
$image['userid'] = intval($image['userid']);
$image['catid'] = intval($image['catid']);

check_image_id($imageid);



$categoryperms = fetch_category_perms();
if (((!$categoryperms["$image[catid]"]['candeleteothersposts'] AND $vbulletin->userinfo['userid'] == $image['userid']) OR ($categoryperms["$image[catid]"]['candeleteothersposts'] AND $vbulletin->userinfo['userid'] != $image['userid'])) AND !is_category_mod($image['catid']))
{
	print_no_permission();
}


if ($inline_mod_authenticate AND !inlinemod_authenticated())
{
	//show_inline_mod_login();
}


switch ($_POST['do'])
{
	case 'inlinedelete':
	case 'inlineapprove':
	case 'inlineunapprove':
	case 'inlineundelete':

		if (!$vbulletin->options['pc_enabled'])
		{
			print_no_permission();
		}

		if (empty($vbulletin->GPC['imagecommentlist']))
		{
			standard_error(fetch_error('you_did_not_select_any_valid_messages'));
		}

		if (count($vbulletin->GPC['imagecommentlist']) > $itemlimit)
		{
			standard_error(fetch_error('you_are_limited_to_working_with_x_messages', $itemlimit));
		}

		$messageids = implode(', ', $vbulletin->GPC['imagecommentlist']);
		break;

	case 'doinlinedelete':

		if (!$vbulletin->options['pc_enabled'])
		{
			print_no_permission();
		}

		$vbulletin->input->clean_array_gpc('p', array(
			'messageids' => TYPE_STR,
		));
		$messageids = explode(',', $vbulletin->GPC['messageids']);
		$messageids = $vbulletin->input->clean($messageids, TYPE_ARRAY_UINT);

		if (count($messageids) > $itemlimit)
		{
			standard_error(fetch_error('you_are_limited_to_working_with_x_messages', $itemlimit));
		}
		break;
}

// set forceredirect for IIS
$forceredirect = (strpos($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS') !== false);

$messagelist = $messagearray = $userlist = array();
// not regisetered hook !!!!!!!!!!!!!!
//($hook = vBulletinHook::fetch_hook('ppg_imagecomments_inlinemod_start')) ? eval($hook) : false;

if ($_POST['do'] == 'clearpicture')
{
	setcookie('vbulletin_inlinepicture', '', TIMENOW - 3600, '/');

	eval(print_standard_redirect('redirect_inline_messagelist_cleared', true, $forceredirect));
}

if ($_POST['do'] == 'clearmessage')
{
	setcookie('vbulletin_inlineimagecomment', '', TIMENOW - 3600, '/');

	eval(print_standard_redirect('redirect_inline_messagelist_cleared', true, $forceredirect));
}

if ($_POST['do'] == 'doinlinedelete')
{

	$checkpost =& $messageids;

	$delcount = 0;
	if (is_array($checkpost))
	{
		$postids = array(0);
		foreach ($checkpost AS $key => $val)
		{
			if ($checkpost["$key"])
			{
				$delcount++;
				$postids[] = $val;
			}
		}


		// we get postinfo with catid and imageid for each post to delete

		$posts = $db->query_read("
				SELECT posts.postid AS postid, posts.imageid AS imageid, images.catid AS catid, categories.lastpostid AS lastpostid
				FROM " . TABLE_PREFIX . "ppgal_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
				LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
			
				WHERE posts.postid IN (" . implode(',', $postids) . ")
				ORDER BY posts.dateline
		");
		$delpostinfo = array();
		if ($db->num_rows($posts))
		{
			while ($post = $vbulletin->db->fetch_array($posts))
			{		
				$thispost = $post['postid'];
				$thisimage = $post['imageid'];
				$thiscat = $post['catid'];
				$delpostinfo[$thispost] = $post;
				$delcats[$thiscat][$thispost] = $post;
				$delimages[$thisimage][$thispost] = $post;
			}
			unset($post,$thispost);

		}
		else
		{
			// we should never get here as postids is not empty
			die('debug error: No posts to delete in query');
		}
		$db->free_result($posts);
		
		$delimageids = array();

		foreach ($delimages AS $key => $val)
		{
			if ($delimages["$key"])
			{
				
				$delimageids["$key"] = $val;

			}
			
		}
		unset($delimages,$key,$val);
		



$postids = array();
$delpost = array();
$delcount = array();
$catid = array();
$lastpostid = array();
$delcount = array();
$imageid = array();

		foreach ($delimageids AS $key => $val)
		{
	

			$delpost = array();
			$delpost[$key] = array(0);
			$delcount[$key] = count($delimageids[$key]);
			$count = 0;
			foreach($val AS $postkey => $postval)
			{
				$delpost[$key][] = $postkey;
				$count++;
				$catid[$key] = $postval['catid'];
				$lastpostid[$key] = $postval['lastpostid'];
			}

			$postids[$key] = implode(',', $delpost[$key]);
			
			$delcount[$key] = $count;
			$imageid[$key] = $key;
			if (!is_category_mod($catid[$key]))
			{
				print_no_permission();
			}
			$thisdelpost = $postids[$key]; 
			$thisdelcount = $delcount[$key]; 
			$thisimageid = $imageid[$key]; 
			$thiscatid = $catid[$key];

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid IN($thisdelpost)");
			
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET posts = posts-$thisdelcount WHERE imageid = '$thisimageid'");
	
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_categories SET postcount = postcount-$thisdelcount WHERE catid = '$thiscatid'");


			$imageposts = $db->query_first("SELECT userid, dateline, username FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$thisimageid' ORDER BY dateline DESC");

			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "ppgal_images SET lastpostdateline = '$imageposts[dateline]', lastpostuserid = '$imageposts[userid]', lastpostusername = '$imageposts[username]' WHERE imageid = '$thisimageid'");

			if (in_array($lastpostid[$key], $delpost[$key]))
			{

				$thiscatlastpost = $db->query_first("
						SELECT postid, posts.userid, posts.username, posts.dateline, images.title
						FROM " . TABLE_PREFIX . "ppgal_posts AS posts
						LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images ON (posts.imageid = images.imageid)
						WHERE images.catid = '$thiscatid' AND visible = 1
						ORDER BY images.dateline ASC
				");

				$cats = array();
				$cats['lastpostid'] = $thiscatlastpost['postid'];
				$cats['lastpostuserid'] = $thiscatlastpost['userid'];
				$cats['lastpostusername'] = $thiscatlastpost['username'];
				$cats['lastpostdateline'] = $thiscatlastpost['dateline'];
				$cats['lastpostimagetitle'] = $thiscatlastpost['title'];

				$db->query_read(fetch_query_sql($cats, 'ppgal_categories', 'WHERE catid = ' . $thiscatid));
			}
		}

	}
// empty cookie
	setcookie('vbulletin_inlineimagecomment', '', TIMENOW - 3600, '/');
	
eval(print_standard_redirect('adv_gallery_posts_deleted', true, $forceredirect));




}

if ($_POST['do'] == 'inlinedelete')
{
	$show['removemessages'] = false;
	$show['deletemessages'] = false;
	$show['deleteoption'] = false;
	$checked = array('delete' => 'checked="checked"');
	$picturelist = array();
	$messagearray = array();
	$delmessageids =& $vbulletin->GPC['imagecommentlist'];
	if(empty($delmessageids))
	{
		$delmessageids = array(0);
	}
	
	$posts = $db->query_read("
			SELECT postid, posts.title, posts.imageid, pagetext, posts.username, posts.userid, posts.dateline, images.title AS imagetitle, images.catid, categories.title AS cattitle, parentlist
			FROM " . TABLE_PREFIX . "ppgal_posts AS posts
			LEFT JOIN " . TABLE_PREFIX . "ppgal_images AS images USING (imageid)
			LEFT JOIN " . TABLE_PREFIX . "ppgal_categories AS categories USING (catid)
		
			WHERE posts.postid IN (" . implode(',', $delmessageids) . ")
			ORDER BY posts.dateline
	");
		//WHERE posts.imageid = '$imageid'
		// add title date etc.. as we could use it for other inline mods..
	if ($db->num_rows($posts))
	{
		while ($post = $vbulletin->db->fetch_array($posts))
		{
			$image['title'] = stripslashes($post['imagetitle']);
			$post['postdate'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
			$post['posttime'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
			$categoryid = $post['catid'];
			$parentlist = $post['parentlist'];
			$postid = intval($post['postid']);
             //   eval('$postbits .= "' . fetch_template('threadadmin_postbit') . '";');
			if(in_array($postid, $vbulletin->GPC['imagecommentlist']))
			{
				$messagearray["$post[postid]"] = $post;
				$picturelist["$post[imageid]"] = true;
				$userlist["$post[userid]"] = true;
			}

		}
		$show['deleteoption'] = true;
		$show['deletemessages'] = true;

		
	}

	if (!is_category_mod($categoryid))
	{
		print_no_permission();
	}


	if (empty($messagearray))
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}

	$messagecount = count($messagearray);
	$picturecount = count($picturelist);

	$url =& $vbulletin->url;

	$navbits = array('' => $vbphrase['delete_messages']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);

//	($hook = vBulletinHook::fetch_hook('picturecomment_inlinemod_delete')) ? eval($hook) : false;
//print_r($checked); 
//print   ' <br /> ' .$messagecount. ' - ' . $picturecount . ' - ' . $url . '<br />';
//print_r($messageids); exit;
	$templater = vB_Template::create('adv_gallery_showimage_comment_delete');
		$templater->register_page_templates();
		$templater->register('checked', $checked);
		$templater->register('imageid', $imageid);
		$templater->register('messagecount', $messagecount);
		$templater->register('ppg_vars', $ppg_vars);
		$templater->register('messageids', $messageids);
		$templater->register('navbar', $navbar);
		$templater->register('picturecount', $picturecount);
		$templater->register('url', $url);
	print_output($templater->render());

}




if ($_POST['do'] == 'inlineapprove' OR $_POST['do'] == 'inlineunapprove')
{
	$insertrecords = array();

	$approve = ($_POST['do'] == 'inlineapprove');

	// Validate Messages
	$messages = $db->query_read_slave("
		SELECT
			picturecomment.*, a.userid AS picture_userid, a.caption AS picture_caption, a.attachmentid
		FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
		INNER JOIN " . TABLE_PREFIX . "attachment AS a ON (a.filedataid = picturecomment.filedataid AND a.userid = picturecomment.userid)
		WHERE
			a.contenttypeid = $contenttypeid
				AND
			picturecomment.commentid IN ($messageids)
				AND
			picturecomment.state IN (" . ($approve ? "'moderation'" : "'visible', 'deleted'") . ")
	");
	while ($message = $db->fetch_array($messages))
	{
		$pictureinfo = array(
			'attachmentid' => $message['attachmentid'],
			'userid'       => $message['picture_userid']
		);

		if ($message['state'] == 'deleted' AND !can_moderate(0, 'candeletepicturecomments'))
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_deleted_messages'));
		}
		else if (!fetch_user_picture_message_perm('canmoderatemessages', $pictureinfo, $message))
		{
			standard_error(fetch_error('you_do_not_have_permission_to_moderate_messages'));
		}

		$messagearray["$message[commentid]"] = $message;
		$userlist["$pictureinfo[userid]"] = true;

		if (!$approve)
		{
			$insertrecords[] = "($message[commentid], 'picturecomment', " . TIMENOW . ")";
		}
	}

	if (empty($messagearray))
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}

	// Set message state
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "picturecomment
		SET state = '" . ($approve ? 'visible' : 'moderation') . "'
		WHERE commentid IN (" . implode(',', array_keys($messagearray)) . ")
	");

	if ($approve)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "moderation
			WHERE primaryid IN(" . implode(',', array_keys($messagearray)) . ")
				AND type = 'picturecomment'
		");
	}
	else	// Unapprove
	{
		$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "moderation
				(primaryid, type, dateline)
			VALUES
				" . implode(',', $insertrecords) . "
		");

		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "deletionlog
			WHERE type = 'picturecomment' AND
				primaryid IN(" . implode(',', array_keys($messagearray)) . ")
		");
	}

	foreach (array_keys($userlist) AS $userid)
	{
		build_picture_comment_counters($userid);
	}

	foreach ($messagearray AS $commentinfo)
	{
		log_moderator_action($commentinfo,
			($approve ? 'pc_by_x_on_y_approved' : 'pc_by_x_on_y_unapproved'),
			array($commentinfo['postusername'], fetch_trimmed_title($commentinfo['picture_caption'], 50))
		);
	}

	setcookie('vbulletin_inlineimagecomment', '', TIMENOW - 3600, '/');

	($hook = vBulletinHook::fetch_hook('imagecomment_inlinemod_approveunapprove')) ? eval($hook) : false;

	if ($approve)
	{
		eval(print_standard_redirect('redirect_inline_approvedmessages', true, $forceredirect));
	}
	else
	{
		eval(print_standard_redirect('redirect_inline_unapprovedmessages', true, $forceredirect));
	}
}




if ($_POST['do'] == 'inlineundelete')
{
	// Validate Messages
	$messages = $db->query_read_slave("
		SELECT picturecomment.*, a.userid AS picture_userid, a.caption AS picture_caption
		FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
		INNER JOIN " . TABLE_PREFIX . "attachment AS a ON (a.filedataid = picturecomment.filedataid AND a.userid = picturecomment.userid AND a.contenttypeid = " . intval($contenttypeid) . ")
		WHERE picturecomment.commentid IN ($messageids)
			AND picturecomment.state = 'deleted'
	");
	while ($message = $db->fetch_array($messages))
	{
		$pictureinfo = array(
			'attachmentid' => $message['attachmentid'],
			'userid'       => $message['picture_userid']
		);
		if (!can_moderate(0, 'candeletepicturecomments'))
		{
			standard_error(fetch_error('you_do_not_have_permission_to_manage_deleted_messages'));
		}

		$messagearray["$message[commentid]"] = $message;
		$userlist["$pictureinfo[userid]"] = true;
	}

	if (empty($messagearray))
	{
		standard_error(fetch_error('you_did_not_select_any_valid_messages'));
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "deletionlog
		WHERE type = 'picturecomment' AND
			primaryid IN(" . implode(',', array_keys($messagearray)) . ")
	");
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "picturecomment
		SET state = 'visible'
		WHERE commentid IN(" . implode(',', array_keys($messagearray)) . ")
	");

	foreach(array_keys($userlist) AS $userid)
	{
		build_picture_comment_counters($userid);
	}

	if (can_moderate(0, 'candeletepicturecomments'))
	{
		foreach ($messagearray AS $message)
		{
			log_moderator_action($message, 'pc_by_x_on_y_undeleted',
				array($message['postusername'], fetch_trimmed_title($message['picture_caption'], 50))
			);
		}
	}

	// empty cookie
	setcookie('vbulletin_inlineimagecomment', '', TIMENOW - 3600, '/');

	($hook = vBulletinHook::fetch_hook('imagecomment_inlinemod_undelete')) ? eval($hook) : false;

	eval(print_standard_redirect('redirect_inline_undeletedmessages', true, $forceredirect));
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 00:58, Tue Dec 22nd 2009
|| # SVN: $Revision: 32878 $
|| ####################################################################
\*======================================================================*/
