<?php
//////////////////////////// COPYRIGHT NOTICE //////////////////////////////
// This script is part of PhotoPost vBGallery, a software application by  //
// All Enthusiast, Inc.  Use of any kind of part or all of this           //
// script or modification of this script requires a license from All      //
// Enthusiast, Inc.  Use or modification of this script without a license //
// constitutes Software Piracy and will result in legal action from All   //
// Enthusiast, Inc.  All rights reserved.                                 //
// http://www.photopost.com      legal@photopost.com                      //
//                                                                        //
//            PhotoPost Copyright 2008, All Enthusiast, Inc.              //
////////////////////////////////////////////////////////////////////////////

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'showimage');
define('GET_IMGTYPE_ARRAY', true);
define('GET_EDIT_TEMPLATES', true);
define('PP_SCRIPT', 'vBGallery');

// ################### PRE-CACHE TEMPLATES AND DATA ######################

// get special phrase groups
$phrasegroups = array(
	'adv_gallery_showimg',
	'postbit',
	'showthread',
	'reputationlevel',
	'posting'
);

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
	'attachmentcache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'ADV_GALLERY_SHOWIMAGE',
	'adv_gallery_showimage_custombits',
	'adv_gallery_showimage_exifbits',
	'adv_gallery_showimage_filmthumb',
	'adv_gallery_showimage_keywordbit',
	'editor_clientscript',
	'editor_jsoptions_font',
	'editor_jsoptions_size',
	'im_aim',
	'im_yahoo',
	'im_icq',
	'im_msn',
	'im_skype',
	'navbar_main',
	'bbcode_quote',
	'postbit',
    'bbcode_code',
	'bbcode_html',
	'bbcode_php',
	'bbcode_quote',
    'postbit_wrapper',
	'postbit_legacy',
	'postbit_buttons',
	'postbit_ignore',
	'postbit_ip',
	'postbit_onlinestatus',
	'postbit_reputation',
	'showthread_quickreply'
);

// ######################### REQUIRE BACK-END ############################

require_once('./gallery_global.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/class_bbcode.php');
require_once(DIR . '/includes/class_postbit.php');


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

($hook = vBulletinHook::fetch_hook('ppgal_showimage_start')) ? eval($hook) : false;

$postid = $vbulletin->input->clean_gpc('r', 'postid', TYPE_INT);
$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_INT);
$goto = $vbulletin->input->clean_gpc('r', 'goto', TYPE_NOHTML);
$orderby = $vbulletin->input->clean_gpc('r', 'orderby', TYPE_NOHTML);
$direction = $vbulletin->input->clean_gpc('r', 'direction', TYPE_NOHTML);
$imageuser = $vbulletin->input->clean_gpc('r', 'imageuser', TYPE_INT);
$searchid = $vbulletin->input->clean_gpc('r', 'searchid', TYPE_INT);
$original = $vbulletin->input->clean_gpc('r', 'original', TYPE_INT);
$noignore = $vbulletin->input->clean_gpc('r', 'noignore', TYPE_INT);
$cutoffdate = $vbulletin->input->clean_gpc('r', 'cutoffdate', TYPE_NOHTML);

function get_ext( $filename )
{
    return substr( $filename, strrpos($filename,".") );
}
// Request Image ID  for Post
if ($postid AND !$imageid)
{
	$getimageid = $db->query_first("SELECT imageid FROM " . TABLE_PREFIX . "ppgal_posts WHERE postid = '$postid'");
	exec_header_redirect('showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $getimageid['imageid'] . '&noignore=' . $noignore . '&postid=' . $postid . '#post' . $postid);
}

// Request Last Post
if ($goto == 'lastpost')
{
	if ($imageid AND !$postid)
	{
		$getpostid = $db->query_first("SELECT postid FROM " . TABLE_PREFIX . "ppgal_posts WHERE imageid = '$imageid' ORDER BY dateline DESC");
		exec_header_redirect('showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $imageid . '#post' . $getpostid['postid']);
	}
}

check_image_id($imageid);

$limit = '';

$wherequery = array();

// Only show images that not moderated
$wherequery[] = 'valid = 1';

// Check to ignore list
$ignquery = fetch_ignored_users($image['catid']);
if ($ignquery)
{
	$wherequery[] = 'images.userid NOT IN(' . $ignquery . ')';
}

// Previous link, Next link, Filmstrip
if ($goto == 'next' OR $goto == 'previous' OR $ppg_options['gallery_filmstrip'])
{

	if ($userid)
	{
		$wherequery[] = 'images.userid = ' . $userid;
	}

	if ($catid == 'searchresults')
	{
		$search = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "ppgal_search WHERE searchid = '$searchid'");
		$orderby = $search['orderby'];
		$direction = $search['direction'];
    		if (!$search['searchid'])
    		{
    			eval(standard_error(fetch_error('searchnoresults', '')));
    		}
	}
	$doorderby = construct_orderby();

	if ($orderby == 'rating')
	{
		$votequery = 'IF(votenum >= ' . iif($catid == 'popimages', $ppg_options['gallery_popimages_votelimit'], $vbulletin->options['showvotes']) . ', votenum, 0) AS votenum, IF(votenum >= ' . iif($catid == 'popimages', $ppg_options['gallery_popimages_votelimit'], $vbulletin->options['showvotes']) . ' AND votenum> 0, votetotal / votenum, 0) AS voteavg,';
	}

	// Figure out which category we're dealing with
	switch ($catid)
	{
		// User Favorites
		case 'favorites':

			$favquery = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_favorites AS favorites USING (imageid)';
			$wherequery[] = 'favorites.userid = \'' . $vbulletin->userinfo['userid'] . '\'';
			break;

		// Popular images
		case 'popimages':
			$limit = $ppg_options['gallery_popimagelimit'];
			if ($orderby == 'rating')
			{
				$doorderby = 'voteavg DESC, votenum';
				$wherequery[] = 'votenum >= ' . $ppg_options['gallery_popimages_votelimit'];
			}
			$direction = 'DESC';
			break;

		// New Images
		case 'newimages':
			$doorderby = 'dateline';
			$direction = 'DESC';
			if ($cutoffdate)
			{
				$wherequery[] = 'images.dateline > ' . iif($cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (time() - ($cutoffdate * 86400)));
			}
			else
			{
				$limit = $ppg_options['gallery_newhomeimages'];
			}

			break;

		// New Posts
		case 'newposts':
			$wherequery[] = 'images.posts != 0 AND images.lastpostdateline > ' . iif(!$cutoffdate OR $cutoffdate == 'lastvisit', $vbulletin->userinfo['lastvisit'], (time() - ($cutoffdate * 86400)));;
			$doorderby = 'images.lastpostdateline';
			$direction = 'DESC';
			break;

		// Member Search
		case 'member':
			$wherequery[] = 'userid = \'' . $imageuser . '\'';
			break;

		case 'searchresults':
			$wherequery[] = 'imageid IN (' . $search['imageids'] . ')';
			break;

		// Category ID
		default:
			$cat = intval($catid);

			// In case of a reply, there won't be a catid... Assume we're in a category
			if (!$cat)
			{
				$getcat = $db->query_first("SELECT catid FROM " . TABLE_PREFIX . "ppgal_images WHERE imageid = '$imageid'");
				$cat = $getcat['catid'];
			}

			$wherequery[] = 'catid = \'' . $cat . '\'';
	}


	if ($privatecatids = fetch_private_categories())
	{
		$wherequery[] = 'images.catid NOT IN(' . $privatecatids . ')';
	}

	if (!in_array($direction, array('DESC', 'ASC')))
	{
		$direction = $ppg_options['gallery_defdirection'];
	}

	if (in_array($goto, array('next', 'previous')))
	{
		$counter = 0;
		$imagearray = array();
		$getids = $db->query_read("
				SELECT $votequery images.imageid
				FROM " . TABLE_PREFIX . "ppgal_images AS images
				$favquery
				WHERE " . implode(' AND ', $wherequery) . "
				ORDER BY $doorderby $direction, images.imageid
				" . iif($limit, 'LIMIT ' . $limit)
		);
		while($prevnext = $vbulletin->db->fetch_array($getids))
		{
			$counter ++;
			$imagearray[] = $prevnext['imageid'];
		}

		$db->free_result($getids);
		unset($prevnext);

		$key = array_search($imageid, $imagearray);
		if ($goto == 'next')
		{
			$imageid = iif(isset($imagearray[$key+1]), $imagearray[$key+1], $imagearray[0]);
		}
		else
		{
			$imageid = iif(isset($imagearray[$key-1]), $imagearray[$key-1], $imagearray[$counter-1]);
		}
	}
}

// Show user favorites
if ($vbulletin->userinfo['userid'] AND $ppg_options['gallery_allowfav'])
{
	$query['favfields'] = ',NOT ISNULL(favorites.imageid) AS favid';
	$query['favjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_favorites AS favorites ON (favorites.imageid = images.imageid AND favorites.userid = ' . $vbulletin->userinfo['userid'] . ')';
}

// Show if subscribe
if ($show['subscribe'])
{
	$query['subfields'] = ',NOT ISNULL(subscribeimage.imageid) AS issubscribed';
	$query['subjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_subscribeimage AS subscribeimage ON (subscribeimage.imageid = images.imageid AND subscribeimage.userid = ' . $vbulletin->userinfo['userid'] . ')';
}

// Show EXIF data
if ($ppg_options['gallery_showexif'])
{
	$query['exiffields'] = ', exifinfo';
	$query['exifjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'ppgal_exif AS exif ON (images.imageid = exif.imageid)';
}

$image = $db->query_first("
		SELECT categories.title AS cattitle, categories.description AS catdesc, images.imageid, username, images.userid, images.title, images.catid, dateline, images.description, keywords, filename, thumbname, width, height, extension, filesize, originalname, originalfilesize, originalwidth, originalheight, views, posts, valid, open, sticky, votenum, votetotal, options, catimage, catuserid, membercat, useroptions, adv_setting, customfields.*
		$query[favfields]
		$query[subfields]
		$query[exiffields]
		FROM " . TABLE_PREFIX . "ppgal_images AS images
		LEFT JOIN " . TABLE_PREFIX ."ppgal_categories AS categories ON (images.catid = categories.catid)
		LEFT JOIN " . TABLE_PREFIX . "ppgal_customfields_entries AS customfields ON (images.imageid = customfields.imgid)
		$query[favjoin]
		$query[subjoin]
		$query[exifjoin]
		WHERE images.imageid = '$imageid'
");

$adv_options = unserialize($image['adv_setting']);

// Check is image is set to watermark
if ($adv_options['gallery_watermark'] AND !$ppg_options['gallery_permwatermark'])
{
	$ppg_options['gallery_echoimage'] = true;
}

// Check if the image is not valid and user is not category mod no permission
if (!$image['valid'] AND !is_category_mod($image['catid']))
{
	print_no_permission();
}

// Check if user can see the image
$categoryperms = fetch_category_perms();

check_image_view($image, 'showimage');

if (!$categoryperms["$image[catid]"]['canvieworiginal'] AND $original)
{
	print_no_permission();
}

// Create previous link, next link
$adv_sorturl = construct_adv_sort_url();

$prevurl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;goto=previous' . $adv_sorturl;
$nexturl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;goto=next' . $adv_sorturl;

// Filmstrip
if ($ppg_options['gallery_filmstrip'])
{
	if ($image['membercat'] AND (intval($catid) OR !$catid))
	{
		$wherequery[] = 'images.userid = ' . intval($image['userid']);
	}
	$imagearray = array();
	$filmcache = array();
	$getids = $db->query_read("
			SELECT $votequery images.imageid, images.title, images.userid, images.thumbname, extension
			FROM " . TABLE_PREFIX . "ppgal_images AS images
			$favquery
			WHERE " . implode(' AND ', $wherequery) . "
			ORDER BY $doorderby $direction, images.imageid DESC
			" . iif($limit, 'LIMIT ' . $limit)
	);

	while($prevnext = $vbulletin->db->fetch_array($getids))
	{
		$imagearray[] = $prevnext['imageid'];
		$filmcache["$prevnext[imageid]"] = $prevnext;
	}

	$db->free_result($getids);
	unset($prevnext);

	$idsize = sizeof($imagearray);

	$key = array_search($imageid, $imagearray);

	$filmstrip = array();
	$halfcount = ceil($ppg_options['gallery_filmstrip'] / -2);
	$nextcount = 0;
	$prevcount = 0;
	$startsub = 0;
	$idcount = 0;
	while ($idcount < $ppg_options['gallery_filmstrip'])
	{
		$imgid = $imagearray[$key+$halfcount];

		if ($halfcount == -1)
		{
			$prevurl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . iif($imgid, $imgid, $imagearray[$idsize-1]) . $adv_sorturl;
		}
		if ($halfcount == 1)
		{
			$nexturl = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . iif ($imgid, $imgid, $imagearray[0]) . $adv_sorturl;
		}

		if ($imgid)
		{
			$filmstrip["$imgid"] = $filmcache["$imgid"];
			if ($halfcount == 0)
			{
				$filmstrip["$imgid"]['filmarrow'] = '&nbsp;';
			}
			else if ($halfcount > 0)
			{
				$filmstrip["$imgid"]['filmarrow'] = str_repeat('&rsaquo;', abs($halfcount));
			}
			else
			{
				$filmstrip["$imgid"]['filmarrow'] = str_repeat('&lsaquo;', abs($halfcount));
			}
		}

		$idcount++;
		$halfcount++;
	}

	unset($filmcache, $imagearray);

	if (!empty($filmstrip))
	{
		$filmcellwidth = round(100 / sizeof($filmstrip)) . '%';
		$show['filmstrip'] = true;
		foreach ($filmstrip AS $imgid => $imginfo)
		{
			$imginfo['url'] = construct_image_url($imginfo, 'thumbname');
			eval('$filmstripthumbs .= "' . fetch_template('adv_gallery_showimage_filmthumb') . '";');
		}
	}
}

$catopts = construct_cat_opts($image['catid'], $image['options']);

if ($image['catuserid'])
{
	$useroptions = construct_cat_user_opts($image['catid'], $image['useroptions']);
}

// Rating
if ($categoryperms["$image[catid]"]['canrateimages'] AND $catopts['allow_ratings'] AND $ppg_options['gallery_allowrating'] AND ($useroptions['allow_rating'] OR !$image['catuserid']))
{
	if ($image['votenum'])
	{
		$image['voteavg'] = vb_number_format($image['votetotal'] / $image['votenum'], 2);
	}
	$show['ratelink'] = true;
}

$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

$show['modopts'] = is_category_mod($image['catid']);

$vbulletin->db->query_write("UPDATE LOW_PRIORITY " . TABLE_PREFIX . "ppgal_images SET views = views + 1 WHERE imageid = '$image[imageid]'");

$image['title'] = stripslashes($image['title']);
if (!$image['title'])
{
	$image['title'] = $image['filename'];
}

$image['description_clean'] = htmlspecialchars_uni(strip_bbcode(fetch_trimmed_title(strip_tags($image['description']), 170), false, true));
$image['description_clean'] = str_replace(chr(10), " ", $image['description_clean']); //remove carriage returns
$image['description_clean'] = str_replace(chr(13), " ", $image['description_clean']); //remove carriage returns

if ($image['description']){
$image['description_meta'] = "<meta name=\"description\" content=\"".$image['description_clean']."\" />";
$headinclude = eregi_replace("<meta name=\"description\"[^>]*>", $image['description_meta'], $headinclude);
}

$image['description'] = $bbcode_parser->do_parse(stripslashes($image['description']), $catopts['allow_desc_html'], $catopts['allow_desc_smilies'], $catopts['allow_desc_bbcode'], $catopts['allow_desc_bbimgcode']);
$image['views'] = vb_number_format($image['views']);
$image['posts'] = iif(!$categoryperms["$image[catid]"]['canviewreplies'], 0, vb_number_format($image['posts']));
$image['keywords'] = stripslashes($image['keywords']);
$image['dateadded'] = vbdate($vbulletin->options['dateformat'], $image['dateline']);
$image['timeadded'] = vbdate($vbulletin->options['timeformat'], $image['dateline']);
$image['username'] = stripslashes($image['username']);
$image['filesize'] = vb_number_format($image['filesize'], 1, true);
$image['originalfilesize'] = vb_number_format($image['originalfilesize'], 1, true);
$image['folderstring'] = fetch_folder_url($image);
$image['url'] = construct_image_url($image, iif($original, 'originalname', 'filename'));
$imagecode = construct_image_url($image, iif($original, 'originalname', 'filename'), true);
$image['thumbnail'] = construct_image_url($image, 'thumbname');
$image['catimage'] = unserialize($image['catimage']);
$catinfo['title'] = $image['cattitle'];
$catinfo['description'] = $image['catdesc'];

if ($ppg_options['gallery_fileurl'] . '/' . $image['catimage']['url'] == $image['thumbnail'])
{
	$show['removecatimage'] = true;
}

if ($ppg_options['gallery_watermark'] AND $ppg_options['gallery_originalwindow'])
{
	$image['originalurl'] = 'displayimage.php?imageid=' . $image['imageid'] . '&original=1' . $adv_sorturl;
}
else if ($ppg_options['gallery_originalwindow'])
{
	$image['originalurl'] = $image['folderstring'] . '/' . $image['originalname'];
}
else
{
	$image['originalurl'] = 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i=' . $image['imageid'] . '&amp;original=1';
}

$show['ecard'] = iif($categoryperms["$image[catid]"]['cansendecard'] AND $ppg_options['gallery_enableecards'], true, false);

if ($searchid)
{
	$search = $db->query_first("SELECT string, sfields, wholeword FROM " . TABLE_PREFIX . "ppgal_search WHERE searchid = '$searchid'");

	$sfields = explode(',', $search['sfields']);

	if (in_array('description', $sfields))
	{
		$image['description'] = highlight_keywords($image['description'], $search['string'], $search['wholeword']);
	}
}

// Show keywords
if ($image['keywords'])
{
    // Lets make <meta> tag keywords from image keywords
    // ** need to add option to count total keywords and trim off default site keywords if needed to not exceed meta tag limit.
    $image['keywords_meta'] = explode(' ', trim($image['keywords']));
    $image['keywords_meta'] = implode(",", $image['keywords_meta']);

      // merge image keywords to site keywords
    $headinclude = str_replace(
		array(
            'name="keywords" content="'
   		),
		array(
            'name="keywords" content="'.$image['keywords_meta'].','
 		),
		$headinclude
	);

    // convert keywords to links
    if ($ppg_options['gallery_convertkeywords'])
	{
		$kwords = explode(' ', trim($image['keywords']));
		$image['keywords'] = '';
		foreach ($kwords AS $keyword)
		{
			if ($keywords)
			{
				$comma = ',';
			}

			if ($searchid)
			{
				if (in_array('keywords', $sfields))
				{
					$image['keyword'] = highlight_keywords($keyword, $search['string'], $search['wholeword']);
				}
			}

			eval('$image[\'keywords\'] .= "$comma ' . fetch_template('adv_gallery_showimage_keywordbit') . '";');
		}
	}
}
else
{
	$image['keywords'] = $vbphrase['none'];
}

// Show ownership of a categories
if (substr($image['username'], -1) != 's')
{
	$plurals = $vbphrase['plural_s'];
}

// Show the correct OLD / NEW statusicon image
$image['statusicon'] = iif($image['dateline'] > $vbulletin->userinfo['lastvisit'], 'new', 'old');

// Show True Rating
$image['truerating'] = 0;
if ($image['votetotal'])
{
	$image['truerating'] = vb_number_format($image['votetotal'] / $image['votenum'], 2);
	$image['roundrating'] = round($image['truerating']);
}

// Show Customfields
$customfields = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "ppgal_customfields ORDER BY displayorder");
if ($db->num_rows($customfields))
{
	while ($field = $vbulletin->db->fetch_array($customfields))
	{
		$thisfield = 'field' . $field['fieldid'];
		if (!$image["$thisfield"])
		{
			continue;
		}

		$show['customfields'] = true;
		$bgclass = exec_switch_bg();

		$field['value'] = $bbcode_parser->do_parse($image["$thisfield"], $catopts['allow_custom_html'], $catopts['allow_custom_smilies'], $catopts['allow_custom_bbcode'], $catopts['allow_custom_bbimgcode']);
		if ($searchid)
		{
			if (in_array($thisfield, $sfields))
			{
				$field['value'] = highlight_keywords($image["$thisfield"], $search['string'], $search['wholeword']);
			}
		}
		eval('$customfieldbits .= "' . fetch_template('adv_gallery_showimage_custombits') . '";');
	}
}
$db->free_result($customfields);
unset($field);


// Show EXIF tables
$image['exifinfo'] = unserialize($image['exifinfo']);

if (!empty($image['exifinfo']) AND $ppg_options['gallery_exiffields'])
{
	$counter = 0;
	$exif['display'] = explode("\r\n", $ppg_options['gallery_exiffields']);

	$show['camerainfo'] = true;
	function process_exif($title, $value)
	{
		global $exif, $exifrows, $counter;

		if (in_array($title, $exif['display']))
		{
			if ($counter == 2)
			{
				$exifrows .= '</tr><tr>';
				$counter	 = 0;
			}
			$counter++;
			eval('$exifrows .= "' . fetch_template('adv_gallery_showimage_exifbits') . '";');
		}
	}

	foreach ($image['exifinfo'] AS $title => $value)
	{
		if (is_array($value))
		{
			foreach ($value AS $title => $value)
			{

		if ($title AND in_array($title, $exif['display']))
		{
			if ($counter == 2)
			{
				$exifrows .= '</tr><tr>';
				$counter	 = 0;
			}
			$counter++;
			eval('$exifrows .= "' . fetch_template('adv_gallery_showimage_exifbits') . '";');
		}


			}
		}
		else
		{
		if (in_array($title, $exif['display']))
		{
			if ($counter == 2)
			{
				$exifrows .= '</tr><tr>';
				$counter	 = 0;
			}
			$counter++;
			eval('$exifrows .= "' . fetch_template('adv_gallery_showimage_exifbits') . '";');
		}
		}
	}
	$exifrows .= construct_empty_cellbits(2, 2);
}

unset($exif);

// Check to see if reply link should be shown
if ($ppg_options['gallery_allowreplies'] AND $categoryperms["$image[catid]"]['canreplytoimages'] AND $catopts['open_for_posts'] != 0  AND $catopts['allow_replies'])
{
	$show['replylink'] = true;
}

// Check to see if send to a friend
if ($categoryperms["$image[catid]"]['cansendimagetofriend'])
{
	$show['sendtofriend'] = true;
}

// Check to see if user can edit
if ($vbulletin->userinfo['userid'] AND (($image['userid'] == $vbulletin->userinfo['userid'] AND $categoryperms["$image[catid]"]['caneditimages']) OR $categoryperms["$image[catid]"]['caneditothersimages'] OR is_category_mod($image['catid'])))
{
	$show['editlink'] = true;
}

// ######################### Replies to Image #############################
if ($ppg_options['gallery_allowreplies'] AND $categoryperms["$image[catid]"]['canviewreplies'] AND $catopts['allow_replies'])
{

	$ignarray = array();

	if ($vbulletin->userinfo['ignorelist'])
	{
		$ignarray = explode(' ', $vbulletin->userinfo['ignorelist']);
	}

	if ($vbulletin->userinfo['maxposts'] != -1)
	{
		$perpage = $vbulletin->userinfo['maxposts'];
	}

	if (!intval($perpage))
	{
		$perpage = $ppg_options['gallery_repliesperpage'];
	}

	if ($_REQUEST['p'])
	{
		$postid = intval($_REQUEST['p']);
	}

	if ($postid)
	{
		$pages = $db->query_first("SELECT COUNT(postid) AS count FROM " . TABLE_PREFIX . "ppgal_posts AS posts WHERE postid < '$postid' AND imageid = '$image[imageid]' AND visible = 1");
		$pagenumber = ceil(($pages['count'] + 1) / $perpage);
	}

	if (!intval($pagenumber))
	{
	 	$pagenumber = 1;
	}
	$counter = 0;
	$perpage = intval($perpage);
	$lowerlimit = ($pagenumber-1) * $perpage + 1;
	$upperlimit = ($pagenumber) * $perpage;

	$countreplies = $db->query_first("SELECT COUNT(postid) AS count FROM " . TABLE_PREFIX . "ppgal_posts AS posts WHERE imageid = '$image[imageid]' AND visible = 1");

	if ($countreplies['count'] > 0)
	{
		if ($upperlimit > $countreplies['count'])
		{
			$upperlimit = $countreplies['count'];
			if ($lowerlimit > $countreplies['count'])
			{
				$lowerlimit = $countreplies['count'] - $perpage;
			}
		}
		if ($lowerlimit <= 0)
		{
			$lowerlimit = 1;
		}

		$pagenav = construct_page_nav($pagenumber, $perpage, $countreplies['count'], 'showimage.php?' . $vbulletin->session->vars['sessionurl'] . 'i='. $image['imageid'] . $adv_sorturl);

    
		$counter = 0;
		$postcount = ($pagenumber - 1 ) * $perpage;
		$show['postheader'] = true;

		if ($ppg_options['gallery_showquickreply'] AND $show['replylink'] AND $image['open'])
		{
			$SHOWQUICKREPLY = true;
		}

		// Icons
		if ($ppg_options['gallery_allowposticons'])
		{
			$query['iconfields'] = ',icon.title as icontitle, icon.iconpath';
			$query['iconjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'icon AS icon ON (posts.iconid = icon.iconid)';
		}

		 //Avatars   	
		if ($vbulletin->options['avatarenabled'] AND ($vbulletin->userinfo['avatarid'] OR ($vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canuseavatar']) OR $vbulletin->userinfo['adminavatar']))
		{
			$query['avatarfields'] = ',avatar.avatarpath, NOT ISNULL(customavatar.filedata) AS hascustom, customavatar.dateline AS avatardateline, avatarrevision';
			$query['avatarjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'avatar AS avatar ON (avatar.avatarid = user.avatarid)
				LEFT JOIN ' . TABLE_PREFIX . 'customavatar AS customavatar ON (customavatar.userid = user.userid)';
		}

		// Reputation
		if ($vbulletin->options['reputationenable'])
		{
			$query['repjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'reputationlevel AS reputationlevel ON (user.reputationlevelid = reputationlevel.reputationlevelid)';
		}


		 $query['rankfields'] = ',usertextfield.rank';


		// Signatures
	if ($ppg_options['gallery_allowsignatures'])
		{

			$query['sigfields'] = ', usertextfield.signature AS psig, sigparsed.signatureparsed, user.sigpicrevision AS sighasimages, sigpic.userid AS sigpic, sigpic.filename AS sigpicfilename, sigpic.dateline AS sigpicdateline, sigpic.width AS sigpicwidth, sigpic.height AS sigpicheight';
			$query['sigjoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'sigparsed AS sigparsed ON (posts.userid = sigparsed.userid AND sigparsed.styleid = ' . intval(STYLEID) . ' AND sigparsed.languageid = ' . intval(LANGUAGEID) . ')
			LEFT JOIN ' . TABLE_PREFIX . 'sigpic AS sigpic ON (posts.userid = sigpic.userid)';
		}

		$postcount = ($pagenumber - 1) * $perpage;

		$postbittemplatename = iif($vbulletin->options['legacypostbit'], 'postbit_legacy', 'postbit');

		$vbulletin->templatecache['postbit_ip'] = str_replace('"postings.php', '"moderate.php', $vbulletin->templatecache['postbit_ip']);

		// Replace links and add $bburl
		$vbulletin->templatecache["$postbittemplatename"] = str_replace(
			array(
				'"editpost.php',
				'"image.php',
				'imwindow',
				'"member.php',
				'"private.php',
				'"profile.php',
				'"report.php?',
				'"search.php',
				'"sendmessage.php',
				'"showpost.php'
			),
			array(
				'"newreply.php',
				'"' . $vbulletin->options['bburl'] . '/image.php',
				'openimwindow',
				'"' . $vbulletin->options['bburl'] . '/member.php',
				'"' . $vbulletin->options['bburl'] . '/private.php',
				'"' . $vbulletin->options['bburl'] . '/profile.php',
				'"misc.php?do=report&amp;type=post&amp;',
				'"' . $vbulletin->options['bburl'] . '/search.php',
				'"' . $vbulletin->options['bburl'] . '/sendmessage.php',
				'"showimage.php'
			),
			$vbulletin->templatecache["$postbittemplatename"]
		);

		$vbulletin->templatecache['postbit_ignore'] = str_replace(
			array(
				'"member.php',
				'"profile.php',
				'showpost.php?'
			),
			array(
				'"' . $vbulletin->options['bburl'] . '/member.php',
				'"' . $vbulletin->options['bburl'] . '/profile.php',
				'showimage.php?noignore=1&amp;'
			),
			$vbulletin->templatecache['postbit_ignore']
		);

		$posts = $db->query_read("
				SELECT 
				posts.postid, posts.pagetext, posts.title, posts.userid, posts.username AS postusername,
                posts.dateline, posts.ipaddress AS ip, posts.iconid, posts.allowsmilie, posts.showsignature, user.*, userfield.*, ppgal_user.*
				$query[iconfields]
				$query[avatarfields] 
				$query[repfields]
                $query[rankfields]
				$query[sigfields]
				FROM " . TABLE_PREFIX . "ppgal_posts AS posts
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (posts.userid = user.userid)
                LEFT JOIN " . TABLE_PREFIX . "ppgal_user AS ppgal_user ON (ppgal_user.userid = user.userid)
                LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid)
     			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (user.userid = usertextfield.userid)
                $query[avatarjoin]
				$query[iconjoin]
				$query[repjoin]
				$query[sigjoin]
				WHERE imageid = '$image[imageid]' AND posts.visible = 1
				ORDER BY posts.dateline
				LIMIT " . ($lowerlimit - 1) . ", $perpage
		");
		

		while ($post = $vbulletin->db->fetch_array($posts))
		{
	    $post['message'] = $bbcode_parser->do_parse($post['pagetext'], 0, $post['allowsmilie'], 1, 1);
	    $post['postdate'] = vbdate($vbulletin->options['dateformat'], $post['dateline']);
	    $post['posttime'] = vbdate($vbulletin->options['timeformat'], $post['dateline']);
		$post['title'] = stripslashes($post['title']);

			if (empty($checkperms["$post[userid]"]))
			{
				$checkperms["$post[userid]"] = cache_permissions($post, false);
			}

			if ($searchid)
			{
				if (in_array('pagetext', $sfields))
				{
					$post['message'] = highlight_keywords($post['message'], $search['string'], $search['wholeword']);
				}
			}

			$show['postcount'] = true;
			$post['postcount'] = ++$postcount;
		
		
			// Status Icon
			$post['statusicon'] = 'old';
			if ($post['dateline'] > $vbulletin->userinfo['lastvisit'])
			{
				$post['statusicon'] = 'new';
			}

			$show['messageicon'] = false;

			// Post Icon
			if ($ppg_options['gallery_allowposticons'])
			{
				if ($post['iconid'] OR $vbulletin->options['showdeficon'])
				{
					$show['messageicon'] = true;
				}
				if ($vbulletin->options['showdeficon'] AND !$post['iconid'])
				{
					$post['iconpath'] = $vbulletin->options['showdeficon'];
					$post['icontitle'] = $vbphrase['default'];
				}
			}

			// Set default $show variables
			$show['profile'] = false;
			$show['avatar'] = false;
			$show['buddy'] = false;
			$show['search'] = false;
			$show['emaillink'] = false;
			$show['pmlink'] = false;
			$show['homepage'] = false;
			$show['reputation'] = false;
			
			if ($show['replylink'] AND $image['open'])
			{
				$post['replylink'] = 'newreply.php?' . $vbulletin->session->vars['sessionurl'] . 'p=' . $post['postid'];
			}

			// Show IP address
			$post['iplogged'] = '';
			if ($post['ip'])
			{
				if ($vbulletin->options['logip'] == 2)
				{
					$show['ip'] = true;
					eval('$post[\'iplogged\'] .= "' . fetch_template('postbit_ip') . '";');
				}
				else if ($vbulletin->options['logip'] == 1 AND is_category_mod($post['catid']))
				{
					$show['ip'] = false;
					eval('$post[\'iplogged\'] .= "' . fetch_template('postbit_ip') . '";');
				}
			}



			if ($post['userid'])
			{
				// Post was by a user
				$post = array_merge($post, convert_bits_to_array($post['options'], $vbulletin->bf_misc_useroptions));

				$post['musername'] = fetch_musername($post);

				$show['profile'] = true;
				$show['buddy'] = true;
				$show['search'] = true;

				// Email, homepage, & PM links
				if ($post['showemail'] AND $vbulletin->options['displayemails'])
				{
					$show['emaillink'] = true;
				}
				if ($post['homepage'] AND $post['homepage'] != 'http://')
				{
					$show['homepage'] = true;
				}
				if ($vbulletin->options['enablepms'] AND $post['receivepm'])
				{
					$show['pmlink'] = true;
				}

				// Report link
				$show['reportlink'] = false;
				if ($vbulletin->userinfo['userid'] != $post['userid'])
				{
					$show['reportlink'] = true;
				}

				// User stats
		    $post['joindate'] = vbdate($vbulletin->options['registereddateformat'], $post['joindate']);
				$post['posts'] = vb_number_format($post['posts']);

				// Online Status
				fetch_online_status($post, true);

				// Reputation
				if ($vbulletin->options['reputationenable'])
				{
					fetch_reputation_image($post, $checkperms["$post[userid]"]);
					$show['reputation'] = true;
				}
				
                // Rank
                $post['rank'] = str_replace('src="', 'src="' . $vbulletin->options['bburl'] . '/', $post['rank']);


				// Im Icons
				construct_im_icons($post);

				// User Title
				if ($post['customtitle'] == 2)
				{
					$post['usertitle'] = htmlspecialchars_uni($post['usertitle']);
				}

				// Signature
				if ($post['showsignature'] OR !$vbulletin->userinfo['userid'])
				{
			                    require_once(DIR . '/includes/functions_wysiwyg.php');
			                    $post['signature'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($post['psig'], $imageinfo['allowhtml']));
			                    $show['signature'] = true;
				        if ( $post['sigpicfilename'] )
				        {

			                     $spic = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "setting WHERE varname = 'sigpicurl'");
			                     if ( empty($post['sighasimages'])) $post['sighasimages'] = 1;
				             if ( $vboptions['usefileavatar'] )
				             {
					         $sigpic = "<br /><img src=\"{$spic['value']}/sigpic{$post['userid']}_{$post['sighasimages']}.gif\" alt=\"\" /><br />";
				             }
				             else
				             {
				                  $sigpic = "<br /><img src=\"image.php?type=sigpic&userid={$post['userid']}\" border=\"0\"><br />";
				             }
			                     $sigpic = str_replace('src="', 'src="' . $vbulletin->options['bburl'] . '/', $sigpic);
			                     $post['signature'] = str_replace("[SIGPIC][/SIGPIC]", "$sigpic", $post[signature]);

				        }
	                        }
				else
				{
					$post['signature'] = '';
				}
					
				// Get Avatar
				$post['avatarurl'] = '';

				if ($vbulletin->userinfo['showavatars'] OR !$vbulletin->userinfo['userid'])
				{
			  	        
					if ($post['avatarpath'])
			         	{
				        $post['avatarurl'] = $vbulletin->options['bburl'] . '/' . $post['avatarpath'];
			                }
					else if ($post['hascustom'] != "" && $post['avatarrevision'] != 0 )
					{
						if ($vbulletin->options['usefileavatar'])
						{
							$post['avatarurl'] = $vbulletin->options['bburl'] . '/' . $vbulletin->options['avatarurl'] . '/avatar' . $post['userid'] . '_' . $post['avatarrevision'] . '.gif';
						}
						else
						{
							$post['avatarurl'] = $vbulletin->options['bburl'] . '/image.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $post['userid'] . '&amp;dateline=' . $post['avatardateline'];
						}
					}
					if ($post['avatarurl'])
					{
						$show['avatar'] = true;
					}
				}
				if (($categoryperms["$image[catid]"]['caneditposts'] AND $post['userid'] == $vbulletin->userinfo['userid']) OR $categoryperms["$image[catid]"]['caneditothersposts'])
				{
					$post['editlink'] = 'newreply.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editpost&amp;p=' . $post['postid'];
				}
			}
			else
			{
				// Guest Post
				$post['posts'] = $vbphrase['n_a'];
				$post['username'] = $post['postusername'];
				$post['musername'] = fetch_musername($post);
				$post['usertitle'] = $vbphrase['guest'];
			}

			// Print the postbit
            if (in_array($post['userid'], $ignarray) AND !$noignore)
			{
				eval('$postbit .= "' . fetch_template('postbit_ignore') . '";');
			}
			else
			{
				eval('$postbit .= "' . fetch_template($postbittemplatename) . '";');
			}
		}
		$db->free_result($posts);
		unset($query, $post);
	}
}
		
$postbit = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $postbit);

if ($ppg_options['gallery_showquickreply'] AND $show['replylink'] AND $vbulletin->userinfo['userid'] AND $image['open'])
{

    $vbulletin->templatecache['editor_clientscript'] = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $vbulletin->templatecache['editor_clientscript']);
    require_once(DIR . '/includes/functions_editor.php');

    $show['quickreply'] = true;
    
    $show['wysiwyg'] = ($catopts['allow_post_bbcode'] ? is_wysiwyg_compatible() : 0);
    $istyles_js = construct_editor_styles_js();
    
    $vbulletin->options['allowbbcode'] = $catopts['allow_post_bbcode'];
    $vbulletin->options['allowbbimagecode'] = $catopts['allow_post_bbimgcode'];
    $vbulletin->options['allowsmilies'] = $catopts['allow_post_smilies'];
  
    $threadedmode = 0;
    $qrpostid = 'who cares';
    $show['qr_require_click'] = 0;

    $vBeditJs = construct_editor_js_arrays();
    eval('$vBeditTemplate[\'clientscript\'] = "' . fetch_template('editor_clientscript') . '";');

    $editorid = construct_edit_toolbar('', 0, $imageinfo['imageid'], ($vbulletin->options['allowsmilies'] ? 1 : 0), 1, false, 'qr');
    $headinclude .= ' 
		<!-- set up CSS for the editor -->
		<link rel="stylesheet" type="text/css" href="' . $vbulletin->options['bburl'] . '/clientscript/vbulletin_editor.css" />
		<style type="text/css">
		<!--
		#vBulletin_editor {
			background: ' . $istyles['pi_button_normal'][0] . ';
			padding: ' . $stylevar['cellpadding'] . 'px;
		}
		#controlbar, .controlbar {
			background: ' . $istyles['pi_button_normal'][0] . ';
		}
		.imagebutton {
			background: ' . $istyles['pi_button_normal'][0] . ';
			color: ' . $istyles['pi_button_normal'][1] . ';
			padding: ' . $istyles['pi_button_normal'][2] . ';
			border: ' . $istyles['pi_button_normal'][3] . ';
		}
		-->
		</style>
	';

	unset($threadid);

	if (!$ppg_options['gallery_allowsignatures'])
	{
		$vbulletin->userinfo['signature'] = '';
	}

	eval('$quickreply = "' . fetch_template('showthread_quickreply') . '";');

	$messagearea = "
		<script type=\"text/javascript\">
		<!--
			var threaded_mode = $threadedmode;
			var require_click = 0;
			var is_last_page = " . iif(ceil($countimages['count'] / $perpage) == $pagenumber, 1, 0) . ";
			var allow_ajax_qr = 0;
			var ajax_last_post = '';
		// -->
		</script>
		$messagearea
	";

}

if (!intval($catid))
{
	$catnavarray = construct_dir_navbits($categorycache["$image[catid]"]['parentlist']);
	if ($categorycache["$image[catid]"]['membercat'])
	{
		$catnavarray['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$image[catid]&amp;userid=$image[userid]"] = construct_phrase($vbphrase['usernames_images'], $image['username'], iif(substr($image['username'], -1) != 's', $vbphrase['plural_s'])) . ' ('.$post['ppicount'].')';
	}

	foreach ($catnavarray AS $link => $navtext)
	{
		$catnavbits .= iif($gt, '&rsaquo;') . ' <a href="' . $link . '">' . $navtext . '</a> ';
		$gt = 1;
	}
}

switch($catid)
{
	case 'favorites':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=favorites"] = $vbphrase['my_favorites'];
		break;

	case 'newimages':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=newimages"] = $vbphrase['whats_new'];
		break;

	case 'popimages':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=popimages"] = $vbphrase['whats_popular'];
		break;

	case 'searchresults':
		$navbits["search.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchresults&amp;searchid=$searchid"] = $vbphrase['search_results'];
		break;

	case 'member':
		$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "do=member&amp;imageuser=$image[userid]"] = construct_phrase($vbphrase['usernames_images'], $image['username'], $plurals); //21741
		break;

	default:
		$navbits = construct_dir_navbits($categorycache["$image[catid]"]['parentlist']);

		if ($categorycache["$image[catid]"]['membercat'])
		{
			$navbits['browseimages.php?' . $vbulletin->session->vars['sessionurl'] . "c=$image[catid]&amp;userid=$image[userid]"] = construct_phrase($vbphrase['usernames_images'], $image['username'], iif(substr($image['username'], -1) != 's', $vbphrase['plural_s']));
		}
	}

if ($ppg_options['gallery_showcatdesc'])
{
require_once(DIR . '/includes/functions_wysiwyg.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
$catinfo['description'] = $bbcode_parser->do_parse(convert_wysiwyg_html_to_bbcode($catinfo['description']));
}

$navbits[''] = $image['title'];
$navbits = construct_navbits($navbits);

($hook = vBulletinHook::fetch_hook('ppgal_showimage_complete')) ? eval($hook) : false;

eval('$navbar = "' . fetch_template('navbar') . '";'); 
eval('$gallerynav = "' . fetch_template('adv_gallery_navbar') . '";');

if (!isset($catid))
{
	$catid = $image['catid'];
}

$categoryjump = print_category_jump($catid);

eval('print_output("' . fetch_template('ADV_GALLERY_SHOWIMAGE') . '");');

?>